/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;

public final class NbKeymap
extends Observable
implements Keymap,
Comparator {
    String name;
    Keymap parent;
    Map bindings;
    Action defaultAction;
    Map actions;
    private static List context = new ArrayList();
    private final Action NO_ACTION = new KeymapAction(null, null);

    public static void resetContext() {
        context.clear();
        StatusDisplayer.getDefault().setStatusText("");
    }

    public static KeyStroke[] getContext() {
        return context.toArray(new KeyStroke[context.size()]);
    }

    public static void shiftContext(KeyStroke stroke) {
        context.add(stroke);
        StringBuffer text = new StringBuffer();
        Iterator it = context.iterator();
        while (it.hasNext()) {
            text.append(NbKeymap.getKeyText((KeyStroke)it.next())).append(' ');
        }
        StatusDisplayer.getDefault().setStatusText(text.toString());
    }

    private static String getKeyText(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return "";
        }
        String modifText = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if ("".equals(modifText)) {
            return KeyEvent.getKeyText(keyStroke.getKeyCode());
        }
        return modifText + "+" + KeyEvent.getKeyText(keyStroke.getKeyCode());
    }

    public Action createMapAction(Keymap k, KeyStroke stroke) {
        return new KeymapAction(k, stroke);
    }

    public NbKeymap() {
        this("Default", null);
    }

    NbKeymap(String name, Keymap parent) {
        this.name = name;
        this.parent = parent;
        this.bindings = new HashMap();
    }

    public Action getDefaultAction() {
        if (this.defaultAction != null) {
            return this.defaultAction;
        }
        return this.parent != null ? this.parent.getDefaultAction() : null;
    }

    public void setDefaultAction(Action a) {
        this.defaultAction = a;
        this.setChanged();
        this.notifyObservers();
    }

    public String getName() {
        return this.name;
    }

    public Action getAction(KeyStroke key) {
        Action a;
        KeyStroke[] ctx = NbKeymap.getContext();
        Keymap activ = this;
        for (int i = 0; i < ctx.length; ++i) {
            if (activ == this) {
                a = (Action)this.bindings.get(ctx[i]);
                if (a == null && this.parent != null) {
                    a = this.parent.getAction(ctx[i]);
                }
            } else {
                a = activ.getAction(ctx[i]);
            }
            if (!(a instanceof KeymapAction)) {
                int code = key.getKeyCode();
                if (code != 17 && code != 18 && code != 65406 && code != 16 && code != 157) {
                    NbKeymap.resetContext();
                }
                return null;
            }
            activ = ((KeymapAction)a).keymap;
        }
        if (activ == this) {
            a = (Action)this.bindings.get(key);
            if (a == null && this.parent != null) {
                a = this.parent.getAction(key);
            }
            return a;
        }
        a = activ.getAction(key);
        if (a != null) {
            if (!(a instanceof KeymapAction)) {
                NbKeymap.resetContext();
            }
            return a;
        }
        if (key.isOnKeyRelease() || key.getKeyChar() != '\u0000' && key.getKeyChar() != '\uffff') {
            return null;
        }
        switch (key.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                return null;
            }
        }
        NbKeymap.resetContext();
        return this.NO_ACTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStroke[] getBoundKeyStrokes() {
        int i = 0;
        KeyStroke[] keys = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            keys = new KeyStroke[this.bindings.size()];
            Iterator iter = this.bindings.keySet().iterator();
            while (iter.hasNext()) {
                keys[i++] = (KeyStroke)iter.next();
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] getBoundActions() {
        int i = 0;
        Action[] actionsArray = null;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            actionsArray = new Action[this.bindings.size()];
            Iterator iter = this.bindings.values().iterator();
            while (iter.hasNext()) {
                actionsArray[i++] = (Action)iter.next();
            }
        }
        return actionsArray;
    }

    public KeyStroke[] getKeyStrokesForAction(Action a) {
        List strokes;
        Map localActions = this.actions;
        if (localActions == null) {
            localActions = this.buildReverseMapping();
        }
        if ((strokes = (List)localActions.get(a)) != null) {
            return strokes.toArray(new KeyStroke[strokes.size()]);
        }
        return new KeyStroke[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildReverseMapping() {
        HashMap<Action, List<KeyStroke>> localActions = this.actions = new HashMap<Action, List<KeyStroke>>();
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            Iterator it = this.bindings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry curEntry = it.next();
                Action curAction = (Action)curEntry.getValue();
                KeyStroke curKey = (KeyStroke)curEntry.getKey();
                List<KeyStroke> keysForAction = (List<KeyStroke>)localActions.get(curAction);
                if (keysForAction == null) {
                    keysForAction = Collections.synchronizedList(new ArrayList(1));
                    localActions.put(curAction, keysForAction);
                }
                keysForAction.add(curKey);
            }
        }
        return localActions;
    }

    public synchronized boolean isLocallyDefined(KeyStroke key) {
        return this.bindings.containsKey(key);
    }

    private void updateActionAccelerator(final Action a) {
        if (a == null) {
            return;
        }
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                KeyStroke[] keystrokes = NbKeymap.this.getKeyStrokesForAction(a);
                Arrays.sort(keystrokes, NbKeymap.this);
                a.putValue("AcceleratorKey", keystrokes.length > 0 ? keystrokes[0] : null);
            }
        });
    }

    public int compare(Object o1, Object o2) {
        KeyStroke k1 = (KeyStroke)o1;
        KeyStroke k2 = (KeyStroke)o2;
        return KeyEvent.getKeyText(k1.getKeyCode()).length() - KeyEvent.getKeyText(k2.getKeyCode()).length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionForKeyStroke(KeyStroke key, Action a) {
        Action old;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            old = this.bindings.put(key, a);
            this.actions = null;
        }
        this.updateActionAccelerator(a);
        this.updateActionAccelerator(old);
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActionForKeyStrokeMap(Map map) {
        HashSet actionsSet = new HashSet();
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                Object value = map.get(key);
                actionsSet.add(value);
                actionsSet.add(this.bindings.put(key, value));
            }
            this.actions = null;
        }
        Iterator it = actionsSet.iterator();
        while (it.hasNext()) {
            this.updateActionAccelerator((Action)it.next());
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyStrokeBinding(KeyStroke key) {
        Action a;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            a = (Action)this.bindings.remove(key);
            this.actions = null;
        }
        this.updateActionAccelerator(a);
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBindings() {
        HashSet actionsSet;
        NbKeymap nbKeymap = this;
        synchronized (nbKeymap) {
            actionsSet = new HashSet(this.bindings.values());
            this.bindings.clear();
            this.actions = null;
        }
        Iterator it = actionsSet.iterator();
        while (it.hasNext()) {
            this.updateActionAccelerator((Action)it.next());
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Keymap getResolveParent() {
        return this.parent;
    }

    public void setResolveParent(Keymap parent) {
        this.parent = parent;
        this.setChanged();
        this.notifyObservers();
    }

    public String toString() {
        return "Keymap[" + this.name + "]" + this.bindings;
    }

    public class KeymapAction
    extends AbstractAction {
        private Keymap keymap;
        private KeyStroke stroke;

        public KeymapAction(Keymap keymap, KeyStroke stroke) {
            this.keymap = keymap;
            this.stroke = stroke;
        }

        public Keymap getSubMap() {
            return this.keymap;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.stroke == null) {
                NbKeymap.resetContext();
            } else {
                NbKeymap.shiftContext(this.stroke);
            }
        }
    }

    public static class SubKeymap
    implements Keymap {
        Object hold;
        Keymap parent;
        Map bindings;
        Action defaultAction;

        public SubKeymap(Object hold) {
            this.hold = hold;
            this.bindings = new HashMap();
        }

        public void setMapping(Map m) {
            this.bindings = new HashMap(m);
        }

        public String getName() {
            return "name";
        }

        public void setResolveParent(Keymap parent) {
            this.parent = parent;
        }

        public Keymap getResolveParent() {
            return this.parent;
        }

        public void addActionForKeyStroke(KeyStroke key, Action a) {
            this.bindings.put(key, a);
        }

        public KeyStroke[] getKeyStrokesForAction(Action a) {
            return new KeyStroke[0];
        }

        public void setDefaultAction(Action a) {
            this.defaultAction = a;
        }

        public Action getAction(KeyStroke key) {
            return (Action)this.bindings.get(key);
        }

        public boolean isLocallyDefined(KeyStroke key) {
            return this.bindings.containsKey(key);
        }

        public void removeKeyStrokeBinding(KeyStroke keys) {
            this.bindings.remove(keys);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Action[] getBoundActions() {
            SubKeymap subKeymap = this;
            synchronized (subKeymap) {
                return this.bindings.values().toArray(new Action[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KeyStroke[] getBoundKeyStrokes() {
            SubKeymap subKeymap = this;
            synchronized (subKeymap) {
                return this.bindings.keySet().toArray(new KeyStroke[0]);
            }
        }

        public Action getDefaultAction() {
            return this.defaultAction;
        }

        public void removeBindings() {
            this.bindings.clear();
        }
    }
}

