/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.websvc.core.PortInformation;
import org.netbeans.modules.websvc.core.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PortInformationHandler
extends DefaultHandler
implements PortInformation {
    private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
    private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String SOAP_BINDING = "http://schemas.xmlsoap.org/wsdl/soap";
    private static final String SOAP_BINDING_SLASH = "http://schemas.xmlsoap.org/wsdl/soap/";
    private Map serviceMap;
    private String targetNamespace;
    private List entirePortList;
    private List bindingPortList;
    private List wsdlImports;
    private String currentServiceName;
    private PortInfo bindingPort;
    private Set wscompileFeatures;
    private boolean serviceNameConflict;

    public PortInformationHandler() {
        this.serviceMap = new LinkedHashMap(5);
        this.entirePortList = new ArrayList();
        this.bindingPortList = new ArrayList();
        this.wsdlImports = new ArrayList();
        this.initWscompileFeatures();
    }

    public PortInformationHandler(String targetNamespace, Map serviceMap, List entirePortList, List bindingPortList, List wsdlImports) {
        this.targetNamespace = targetNamespace;
        this.serviceMap = serviceMap;
        this.entirePortList = entirePortList;
        this.bindingPortList = bindingPortList;
        this.wsdlImports = wsdlImports;
        this.initWscompileFeatures();
    }

    private void initWscompileFeatures() {
        this.wscompileFeatures = new HashSet(5);
        this.wscompileFeatures.add("wsi");
        this.wscompileFeatures.add("strict");
    }

    public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
        if (W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) {
            String location;
            if ("portType".equals(localname)) {
                PortInfo key = new PortInfo();
                key.setPortType(attributes.getValue("name"));
                PortInfo pi = (PortInfo)this.getPortInfoByKey(key);
                if (pi == null) {
                    this.entirePortList.add(key);
                }
            } else if ("binding".equals(localname)) {
                PortInfo key = new PortInfo();
                key.setBinding(attributes.getValue("name"));
                key.setPortType(this.getLocalPart(attributes.getValue("type")));
                PortInfo pi = (PortInfo)this.getPortInfoByKey(key);
                if (pi == null) {
                    this.entirePortList.add(key);
                } else {
                    if (pi.getBinding() == null) {
                        pi.setBinding(key.getBinding());
                    }
                    if (pi.getPortType() == null) {
                        pi.setPortType(key.getPortType());
                    }
                }
                this.bindingPort = pi;
                this.bindingPortList.add(this.bindingPort);
            } else if ("port".equals(localname)) {
                PortInfo key = new PortInfo();
                key.setPort(attributes.getValue("name"));
                key.setBinding(this.getLocalPart(attributes.getValue("binding")));
                PortInfo pi = (PortInfo)this.getPortInfoByKey(key);
                if (pi == null) {
                    this.entirePortList.add(key);
                    pi = key;
                } else {
                    if (pi.getPort() == null) {
                        pi.setPort(key.getPort());
                    }
                    if (pi.getBinding() == null) {
                        pi.setBinding(key.getBinding());
                    }
                }
                assert (this.currentServiceName != null);
                ServiceInfo serviceInfo = (ServiceInfo)this.serviceMap.get(this.currentServiceName);
                if (serviceInfo == null) {
                    serviceInfo = new ServiceInfo(this.currentServiceName);
                    this.serviceMap.put(this.currentServiceName, serviceInfo);
                }
                List servicePorts = serviceInfo.getPorts();
                servicePorts.add(pi);
            } else if ("service".equals(localname)) {
                this.currentServiceName = attributes.getValue("name");
                if (this.currentServiceName != null) {
                    this.currentServiceName = Utilities.removeSpacesFromServiceName(this.currentServiceName);
                }
            } else if ("definitions".equals(localname)) {
                this.targetNamespace = attributes.getValue("targetNamespace");
            } else if ("import".equals(localname) && (location = attributes.getValue("location")) != null) {
                this.wsdlImports.add(location);
            }
        } else if (this.bindingPort != null && "binding".equals(localname)) {
            String style;
            this.bindingPort.setBindingType(this.normalizeUri(uri));
            if ((SOAP_BINDING.equals(uri) || SOAP_BINDING_SLASH.equals(uri)) && (style = attributes.getValue("style")) != null && ("rpc".equals(style) || style.endsWith(":rpc"))) {
                this.wscompileFeatures.remove("strict");
                this.wscompileFeatures.add("rpcliteral");
            }
        } else if (W3C_XML_SCHEMA.equals(uri)) {
            if ("element".equals(localname)) {
                String elementType = attributes.getValue("type");
                if (elementType != null && ("anyType".equals(elementType) || elementType.endsWith(":anyType"))) {
                    this.wscompileFeatures.add("nodatabinding");
                }
            } else if ("import".equals(localname) && attributes.getValue("schemaLocation") == null && attributes.getValue("namespace") != null) {
                this.wscompileFeatures.add("searchschema");
            }
        }
    }

    public Map getServices() {
        return this.serviceMap;
    }

    public void endElement(String uri, String localname, String qname) throws SAXException {
        if (W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) {
            if ("binding".equals(localname)) {
                this.bindingPort = null;
            } else if ("service".equals(localname)) {
                PortInformation.ServiceInfo si;
                if (this.currentServiceName != null && (si = this.getServiceInfo(this.currentServiceName)) != null) {
                    List ports = si.getPorts();
                    for (PortInformation.PortInfo pi : ports) {
                        if (!this.currentServiceName.equals(pi.getPortType())) continue;
                        this.serviceNameConflict = true;
                        break;
                    }
                }
                this.currentServiceName = null;
            }
        }
    }

    public boolean isServiceNameConflict() {
        return this.serviceNameConflict;
    }

    public String[] getServiceNames() {
        Set keys = this.serviceMap.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    public PortInformation.ServiceInfo getServiceInfo(String serviceName) {
        ServiceInfo result = (ServiceInfo)this.serviceMap.get(serviceName);
        if (result == null) {
            for (ServiceInfo si : this.serviceMap.values()) {
                if (!serviceName.equalsIgnoreCase(si.getServiceName())) continue;
                result = si;
                break;
            }
        }
        return result;
    }

    public List getBindings() {
        return this.bindingPortList;
    }

    public List getImportedSchemas() {
        return this.wsdlImports;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public List getEntirePortList() {
        return this.entirePortList;
    }

    public Set getWscompileFeatures() {
        return this.wscompileFeatures;
    }

    private String normalizeUri(String uri) {
        String result = uri;
        if (uri.charAt(uri.length() - 1) == '/') {
            result = uri.substring(0, uri.length() - 1);
        }
        return result;
    }

    private PortInformation.PortInfo getPortInfoByKey(PortInfo key) {
        PortInfo result = null;
        for (PortInfo pi : this.entirePortList) {
            if (this.compareField(key.getPort(), pi.getPort())) {
                result = pi;
                break;
            }
            if (this.compareField(key.getBinding(), pi.getBinding())) {
                result = pi;
                break;
            }
            if (!this.compareField(key.getPortType(), pi.getPortType())) continue;
            result = pi;
            break;
        }
        return result;
    }

    private boolean compareField(String key, String match) {
        boolean result = false;
        if (match != null && match.equals(key)) {
            result = true;
        }
        return result;
    }

    private String getLocalPart(String uri) {
        String result = uri;
        int index = uri.lastIndexOf(58);
        if (index != -1) {
            result = uri.substring(index + 1);
        }
        return result;
    }

    public static final class ServiceInfo
    implements PortInformation.ServiceInfo {
        private String serviceName;
        private List portList;

        public ServiceInfo(String name, List ports) {
            this.init(name, ports);
        }

        public ServiceInfo(String name) {
            this.init(name, new ArrayList());
        }

        private void init(String name, List ports) {
            this.serviceName = name;
            this.portList = ports;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public List getPorts() {
            return this.portList;
        }
    }

    public static final class PortInfo
    implements PortInformation.PortInfo {
        private String portName;
        private String bindingName;
        private String bindingType;
        private String portTypeName;

        public String getPortType() {
            return this.portTypeName;
        }

        void setPortType(String pt) {
            this.portTypeName = pt;
        }

        public String getBinding() {
            return this.bindingName;
        }

        void setBinding(String b) {
            this.bindingName = b;
        }

        public String getBindingType() {
            return this.bindingType;
        }

        void setBindingType(String bt) {
            this.bindingType = bt;
        }

        public String getPort() {
            return this.portName;
        }

        void setPort(String p) {
            this.portName = p;
        }

        public String toString() {
            return "(" + this.portName + ", " + this.bindingName + ", " + this.portTypeName + ")";
        }
    }
}

