/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.Utilities;
import org.netbeans.modules.websvc.core.client.wizard.ProxySettingsDlg;
import org.netbeans.modules.websvc.core.client.wizard.WebProxySetter;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientCreator;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientWizardDescriptor;
import org.netbeans.modules.websvc.core.client.wizard.WsdlRetriever;
import org.netbeans.modules.websvc.core.jaxws.JaxWsExplorerPanel;
import org.netbeans.modules.websvc.core.webservices.action.JaxRpcWsdlCookie;
import org.netbeans.modules.websvc.jaxws.api.JaxWsWsdlCookie;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientInfo
extends JPanel
implements WsdlRetriever.MessageReceiver {
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static final int WSDL_FROM_PROJECT = 0;
    private static final int WSDL_FROM_FILE = 1;
    private static final int WSDL_FROM_URL = 2;
    private static final FileFilter WSDL_FILE_FILTER = new WsdlFileFilter();
    private static String previousDirectory = "";
    private WebServiceClientWizardDescriptor descriptorPanel;
    private WizardDescriptor wizardDescriptor;
    private boolean settingFields;
    private int wsdlSource;
    private File wsdlTmpFile;
    private WsdlRetriever retriever;
    private String downloadMsg;
    private boolean retrieverFailed = false;
    private boolean isWaitingForScan = false;
    private Project project;
    private int projectType;
    private ButtonGroup btnGrpWsdlSource;
    private JButton jBtnBrowse;
    private JButton jBtnBrowse1;
    private JButton jBtnProxy;
    private JComboBox jCbxClientType;
    private JComboBox jCbxPackageName;
    private JComboBox jComboBoxJaxVersion;
    private JLabel jLabelJaxVersion;
    private JLabel jLblChooseSource;
    private JLabel jLblClientType;
    private JLabel jLblPackageDescription;
    private JLabel jLblPackageName;
    private JLabel jLblProject;
    private JRadioButton jRbnFilesystem;
    private JRadioButton jRbnProject;
    private JRadioButton jRbnUrl;
    private JTextField jTxtLocalFilename;
    private JTextField jTxtProject;
    private JTextField jTxtWsdlProject;
    private JTextField jTxtWsdlURL;

    public ClientInfo(WebServiceClientWizardDescriptor panel) {
        this.descriptorPanel = panel;
        this.settingFields = false;
        this.wsdlSource = 0;
        this.wsdlTmpFile = null;
        this.retriever = null;
        this.initComponents();
        this.jLblClientType.setVisible(false);
        this.jCbxClientType.setVisible(false);
        this.jComboBoxJaxVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"JAX-WS", "JAX-RPC"}));
        this.initUserComponents();
    }

    private void initComponents() {
        this.btnGrpWsdlSource = new ButtonGroup();
        this.jLblChooseSource = new JLabel();
        this.jRbnFilesystem = new JRadioButton();
        this.jTxtWsdlProject = new JTextField();
        this.jBtnBrowse = new JButton();
        this.jRbnProject = new JRadioButton();
        this.jTxtWsdlURL = new JTextField();
        this.jBtnProxy = new JButton();
        this.jTxtLocalFilename = new JTextField();
        this.jLblPackageDescription = new JLabel();
        this.jLblProject = new JLabel();
        this.jTxtProject = new JTextField();
        this.jLblPackageName = new JLabel();
        this.jCbxPackageName = new JComboBox();
        this.jLblClientType = new JLabel();
        this.jCbxClientType = new JComboBox();
        this.jRbnUrl = new JRadioButton();
        this.jBtnBrowse1 = new JButton();
        this.jLabelJaxVersion = new JLabel();
        this.jComboBoxJaxVersion = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"LBL_WsdlSource"));
        Mnemonics.setLocalizedText((JLabel)this.jLblChooseSource, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_WsdlSource"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLblChooseSource, gridBagConstraints);
        this.btnGrpWsdlSource.add(this.jRbnFilesystem);
        Mnemonics.setLocalizedText((AbstractButton)this.jRbnFilesystem, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_WsdlSourceFilesystem"));
        this.jRbnFilesystem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientInfo.this.jRbnFilesystemActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jRbnFilesystem, gridBagConstraints);
        this.jRbnFilesystem.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"A11Y_WsdlSource"));
        this.jTxtWsdlProject.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jTxtWsdlProject, gridBagConstraints);
        this.jTxtWsdlProject.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientInfo.class, (String)"ACSN_WsdlSourceFilesystem"));
        this.jTxtWsdlProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"ACSD_WsdlSourceFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.jBtnBrowse, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_Browse"));
        this.jBtnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientInfo.this.jBtnBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.jBtnBrowse, gridBagConstraints);
        this.jBtnBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ClientInfo.class).getString("A11Y_BrowseLocalFile"));
        this.btnGrpWsdlSource.add(this.jRbnProject);
        this.jRbnProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jRbnProject, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_ProjectUrl"));
        this.jRbnProject.setFocusable(false);
        this.jRbnProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientInfo.this.jRbnProjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jRbnProject, gridBagConstraints);
        this.jRbnProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"A11Y_WsdlSourceUrl"));
        this.jTxtWsdlURL.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 6);
        this.add((Component)this.jTxtWsdlURL, gridBagConstraints);
        this.jTxtWsdlURL.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientInfo.class, (String)"ACSN_WsdlSourceUrl"));
        this.jTxtWsdlURL.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"ACSD_WsdlSourceUrl"));
        Mnemonics.setLocalizedText((AbstractButton)this.jBtnProxy, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_ProxySettings"));
        this.jBtnProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientInfo.this.jBtnProxyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.jBtnProxy, gridBagConstraints);
        this.jBtnProxy.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"A11Y_ProxySettings"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jTxtLocalFilename, gridBagConstraints);
        this.jTxtLocalFilename.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ClientInfo.class).getString("ACSN_WsdlSourceLocalFile"));
        this.jTxtLocalFilename.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"A11Y_LocalFilename"));
        this.jLblPackageDescription.setLabelFor(this.jCbxPackageName);
        Mnemonics.setLocalizedText((JLabel)this.jLblPackageDescription, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_PackageDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jLblPackageDescription, gridBagConstraints);
        this.jLblProject.setLabelFor(this.jTxtProject);
        Mnemonics.setLocalizedText((JLabel)this.jLblProject, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.jLblProject, gridBagConstraints);
        this.jTxtProject.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.jTxtProject, gridBagConstraints);
        this.jTxtProject.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"A11Y_Project"));
        this.jLblPackageName.setLabelFor(this.jCbxPackageName);
        Mnemonics.setLocalizedText((JLabel)this.jLblPackageName, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.jLblPackageName, gridBagConstraints);
        this.jCbxPackageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.jCbxPackageName, gridBagConstraints);
        this.jLblClientType.setLabelFor(this.jCbxClientType);
        Mnemonics.setLocalizedText((JLabel)this.jLblClientType, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_ClientType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLblClientType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jCbxClientType, gridBagConstraints);
        this.jCbxClientType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientInfo.class, (String)"A11Y_ClientType"));
        this.btnGrpWsdlSource.add(this.jRbnUrl);
        Mnemonics.setLocalizedText((AbstractButton)this.jRbnUrl, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_WsdlUrl"));
        this.jRbnUrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientInfo.this.jRbnUrlActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jRbnUrl, gridBagConstraints);
        this.jRbnUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ClientInfo.class).getString("A11Y_WsdlURL"));
        Mnemonics.setLocalizedText((AbstractButton)this.jBtnBrowse1, (String)NbBundle.getMessage(ClientInfo.class, (String)"LBL_Browse1"));
        this.jBtnBrowse1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClientInfo.this.jBtnBrowse1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.jBtnBrowse1, gridBagConstraints);
        this.jBtnBrowse1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ClientInfo.class).getString("A11Y_BrowseWSDLProject"));
        this.jLabelJaxVersion.setLabelFor(this.jComboBoxJaxVersion);
        Mnemonics.setLocalizedText((JLabel)this.jLabelJaxVersion, (String)NbBundle.getBundle(ClientInfo.class).getString("LBL_JAX_Version"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(28, 0, 0, 6);
        this.add((Component)this.jLabelJaxVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(24, 6, 0, 0);
        this.add((Component)this.jComboBoxJaxVersion, gridBagConstraints);
    }

    private void jBtnBrowse1ActionPerformed(ActionEvent evt) {
        String result = this.browseProjectServices();
        if (result != null) {
            this.jTxtWsdlProject.setText(result);
        }
    }

    private void jRbnUrlActionPerformed(ActionEvent evt) {
        this.wsdlSource = 2;
        this.enableWsdlSourceFields(false, false, true);
        this.descriptorPanel.fireChangeEvent();
    }

    private void jBtnProxyActionPerformed(ActionEvent evt) {
        ProxySettingsDlg.showDialog();
        this.wsdlUrlChanged();
    }

    private void jBtnBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(previousDirectory);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(WSDL_FILE_FILTER);
        chooser.setFileFilter(WSDL_FILE_FILTER);
        if (chooser.showOpenDialog(this) == 0) {
            String proxyHost;
            File wsdlFile = chooser.getSelectedFile();
            this.jTxtLocalFilename.setText(wsdlFile.getAbsolutePath());
            previousDirectory = wsdlFile.getPath();
            int result = this.resolveImports(wsdlFile);
            if ((result & 2) == 2 && ((proxyHost = WebProxySetter.getInstance().getProxyHost()) == null || proxyHost.length() == 0)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_SetUpProxyForImports"), 2));
            }
            if ((result & 1) == 1) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_IdeGeneratedStaticStubOnly"), 2));
            }
        }
    }

    private void jRbnFilesystemActionPerformed(ActionEvent evt) {
        this.wsdlSource = 1;
        this.enableWsdlSourceFields(false, true, false);
        this.descriptorPanel.fireChangeEvent();
    }

    private void jRbnProjectActionPerformed(ActionEvent evt) {
        this.wsdlSource = 0;
        this.enableWsdlSourceFields(true, false, false);
        this.descriptorPanel.fireChangeEvent();
    }

    private void enableWsdlSourceFields(boolean fromProject, boolean fromFile, boolean fromUrl) {
        this.jTxtWsdlProject.setEnabled(fromProject);
        this.jBtnBrowse1.setEnabled(fromProject);
        this.jTxtLocalFilename.setEnabled(fromFile);
        this.jBtnBrowse.setEnabled(fromFile);
        this.jTxtWsdlURL.setEnabled(fromUrl);
    }

    private void initUserComponents() {
        this.setName(NbBundle.getMessage(ClientInfo.class, (String)"TITLE_WebServiceClientWizard"));
        this.jTxtWsdlURL.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ClientInfo.this.wsdlUrlChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                ClientInfo.this.wsdlUrlChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                ClientInfo.this.wsdlUrlChanged();
            }
        });
        this.jTxtLocalFilename.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ClientInfo.this.updateTexts();
            }

            public void insertUpdate(DocumentEvent e) {
                ClientInfo.this.updateTexts();
            }

            public void removeUpdate(DocumentEvent e) {
                ClientInfo.this.updateTexts();
            }
        });
        this.jTxtWsdlProject.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ClientInfo.this.wsdlUrlChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                ClientInfo.this.wsdlUrlChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                ClientInfo.this.wsdlUrlChanged();
            }
        });
        Component editorComponent = this.jCbxPackageName.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextComponent) {
            ((JTextComponent)editorComponent).getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    ClientInfo.this.updateTexts();
                }

                public void insertUpdate(DocumentEvent e) {
                    ClientInfo.this.updateTexts();
                }

                public void removeUpdate(DocumentEvent e) {
                    ClientInfo.this.updateTexts();
                }
            });
        } else {
            this.jCbxPackageName.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    if (!ClientInfo.this.settingFields) {
                        ClientInfo.this.descriptorPanel.fireChangeEvent();
                    }
                }
            });
        }
        this.jCbxPackageName.setRenderer(PackageView.listRenderer());
    }

    void store(WizardDescriptor d) {
        if (this.wsdlSource == 0 || this.wsdlSource == 2) {
            d.putProperty("wsdlDownloadUrl", (Object)this.getDownloadUrl());
            d.putProperty("wsdlDownloadedWsdl", (Object)this.getDownloadWsdl());
            d.putProperty("wsdlDownloadedSchemas", (Object)this.getDownloadedSchemas());
            d.putProperty("wsdlFilePath", (Object)(this.retriever == null ? "" : this.retriever.getWsdlFileName()));
        } else if (this.wsdlSource == 1) {
            d.putProperty("wsdlDownloadUrl", null);
            d.putProperty("wsdlDownloadedWsdl", null);
            d.putProperty("wsdlDownloadedSchemas", null);
            d.putProperty("wsdlFilePath", (Object)this.jTxtLocalFilename.getText().trim());
        }
        d.putProperty("wsdlPackageName", (Object)this.getPackageName());
        d.putProperty("clientStubType", this.jCbxClientType.getSelectedItem());
        d.putProperty("jaxVersion", this.jComboBoxJaxVersion.getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(WizardDescriptor d) {
        ClassPath classPath;
        this.wizardDescriptor = d;
        this.project = Templates.getProject((WizardDescriptor)d);
        WebModule wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        EjbJar em = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        Car car = Car.getCar((FileObject)this.project.getProjectDirectory());
        this.projectType = car != null ? 3 : (em != null ? 2 : (wm != null ? 1 : 0));
        if (this.projectType > 0 && !Util.isJavaEE5orHigher((Project)this.project)) {
            this.jLblClientType.setVisible(true);
            this.jCbxClientType.setVisible(true);
        }
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        FileObject wsimportFO = null;
        FileObject wscompileFO = null;
        if (sgs.length > 0 && (classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile")) != null) {
            wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
            wscompileFO = classPath.findResource("com/sun/xml/rpc/tools/ant/Wscompile.class");
        }
        boolean jsr109OldSupported = this.isJsr109OldSupported(this.project);
        boolean jsr109Supported = this.isJsr109Supported(this.project);
        boolean jwsdpSupported = this.isJwsdpSupported(this.project);
        boolean wsitSupported = this.isWsitSupported(this.project);
        if (this.projectType > 0) {
            this.jLabelJaxVersion.setEnabled(false);
            this.jComboBoxJaxVersion.setEnabled(false);
            if (Util.isJavaEE5orHigher((Project)this.project)) {
                this.jComboBoxJaxVersion.setSelectedItem("JAX-WS");
            } else if (!jsr109OldSupported && !jsr109Supported || !jsr109Supported && jsr109OldSupported && jwsdpSupported || wsitSupported) {
                this.jComboBoxJaxVersion.setSelectedItem("JAX-WS");
            } else {
                this.jComboBoxJaxVersion.setSelectedItem("JAX-RPC");
            }
        } else if (Util.isSourceLevel16orHigher((Project)this.project)) {
            this.jLabelJaxVersion.setEnabled(false);
            this.jComboBoxJaxVersion.setEnabled(false);
            this.jComboBoxJaxVersion.setSelectedItem("JAX-WS");
        } else if (Util.getSourceLevel((Project)this.project).equals("1.5")) {
            if (wsimportFO != null) {
                this.jLabelJaxVersion.setEnabled(false);
                this.jComboBoxJaxVersion.setEnabled(false);
                this.jComboBoxJaxVersion.setSelectedItem("JAX-WS");
            } else if (wscompileFO != null) {
                this.jLabelJaxVersion.setEnabled(false);
                this.jComboBoxJaxVersion.setEnabled(false);
                this.jComboBoxJaxVersion.setSelectedItem("JAX-RPC");
            } else {
                this.jLabelJaxVersion.setEnabled(true);
                this.jComboBoxJaxVersion.setEnabled(true);
            }
        } else {
            this.jLabelJaxVersion.setEnabled(false);
            this.jComboBoxJaxVersion.setEnabled(false);
            this.jComboBoxJaxVersion.setSelectedItem("JAX-RPC");
        }
        try {
            this.settingFields = true;
            Project p = Templates.getProject((WizardDescriptor)d);
            this.jTxtProject.setText(ProjectUtils.getInformation((Project)p).getDisplayName());
            this.jTxtWsdlURL.setText((String)d.getProperty("wsdlDownloadUrl"));
            this.jTxtLocalFilename.setText(this.retriever != null ? this.retriever.getWsdlFileName() : "");
            this.jTxtWsdlURL.setText((String)d.getProperty("wsdlFilePath"));
            this.jCbxPackageName.setModel(this.getPackageModel(p));
            this.jCbxPackageName.setSelectedItem(this.getPackageItem((String)d.getProperty("wsdlPackageName")));
            Integer source = (Integer)d.getProperty("wsdlSource");
            if (source == null || source < 0 || source > 2) {
                source = new Integer(0);
            }
            this.wsdlSource = source;
            this.wsdlTmpFile = null;
            this.retriever = null;
            this.downloadMsg = null;
            this.enableWsdlSourceFields(this.wsdlSource == 0, this.wsdlSource == 1, this.wsdlSource == 2);
            this.btnGrpWsdlSource.setSelected(this.getSelectedRadioButton(this.wsdlSource).getModel(), true);
            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)p.getProjectDirectory());
            Object selectedStub = d.getProperty("clientStubType");
            DefaultComboBoxModel stubModel = new DefaultComboBoxModel();
            if (clientSupport != null) {
                List clientStubs = clientSupport.getStubDescriptors();
                Iterator iter = clientStubs.iterator();
                while (iter.hasNext()) {
                    stubModel.addElement(iter.next());
                }
                if (!clientStubs.contains(selectedStub)) {
                    selectedStub = null;
                }
                if (!jsr109OldSupported && !jsr109Supported || !jsr109Supported && jsr109OldSupported && jwsdpSupported || wsitSupported) {
                    selectedStub = this.getJAXRPCClientStub(clientStubs);
                    this.jCbxClientType.setEnabled(false);
                }
            } else {
                selectedStub = null;
            }
            this.jCbxClientType.setModel(stubModel);
            if (selectedStub != null) {
                this.jCbxClientType.setSelectedItem(selectedStub);
            }
        }
        finally {
            this.settingFields = false;
        }
    }

    private ClientStubDescriptor getJAXRPCClientStub(List<ClientStubDescriptor> clientStubs) {
        for (ClientStubDescriptor clientStub : clientStubs) {
            if (!clientStub.getName().equals("jaxrpc_static_client")) continue;
            return clientStub;
        }
        return null;
    }

    public void validatePanel() throws WizardValidationException {
        if (!this.valid(this.wizardDescriptor)) {
            throw new WizardValidationException((JComponent)this, "", "");
        }
        this.retrieverFailed = false;
        this.retriever = null;
        if ((this.projectType != 0 && !Util.isJavaEE5orHigher((Project)this.project) || this.projectType == 0 && this.jComboBoxJaxVersion.getSelectedItem().equals("JAX-RPC")) && this.wsdlSource != 1) {
            this.retriever = new WsdlRetriever(this, this.wsdlSource == 0 ? this.jTxtWsdlProject.getText() : this.jTxtWsdlURL.getText().trim());
            Task task = new Task((Runnable)this.retriever);
            try {
                task.run();
                task.waitFinished(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.retriever.getState() != 3) {
                this.retrieverFailed = true;
                throw new WizardValidationException((JComponent)this, "", "");
            }
            this.wizardDescriptor.putProperty("wsdlFilePath", (Object)(this.retriever == null ? "" : this.retriever.getWsdlFileName()));
        }
    }

    private ComboBoxModel getPackageModel(Project p) {
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] groups = sources.getSourceGroups("java");
        ComboBoxModel result = groups.length > 1 ? PackageView.createListView((SourceGroup)groups[0]) : (groups.length == 1 ? PackageView.createListView((SourceGroup)groups[0]) : new DefaultComboBoxModel());
        return result;
    }

    private Object getPackageItem(String name) {
        String result = name;
        ComboBoxModel model = this.jCbxPackageName.getModel();
        int max = model.getSize();
        for (int i = 0; i < max; ++i) {
            Object item = model.getElementAt(i);
            if (!item.toString().equals(name)) continue;
            result = item;
            break;
        }
        return result;
    }

    private String getPackageName() {
        return this.jCbxPackageName.getEditor().getItem().toString().trim();
    }

    private JRadioButton getSelectedRadioButton(int selected) {
        JRadioButton result = this.jRbnProject;
        switch (selected) {
            case 0: {
                result = this.jRbnProject;
                break;
            }
            case 1: {
                result = this.jRbnFilesystem;
                break;
            }
            case 2: {
                result = this.jRbnUrl;
            }
        }
        return result;
    }

    private byte[] getDownloadWsdl() {
        byte[] result = null;
        if (this.retriever != null && this.retriever.getState() == 3) {
            result = this.retriever.getWsdl();
        }
        return result;
    }

    private List getDownloadedSchemas() {
        List result = null;
        if (this.retriever != null && this.retriever.getState() == 3) {
            result = this.retriever.getSchemas();
        }
        return result;
    }

    private String getDownloadUrl() {
        String result = "";
        if (this.retriever != null) {
            result = this.retriever.getWsdlUrl();
        } else if (this.wsdlSource == 2) {
            result = WsdlRetriever.beautifyUrlName(this.jTxtWsdlURL.getText().trim());
        } else if (this.wsdlSource == 0) {
            result = this.jTxtWsdlProject.getText().trim();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean valid(WizardDescriptor wizardDescriptor) {
        String packageName;
        Project p;
        block45: {
            SourceGroup[] sgs;
            List clientStubs;
            p = Templates.getProject((WizardDescriptor)wizardDescriptor);
            if (!this.checkNonJsr109Valid(wizardDescriptor)) {
                return false;
            }
            WebServicesClientSupport clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)p.getProjectDirectory());
            List list = clientStubs = clientSupport != null ? clientSupport.getStubDescriptors() : null;
            if (clientStubs == null || clientStubs.size() == 0) {
                wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_NoStubsDefined"));
                return false;
            }
            if (this.jComboBoxJaxVersion.getSelectedItem().equals("JAX-RPC") && (sgs = WebServiceClientCreator.getJavaSourceGroups(this.project)).length <= 0) {
                wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_MissingSourceRoot"));
                return false;
            }
            if (this.wsdlSource == 0 || this.wsdlSource == 2) {
                String wsdlUrl;
                String string = wsdlUrl = this.wsdlSource == 0 ? this.jTxtWsdlProject.getText().trim() : this.jTxtWsdlURL.getText().trim();
                if (wsdlUrl == null || wsdlUrl.length() == 0) {
                    wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_EnterURL"));
                    return false;
                }
                if (this.retrieverFailed && this.retriever != null) {
                    if (this.retriever.getState() < 3) {
                        wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_DownloadProgress", (Object)(this.downloadMsg != null ? this.downloadMsg : NbBundle.getMessage(ClientInfo.class, (String)"LBL_Unknown"))));
                        return false;
                    }
                    if (this.retriever.getState() > 3) {
                        if (this.downloadMsg != null) {
                            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_DownloadFailed", (Object)this.downloadMsg));
                        } else {
                            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_DownloadFailedUnknown"));
                        }
                        return false;
                    }
                }
            } else if (this.wsdlSource == 1) {
                String wsdlFilePath = this.jTxtLocalFilename.getText().trim();
                if (wsdlFilePath == null || wsdlFilePath.length() == 0) {
                    wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_EnterFilename"));
                    return false;
                }
                File f = new File(wsdlFilePath);
                if (f == null) {
                    wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_WsdlInvalid"));
                    return false;
                }
                if (!f.exists()) {
                    wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_WsdlDoesNotExist"));
                    return false;
                }
                FileReader fr = null;
                BufferedReader lnReader = null;
                try {
                    fr = new FileReader(f);
                    if (!this.jComboBoxJaxVersion.getSelectedItem().equals("JAX-RPC") || (lnReader = new LineNumberReader(fr)) == null) break block45;
                    String line = null;
                    try {
                        line = ((LineNumberReader)lnReader).readLine();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    while (line != null) {
                        if (line.indexOf("REPLACE_WITH_ACTUAL_URL") > 0) {
                            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_WrongWsdl"));
                            boolean ioe = false;
                            return ioe;
                        }
                        try {
                            line = ((LineNumberReader)lnReader).readLine();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (FileNotFoundException fne) {
                    wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_WsdlDoesNotExist"));
                }
                finally {
                    try {
                        if (lnReader != null) {
                            lnReader.close();
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        }
        if ((packageName = this.getPackageName()) == null || packageName.length() == 0) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_EnterJavaPackageName"));
            return false;
        }
        if (!Utilities.isJavaPackage(packageName)) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_PackageInvalid"));
            return false;
        }
        JaxWsModel jaxWsModel = (JaxWsModel)p.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Service[] services = jaxWsModel.getServices();
            for (int i = 0; i < services.length; ++i) {
                if (services[i].getWsdlUrl() == null || !packageName.equals(services[i].getPackageName())) continue;
                wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_PackageUsedForService", (Object)services[i].getServiceName()));
                return false;
            }
            Client[] clients = jaxWsModel.getClients();
            for (int i = 0; i < clients.length; ++i) {
                if (!packageName.equals(clients[i].getPackageName())) continue;
                wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_PackageUsedForClient", (Object)clients[i].getName()));
                return false;
            }
        }
        if (this.projectHasEmbeddedSpaces()) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_SPACE_IN_PROJECT_PATH"));
        } else {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)"");
        }
        if (JavaMetamodel.getManager().isScanInProgress()) {
            if (!this.isWaitingForScan) {
                this.isWaitingForScan = true;
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JavaMetamodel.getManager().waitScanFinished();
                        ClientInfo.this.isWaitingForScan = false;
                        ClientInfo.this.descriptorPanel.fireChangeEvent();
                    }
                });
            }
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"MSG_ScanningInProgress"));
            return false;
        }
        wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)"");
        return true;
    }

    private boolean projectHasEmbeddedSpaces() {
        FileObject projectDir = this.project.getProjectDirectory();
        File projectDirFile = FileUtil.toFile((FileObject)projectDir);
        String path = projectDirFile.getAbsolutePath();
        int index = path.indexOf(" ");
        return index != -1;
    }

    private J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID;
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (serverInstanceID = provider.getServerInstanceID()) != null && serverInstanceID.length() > 0) {
            return Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        }
        return null;
    }

    private boolean isJsr109Supported(Project project) {
        J2eePlatform j2eePlatform = this.getJ2eePlatform(project);
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("jsr109");
        }
        return false;
    }

    private boolean isJsr109OldSupported(Project project) {
        J2eePlatform j2eePlatform = this.getJ2eePlatform(project);
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("wscompile");
        }
        return false;
    }

    private boolean isJwsdpSupported(Project project) {
        J2eePlatform j2eePlatform = this.getJ2eePlatform(project);
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("jwsdp");
        }
        return false;
    }

    private boolean isWsitSupported(Project project) {
        J2eePlatform j2eePlatform = this.getJ2eePlatform(project);
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("wsit");
        }
        return false;
    }

    private boolean checkNonJsr109Valid(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        boolean jsr109Supported = this.isJsr109Supported(project);
        boolean jsr109oldSupported = this.isJsr109OldSupported(project);
        boolean jwsdpSupported = this.isJwsdpSupported(project);
        boolean wsitSupported = this.isWsitSupported(project);
        if ((!jsr109Supported && !jsr109oldSupported || !jsr109Supported && jsr109oldSupported && jwsdpSupported || wsitSupported) && Util.isSourceLevel14orLower((Project)project)) {
            wizardDescriptor.putProperty(PROP_ERROR_MESSAGE, (Object)NbBundle.getMessage(ClientInfo.class, (String)"ERR_NeedProperSourceLevel"));
            return false;
        }
        return true;
    }

    private boolean isWsCompileSupported(Project p) {
        J2eePlatform j2eePlatform;
        String serverInstanceID;
        boolean result = true;
        J2eeModuleProvider provider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (serverInstanceID = provider.getServerInstanceID()) != null && serverInstanceID.length() > 0 && !(j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID)).isToolSupported("wscompile")) {
            result = false;
        }
        return result;
    }

    private void wsdlUrlChanged() {
        this.retriever = null;
        this.updateTexts();
    }

    private void updateTexts() {
        if (!this.settingFields) {
            this.descriptorPanel.fireChangeEvent();
        }
    }

    private boolean isValidUrl(String urlText) {
        return urlText != null && urlText.length() != 0;
    }

    @Override
    public void setWsdlDownloadMessage(String m) {
        this.downloadMsg = m;
        if (this.retriever.getState() >= 3) {
            this.jTxtWsdlURL.setEditable(true);
            this.jTxtLocalFilename.setText(this.retriever.getWsdlFileName());
        }
        this.descriptorPanel.fireChangeEvent();
    }

    private int resolveImports(File file) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            ImportsHandler handler = new ImportsHandler();
            saxParser.parse(new InputSource(new FileInputStream(file)), (DefaultHandler)handler);
            int httpImport = handler.isHttpImport() ? 1 : 0;
            int wsdlImport = handler.isImportingWsdl() ? 1 : 0;
            return httpImport * 2 + wsdlImport;
        }
        catch (ParserConfigurationException ex) {
        }
        catch (SAXException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    private String browseProjectServices() {
        JaxWsExplorerPanel explorerPanel = new JaxWsExplorerPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)explorerPanel, NbBundle.getMessage(ClientInfo.class, (String)"TTL_SelectService"));
        explorerPanel.setDescriptor(descriptor);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor).equals(NotifyDescriptor.OK_OPTION)) {
            Node serviceNode = explorerPanel.getSelectedService();
            JaxWsWsdlCookie wsdlCookie = (JaxWsWsdlCookie)serviceNode.getCookie(JaxWsWsdlCookie.class);
            if (wsdlCookie != null) {
                return wsdlCookie.getWsdlURL();
            }
            JaxRpcWsdlCookie wsdl1Cookie = (JaxRpcWsdlCookie)serviceNode.getCookie(JaxRpcWsdlCookie.class);
            if (wsdl1Cookie != null) {
                return wsdl1Cookie.getWsdlURL();
            }
        }
        return null;
    }

    private static class ImportsHandler
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private boolean insideSchema;
        private boolean httpImport;
        private boolean importingWsdl;

        private ImportsHandler() {
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            String schemaLocation;
            if (W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) {
                String wsdlLocation;
                if ("types".equals(localname)) {
                    this.insideSchema = true;
                }
                if ("import".equals(localname) && (wsdlLocation = attributes.getValue("location")) != null && wsdlLocation.startsWith("http://")) {
                    this.httpImport = true;
                    this.importingWsdl = true;
                }
            }
            if (this.insideSchema && "import".equals(localname) && (schemaLocation = attributes.getValue("schemaLocation")) != null && schemaLocation.startsWith("http://")) {
                this.httpImport = true;
            }
        }

        public void endElement(String uri, String localname, String qname) throws SAXException {
            if ((W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) && "types".equals(localname)) {
                this.insideSchema = false;
            }
        }

        boolean isHttpImport() {
            return this.httpImport;
        }

        boolean isImportingWsdl() {
            return this.importingWsdl;
        }
    }

    private static class WsdlFileFilter
    extends FileFilter {
        private WsdlFileFilter() {
        }

        public boolean accept(File f) {
            boolean result = f.isDirectory() || "wsdl".equalsIgnoreCase(FileUtil.getExtension((String)f.getName()));
            return result;
        }

        public String getDescription() {
            return NbBundle.getMessage(ClientInfo.class, (String)"LBL_WsdlFilterDescription");
        }
    }
}

