/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.client.WebServicesClientView;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.registry.WebServiceMethod;
import org.netbeans.modules.websvc.core.jaxws.JaxWsUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ClientExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager;
    private BeanTreeView treeView;
    private FileObject srcFileObject;
    private Node selectedMethod;
    private Project[] projects;
    private Children rootChildren;
    private Node explorerClientRoot;
    private List projectNodeList;
    private JLabel jLblTreeView;

    public ClientExplorerPanel(FileObject srcFileObject) {
        this.srcFileObject = srcFileObject;
        this.projects = OpenProjects.getDefault().getOpenProjects();
        this.rootChildren = new Children.Array();
        this.explorerClientRoot = new AbstractNode(this.rootChildren);
        this.projectNodeList = new ArrayList();
        this.manager = new ExplorerManager();
        this.selectedMethod = null;
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLblTreeView.setText(NbBundle.getMessage(ClientExplorerPanel.class, (String)"LBL_AvailableWebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor((Component)this.treeView);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.projects.length; ++i) {
            LogicalViewProvider logicalProvider;
            Project srcFileProject = FileOwnerQuery.getOwner((FileObject)this.srcFileObject);
            if (srcFileProject == null || !JaxWsUtils.isProjectReferenceable(this.projects[i], srcFileProject) || (logicalProvider = (LogicalViewProvider)this.projects[i].getLookup().lookup(LogicalViewProvider.class)) == null) continue;
            Node rootNode = logicalProvider.createLogicalView();
            boolean jaxWsServices = false;
            Node servicesNode = JAXWSClientView.getJAXWSClientView().createJAXWSClientView(this.projects[i]);
            if (servicesNode != null) {
                Children.Array children = new Children.Array();
                Node[] nodes = servicesNode.getChildren().getNodes();
                if (nodes != null && nodes.length > 0) {
                    jaxWsServices = true;
                    Node[] filterNodes = new Node[nodes.length];
                    for (int j = 0; j < nodes.length; ++j) {
                        filterNodes[j] = new FilterNode(nodes[j]);
                    }
                    children.add(filterNodes);
                    this.projectNodeList.add(new ProjectNode((Children)children, rootNode));
                }
            }
            if (jaxWsServices || srcFileProject != this.projects[i]) continue;
            FileObject wsdlFolder = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.srcFileObject).getWsdlFolder();
            servicesNode = WebServicesClientView.getWebServicesClientView((FileObject)this.srcFileObject).createWebServiceClientView(wsdlFolder);
            if (servicesNode == null) continue;
            Children.Array children = new Children.Array();
            Node[] nodes = servicesNode.getChildren().getNodes();
            if (nodes == null || nodes.length <= 0) continue;
            jaxWsServices = true;
            Node[] filterNodes = new Node[nodes.length];
            for (int j = 0; j < nodes.length; ++j) {
                filterNodes[j] = new FilterNode(nodes[j]);
            }
            children.add(filterNodes);
            this.projectNodeList.add(new ProjectNode((Children)children, rootNode));
        }
        Node[] projectNodes = new Node[this.projectNodeList.size()];
        this.projectNodeList.toArray(projectNodes);
        this.rootChildren.add(projectNodes);
        this.manager.setRootContext(this.explorerClientRoot);
        this.treeView.expandAll();
        this.descriptor.setValid(false);
    }

    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Node getSelectedMethod() {
        return this.selectedMethod;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Node[] nodes;
        if (evt.getSource() == this.manager && "selectedNodes".equals(evt.getPropertyName()) && (nodes = this.manager.getSelectedNodes()) != null && nodes.length > 0) {
            Node node = nodes[0];
            if (node.getLookup().lookup(WsdlOperation.class) != null || node.getCookie(WebServiceMethod.class) != null) {
                this.selectedMethod = node;
                this.descriptor.setValid(true);
            } else {
                this.selectedMethod = null;
                this.descriptor.setValid(false);
            }
        }
    }

    private class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node rootNode) {
            super(children);
            this.rootNode = rootNode;
            this.setName(rootNode.getDisplayName());
        }

        public Image getIcon(int type) {
            return this.rootNode.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.rootNode.getOpenedIcon(type);
        }
    }
}

