/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.core.Utilities;
import org.netbeans.modules.websvc.customization.model.JavaMethod;
import org.netbeans.modules.websvc.customization.model.PortCustomization;
import org.netbeans.modules.websvc.customization.model.Provider;
import org.netbeans.modules.websvc.customization.model.impl.JAXWSQName;
import org.netbeans.modules.websvc.customization.multiview.ExternalBindingTablePanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PortPanel
extends SaveableSectionInnerPanel {
    private Port port;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener defaultListener;
    private ProviderActionListener providerActionListener;
    private Node node;
    private JCheckBox defaultMethodCB;
    private JLabel portAccessLabel;
    private JTextField portAccessMethodText;
    private JCheckBox providerCB;
    private JLabel serviceLabel;
    private JLabel serviceName;

    public PortPanel(SectionView view, Port port, Node node) {
        super(view);
        this.port = port;
        this.model = this.port.getModel();
        this.node = node;
        this.initComponents();
        this.serviceLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.serviceName.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.serviceName.setText(this.getParentOfPort(port));
        this.defaultMethodCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.portAccessMethodText.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.portAccessLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
        this.defaultListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultMethodCB);
        this.defaultMethodCB.addItemListener(itemListener);
        if (!this.isClient()) {
            this.providerCB.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
            this.providerActionListener = new ProviderActionListener();
            ActionListener providerListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.providerActionListener, (Object)this.providerCB);
            this.providerCB.addActionListener(providerListener);
        } else {
            this.providerCB.setVisible(false);
        }
        this.addModifier(this.portAccessMethodText);
        this.addModifier(this.defaultMethodCB);
        this.addValidatee(this.portAccessMethodText);
    }

    private boolean isClient() {
        Client client = (Client)this.node.getLookup().lookup(Client.class);
        return client != null;
    }

    private String getParentOfPort(Port port) {
        Service service = (Service)port.getParent();
        return service.getName();
    }

    private void sync() {
        List ee = this.port.getExtensibilityElements(PortCustomization.class);
        if (ee.size() == 1) {
            PortCustomization pc = (PortCustomization)ee.get(0);
            JavaMethod jm = pc.getJavaMethod();
            if (jm != null) {
                this.setPortAccessMethod(jm.getName());
            } else {
                this.defaultMethodCB.setSelected(true);
                this.portAccessMethodText.setEnabled(false);
                this.portAccessMethodText.setBackground(Color.LIGHT_GRAY);
            }
            Provider provider = pc.getProvider();
            if (provider != null) {
                if (provider.isEnabled()) {
                    this.providerCB.setSelected(true);
                } else {
                    this.providerCB.setSelected(false);
                }
            } else {
                this.providerCB.setSelected(false);
            }
        } else {
            this.providerCB.setSelected(false);
            this.defaultMethodCB.setSelected(true);
            this.portAccessMethodText.setEnabled(false);
            this.portAccessMethodText.setBackground(Color.LIGHT_GRAY);
        }
    }

    public void setPortAccessMethod(String name) {
        this.portAccessMethodText.setText(name);
    }

    public String getPortAccessMethod() {
        return this.portAccessMethodText.getText();
    }

    public void setProvider(boolean enable) {
        this.providerCB.setSelected(enable);
    }

    public boolean isProvider() {
        return this.providerCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List ee = this.port.getExtensibilityElements(PortCustomization.class);
        if (jComponent == this.providerCB) {
            if (ee.size() == 1) {
                PortCustomization pc = (PortCustomization)ee.get(0);
                Provider provider = pc.getProvider();
                if (this.isProvider()) {
                    if (provider == null) {
                        try {
                            provider = (Provider)this.model.getFactory().create((WSDLComponent)pc, JAXWSQName.PROVIDER.getQName());
                            this.model.startTransaction();
                            provider.setEnabled(true);
                            pc.setProvider(provider);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else if (provider != null) {
                    try {
                        this.model.startTransaction();
                        pc.removeProvider(provider);
                        if (pc.getChildren().size() == 0) {
                            this.port.removeExtensibilityElement((ExtensibilityElement)pc);
                        }
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (this.isProvider()) {
                WSDLComponentFactory factory = this.model.getFactory();
                PortCustomization pc = (PortCustomization)factory.create((WSDLComponent)this.port, JAXWSQName.BINDINGS.getQName());
                Provider provider = (Provider)factory.create((WSDLComponent)pc, JAXWSQName.PROVIDER.getQName());
                try {
                    this.model.startTransaction();
                    provider.setEnabled(true);
                    pc.setProvider(provider);
                    this.port.addExtensibilityElement((ExtensibilityElement)pc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        } else if (jComponent == this.portAccessMethodText || jComponent == this.defaultMethodCB) {
            PortCustomization pc;
            JavaMethod jm;
            String text = this.portAccessMethodText.getText();
            if (text != null && !text.trim().equals("") && !this.defaultMethodCB.isSelected()) {
                if (!Utilities.isJavaIdentifier((String)text)) {
                    return;
                }
                if (ee.size() == 1) {
                    PortCustomization pc2 = (PortCustomization)ee.get(0);
                    JavaMethod jm2 = pc2.getJavaMethod();
                    if (jm2 == null) {
                        try {
                            jm2 = (JavaMethod)this.model.getFactory().create((WSDLComponent)pc2, JAXWSQName.METHOD.getQName());
                            this.model.startTransaction();
                            jm2.setName(text);
                            pc2.setJavaMethod(jm2);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    } else {
                        try {
                            this.model.startTransaction();
                            jm2.setName(text);
                            this.wsdlDirty = true;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                } else {
                    WSDLComponentFactory factory = this.model.getFactory();
                    PortCustomization pc3 = (PortCustomization)factory.create((WSDLComponent)this.port, JAXWSQName.BINDINGS.getQName());
                    JavaMethod jm3 = (JavaMethod)factory.create((WSDLComponent)pc3, JAXWSQName.METHOD.getQName());
                    try {
                        this.model.startTransaction();
                        jm3.setName(text);
                        pc3.setJavaMethod(jm3);
                        this.port.addExtensibilityElement((ExtensibilityElement)pc3);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else if (ee.size() == 1 && (jm = (pc = (PortCustomization)ee.get(0)).getJavaMethod()) != null) {
                try {
                    this.model.startTransaction();
                    pc.removeJavaMethod(jm);
                    if (pc.getChildren().size() == 0) {
                        this.port.removeExtensibilityElement((ExtensibilityElement)pc);
                    }
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.portAccessMethodText && !Utilities.isJavaIdentifier((String)val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.portAccessMethodText) {
            PortCustomization pc;
            JavaMethod jm;
            String methodName = "";
            List ee = this.port.getExtensibilityElements(PortCustomization.class);
            if (ee.size() == 1 && (jm = (pc = (PortCustomization)ee.get(0)).getJavaMethod()) != null) {
                methodName = jm.getName();
            }
            this.portAccessMethodText.setText(methodName);
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.portAccessLabel = new JLabel();
        this.portAccessMethodText = new JTextField();
        this.providerCB = new JCheckBox();
        this.defaultMethodCB = new JCheckBox();
        this.serviceLabel = new JLabel();
        this.serviceName = new JLabel();
        this.portAccessLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("TOOLTIP_GET_PORT"));
        this.portAccessMethodText.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_PORT_ACCESS_METHOD"));
        this.providerCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_PROVIDER").charAt(0));
        this.providerCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_PROVIDER"));
        this.providerCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.providerCB.setMargin(new Insets(0, 0, 0, 0));
        this.providerCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_PROVIDER"));
        this.providerCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_PROVIDER"));
        this.defaultMethodCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultMethodCB.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultMethodCB.setMargin(new Insets(0, 0, 0, 0));
        this.defaultMethodCB.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_USE_DEFAULT"));
        this.serviceLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENCLOSING_SERVICE"));
        this.serviceLabel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("LBL_ENCLOSING_SERVICE"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.serviceLabel).add((Component)this.portAccessLabel)).add(14, 14, 14).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.portAccessMethodText, -2, 159, -2).add(20, 20, 20).add((Component)this.defaultMethodCB)).add((Component)this.serviceName, -2, 182, -2))).add((Component)this.providerCB)).addContainerGap(77, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.serviceLabel).add((Component)this.serviceName)).addPreferredGap(0, 22, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.portAccessLabel).add((Component)this.portAccessMethodText, -2, -1, -2).add((Component)this.defaultMethodCB)).add(21, 21, 21).add((Component)this.providerCB).add(19, 19, 19)));
    }

    class ProviderActionListener
    implements ActionListener {
        ProviderActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PortPanel.this.providerCB) {
                if (PortPanel.this.providerCB.isSelected()) {
                    NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"WARN_PROVIDER_INTERFACE"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
                    if (notifyDesc.getValue() == NotifyDescriptor.NO_OPTION) {
                        PortPanel.this.providerCB.setSelected(false);
                        return;
                    }
                }
                PortPanel.this.setValue(PortPanel.this.providerCB, null);
            }
        }
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (PortPanel.this.defaultMethodCB.isSelected()) {
                PortPanel.this.portAccessMethodText.setEnabled(false);
                PortPanel.this.portAccessMethodText.setBackground(Color.LIGHT_GRAY);
            } else {
                PortPanel.this.portAccessMethodText.setEnabled(true);
                PortPanel.this.portAccessMethodText.setBackground(Color.WHITE);
                PortPanel.this.portAccessMethodText.requestFocus();
            }
        }
    }
}

