/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class ExcludingLookup
extends Lookup {
    private Lookup delegate;
    private Object classes;

    ExcludingLookup(Lookup delegate, Class[] classes) {
        this.delegate = delegate;
        this.classes = classes.length == 1 ? classes[0] : classes;
    }

    public String toString() {
        return "ExcludingLookup: " + this.delegate + " excludes: " + Arrays.asList(this.classes());
    }

    public Lookup.Result lookup(Lookup.Template template) {
        if (template == null) {
            throw new NullPointerException();
        }
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return Lookup.EMPTY.lookup(template);
        }
        return new R(template.getType(), this.delegate.lookup(template));
    }

    public Object lookup(Class clazz) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(clazz)) {
            return null;
        }
        Object res = this.delegate.lookup(clazz);
        if (this.isObjectAccessible(clazz, res, 0)) {
            return res;
        }
        return null;
    }

    public Lookup.Item lookupItem(Lookup.Template template) {
        if (this.areSubclassesOfThisClassAlwaysExcluded(template.getType())) {
            return null;
        }
        Lookup.Item retValue = this.delegate.lookupItem(template);
        if (this.isObjectAccessible(template.getType(), retValue, 2)) {
            return retValue;
        }
        return null;
    }

    private boolean areSubclassesOfThisClassAlwaysExcluded(Class c) {
        Class[] arr = this.classes();
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].isAssignableFrom(c)) continue;
            return true;
        }
        return false;
    }

    final Class[] classes() {
        if (this.classes instanceof Class[]) {
            return (Class[])this.classes;
        }
        return new Class[]{(Class)this.classes};
    }

    private static boolean isAccessible(Class[] barriers, Class from, Class to) {
        if (to == null || !from.isAssignableFrom(to)) {
            return false;
        }
        for (int i = 0; i < barriers.length; ++i) {
            if (to != barriers[i]) continue;
            return false;
        }
        if (from == to) {
            return true;
        }
        if (ExcludingLookup.isAccessible(barriers, from, to.getSuperclass())) {
            return true;
        }
        Class<?>[] interfaces = to.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!ExcludingLookup.isAccessible(barriers, from, interfaces[i])) continue;
            return true;
        }
        return false;
    }

    private final boolean isObjectAccessible(Class from, Object to, int type) {
        if (to == null) {
            return false;
        }
        return ExcludingLookup.isObjectAccessible(this.classes(), from, to, type);
    }

    static final boolean isObjectAccessible(Class[] barriers, Class from, Object to, int type) {
        if (to == null) {
            return false;
        }
        switch (type) {
            case 0: {
                return ExcludingLookup.isAccessible(barriers, from, to.getClass());
            }
            case 1: {
                return ExcludingLookup.isAccessible(barriers, from, (Class)to);
            }
            case 2: {
                Lookup.Item item = (Lookup.Item)to;
                return ExcludingLookup.isAccessible(barriers, from, item.getType());
            }
        }
        throw new IllegalStateException("Type: " + type);
    }

    final Collection filter(Class[] arr, Class from, Collection c, int type) {
        AbstractCollection ret = null;
        block0: while (true) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object res = it.next();
                if (!ExcludingLookup.isObjectAccessible(arr, from, res, type)) {
                    if (ret != null) continue;
                    if (type == 1) {
                        ret = new HashSet();
                        continue block0;
                    }
                    ret = new ArrayList(c.size());
                    continue block0;
                }
                if (ret == null) continue;
                ret.add(res);
            }
            break;
        }
        return ret != null ? ret : c;
    }

    private final class R
    extends WaitableResult
    implements LookupListener {
        private Lookup.Result result;
        private Object listeners;
        private Class from;

        R(Class from, Lookup.Result delegate) {
            this.from = from;
            this.result = delegate;
        }

        protected void beforeLookup(Lookup.Template t) {
            if (this.result instanceof WaitableResult) {
                ((WaitableResult)this.result).beforeLookup(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener l) {
            boolean add;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(true, l, this.listeners);
                add = this.listeners != null;
            }
            if (add) {
                this.result.addLookupListener(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener l) {
            boolean remove;
            R r = this;
            synchronized (r) {
                this.listeners = AbstractLookup.modifyListenerList(false, l, this.listeners);
                remove = this.listeners == null;
            }
            if (remove) {
                this.result.removeLookupListener(this);
            }
        }

        public Collection allInstances() {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allInstances(), 0);
        }

        public Set allClasses() {
            return (Set)ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allClasses(), 1);
        }

        public Collection allItems() {
            return ExcludingLookup.this.filter(ExcludingLookup.this.classes(), this.from, this.result.allItems(), 2);
        }

        public void resultChanged(LookupEvent ev) {
            if (ev.getSource() == this.result) {
                this.collectFires(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void collectFires(Collection evAndListeners) {
            Object[] arr;
            R r = this;
            synchronized (r) {
                if (this.listeners == null) {
                    return;
                }
                if (this.listeners instanceof LookupListener) {
                    arr = new LookupListener[]{(LookupListener)this.listeners};
                } else {
                    ArrayList l = (ArrayList)this.listeners;
                    arr = l.toArray(new LookupListener[l.size()]);
                }
            }
            Object[] ll = arr;
            LookupEvent newev = new LookupEvent(this);
            AbstractLookup.notifyListeners(ll, newev, evAndListeners);
        }
    }
}

