/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.options;

import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JavaIndentEngine;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.options.OptionSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JavaOptions
extends BaseOptions {
    public static final String JAVA = "java";
    public static final String COMPLETION_AUTO_POPUP_PROP = "completionAutoPopup";
    public static final String COMPLETION_CASE_SENSITIVE_PROP = "completionCaseSensitive";
    public static final String COMPLETION_NATURAL_SORT_PROP = "completionNaturalSort";
    public static final String COMPLETION_AUTO_POPUP_DELAY_PROP = "completionAutoPopupDelay";
    public static final String FORMAT_SPACE_BEFORE_PARENTHESIS_PROP = "formatSpaceBeforeParenthesis";
    public static final String FORMAT_COMPOUND_BRACKET_ADD_NL_PROP = "formatCompoundBracketAddNL";
    public static final String FAST_IMPORT_SELECTION_PROP = "fastImportSelection";
    private static final String HELP_ID = "editing.editor.java";
    public static final String JAVADOC_BGCOLOR = "javaDocBGColor";
    public static final String JAVADOC_AUTO_POPUP_DELAY_PROP = "javaDocAutoPopupDelay";
    public static final String JAVADOC_PREFERRED_SIZE_PROP = "javaDocPreferredSize";
    public static final String JAVADOC_AUTO_POPUP_PROP = "javaDocAutoPopup";
    public static final String SHOW_DEPRECATED_MEMBERS_PROP = "showDeprecatedMembers";
    public static final String COMPLETION_INSTANT_SUBSTITUTION_PROP = "completionInstantSubstitution";
    public static final String FAST_IMPORT_PACKAGE_PROP = "fastImportPackage";
    public static final String GOTO_CLASS_CASE_SENSITIVE_PROP = "gotoClassCaseSensitive";
    public static final String GOTO_CLASS_SHOW_INNER_CLASSES_PROP = "gotoClassShowInnerClasses";
    public static final String GOTO_CLASS_SHOW_LIBRARY_CLASSES_PROP = "gotoClassShowLibraryClasses";
    static final String[] JAVA_PROP_NAMES = OptionSupport.mergeStringArrays((String[])BaseOptions.BASE_PROP_NAMES, (String[])new String[]{"completionAutoPopup", "completionCaseSensitive", "completionAutoPopupDelay", "formatSpaceBeforeParenthesis", "formatCompoundBracketAddNL", "javaDocBGColor", "javaDocPreferredSize", "javaDocAutoPopup", "showDeprecatedMembers", "completionInstantSubstitution", "completionNaturalSort", "fastImportPackage", "gotoClassCaseSensitive", "gotoClassShowInnerClasses", "gotoClassShowLibraryClasses", "codeFoldingProps"});
    static final long serialVersionUID = -7951549840240159575L;

    public JavaOptions() {
        this(JavaKit.class, JAVA);
    }

    public JavaOptions(Class kitClass, String typeName) {
        super(kitClass, typeName);
    }

    public void setFormatSpaceBeforeParenthesis(boolean v) {
        this.setSettingBoolean("java-format-space-before-parenthesis", v, FORMAT_SPACE_BEFORE_PARENTHESIS_PROP);
    }

    public void setFormatCompoundBracketAddNL(boolean v) {
        this.setSettingBoolean("java-format-newline-before-brace", v, FORMAT_COMPOUND_BRACKET_ADD_NL_PROP);
    }

    public boolean getCompletionAutoPopup() {
        return this.getSettingBoolean("completion-auto-popup");
    }

    public void setCompletionAutoPopup(boolean v) {
        this.setSettingBoolean("completion-auto-popup", v, COMPLETION_AUTO_POPUP_PROP);
    }

    public boolean getCompletionCaseSensitive() {
        return this.getSettingBoolean("completion-case-sensitive");
    }

    public void setCompletionCaseSensitive(boolean v) {
        this.setSettingBoolean("completion-case-sensitive", v, COMPLETION_CASE_SENSITIVE_PROP);
    }

    public boolean getCompletionInstantSubstitution() {
        return this.getSettingBoolean("completion-instant-substitution");
    }

    public void setCompletionInstantSubstitution(boolean v) {
        this.setSettingBoolean("completion-instant-substitution", v, COMPLETION_INSTANT_SUBSTITUTION_PROP);
    }

    public int getCompletionAutoPopupDelay() {
        return this.getSettingInteger("completion-auto-popup-delay");
    }

    public void setCompletionAutoPopupDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("completion-auto-popup-delay", delay, COMPLETION_AUTO_POPUP_DELAY_PROP);
    }

    public boolean getJavaDocAutoPopup() {
        return this.getSettingBoolean("javadoc-auto-popup");
    }

    public void setJavaDocAutoPopup(boolean auto) {
        this.setSettingBoolean("javadoc-auto-popup", auto, JAVADOC_AUTO_POPUP_PROP);
    }

    public Color getJavaDocBGColor() {
        return (Color)this.getSettingValue("javadoc-bg-color");
    }

    public void setJavaDocBGColor(Color c) {
        this.setSettingValue("javadoc-bg-color", c, JAVADOC_BGCOLOR);
    }

    public Dimension getJavaDocPreferredSize() {
        return (Dimension)this.getSettingValue("javadoc-preferred-size");
    }

    public void setJavaDocPreferredSize(Dimension d) {
        this.setSettingValue("javadoc-preferred-size", d, JAVADOC_PREFERRED_SIZE_PROP);
    }

    public boolean getShowDeprecatedMembers() {
        return this.getSettingBoolean("show-deprecated-members");
    }

    public void setShowDeprecatedMembers(boolean v) {
        this.setSettingBoolean("show-deprecated-members", v, SHOW_DEPRECATED_MEMBERS_PROP);
    }

    public boolean getCompletionNaturalSort() {
        return this.getSettingBoolean("completion-natural-sort");
    }

    public void setCompletionNaturalSort(boolean v) {
        this.setSettingBoolean("completion-natural-sort", v, COMPLETION_NATURAL_SORT_PROP);
    }

    public int getFastImportSelection() {
        return this.getSettingInteger("fast-import-selection");
    }

    public void setFastImportSelection(int sel) {
        this.setSettingInteger("fast-import-selection", sel, FAST_IMPORT_SELECTION_PROP);
    }

    public boolean getFastImportPackage() {
        return this.getFastImportSelection() == 1;
    }

    public void setFastImportPackage(boolean v) {
        if (v) {
            this.setFastImportSelection(1);
        }
    }

    public boolean getGotoClassCaseSensitive() {
        return this.getSettingBoolean("goto-class-case-sensitive");
    }

    public void setGotoClassCaseSensitive(boolean v) {
        this.setSettingBoolean("goto-class-case-sensitive", v, GOTO_CLASS_CASE_SENSITIVE_PROP);
    }

    public boolean getGotoClassShowInnerClasses() {
        return this.getSettingBoolean("goto-class-show-inner-classes");
    }

    public void setGotoClassShowInnerClasses(boolean v) {
        this.setSettingBoolean("goto-class-show-inner-classes", v, GOTO_CLASS_SHOW_INNER_CLASSES_PROP);
    }

    public boolean getGotoClassShowLibraryClasses() {
        return this.getSettingBoolean("goto-class-show-library-classes");
    }

    public void setGotoClassShowLibraryClasses(boolean v) {
        this.setSettingBoolean("goto-class-show-library-classes", v, GOTO_CLASS_SHOW_LIBRARY_CLASSES_PROP);
    }

    protected Class getDefaultIndentEngineClass() {
        return JavaIndentEngine.class;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public Map getCodeFoldingProps() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(super.getCodeFoldingProps());
        Boolean val = (Boolean)this.getSettingValue("code-folding-collapse-method");
        map.put("code-folding-collapse-method", val);
        val = (Boolean)this.getSettingValue("code-folding-collapse-innerclass");
        map.put("code-folding-collapse-innerclass", val);
        val = (Boolean)this.getSettingValue("code-folding-collapse-import");
        map.put("code-folding-collapse-import", val);
        val = (Boolean)this.getSettingValue("code-folding-collapse-javadoc");
        map.put("code-folding-collapse-javadoc", val);
        val = (Boolean)this.getSettingValue("code-folding-collapse-initial-comment");
        map.put("code-folding-collapse-initial-comment", val);
        return map;
    }

    public void setCodeFoldingProps(Map props) {
        String name = "code-folding-enable";
        this.setSettingValue(name, props.get(name));
        name = "code-folding-collapse-method";
        this.setSettingValue(name, props.get(name));
        name = "code-folding-collapse-innerclass";
        this.setSettingValue(name, props.get(name));
        name = "code-folding-collapse-import";
        this.setSettingValue(name, props.get(name));
        name = "code-folding-collapse-javadoc";
        this.setSettingValue(name, props.get(name));
        name = "code-folding-collapse-initial-comment";
        this.setSettingValue(name, props.get(name));
    }

    protected String getString(String key) {
        try {
            return NbBundle.getMessage((Class)JavaOptions.class, (String)key);
        }
        catch (MissingResourceException e) {
            return super.getString(key);
        }
    }
}

