/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.DocumentEvent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.java.JCExpression;
import org.netbeans.editor.ext.java.JavaSyntaxSupport;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeParameter;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.editor.java.NbJMIResultItem;
import org.netbeans.modules.editor.java.NbJavaSyntaxSupport;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.PositionBounds;

public class NbJavaJMISyntaxSupport
extends NbJavaSyntaxSupport {
    private JMIUtils jmiUtils;
    private HashMap featuresAtPosMap = new HashMap();

    public synchronized JMIUtils getJMIUtils() {
        if (this.jmiUtils == null) {
            this.jmiUtils = JMIUtils.get(this.getDocument());
        }
        return this.jmiUtils;
    }

    public NbJavaJMISyntaxSupport(BaseDocument doc) {
        super(doc);
        this.setJava15(true);
    }

    public JavaClass getJavaClass(int pos) {
        Feature f = this.getFeatureAtPos(pos, false);
        return f == null || !f.isValid() ? null : (f instanceof JavaClass ? (JavaClass)f : (JavaClass)f.getDeclaringClass());
    }

    public boolean isStaticBlock(int pos) {
        Feature f = this.getFeatureAtPos(pos, false);
        return f != null && f.isValid() ? (f.getModifiers() & 8) != 0 : false;
    }

    protected int getMethodStartPosition(int pos) {
        Feature f = this.getFeatureAtPos(pos, false);
        return f instanceof CallableFeature ? JavaMetamodel.getManager().getElementPosition((Element)f).getBegin().getOffset() : -1;
    }

    public Feature getFeatureAtPos(int pos, boolean includingJavadoc) {
        Integer posI = new Integer(pos);
        if (this.featuresAtPosMap.containsKey(posI)) {
            Element e = (Element)this.featuresAtPosMap.get(posI);
            if (e instanceof JavaDoc) {
                return (Feature)e.refImmediateComposite();
            }
            return (Feature)e;
        }
        Resource rsc = this.getResource();
        if (rsc == null) {
            this.featuresAtPosMap.put(posI, null);
            return null;
        }
        JavaClass jcls = null;
        List els = rsc.getClassifiers();
        boolean cont = true;
        block0: while (cont) {
            cont = false;
            Object[] features = els.toArray();
            for (int i = 0; i < features.length; ++i) {
                PositionBounds jbounds;
                Feature el = (Feature)features[i];
                PositionBounds bounds = JavaMetamodel.getManager().getElementPosition((Element)el);
                if (bounds.getBegin().getOffset() < pos && bounds.getEnd().getOffset() > pos) {
                    if (el instanceof JavaClass) {
                        jcls = (JavaClass)el;
                        els = jcls.getFeatures();
                        cont = true;
                        continue block0;
                    }
                    this.featuresAtPosMap.put(posI, el);
                    return el;
                }
                JavaDoc jd = el.getJavadoc();
                if (!includingJavadoc || jd == null || (jbounds = JavaMetamodel.getManager().getElementPosition((Element)jd)).getBegin().getOffset() >= pos || jbounds.getEnd().getOffset() <= pos) continue;
                this.featuresAtPosMap.put(posI, jd);
                return el;
            }
        }
        this.featuresAtPosMap.put(posI, jcls);
        return jcls;
    }

    protected void documentModified(DocumentEvent evt) {
        super.documentModified(evt);
        this.featuresAtPosMap.clear();
    }

    public Object findType(String varName, int varPos) {
        Object obj = super.findType(varName, varPos);
        if (!(obj instanceof JavaSyntaxSupport.JavaVariable)) {
            return obj;
        }
        JCExpression typeExp = ((JavaSyntaxSupport.JavaVariable)obj).getTypeExpression();
        JCExpression varExp = ((JavaSyntaxSupport.JavaVariable)obj).getVariableExpression();
        Type type = this.getType(typeExp);
        if (type != null) {
            type = this.processArrayDepth(type, this.getArrayDepth(varExp));
        }
        return type;
    }

    public int findLocalDeclarationPosition(String varName, int varPos) {
        Object obj = super.findType(varName, varPos);
        if (!(obj instanceof JavaSyntaxSupport.JavaVariable)) {
            return super.findLocalDeclarationPosition(varName, varPos);
        }
        return this.getExpressionPos(((JavaSyntaxSupport.JavaVariable)obj).getTypeExpression());
    }

    public Collection getLocalVariableNames(String namePrefix, int pos, boolean exactMatch) {
        Map varMap = this.getLocalVariableMap(pos);
        if (varMap != null) {
            if (namePrefix != null && namePrefix.length() > 0) {
                return this.getJMIUtils().filterNames(varMap.keySet(), namePrefix, exactMatch);
            }
            if (!exactMatch) {
                return varMap.keySet();
            }
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getLocalVariableNamesOfType(int offset, Type type) {
        Map localVarMap = this.getLocalVariableMap(offset);
        Collection varNames = this.getLocalVariableNames("", offset, false);
        ArrayList<String> matchingVarNames = new ArrayList<String>();
        Iterator it = varNames.iterator();
        while (it.hasNext()) {
            String varName = (String)it.next();
            JavaSyntaxSupport.OffsetJavaVariable var = (JavaSyntaxSupport.OffsetJavaVariable)localVarMap.get(varName);
            Type varType = this.getType(var.getTypeExpression());
            if (!NbJavaJMISyntaxSupport.isSubType(varType, type)) continue;
            matchingVarNames.add(varName);
        }
        return matchingVarNames;
    }

    public Collection getGlobalVariableNamesOfType(int offset, Type type) {
        Map globalVarMap = this.getGlobalVariableMap(offset);
        ArrayList<String> matchingVarNames = new ArrayList<String>();
        Iterator it = globalVarMap.keySet().iterator();
        while (it.hasNext()) {
            String varName = (String)it.next();
            Type varType = (Type)globalVarMap.get(varName);
            if (!NbJavaJMISyntaxSupport.isSubType(varType, type)) continue;
            matchingVarNames.add(varName);
        }
        return matchingVarNames;
    }

    public Collection getLocalVariableNamesOfArrayType(int offset) {
        Map localVarMap = this.getLocalVariableMap(offset);
        Collection varNames = this.getLocalVariableNames("", offset, false);
        ArrayList<String> matchingVarNames = new ArrayList<String>();
        Iterator it = varNames.iterator();
        while (it.hasNext()) {
            String varName = (String)it.next();
            JavaSyntaxSupport.OffsetJavaVariable var = (JavaSyntaxSupport.OffsetJavaVariable)localVarMap.get(varName);
            Type varType = this.getType(var.getTypeExpression());
            if (!(varType instanceof Array)) continue;
            matchingVarNames.add(varName);
        }
        return matchingVarNames;
    }

    public Collection getGlobalVariableNamesOfArrayType(int offset) {
        Map globalVarMap = this.getGlobalVariableMap(offset);
        ArrayList<String> matchingVarNames = new ArrayList<String>();
        Iterator it = globalVarMap.keySet().iterator();
        while (it.hasNext()) {
            String varName = (String)it.next();
            Type varType = (Type)globalVarMap.get(varName);
            if (!(varType instanceof Array)) continue;
            matchingVarNames.add(varName);
        }
        return matchingVarNames;
    }

    private static boolean isSubType(Type type, Type ofType) {
        boolean subType = type.equals(ofType);
        if (!subType && type instanceof ClassDefinition && ofType instanceof ClassDefinition) {
            subType = ((ClassDefinition)type).isSubTypeOf((ClassDefinition)ofType);
        }
        return subType;
    }

    private int getExpressionPos(JCExpression exp) {
        return Math.min(exp.getTokenCount() > 0 ? exp.getTokenOffset(0) : Integer.MAX_VALUE, exp.getParameterCount() > 0 ? this.getExpressionPos(exp.getParameter(0)) : Integer.MAX_VALUE);
    }

    private int getArrayDepth(JCExpression exp) {
        return exp.getExpID() == 7 ? exp.getTokenCount() / 2 : 0;
    }

    private String getTypeName(JCExpression exp) {
        switch (exp.getExpID()) {
            case 1: 
            case 14: {
                return exp.getTokenText(0);
            }
            case 4: {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < exp.getParameterCount(); ++i) {
                    sb.append(this.getTypeName(exp.getParameter(i)));
                    if (i >= exp.getParameterCount() - 1) continue;
                    sb.append('.');
                }
                return sb.toString();
            }
            case 17: {
                return this.getTypeName(exp.getParameter(0));
            }
        }
        throw new IllegalStateException();
    }

    private Type getType(JCExpression typeExp) {
        Type type = null;
        switch (typeExp.getExpID()) {
            case 19: {
                type = this.getJMIUtils().resolveType("java.lang.Object");
                break;
            }
            case 7: {
                type = this.processArrayDepth(this.getType(typeExp.getParameter(0)), this.getArrayDepth(typeExp));
                break;
            }
            case 17: {
                type = this.getType(typeExp.getParameter(0));
                if (!(type instanceof JavaClass) || ((JavaClass)type).getTypeParameters().isEmpty()) break;
                ArrayList<Type> params = new ArrayList<Type>(typeExp.getParameterCount() - 1);
                for (int i = 1; i < typeExp.getParameterCount(); ++i) {
                    params.add(this.getType(typeExp.getParameter(i)));
                }
                type = this.getJMIUtils().resolveParameterizedType((JavaClass)type, params);
                break;
            }
            case 4: {
                type = this.getType(typeExp.getParameter(0));
                if (type != null && !(type instanceof UnresolvedClass)) {
                    int i = 1;
                    while (type instanceof ClassDefinition && i < typeExp.getParameterCount()) {
                        if (!((type = ((ClassDefinition)type).getInnerClass(this.getTypeName(typeExp.getParameter(i++)), true)) instanceof JavaClass) || ((JavaClass)type).getTypeParameters().isEmpty()) continue;
                        type = this.getJMIUtils().resolveParameterizedType((JavaClass)type, null);
                    }
                    break;
                }
                type = this.getJMIUtils().resolveType(this.getTypeName(typeExp));
            }
            default: {
                Feature f;
                TypeParameter tp;
                Iterator it;
                String typeName = this.getTypeName(typeExp);
                JavaClass outerCls = this.getJavaClass(typeExp.getTokenOffset(0));
                if (outerCls != null) {
                    JavaClass innerClass = outerCls.getInnerClass(typeName, true);
                    if (innerClass != null) {
                        type = innerClass;
                    } else {
                        it = outerCls.getTypeParameters().iterator();
                        while (it.hasNext()) {
                            tp = (TypeParameter)it.next();
                            if (!tp.getName().equals(typeName)) continue;
                            type = tp;
                            break;
                        }
                    }
                }
                if (type == null && (f = this.getFeatureAtPos(typeExp.getTokenOffset(0), false)) instanceof CallableFeature) {
                    it = ((CallableFeature)f).getTypeParameters().iterator();
                    while (it.hasNext()) {
                        tp = (TypeParameter)it.next();
                        if (!tp.getName().equals(typeName)) continue;
                        type = tp;
                        break;
                    }
                }
                if (type == null) {
                    type = this.getTypeFromName(typeName, true, outerCls, true);
                }
                if (type instanceof JavaClass && !((JavaClass)type).getTypeParameters().isEmpty()) {
                    type = this.getJMIUtils().resolveParameterizedType((JavaClass)type, null);
                }
                if (type != null) break;
                type = this.getJMIUtils().resolveType(typeName);
            }
        }
        return type;
    }

    private Type processArrayDepth(Type typ, int arrayDepth) {
        while (arrayDepth > 0) {
            typ = this.getJMIUtils().resolveArray(typ);
            --arrayDepth;
        }
        return typ;
    }

    public Type getTypeFromName(String name, boolean searchByName, JavaClass context, boolean useContext) {
        Object ret = this.getJMIUtils().resolveType(name);
        if (ret != null && !(ret instanceof UnresolvedClass)) {
            return ret;
        }
        JavaClass topClass = this.getTopJavaClass();
        ret = context != null ? context.getInnerClass(name, true) : (topClass != null ? topClass.getInnerClass(name, true) : null);
        if (ret != null) {
            return ret;
        }
        JavaClass importedClass = this.getJMIUtils().getImportedClass(name, topClass, (JavaClass)(useContext ? context : null), this.getResource());
        if (importedClass != null) {
            return importedClass;
        }
        if (searchByName) {
            List clsList = this.getJMIUtils().findClasses(null, name, true, false, true, (JavaClass)(useContext ? context : null), false, false);
            int maxWeight = 0;
            Iterator it = clsList.iterator();
            while (it.hasNext()) {
                JavaClass javaClass = (JavaClass)it.next();
                this.getJMIUtils();
                int weight = JMIUtils.getDefaultSelectionWeight(javaClass);
                if (weight <= maxWeight) continue;
                maxWeight = weight;
                ret = javaClass;
            }
            return ret;
        }
        return null;
    }

    public Resource getResource() {
        return this.getJMIUtils().getResource();
    }

    public JavaClass getTopJavaClass(Resource res) {
        Iterator cls;
        if (res != null && (cls = res.getClassifiers().iterator()).hasNext()) {
            return (JavaClass)cls.next();
        }
        return null;
    }

    public JavaClass getTopJavaClass() {
        return this.getTopJavaClass(this.getResource());
    }

    protected Map buildGlobalVariableMap(int pos) {
        this.refreshClassInfo();
        JavaClass cls = this.getJavaClass(pos);
        if (cls == null) {
            cls = this.getTopJavaClass();
        }
        if (cls != null) {
            HashMap<String, Type> varMap = new HashMap<String, Type>();
            List fldList = this.getJMIUtils().findFields((Type)cls, "", false, true, null, false, false, false, false);
            for (int i = fldList.size() - 1; i >= 0; --i) {
                Field fld = (Field)fldList.get(i);
                varMap.put(fld.getName(), fld.getType());
            }
            return varMap;
        }
        return null;
    }

    public Type getCommonType(Type typ1, Type typ2) {
        if (this.getJMIUtils().isAssignable(typ1, typ2)) {
            return typ1;
        }
        if (this.getJMIUtils().isAssignable(typ2, typ1)) {
            return typ2;
        }
        return null;
    }

    public List filterMethods(List methodList, List parmTypeList, boolean acceptMoreParameters) {
        if (parmTypeList == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CallableFeature> ret = new ArrayList<CallableFeature>();
        int parmTypeCnt = parmTypeList.size();
        Iterator it = methodList.iterator();
        while (it.hasNext()) {
            boolean isVarArg;
            CallableFeature m = (CallableFeature)it.next();
            List methodParms = m.getParameters();
            int methodParmsCnt = methodParms.size();
            boolean bl = isVarArg = methodParmsCnt > 0 ? ((Parameter)methodParms.get(methodParmsCnt - 1)).isVarArg() : false;
            if ((methodParmsCnt != parmTypeCnt || acceptMoreParameters && methodParmsCnt != 0) && (!acceptMoreParameters || methodParmsCnt <= parmTypeCnt) && (!isVarArg || methodParmsCnt > parmTypeCnt)) continue;
            boolean accept = true;
            boolean bestMatch = !acceptMoreParameters;
            for (int i = 0; accept && i < parmTypeCnt; ++i) {
                Type mpt = ((Parameter)methodParms.get(i < methodParmsCnt ? i : methodParmsCnt - 1)).getType();
                Type t = (Type)parmTypeList.get(i);
                if (t != null && !t.isValid() || !mpt.isValid()) {
                    accept = false;
                    break;
                }
                if (t != null) {
                    if (this.getJMIUtils().isEqualType(t, mpt)) continue;
                    bestMatch = false;
                    if (this.getJMIUtils().isAssignable(t, mpt) || !acceptMoreParameters && isVarArg && i == methodParmsCnt - 1 && methodParmsCnt == parmTypeCnt && t instanceof Array && this.getJMIUtils().isAssignable(((Array)t).getType(), mpt)) continue;
                    accept = false;
                    break;
                }
                if (mpt instanceof PrimitiveType) {
                    accept = false;
                    break;
                }
                bestMatch = false;
            }
            if (!accept) continue;
            if (bestMatch) {
                ret.clear();
            }
            ret.add(m);
            if (!bestMatch) continue;
            break;
        }
        return ret;
    }

    public boolean isImported(JavaClass cls) {
        JavaClass importedClass = this.getJMIUtils().getImportedClass(cls.getSimpleName(), this.getTopJavaClass(), null, this.getResource());
        return importedClass != null && importedClass.equals(cls);
    }

    public int[] getImportSectionBounds() {
        Resource resource = this.getResource();
        int startOffset = Integer.MAX_VALUE;
        int endOffset = Integer.MIN_VALUE;
        if (resource != null) {
            Iterator it = resource.getImports().iterator();
            while (it.hasNext()) {
                Import imp = (Import)it.next();
                PositionBounds pb = JavaMetamodel.getManager().getElementPosition((Element)imp);
                startOffset = Math.min(startOffset, pb.getBegin().getOffset());
                endOffset = Math.max(endOffset, pb.getEnd().getOffset());
            }
        }
        return new int[]{startOffset, endOffset};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getJavaDocURLs(Object obj) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (obj instanceof NbJMIResultItem) {
            obj = ((NbJMIResultItem)obj).getAssociatedObject();
        }
        if (obj instanceof Element) {
            JavaModel.getJavaRepository().beginTrans(false);
            try {
                if (((Element)obj).isValid()) {
                    URL u;
                    Attribute attr;
                    ClassDefinition cls;
                    if (obj instanceof JavaPackage) {
                        JavaPackage pkg = (JavaPackage)obj;
                        URL u2 = this.getDocFileObjects(pkg.getName(), "package-summary");
                        if (u2 != null) {
                            urlList.add(u2);
                        }
                    } else if (obj instanceof JavaClass) {
                        JavaClass cls2 = (JavaClass)obj;
                        URL u3 = this.getDocFileObjects(cls2.getName(), null);
                        if (u3 != null) {
                            urlList.add(u3);
                        }
                    } else if (obj instanceof CallableFeature) {
                        CallableFeature ctr = (CallableFeature)obj;
                        ClassDefinition cls3 = ctr.getDeclaringClass();
                        URL url = this.getDocFileObjects(cls3.getName(), null);
                        if (url != null) {
                            StringBuffer sb = new StringBuffer("#");
                            sb.append(ctr instanceof Constructor ? JMIUtils.getTypeName(ctr.getType(), false, false) : ctr.getName());
                            sb.append('(');
                            List parms = ctr.getParameters();
                            int cntM1 = parms.size() - 1;
                            for (int j = 0; j <= cntM1; ++j) {
                                String name = ((Parameter)parms.get(j)).getType().getName();
                                int idx = name.indexOf(60);
                                if (idx > -1) {
                                    name = name.substring(0, idx);
                                }
                                sb.append(name);
                                if (j >= cntM1) continue;
                                sb.append(", ");
                            }
                            sb.append(')');
                            try {
                                urlList.add(new URL(url.toExternalForm() + sb));
                            }
                            catch (MalformedURLException e) {
                                ErrorManager.getDefault().log(65536, e.toString());
                            }
                        }
                    } else if (obj instanceof Field) {
                        URL u4;
                        Field fld = (Field)obj;
                        ClassDefinition cls4 = fld.getDeclaringClass();
                        if (cls4 != null && (u4 = this.getDocFileObjects(cls4.getName(), null)) != null) {
                            try {
                                urlList.add(new URL(u4.toExternalForm() + '#' + fld.getName()));
                            }
                            catch (MalformedURLException e) {
                                ErrorManager.getDefault().log(65536, e.toString());
                            }
                        }
                    } else if (obj instanceof Attribute && (cls = (attr = (Attribute)obj).getDeclaringClass()) != null && (u = this.getClassDocFileObjects(cls)) != null) {
                        try {
                            urlList.add(new URL(u.toExternalForm() + '#' + attr.getName() + "()"));
                        }
                        catch (MalformedURLException e) {
                            ErrorManager.getDefault().log(65536, e.toString());
                        }
                    }
                }
            }
            finally {
                JavaModel.getJavaRepository().endTrans();
            }
        }
        URL[] ret = new URL[urlList.size()];
        urlList.toArray(ret);
        return ret;
    }

    public String openSource(Object item, boolean findDeclaration) {
        JavaClass elem = null;
        JavaClass typ = null;
        if (item instanceof JavaPackage) {
            if (!findDeclaration) {
                Node node;
                DataObject dob;
                String pkgName = ((JavaPackage)item).getName();
                if (pkgName == null || pkgName.length() <= 0) {
                    return null;
                }
                FileObject fo = this.findResource(pkgName.replace('.', '/'));
                if (fo != null && (dob = this.getDataObject(fo)) != null && (node = dob.getNodeDelegate()) != null) {
                    NodeOperation.getDefault().explore(node);
                    return null;
                }
                return pkgName;
            }
        } else if (item instanceof JavaClass) {
            elem = typ = (JavaClass)item;
        } else if (item instanceof Field) {
            if (findDeclaration) {
                elem = (Field)item;
                typ = ((Field)elem).getDeclaringClass();
            } else {
                typ = ((Field)item).getType();
                if (typ instanceof JavaClass) {
                    elem = JMIUtils.getSourceElementIfExists((ClassDefinition)typ);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        } else if (item instanceof CallableFeature) {
            elem = (CallableFeature)item;
            typ = ((CallableFeature)item).getDeclaringClass();
        }
        if (elem != null && JMIUtils.openElement(elem)) {
            return null;
        }
        return typ instanceof JavaClass ? typ.getName() : null;
    }

    private URL getClassDocFileObjects(ClassDefinition cls) {
        if (cls instanceof Array) {
            return null;
        }
        String pkgName = cls.getResource().getPackageName();
        String clsName = pkgName.length() > 0 ? cls.getName().substring(pkgName.length() + 1) : cls.getName();
        URL u = this.getDocFileObjects(pkgName, clsName);
        return u;
    }
}

