/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryEvent;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.editor.ext.java.CompoundFinder;
import org.netbeans.editor.ext.java.JCBaseFinder;
import org.netbeans.editor.ext.java.JCClass;
import org.netbeans.editor.ext.java.JCFinder;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.editor.java.MDRFinder;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class JCFinderFactory {
    private static JCFinderFactory DEFAULT;
    private HashMap cache = new HashMap();
    private WeakHashMap cpListening = new WeakHashMap();
    private WeakHashMap fakeClasses = new WeakHashMap();
    private static PropertyChangeListener cpListener;
    private SoftReference globalFinder;
    private GlobalPathRegistryListener gpListener;
    private final Object CACHE_LOCK = new Object();
    private boolean useFakeFinder = false;
    static /* synthetic */ Class class$org$netbeans$modules$editor$java$JCFinderFactory;

    private JCFinderFactory() {
        cpListener = new ClassPathListener();
        this.gpListener = new GlobalPathListener();
        GlobalPathRegistry.getDefault().addGlobalPathRegistryListener(this.gpListener);
    }

    public static synchronized JCFinderFactory getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new JCFinderFactory();
        }
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.cache = new HashMap();
            this.invalidateGlobalFinderCache();
        }
    }

    public void appendClass(JCClass cls) {
        this.useFakeFinder = true;
        this.fakeClasses.put(cls, null);
        this.resetCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JCFinder getFinder(FileObject fo) {
        ClassPath sourceCP = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        FileObject owner = sourceCP == null ? null : sourceCP.findOwnerRoot(fo);
        FileObject cacheKey = owner != null ? owner : fo;
        JCFinder finder = this.retrieveFromCache(cacheKey);
        if (finder != null) {
            return finder;
        }
        ArrayList<Object> finders = new ArrayList<Object>();
        ArrayList fileObjects = new ArrayList();
        if (owner != null) {
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            this.addClasspathFinders(finders, fileObjects, cp, false);
            cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
            this.addClasspathFinders(finders, fileObjects, cp, true);
            cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
            this.addClasspathFinders(finders, fileObjects, cp, true);
        } else {
            finders.add(this.getGlobalFinder());
        }
        if (this.useFakeFinder) {
            FakeFinder fakeFinder = new FakeFinder(JavaKit.class);
            finders.add((Object)fakeFinder);
        }
        finder = new CompoundFinder(finders, JavaKit.class);
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.cache.put(cacheKey, new SoftReference<JCFinder>(finder));
        }
        return finder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JCFinder getGlobalFinder() {
        JCFinder finder;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            finder = this.globalFinder != null ? (JCFinder)this.globalFinder.get() : null;
        }
        if (finder != null) {
            return finder;
        }
        ArrayList finders = new ArrayList();
        ArrayList fileObjects = new ArrayList();
        Iterator it = GlobalPathRegistry.getDefault().getPaths("classpath/source").iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            this.addClasspathFinders(finders, fileObjects, cp, false);
        }
        ArrayList allCPs = new ArrayList();
        allCPs.addAll(GlobalPathRegistry.getDefault().getPaths("classpath/compile"));
        allCPs.addAll(GlobalPathRegistry.getDefault().getPaths("classpath/boot"));
        it = allCPs.iterator();
        while (it.hasNext()) {
            ClassPath cp = (ClassPath)it.next();
            this.addClasspathFinders(finders, fileObjects, cp, true);
        }
        finder = new CompoundFinder(finders, JavaKit.class);
        Object object2 = this.CACHE_LOCK;
        synchronized (object2) {
            this.globalFinder = new SoftReference<JCFinder>(finder);
        }
        return finder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateGlobalFinderCache() {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.globalFinder = null;
        }
    }

    private void addClasspathFinders(List finders, List fileObjects, ClassPath cp, boolean findSources) {
        if (cp == null) {
            return;
        }
        Iterator it = cp.entries().iterator();
        while (it.hasNext()) {
            ClassPath.Entry entry = (ClassPath.Entry)it.next();
            if (findSources) {
                FileObject[] sroots = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots();
                if (sroots.length > 0) {
                    for (int i = 0; i < sroots.length; ++i) {
                        this.addFinder(finders, fileObjects, sroots[i]);
                    }
                    continue;
                }
                this.addFinder(finders, fileObjects, entry.getRoot());
                continue;
            }
            this.addFinder(finders, fileObjects, entry.getRoot());
        }
        if (!this.cpListening.containsKey(cp)) {
            cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)cpListener, (Object)cp));
            this.cpListening.put(cp, null);
        }
    }

    private void addFinder(List finders, List fileObjects, FileObject fo) {
        if (fo == null) {
            return;
        }
        if (fileObjects.contains(fo)) {
            return;
        }
        fileObjects.add(fo);
        MDRFinder finder = new MDRFinder(fo, this.getKitClass());
        if (finder != null) {
            finders.add(finder);
        }
    }

    protected Class getKitClass() {
        return JavaKit.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(FileObject fo) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            this.cache.remove(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JCFinder retrieveFromCache(FileObject fo) {
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            SoftReference ref = (SoftReference)this.cache.get(fo);
            return ref != null ? (JCFinder)ref.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(ClassPath cp) {
        ArrayList keys;
        Object object = this.CACHE_LOCK;
        synchronized (object) {
            keys = new ArrayList(this.cache.keySet());
        }
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            JCFinder finder = this.retrieveFromCache(fo);
            if (finder == null) {
                this.removeFromCache(fo);
                continue;
            }
            ClassPath c = ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile");
            if (c != null && c.equals(cp)) {
                this.removeFromCache(fo);
                continue;
            }
            c = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            if (c != null && c.equals(cp)) {
                this.removeFromCache(fo);
                continue;
            }
            c = ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot");
            if (c == null || !c.equals(cp)) continue;
            this.removeFromCache(fo);
        }
        this.invalidateGlobalFinderCache();
    }

    private class GlobalPathListener
    implements GlobalPathRegistryListener,
    Runnable {
        public void pathsAdded(GlobalPathRegistryEvent event) {
            JCFinderFactory.this.invalidateGlobalFinderCache();
            RequestProcessor.getDefault().post((Runnable)this, 1000);
        }

        public void pathsRemoved(GlobalPathRegistryEvent event) {
            JCFinderFactory.this.invalidateGlobalFinderCache();
        }

        public void run() {
            JCFinderFactory.getDefault().getGlobalFinder();
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        public void propertyChange(PropertyChangeEvent evt) {
            if ("entries".equals(evt.getPropertyName())) {
                if (!($assertionsDisabled || evt != null && evt.getSource() instanceof ClassPath)) {
                    throw new AssertionError();
                }
                JCFinderFactory.this.updateCache((ClassPath)evt.getSource());
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$java$JCFinderFactory == null ? (class$org$netbeans$modules$editor$java$JCFinderFactory = JCFinderFactory.class$("org.netbeans.modules.editor.java.JCFinderFactory")) : class$org$netbeans$modules$editor$java$JCFinderFactory).desiredAssertionStatus();
        }
    }

    private class FakeFinder
    extends JCBaseFinder {
        public FakeFinder(Class kitClass) {
            super(kitClass);
            Set keySet = JCFinderFactory.this.fakeClasses.keySet();
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                JCClass cls = (JCClass)iter.next();
                this.appendClass(cls);
            }
        }
    }
}

