/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.EditorKit;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.netbeans.modules.options.keymap.ActionImpl;
import org.netbeans.modules.options.keymap.CompoundAction;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class EditorBridge {
    private Map actions;
    private Map editorActionsMap;
    private Map actionNameToMimeTypes = new HashMap();
    private EditorSettings editorSettings;
    private Map keyBindingSettings = new HashMap();
    private Listener listener;
    static /* synthetic */ Class class$org$netbeans$modules$options$keymap$EditorBridge;

    Map getActions() {
        if (this.actions == null) {
            Map categories = EditorBridge.readCategories();
            this.actions = new HashMap();
            Iterator it = this.getEditorActionsMap().values().iterator();
            while (it.hasNext()) {
                HashSet<ActionImpl> a;
                ActionImpl action = (ActionImpl)it.next();
                String category = (String)categories.get(action.getId());
                if (category == null) {
                    category = NbBundle.getMessage((Class)(class$org$netbeans$modules$options$keymap$EditorBridge == null ? EditorBridge.class$("org.netbeans.modules.options.keymap.EditorBridge") : class$org$netbeans$modules$options$keymap$EditorBridge), (String)"CTL_Other");
                }
                if ((a = (HashSet<ActionImpl>)this.actions.get(category)) == null) {
                    a = new HashSet<ActionImpl>();
                    this.actions.put(category, a);
                }
                a.add(action);
            }
            this.actions.remove("Hidden");
        }
        return this.actions;
    }

    void refreshActions() {
        this.editorActionsMap = null;
        this.actions = null;
        this.actionNameToMimeTypes = new HashMap();
    }

    String getCurrentProfile() {
        return this.getEditorSettings().getCurrentKeyMapProfile();
    }

    void setCurrentProfile(String profile) {
        this.getEditorSettings().setCurrentKeyMapProfile(profile);
    }

    boolean isCustomProfile(String profile) {
        return this.getEditorSettings().isCustomKeymapProfile(profile);
    }

    Map readKeymap(String profile) {
        HashMap result = new HashMap();
        this.readKeymap(profile, "text/base", false, result);
        Iterator it = this.getEditorSettings().getMimeTypes().iterator();
        while (it.hasNext()) {
            this.readKeymap(profile, (String)it.next(), false, result);
        }
        return Collections.unmodifiableMap(result);
    }

    Map readKeymapDefaults(String profile) {
        HashMap result = new HashMap();
        this.readKeymap(profile, "text/base", true, result);
        Iterator it = this.getEditorSettings().getMimeTypes().iterator();
        while (it.hasNext()) {
            this.readKeymap(profile, (String)it.next(), true, result);
        }
        return Collections.unmodifiableMap(result);
    }

    void deleteProfile(String profile) {
        KeyBindingSettingsFactory kbs = this.getKeyBindingSettings("text/base");
        kbs.setKeyBindings(profile, null);
    }

    void saveKeymap(String profile, Map actionToShortcuts) {
        HashMap<String, ArrayList<MultiKeyBinding>> mimeTypeToKeyBinding = new HashMap<String, ArrayList<MultiKeyBinding>>();
        Iterator it = actionToShortcuts.keySet().iterator();
        while (it.hasNext()) {
            ActionImpl action = (ActionImpl)it.next();
            Set shortcuts = (Set)actionToShortcuts.get(action);
            if (action instanceof CompoundAction) {
                action = ((CompoundAction)action).getEditorAction();
            }
            if (!(action instanceof EditorAction)) continue;
            EditorAction editorAction = (EditorAction)action;
            Set mimeTypes = this.getMimeTypes(editorAction);
            Iterator it2 = shortcuts.iterator();
            while (it2.hasNext()) {
                String shortcut = (String)it2.next();
                MultiKeyBinding mkb = new MultiKeyBinding(Utils.stringToKeyStrokes2(shortcut), editorAction.getId());
                Iterator it3 = mimeTypes.iterator();
                while (it3.hasNext()) {
                    String mimeType = (String)it3.next();
                    ArrayList<MultiKeyBinding> l = (ArrayList<MultiKeyBinding>)mimeTypeToKeyBinding.get(mimeType);
                    if (l == null) {
                        l = new ArrayList<MultiKeyBinding>();
                        mimeTypeToKeyBinding.put(mimeType, l);
                    }
                    l.add(mkb);
                }
            }
        }
        it = this.keyBindingSettings.keySet().iterator();
        while (it.hasNext()) {
            String mimeType = (String)it.next();
            KeyBindingSettingsFactory kbs = (KeyBindingSettingsFactory)this.keyBindingSettings.get(mimeType);
            kbs.setKeyBindings(profile, (List)mimeTypeToKeyBinding.get(mimeType));
        }
    }

    private Map getEditorActionsMap() {
        if (this.editorActionsMap == null) {
            this.editorActionsMap = new HashMap();
            Iterator it = this.getEditorSettings().getMimeTypes().iterator();
            while (it.hasNext()) {
                this.initActionMap((String)it.next());
            }
            this.initActionMap("text/base");
        }
        return this.editorActionsMap;
    }

    private Set getMimeTypes(EditorAction a) {
        this.getEditorActionsMap();
        return (Set)this.actionNameToMimeTypes.get(a.getId());
    }

    private void initActionMap(String mimeType) {
        Object editorKit = null;
        if (mimeType.equals("text/base")) {
            editorKit = BaseKit.getKit((Class)ExtKit.class);
        } else {
            MimeLookup mimeLookup = MimeLookup.getMimeLookup((String)mimeType);
            editorKit = (EditorKit)mimeLookup.lookup(EditorKit.class);
        }
        if (editorKit == null) {
            if (System.getProperty("org.netbeans.optionsDialog") != null) {
                System.out.println("KeymapModel EditorKit not found for: " + mimeType);
            }
            return;
        }
        Action[] as = editorKit.getActions();
        int k = as.length;
        for (int i = 0; i < k; ++i) {
            Object isHidden = as[i].getValue("no-keybinding");
            if (isHidden instanceof Boolean && ((Boolean)isHidden).booleanValue()) continue;
            EditorAction action = new EditorAction((TextAction)as[i]);
            String id = action.getId();
            this.editorActionsMap.put(id, action);
            if (mimeType.equals("text/base")) {
                this.actionNameToMimeTypes.put(id, Collections.singleton("text/base"));
                continue;
            }
            HashSet<String> s = (HashSet<String>)this.actionNameToMimeTypes.get(id);
            if (s == null) {
                s = new HashSet<String>();
                this.actionNameToMimeTypes.put(id, s);
            }
            s.add(mimeType);
        }
    }

    private EditorSettings getEditorSettings() {
        if (this.editorSettings == null) {
            this.editorSettings = EditorSettings.getDefault();
        }
        return this.editorSettings;
    }

    private KeyBindingSettingsFactory getKeyBindingSettings(String mimeType) {
        if (this.keyBindingSettings.containsKey(mimeType)) {
            return (KeyBindingSettingsFactory)this.keyBindingSettings.get(mimeType);
        }
        KeyBindingSettingsFactory kbs = EditorSettings.getDefault().getKeyBindingSettings(new String[]{mimeType});
        this.keyBindingSettings.put(mimeType, kbs);
        this.getListener().add(kbs);
        return kbs;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    private void readKeymap(String profile, String mimeType, boolean defaults, Map map) {
        List keyBindings;
        KeyBindingSettingsFactory kbs = this.getKeyBindingSettings(mimeType);
        if (kbs == null) {
            return;
        }
        List list = keyBindings = defaults ? kbs.getKeyBindingDefaults(profile) : kbs.getKeyBindings(profile);
        if (keyBindings == null) {
            return;
        }
        Map actionNameToShortcuts = EditorBridge.convertKeymap(keyBindings);
        Iterator it = actionNameToShortcuts.keySet().iterator();
        while (it.hasNext()) {
            String actionName = (String)it.next();
            Set keyStrokes = (Set)actionNameToShortcuts.get(actionName);
            ActionImpl action = (ActionImpl)this.getEditorActionsMap().get(actionName);
            if (action == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("action not found " + actionName);
                continue;
            }
            Set s = (Set)map.get(action);
            if (s == null) {
                map.put(action, keyStrokes);
                continue;
            }
            s.addAll(keyStrokes);
        }
    }

    private static Map convertKeymap(List keyBindings) {
        HashMap<String, HashSet<String>> actionNameToShortcuts = new HashMap<String, HashSet<String>>();
        int k = keyBindings.size();
        for (int i = 0; i < k; ++i) {
            HashSet<String> keyStrokes;
            MultiKeyBinding mkb = (MultiKeyBinding)keyBindings.get(i);
            String keyStroke = "";
            Iterator it = mkb.getKeyStrokeList().iterator();
            if (it.hasNext()) {
                StringBuffer sb = new StringBuffer(Utilities.keyToString((KeyStroke)((KeyStroke)it.next())));
                while (it.hasNext()) {
                    sb.append(' ').append(Utilities.keyToString((KeyStroke)((KeyStroke)it.next())));
                }
                keyStroke = sb.toString();
            }
            if ((keyStrokes = (HashSet<String>)actionNameToShortcuts.get(mkb.getActionName())) == null) {
                keyStrokes = new HashSet<String>();
                actionNameToShortcuts.put(mkb.getActionName(), keyStrokes);
            }
            keyStrokes.add(keyStroke);
        }
        return actionNameToShortcuts;
    }

    private static Map readCategories() {
        HashMap<String, String> result = new HashMap<String, String>();
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("OptionsDialog/Actions");
        if (fo == null) {
            return result;
        }
        FileObject[] categories = fo.getChildren();
        int k = categories.length;
        for (int i = 0; i < k; ++i) {
            String categoryName = categories[i].getName();
            String bundleName = (String)categories[i].getAttribute("SystemFileSystem.localizingBundle");
            if (bundleName != null) {
                try {
                    categoryName = NbBundle.getBundle((String)bundleName).getString(categories[i].getPath());
                }
                catch (MissingResourceException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            FileObject[] actions = categories[i].getChildren();
            int jj = actions.length;
            for (int j = 0; j < jj; ++j) {
                if (actions[j].getExt().length() > 0) continue;
                String actionName = actions[j].getName();
                result.put(actionName, categoryName);
            }
        }
        return result;
    }

    public static class EditorAction
    implements ActionImpl {
        private TextAction action;
        private String name;
        private String id;
        private String delegaitngActionId;

        public EditorAction(TextAction a) {
            this.action = a;
        }

        public String getDisplayName() {
            if (this.name == null) {
                this.name = (String)this.action.getValue("ShortDescription");
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        public String getId() {
            if (this.id == null) {
                this.id = (String)this.action.getValue("Name");
            }
            return this.id;
        }

        public String getDelegatingActionId() {
            if (this.delegaitngActionId == null) {
                this.delegaitngActionId = (String)this.action.getValue("systemActionClassName");
            }
            return this.delegaitngActionId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof EditorAction)) {
                return false;
            }
            return ((EditorAction)o).getId().equals(this.getId());
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public String toString() {
            return super.toString() + ":" + this.getId();
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference model;
        private Set settings = new HashSet();

        Listener(EditorBridge model) {
            this.model = new WeakReference<EditorBridge>(model);
        }

        void add(KeyBindingSettingsFactory settings) {
            this.settings.add(settings);
            settings.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private EditorBridge getModel() {
            EditorBridge m = (EditorBridge)this.model.get();
            if (m != null) {
                return m;
            }
            Iterator it = this.settings.iterator();
            while (it.hasNext()) {
                ((KeyBindingSettingsFactory)it.next()).removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.settings = new HashSet();
            return null;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            EditorBridge model = this.getModel();
            if (model == null) {
                return;
            }
        }
    }
}

