/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.apihole.tasklist.SPIHole;
import org.netbeans.modules.tasklist.client.SuggestionManager;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionContext;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionProviders;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SuggestionsScanner
implements Cancellable {
    private ScanProgress progressMonitor;
    private final Set scanned = new HashSet();
    private SuggestionList list;
    private ProviderAcceptor typeFilter;
    private final SuggestionManagerImpl manager = (SuggestionManagerImpl)((Object)Lookup.getDefault().lookup(SuggestionManager.class));
    private final SuggestionProviders registry = SuggestionProviders.getDefault();
    private static Reference instance;
    private volatile boolean interrupted;
    private int suggestionsCounter;
    private int usabilityLimit = 503;
    private boolean workaround38476;
    private List cummulateInList;
    private static boolean lowMemoryWarning;
    private static int lowMemoryWarningCount;
    private static int MB;
    private static int REQUIRED_PER_ITERATION;
    private static int REQUIRED_PER_FULL_GC;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SuggestionsScanner() {
    }

    public static SuggestionsScanner getDefault() {
        if (instance == null) {
            return SuggestionsScanner.createDefault();
        }
        SuggestionsScanner scanner = (SuggestionsScanner)instance.get();
        if (scanner == null) {
            return SuggestionsScanner.createDefault();
        }
        return scanner;
    }

    private static SuggestionsScanner createDefault() {
        SuggestionsScanner scanner = new SuggestionsScanner();
        instance = new WeakReference<SuggestionsScanner>(scanner);
        return scanner;
    }

    public final synchronized void scan(DataObject.Container[] folders, SuggestionList list, ScanProgress monitor) {
        this.scan(folders, list, monitor, ProviderAcceptor.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void scan(DataObject.Container[] folders, SuggestionList list, ScanProgress monitor, ProviderAcceptor filter) {
        try {
            this.typeFilter = filter;
            this.progressMonitor = monitor;
            this.scan(folders, list, true);
        }
        finally {
            this.typeFilter = null;
            this.progressMonitor = null;
            if (monitor != null) {
                monitor.scanFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final synchronized void scan(DataObject.Container[] folders, SuggestionList list, boolean recursive) {
        lowMemoryWarning = false;
        lowMemoryWarningCount = 0;
        this.interrupted = false;
        this.assureMemory(REQUIRED_PER_ITERATION, true);
        this.suggestionsCounter = 0;
        try {
            this.list = list;
            this.workaround38476 = true;
            this.scanPreferred(folders, recursive);
            this.workaround38476 = false;
            if (this.progressMonitor != null) {
                int estimate = -1;
                this.progressMonitor.estimate(estimate);
                for (int i = 0; i < folders.length; ++i) {
                    FileObject fo = ((DataObject)folders[i]).getPrimaryFile();
                    estimate += SuggestionsScanner.countFolders(fo);
                }
                this.progressMonitor.estimate(estimate);
                this.progressMonitor.scanStarted();
            }
            for (int i = 0; i < folders.length; ++i) {
                if (this.shouldStop()) {
                    return;
                }
                DataObject.Container folder = folders[i];
                this.scanFolder(folder, recursive);
            }
        }
        finally {
            this.scanned.clear();
        }
    }

    static TopComponent[] openedTopComponents() {
        final Object[] wsResult = new Object[1];
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                Mode editorMode = WindowManager.getDefault().findMode("editor");
                if (editorMode == null) {
                    return new TopComponent[0];
                }
                return editorMode.getTopComponents();
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Mode editorMode = WindowManager.getDefault().findMode("editor");
                    wsResult[0] = editorMode == null ? new TopComponent[0] : editorMode.getTopComponents();
                }
            });
            return (TopComponent[])wsResult[0];
        }
        catch (InterruptedException e) {
            return new TopComponent[0];
        }
        catch (InvocationTargetException e) {
            return new TopComponent[0];
        }
    }

    private void scanPreferred(DataObject.Container[] folders, boolean recursive) {
        TopComponent[] views = SuggestionsScanner.openedTopComponents();
        DataObject[] roots = null;
        block0: for (int i = 0; i < views.length; ++i) {
            Node[] nodes = views[i].getActivatedNodes();
            if (nodes == null) continue;
            for (int n = 0; n < nodes.length; ++n) {
                DataObject dobj = (DataObject)nodes[n].getCookie(class$org$openide$loaders$DataObject == null ? SuggestionsScanner.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dobj == null) continue;
                if (roots == null) {
                    HashSet<DataObject> allRoots = new HashSet<DataObject>();
                    for (int r = 0; r < folders.length; ++r) {
                        DataObject[] droots = folders[r].getChildren();
                        for (int d = 0; d < droots.length; ++d) {
                            allRoots.add(droots[d]);
                        }
                    }
                    roots = allRoots.toArray(new DataObject[allRoots.size()]);
                }
                this.scanPreferred(dobj, roots, recursive);
                continue block0;
            }
        }
    }

    private void scanPreferred(DataObject dobj, DataObject[] roots, boolean recursive) {
        FileObject fo = dobj.getPrimaryFile();
        for (int i = 0; i < roots.length; ++i) {
            FileObject root = roots[i].getPrimaryFile();
            if (!root.equals(fo) && !(recursive ? FileUtil.isParentOf((FileObject)root, (FileObject)fo) : fo.getParent().equals(root))) continue;
            this.scanLeaf(dobj);
            this.scanned.add(dobj);
            break;
        }
    }

    private void scanFolder(DataObject.Container folder, boolean recursive) {
        DataObject[] children = folder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (this.shouldStop()) {
                return;
            }
            DataObject f = children[i];
            if (f instanceof DataObject.Container) {
                String name;
                if (!recursive || "CVS".equals(name = f.getPrimaryFile().getNameExt()) || "SCCS".equals(name) || ".svn".equals(name)) continue;
                if (this.progressMonitor == null) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$netbeans$modules$tasklist$suggestions$SuggestionsScanner == null ? SuggestionsScanner.class$("org.netbeans.modules.tasklist.suggestions.SuggestionsScanner") : class$org$netbeans$modules$tasklist$suggestions$SuggestionsScanner), (String)"ScanningFolder", (Object)f.getPrimaryFile().getNameExt()));
                } else {
                    this.progressMonitor.folderEntered(f.getPrimaryFile());
                }
                this.scanFolder((DataObject.Container)f, true);
                if (this.progressMonitor == null) continue;
                this.progressMonitor.folderScanned(f.getPrimaryFile());
                continue;
            }
            this.scanLeaf(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized List scanTopComponent(TopComponent topComponent, ProviderAcceptor acceptor) {
        List ret = Collections.EMPTY_LIST;
        try {
            this.cummulateInList = new LinkedList();
            this.progressMonitor = null;
            this.scanned.clear();
            this.workaround38476 = topComponent.isOpened();
            this.suggestionsCounter = 0;
            this.interrupted = false;
            this.typeFilter = acceptor;
            Node[] nodes = topComponent.getActivatedNodes();
            if (nodes == null) {
                List list = ret;
                return list;
            }
            int n = 0;
            if (n < nodes.length) {
                DataObject dobj = (DataObject)nodes[n].getCookie(DataObject.class);
                if (dobj == null) {
                    List list = ret;
                    return list;
                }
                this.scanLeaf(dobj);
            }
            ret = this.cummulateInList;
        }
        finally {
            this.cummulateInList = null;
            this.typeFilter = null;
        }
        return ret;
    }

    private void scanLeaf(DataObject dobj) {
        if (!dobj.isValid()) {
            return;
        }
        if (this.scanned.contains(dobj)) {
            return;
        }
        EditorCookie edit = (EditorCookie)dobj.getCookie(EditorCookie.class);
        if (edit == null) {
            return;
        }
        FileObject fo = dobj.getPrimaryFile();
        if (!VisibilityQuery.getDefault().isVisible(fo)) {
            return;
        }
        String extension = fo.getExt();
        boolean directAccess = "java".equals(extension) || "properties".equals(extension);
        boolean isPrimed = edit.getDocument() == null && !directAccess;
        SuggestionContext env = SPIHole.createSuggestionContext((DataObject)dobj);
        this.scanLeaf(env);
        if (isPrimed && edit.getOpenedPanes() == null && !this.workaround38476) {
            edit.close();
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.fileScanned(dobj.getPrimaryFile());
        }
    }

    private void scanLeaf(SuggestionContext env) {
        List providers = this.registry.getProviders();
        ListIterator it = providers.listIterator();
        while (it.hasNext()) {
            if (this.interrupted) {
                return;
            }
            this.interrupted = Thread.interrupted();
            SuggestionProvider provider = (SuggestionProvider)it.next();
            if (!$assertionsDisabled && this.typeFilter == null) {
                throw new AssertionError();
            }
            if (!this.typeFilter.accept(provider) || !(provider instanceof DocumentSuggestionProvider)) continue;
            List l = null;
            String type = null;
            try {
                type = provider.getType();
                l = ((DocumentSuggestionProvider)provider).scan(env);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error e) {
                ErrorManager.getDefault().annotate((Throwable)e, "Skipping faulty provider (" + provider + ").");
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            if (l == null || l.size() <= 0) continue;
            this.suggestionsCounter += l.size();
            if (this.cummulateInList == null) {
                this.manager.register(type, l, null, this.list, true);
                continue;
            }
            this.cummulateInList.addAll(l);
        }
    }

    private void assureMemory(int estimate, boolean tryGC) {
        Runtime rt = Runtime.getRuntime();
        long total = rt.totalMemory();
        long max = rt.maxMemory();
        long required = Math.max(total / 13L, (long)(estimate + REQUIRED_PER_FULL_GC));
        if (total == max && rt.freeMemory() < required) {
            if (tryGC) {
                try {
                    byte[] gcProvocation = new byte[(int)required];
                    gcProvocation[0] = 75;
                    gcProvocation = null;
                    return;
                }
                catch (OutOfMemoryError e) {
                    this.handleNoMemory();
                }
            } else {
                lowMemoryWarning = true;
            }
        } else if (lowMemoryWarning) {
            lowMemoryWarning = false;
            ++lowMemoryWarningCount;
        }
        if (lowMemoryWarningCount > 7 || total == max && rt.freeMemory() < (long)REQUIRED_PER_FULL_GC) {
            this.handleNoMemory();
        }
    }

    private void handleNoMemory() {
        this.interrupted = true;
        if (this.progressMonitor != null) {
            this.progressMonitor.scanTerminated(-1);
        }
    }

    private boolean shouldStop() {
        if (this.interrupted) {
            return true;
        }
        this.interrupted = Thread.interrupted();
        if (this.interrupted) {
            return true;
        }
        this.assureMemory(REQUIRED_PER_ITERATION, false);
        if (this.interrupted) {
            return true;
        }
        if (this.suggestionsCounter > this.getCountLimit()) {
            this.interrupted = true;
            if (this.progressMonitor != null) {
                this.progressMonitor.scanTerminated(-3);
            }
        }
        return this.interrupted;
    }

    private int getCountLimit() {
        return this.usabilityLimit;
    }

    private static int countFolders(FileObject projectFolder) {
        int count = 0;
        if (Thread.currentThread().isInterrupted()) {
            return count;
        }
        Enumeration en = projectFolder.getFolders(false);
        while (en.hasMoreElements()) {
            FileObject next = (FileObject)en.nextElement();
            String name = next.getNameExt();
            if ("CVS".equals(name) || "SCCS".equals(name) || ".svn".equals(name)) continue;
            ++count;
            count += SuggestionsScanner.countFolders(next);
        }
        return count;
    }

    public boolean cancel() {
        this.interrupted = true;
        if (this.progressMonitor != null) {
            this.progressMonitor.scanTerminated(-2);
        }
        return true;
    }

    public void setUsabilityLimit(int usabilityLimit) {
        this.usabilityLimit = usabilityLimit;
    }

    static {
        $assertionsDisabled = !SuggestionsScanner.class.desiredAssertionStatus();
        lowMemoryWarning = false;
        lowMemoryWarningCount = 0;
        MB = 0x100000;
        REQUIRED_PER_ITERATION = 2 * MB;
        REQUIRED_PER_FULL_GC = 7 * MB;
    }

    public static interface ScanProgress {
        public void estimate(int var1);

        public void scanStarted();

        public void folderEntered(FileObject var1);

        public void fileScanned(FileObject var1);

        public void folderScanned(FileObject var1);

        public void scanFinished();

        public void scanTerminated(int var1);
    }
}

