/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.tasklist.core.TLUtils;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.ProviderAcceptor;
import org.netbeans.modules.tasklist.suggestions.SuggestionCache;
import org.netbeans.modules.tasklist.suggestions.SuggestionImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionList;
import org.netbeans.modules.tasklist.suggestions.SuggestionManagerImpl;
import org.netbeans.modules.tasklist.suggestions.SuggestionsScanner;
import org.netbeans.modules.tasklist.suggestions.settings.ManagerSettings;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SuggestionsBroker {
    private static SuggestionsBroker instance;
    private SuggestionList list;
    private int clientCount = 0;
    private SuggestionManagerImpl manager = (SuggestionManagerImpl)SuggestionManagerImpl.getDefault();
    Env env = new Env();
    private Map openedFilesSuggestionsMap = new HashMap();
    private int allOpenedClientsCount = 0;
    private Job allOpenedJob;
    private SuggestionList allOpenedList;
    private static final Logger LOGGER;
    private List acceptors = new ArrayList(5);
    private final ProviderAcceptor compound = new ProviderAcceptor(){

        public boolean accept(SuggestionProvider provider) {
            Iterator it = SuggestionsBroker.this.acceptors.iterator();
            while (it.hasNext()) {
                ProviderAcceptor acceptor = (ProviderAcceptor)it.next();
                if (!acceptor.accept(provider)) continue;
                return true;
            }
            return false;
        }
    };
    private volatile Long currRequest = new Long(0L);
    private volatile Comparable finishedRequest = null;
    private SuggestionCache cache = null;
    private List docSuggestions = null;
    private RequestProcessor rp = new RequestProcessor("Suggestions Broker");
    private TopComponent currentTC = null;
    private Document currentDocument = null;
    private DataObject currentDO = null;
    private JEditorPane[] editorsWithCaretListener = null;
    private boolean currentModified = false;
    boolean pendingScan = false;
    private volatile RequestProcessor.Task scheduledRescan;
    private boolean waitingEvent = false;
    private boolean wait = false;
    private WindowSystemMonitor windowSystemMonitor;
    private DataSystemMonitor dataSystemMonitor;
    private EditorMonitor editorMonitor;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SuggestionsBroker() {
    }

    public static SuggestionsBroker getDefault() {
        if (instance == null) {
            instance = new SuggestionsBroker();
        }
        return instance;
    }

    public Job startBroker(ProviderAcceptor acceptor) {
        ++this.clientCount;
        if (this.clientCount == 1) {
            this.manager.dispatchRun();
            this.startActiveSuggestionFetching();
        }
        return new Job(acceptor);
    }

    public AllOpenedJob startAllOpenedBroker(ProviderAcceptor acceptor) {
        ++this.allOpenedClientsCount;
        if (this.allOpenedClientsCount == 1) {
            this.acceptors.add(acceptor);
            TopComponent[] documents = SuggestionsScanner.openedTopComponents();
            SuggestionsScanner scanner = SuggestionsScanner.getDefault();
            LinkedList allSuggestions = new LinkedList();
            for (int i = 0; i < documents.length; ++i) {
                DataObject dobj = SuggestionsBroker.extractDataObject(documents[i]);
                if (dobj == null) continue;
                FileObject fileObject = dobj.getPrimaryFile();
                if (this.openedFilesSuggestionsMap.keySet().contains(fileObject)) continue;
                List suggestions = scanner.scanTopComponent(documents[i], this.compound);
                this.openedFilesSuggestionsMap.put(fileObject, suggestions);
                allSuggestions.addAll(suggestions);
            }
            this.getAllOpenedSuggestionList().addRemove(allSuggestions, null, true, null, null);
            this.allOpenedJob = this.startBroker(acceptor);
        }
        return new AllOpenedJob(acceptor);
    }

    private SuggestionList getCurrentSuggestionsList() {
        if (this.list == null) {
            this.list = new SuggestionList();
        }
        return this.list;
    }

    private SuggestionList getAllOpenedSuggestionList() {
        if (this.allOpenedList == null) {
            this.allOpenedList = new SuggestionList();
        }
        return this.allOpenedList;
    }

    final Object getCurrRequest() {
        return this.currRequest;
    }

    private void startActiveSuggestionFetching() {
        LOGGER.info("Starting active suggestions fetching....");
        WindowSystemMonitor monitor = this.getWindowSystemMonitor();
        monitor.enableOpenCloseEvents();
        this.env.addTCRegistryListener(monitor);
        this.env.addDORegistryListener(this.getDataSystemMonitor());
        this.prepareRescanInAWT(false);
    }

    private boolean prepareCurrent() {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError((Object)"This method must be run in the AWT thread");
        }
        if (this.currentTC != null) {
            this.currentTC.removeComponentListener((ComponentListener)this.getWindowSystemMonitor());
            this.currentTC = null;
        }
        if (this.currentDocument != null) {
            this.currentDocument.removeDocumentListener(this.getEditorMonitor());
            this.handleDocHidden(this.currentDocument, this.currentDO);
        }
        this.removeCurrentCaretListeners();
        TopComponent tc = this.env.findActiveEditor();
        if (tc == null) {
            ArrayList previous = new ArrayList(this.getCurrentSuggestionsList().getTasks());
            this.getCurrentSuggestionsList().addRemove(null, previous, false, null, null);
            LOGGER.fine("Cannot find active source editor!");
            return false;
        }
        DataObject dao = SuggestionsBroker.extractDataObject(tc);
        if (dao == null) {
            LOGGER.warning("Suspicious editor without dataobject: " + tc);
            return false;
        }
        EditorCookie edit = (EditorCookie)dao.getCookie(EditorCookie.class);
        if (edit == null) {
            return false;
        }
        StyledDocument doc = edit.getDocument();
        if (doc == null) {
            LOGGER.fine("No document is loaded in editor!");
            return false;
        }
        this.currentDocument = doc;
        this.currentDocument.addDocumentListener(this.getEditorMonitor());
        this.currentTC = tc;
        this.currentTC.addComponentListener((ComponentListener)this.getWindowSystemMonitor());
        this.currentDO = dao;
        this.currentModified = dao.isModified();
        this.addCurrentCaretListeners();
        return true;
    }

    private boolean serveByCache() {
        if (this.cache != null) {
            this.docSuggestions = this.cache.lookup(this.currentDocument);
            if (this.docSuggestions != null) {
                this.manager.register(null, this.docSuggestions, null, this.getCurrentSuggestionsList(), true);
                this.finishedRequest = this.currRequest;
                return true;
            }
        }
        return false;
    }

    private static DataObject extractDataObject(TopComponent topComponent) {
        DataObject dobj = (DataObject)topComponent.getLookup().lookup(DataObject.class);
        if (dobj != null && dobj.isValid()) {
            return dobj;
        }
        return null;
    }

    private RequestProcessor.Task performRescanInRP(final TopComponent tc, final DataObject dataobject, int delay) {
        if (!$assertionsDisabled && this.currRequest == Long.MAX_VALUE) {
            throw new AssertionError((Object)"Wrap around logic needed!");
        }
        final Long origRequest = this.currRequest = new Long(this.currRequest + 1L);
        return this.serializeOnBackground(new Runnable(){

            public void run() {
                ArrayList previous;
                SuggestionsBroker.this.scheduledRescan = null;
                if (SuggestionsBroker.this.wait) {
                    SuggestionsBroker.this.waitingEvent = true;
                    return;
                }
                if (!SuggestionsBroker.isTopComponentOpened(tc)) {
                    return;
                }
                LOGGER.fine("Dispatching rescan() request to providers...");
                SuggestionsBroker.this.setScanning(true);
                List scannedSuggestions = SuggestionsBroker.this.manager.dispatchScan(dataobject, SuggestionsBroker.this.compound);
                if (!SuggestionsBroker.isTopComponentOpened(tc)) {
                    return;
                }
                if (SuggestionsBroker.this.allOpenedClientsCount > 0) {
                    FileObject fo = dataobject.getPrimaryFile();
                    List previous2 = (List)SuggestionsBroker.this.openedFilesSuggestionsMap.remove(fo);
                    SuggestionsBroker.this.openedFilesSuggestionsMap.put(fo, scannedSuggestions);
                    if (previous2 == null || previous2.size() != scannedSuggestions.size() || !previous2.containsAll(scannedSuggestions)) {
                        SuggestionsBroker.this.getAllOpenedSuggestionList().addRemove(scannedSuggestions, previous2, false, null, null);
                    }
                }
                if (!(SuggestionsBroker.this.clientCount <= 0 || (previous = new ArrayList(SuggestionsBroker.this.getCurrentSuggestionsList().getTasks())) != null && previous.size() == scannedSuggestions.size() && previous.containsAll(scannedSuggestions))) {
                    SuggestionsBroker.this.getCurrentSuggestionsList().addRemove(scannedSuggestions, previous, false, null, null);
                }
                if (SuggestionsBroker.this.finishedRequest == null || ((Comparable)origRequest).compareTo(SuggestionsBroker.this.finishedRequest) > 0) {
                    SuggestionsBroker.this.finishedRequest = (Comparable)origRequest;
                }
                if (SuggestionsBroker.this.currRequest == SuggestionsBroker.this.finishedRequest) {
                    SuggestionsBroker.this.setScanning(false);
                    LOGGER.fine("It was last pending request.");
                }
            }
        }, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTopComponentOpened(final TopComponent tc) {
        if (tc == null) {
            return false;
        }
        final boolean[] isOpened = new boolean[1];
        int attempt = 0;
        while (attempt < 57) {
            ErrorManager err;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        isOpened[0] = tc.isOpened();
                    }
                });
                boolean bl = isOpened[0];
                return bl;
            }
            catch (InterruptedException e) {
                err = ErrorManager.getDefault();
                err.annotate((Throwable)e, "[TODO] while get " + tc.getDisplayName() + " state, interrupted, ignoring...");
                err.notify(1, (Throwable)e);
                ++attempt;
            }
            catch (InvocationTargetException e) {
                err = ErrorManager.getDefault();
                err.annotate((Throwable)e, "[TODO] cannot get " + tc.getDisplayName() + " state.");
                err.notify((Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (attempt == 0) continue;
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    private RequestProcessor.Task serializeOnBackground(Runnable request, int delay) {
        return this.rp.post(request, delay, 1);
    }

    private void stuffCache(Document document, DataObject dataobject, boolean unregisterOnly) {
        boolean filteredTaskListFixed = false;
        if (!filteredTaskListFixed) {
            return;
        }
        SuggestionList tasklist = this.getCurrentSuggestionsList();
        if (tasklist.getTasks().size() == 0) {
            return;
        }
        Iterator it = tasklist.getTasks().iterator();
        ArrayList<SuggestionImpl> sgs = new ArrayList<SuggestionImpl>(tasklist.getTasks().size());
        while (it.hasNext()) {
            SuggestionImpl s = (SuggestionImpl)((Object)it.next());
            Object seed = s.getSeed();
            if (seed != SuggestionList.CATEGORY_NODE_SEED) {
                sgs.add(s);
            }
            Iterator sit = s.subtasksIterator();
            while (sit.hasNext()) {
                s = (SuggestionImpl)((Object)sit.next());
                seed = s.getSeed();
                if (seed == SuggestionList.CATEGORY_NODE_SEED) continue;
                sgs.add(s);
            }
        }
        if (!unregisterOnly) {
            if (this.cache == null) {
                this.cache = new SuggestionCache();
            }
            this.cache.add(document, dataobject, sgs);
        }
        if (sgs.size() > 0) {
            this.manager.register(null, null, sgs, tasklist, true);
        }
    }

    private void addCurrentCaretListeners() {
        JEditorPane[] panes;
        if (!$assertionsDisabled && this.editorsWithCaretListener != null) {
            throw new AssertionError((Object)"addCaretListeners() must not be called twice without removeCaretListeners() => memory leak");
        }
        EditorCookie edit = (EditorCookie)this.currentDO.getCookie(EditorCookie.class);
        if (edit != null && (panes = edit.getOpenedPanes()) != null && panes.length > 0) {
            this.editorsWithCaretListener = panes;
            for (int i = 0; i < this.editorsWithCaretListener.length; ++i) {
                this.editorsWithCaretListener[i].addCaretListener(this.getEditorMonitor());
            }
        }
    }

    private void removeCurrentCaretListeners() {
        if (this.editorsWithCaretListener != null) {
            for (int i = 0; i < this.editorsWithCaretListener.length; ++i) {
                this.editorsWithCaretListener[i].removeCaretListener(this.getEditorMonitor());
            }
        }
        this.editorsWithCaretListener = null;
    }

    private void scheduleRescan(boolean delay, final int scanDelay) {
        if (delay && this.scheduledRescan == null) {
            return;
        }
        if (this.scheduledRescan != null) {
            this.scheduledRescan.cancel();
            this.scheduledRescan = null;
            LOGGER.fine("Scheduled rescan task delayed by " + scanDelay + " ms.");
        }
        Runnable task = new Runnable(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void run() {
                if (SuggestionsBroker.this.prepareCurrent()) {
                    if (!$assertionsDisabled && !SuggestionsBroker.this.currentDO.equals(SuggestionsBroker.extractDataObject(SuggestionsBroker.this.currentTC))) {
                        throw new AssertionError((Object)("DO=" + SuggestionsBroker.this.currentDO + "  TC=" + SuggestionsBroker.this.currentTC));
                    }
                    SuggestionsBroker.this.scheduledRescan = SuggestionsBroker.this.performRescanInRP(SuggestionsBroker.this.currentTC, SuggestionsBroker.this.currentDO, scanDelay);
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$tasklist$suggestions$SuggestionsBroker == null ? (class$org$netbeans$modules$tasklist$suggestions$SuggestionsBroker = SuggestionsBroker.class$("org.netbeans.modules.tasklist.suggestions.SuggestionsBroker")) : class$org$netbeans$modules$tasklist$suggestions$SuggestionsBroker).desiredAssertionStatus();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    final void setFixing(boolean wait) {
        boolean wasWaiting = this.wait;
        this.wait = wait;
        if (!wait && wasWaiting && this.waitingEvent) {
            this.scheduleRescan(false, ManagerSettings.getDefault().getEditScanDelay());
            this.waitingEvent = false;
        }
    }

    private void componentsChanged() {
        this.prepareRescanInAWT(true);
    }

    private void prepareRescanInAWT(final boolean delay) {
        Runnable performer = new Runnable(){

            public void run() {
                if (SuggestionsBroker.this.clientCount > 0) {
                    SuggestionsBroker.this.prepareCurrent();
                    if (!SuggestionsBroker.this.serveByCache() && ManagerSettings.getDefault().isScanOnShow()) {
                        if (delay) {
                            SuggestionsBroker.this.performRescanInRP(SuggestionsBroker.this.currentTC, SuggestionsBroker.this.currentDO, ManagerSettings.getDefault().getShowScanDelay());
                        } else {
                            SuggestionsBroker.this.performRescanInRP(SuggestionsBroker.this.currentTC, SuggestionsBroker.this.currentDO, 0);
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            performer.run();
        } else {
            SwingUtilities.invokeLater(performer);
        }
    }

    private void stopActiveSuggestionFetching() {
        LOGGER.info("Stopping active suggestions fetching....");
        if (this.scheduledRescan != null) {
            this.scheduledRescan.cancel();
            this.scheduledRescan = null;
        }
        this.env.removeTCRegistryListener(this.getWindowSystemMonitor());
        this.env.removeDORegistryListener(this.getDataSystemMonitor());
        if (this.currentTC != null) {
            this.currentTC.removeComponentListener((ComponentListener)this.getWindowSystemMonitor());
            this.currentTC = null;
        }
        if (this.currentDocument != null) {
            this.currentDocument.removeDocumentListener(this.getEditorMonitor());
        }
        this.removeCurrentCaretListeners();
        this.handleDocHidden(this.currentDocument, this.currentDO);
        this.currentDocument = null;
    }

    private void setScanning(boolean scanning) {
    }

    private void handleDocHidden(Document document, DataObject dataobject) {
        if (this.currRequest != this.finishedRequest) {
            if (this.cache != null) {
                this.cache.remove(document);
            }
            this.stuffCache(document, dataobject, true);
        } else {
            this.stuffCache(document, dataobject, false);
        }
        this.docSuggestions = null;
    }

    private void handleTopComponentClosed(TopComponent tc) {
        this.componentsChanged();
        DataObject dobj = SuggestionsBroker.extractDataObject(tc);
        if (dobj == null) {
            return;
        }
        List previous = (List)this.openedFilesSuggestionsMap.remove(dobj.getPrimaryFile());
        if (previous != null) {
            this.getAllOpenedSuggestionList().addRemove(null, previous, false, null, null);
        }
    }

    private void handleTopComponentOpened(TopComponent tc) {
        if (tc.isShowing()) {
            this.componentsChanged();
        } else {
            DataObject dao = SuggestionsBroker.extractDataObject(tc);
            if (dao == null) {
                return;
            }
            this.performRescanInRP(tc, dao, ManagerSettings.getDefault().getShowScanDelay());
        }
    }

    private WindowSystemMonitor getWindowSystemMonitor() {
        if (this.windowSystemMonitor == null) {
            this.windowSystemMonitor = new WindowSystemMonitor();
        }
        return this.windowSystemMonitor;
    }

    private DataSystemMonitor getDataSystemMonitor() {
        if (this.dataSystemMonitor == null) {
            this.dataSystemMonitor = new DataSystemMonitor();
        }
        return this.dataSystemMonitor;
    }

    private EditorMonitor getEditorMonitor() {
        if (this.editorMonitor == null) {
            this.editorMonitor = new EditorMonitor();
        }
        return this.editorMonitor;
    }

    static {
        $assertionsDisabled = !SuggestionsBroker.class.desiredAssertionStatus();
        LOGGER = TLUtils.getLogger((Class)SuggestionsBroker.class);
    }

    static class Env {
        Env() {
        }

        void addTCRegistryListener(PropertyChangeListener pcl) {
            TopComponent.getRegistry().addPropertyChangeListener(pcl);
        }

        void removeTCRegistryListener(PropertyChangeListener pcl) {
            TopComponent.getRegistry().removePropertyChangeListener(pcl);
        }

        void addDORegistryListener(ChangeListener cl) {
            DataObject.getRegistry().addChangeListener(cl);
        }

        void removeDORegistryListener(ChangeListener cl) {
            DataObject.getRegistry().removeChangeListener(cl);
        }

        private TopComponent findActiveEditor() {
            Mode mode = WindowManager.getDefault().findMode("editor");
            if (mode == null) {
                return null;
            }
            TopComponent tc = mode.getSelectedTopComponent();
            if (tc instanceof CloneableEditorSupport.Pane) {
                return tc;
            }
            return null;
        }
    }

    private class EditorMonitor
    implements DocumentListener,
    CaretListener {
        private int prevLineNo = -1;

        private EditorMonitor() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            LOGGER.fine("EVENT document changed");
            if (ManagerSettings.getDefault().isScanOnEdit()) {
                SuggestionsBroker.this.scheduleRescan(false, ManagerSettings.getDefault().getEditScanDelay());
            }
        }

        public void removeUpdate(DocumentEvent e) {
            LOGGER.fine("EVENT document changed");
            if (ManagerSettings.getDefault().isScanOnEdit()) {
                SuggestionsBroker.this.scheduleRescan(false, ManagerSettings.getDefault().getEditScanDelay());
            }
        }

        public void caretUpdate(CaretEvent caretEvent) {
            LOGGER.fine("EVENT caret moved");
            SuggestionsBroker.this.scheduleRescan(true, ManagerSettings.getDefault().getEditScanDelay());
            if (SuggestionsBroker.this.currentDocument instanceof StyledDocument) {
                int offset = caretEvent.getDot();
                int lineno = NbDocument.findLineNumber((StyledDocument)((StyledDocument)SuggestionsBroker.this.currentDocument), (int)offset);
                if (lineno == this.prevLineNo) {
                    return;
                }
                this.prevLineNo = lineno;
                Line line = TLUtils.getLineByNumber((DataObject)SuggestionsBroker.this.currentDO, (int)(lineno + 1));
                if (line != null) {
                    // empty if block
                }
            }
        }
    }

    private class DataSystemMonitor
    implements ChangeListener {
        private DataSystemMonitor() {
        }

        public void stateChanged(ChangeEvent e) {
            LOGGER.fine("EVENT " + e.getSource() + " changed.");
            Set mods = DataObject.getRegistry().getModifiedSet();
            boolean wasModified = SuggestionsBroker.this.currentModified;
            SuggestionsBroker.this.currentModified = mods.contains(SuggestionsBroker.this.currentDO);
            if (SuggestionsBroker.this.currentModified != wasModified && !SuggestionsBroker.this.currentModified && ManagerSettings.getDefault().isScanOnSave()) {
                SuggestionsBroker.this.scheduleRescan(false, ManagerSettings.getDefault().getSaveScanDelay());
            }
        }
    }

    private class WindowSystemMonitor
    implements PropertyChangeListener,
    ComponentListener {
        private Set openedSoFar = Collections.EMPTY_SET;

        private WindowSystemMonitor() {
        }

        private void enableOpenCloseEvents() {
            List<TopComponent> list = Arrays.asList(SuggestionsScanner.openedTopComponents());
            this.openedSoFar = new HashSet<TopComponent>(list);
            Iterator<TopComponent> it = list.iterator();
            while (it.hasNext()) {
                TopComponent tc = it.next();
                tc.addComponentListener((ComponentListener)new ComponentAdapter(){

                    public void componentShown(ComponentEvent e) {
                        TopComponent tcomp = (TopComponent)e.getComponent();
                        tcomp.removeComponentListener((ComponentListener)this);
                        SuggestionsBroker.this.handleTopComponentOpened(tcomp);
                    }
                });
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop.equals("opened")) {
                LOGGER.fine("EVENT opened top-components changed");
                List<TopComponent> list = Arrays.asList(SuggestionsScanner.openedTopComponents());
                HashSet<TopComponent> actual = new HashSet<TopComponent>(list);
                if (this.openedSoFar != null) {
                    Iterator it = this.openedSoFar.iterator();
                    while (it.hasNext()) {
                        TopComponent tc = (TopComponent)it.next();
                        if (actual.contains(tc)) continue;
                        SuggestionsBroker.this.handleTopComponentClosed(tc);
                    }
                    Iterator ita = actual.iterator();
                    while (ita.hasNext()) {
                        TopComponent tc = (TopComponent)ita.next();
                        if (this.openedSoFar.contains(tc)) continue;
                        tc.addComponentListener((ComponentListener)new ComponentAdapter(){

                            public void componentShown(ComponentEvent e) {
                                TopComponent tcomp = (TopComponent)e.getComponent();
                                tcomp.removeComponentListener((ComponentListener)this);
                                SuggestionsBroker.this.handleTopComponentOpened(tcomp);
                            }
                        });
                    }
                }
                this.openedSoFar = actual;
            } else if ("activated".equals(prop)) {
                LOGGER.fine("EVENT top-component activated");
                TopComponent activated = WindowManager.getDefault().getRegistry().getActivated();
                if (SuggestionsBroker.this.clientCount > 0 && this.isSelectedEditor((Component)activated) && SuggestionsBroker.this.currentTC == null) {
                    SuggestionsBroker.this.prepareRescanInAWT(false);
                }
            }
        }

        public void componentShown(ComponentEvent e) {
        }

        public void componentHidden(ComponentEvent e) {
            LOGGER.fine("EVENT " + e.getComponent() + " has been hidden");
            if (SuggestionsBroker.this.allOpenedClientsCount == 0) {
                SuggestionsBroker.this.componentsChanged();
            }
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        private boolean isSelectedEditor(Component tc) {
            Mode mode = WindowManager.getDefault().findMode("editor");
            TopComponent selected = null;
            if (mode != null) {
                selected = mode.getSelectedTopComponent();
            }
            return selected == tc;
        }
    }

    public class AllOpenedJob {
        private boolean stopped = false;
        private final ProviderAcceptor acceptor;

        private AllOpenedJob(ProviderAcceptor acceptor) {
            this.acceptor = acceptor;
            SuggestionsBroker.this.acceptors.add(acceptor);
        }

        public SuggestionList getSuggestionList() {
            return SuggestionsBroker.this.getAllOpenedSuggestionList();
        }

        public void stopBroker() {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            SuggestionsBroker.this.acceptors.remove(this.acceptor);
            SuggestionsBroker.this.allOpenedClientsCount--;
            if (SuggestionsBroker.this.allOpenedClientsCount == 0) {
                SuggestionsBroker.this.allOpenedJob.stopBroker();
                SuggestionsBroker.this.openedFilesSuggestionsMap.clear();
            }
        }
    }

    public class Job {
        private boolean stopped = false;
        private final ProviderAcceptor acceptor;

        private Job(ProviderAcceptor acceptor) {
            this.acceptor = acceptor;
            SuggestionsBroker.this.acceptors.add(acceptor);
        }

        public void stopBroker() {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            SuggestionsBroker.this.acceptors.remove(this.acceptor);
            SuggestionsBroker.this.clientCount--;
            if (SuggestionsBroker.this.clientCount == 0) {
                SuggestionsBroker.this.stopActiveSuggestionFetching();
                if (SuggestionsBroker.this.cache != null) {
                    SuggestionsBroker.this.cache.flush();
                }
                SuggestionsBroker.this.list = null;
                instance = null;
            }
        }

        public SuggestionList getSuggestionsList() {
            return SuggestionsBroker.this.getCurrentSuggestionsList();
        }
    }
}

