/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.suggestions;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.tasklist.providers.DocumentSuggestionProvider;
import org.netbeans.modules.tasklist.providers.SuggestionProvider;
import org.netbeans.modules.tasklist.suggestions.SuggestionType;
import org.netbeans.modules.tasklist.suggestions.SuggestionTypes;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class SuggestionProviders {
    private List providers = null;
    private List docProviders = null;
    private Map providersByType = null;
    private static Reference instance;
    static Lookup lookup;
    private Lookup.Result lookupResult;

    private SuggestionProviders() {
    }

    public static synchronized SuggestionProviders getDefault() {
        if (instance == null) {
            return SuggestionProviders.createDefault();
        }
        SuggestionProviders scanner = (SuggestionProviders)instance.get();
        if (scanner == null) {
            return SuggestionProviders.createDefault();
        }
        return scanner;
    }

    private static SuggestionProviders createDefault() {
        SuggestionProviders scanner = new SuggestionProviders();
        instance = new WeakReference<SuggestionProviders>(scanner);
        return scanner;
    }

    public synchronized List getProviders() {
        if (this.providers == null) {
            this.providers = new ArrayList(20);
            Lookup.Template template = new Lookup.Template(SuggestionProvider.class);
            this.lookupResult = lookup.lookup(template);
            this.lookupResult.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    SuggestionProviders.this.invalidateCaches();
                }
            });
            Iterator it = this.lookupResult.allInstances().iterator();
            ArrayList<SuggestionProvider> provList = new ArrayList<SuggestionProvider>(20);
            while (it.hasNext()) {
                SuggestionProvider sp = (SuggestionProvider)it.next();
                provList.add(sp);
            }
            SuggestionProvider[] provA = provList.toArray(new SuggestionProvider[provList.size()]);
            final SuggestionTypes types = SuggestionTypes.getDefault();
            Arrays.sort(provA, new Comparator(){

                public int compare(Object o1, Object o2) {
                    SuggestionProvider a = (SuggestionProvider)o1;
                    SuggestionProvider b = (SuggestionProvider)o2;
                    try {
                        SuggestionType at = types.getType(a.getType());
                        SuggestionType bt = types.getType(b.getType());
                        return at.getPosition() - bt.getPosition();
                    }
                    catch (Exception e) {
                        return -1;
                    }
                }
            });
            for (int i = 0; i < provA.length; ++i) {
                SuggestionProvider sp = provA[i];
                this.providers.add(sp);
            }
        }
        return this.providers;
    }

    public synchronized List getDocProviders() {
        if (this.docProviders == null) {
            this.docProviders = new ArrayList(20);
            Iterator it = this.getProviders().iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof DocumentSuggestionProvider)) continue;
                this.docProviders.add(next);
            }
        }
        return this.docProviders;
    }

    public synchronized SuggestionProvider getProvider(SuggestionType type) {
        if (this.providersByType == null) {
            SuggestionTypes suggestionTypes = SuggestionTypes.getDefault();
            List providers = this.getProviders();
            this.providersByType = new HashMap(100);
            ListIterator it = providers.listIterator();
            while (it.hasNext()) {
                SuggestionProvider provider = (SuggestionProvider)it.next();
                String typeName = provider.getType();
                if (typeName == null) {
                    ErrorManager.getDefault().log("SuggestionProvider " + provider + " provides null value to getTypes()");
                    continue;
                }
                SuggestionType tp = suggestionTypes.getType(typeName);
                this.providersByType.put(tp, provider);
            }
        }
        return (SuggestionProvider)this.providersByType.get(type);
    }

    private synchronized void invalidateCaches() {
        this.providers = null;
        this.docProviders = null;
        this.providersByType = null;
    }

    static {
        lookup = Lookup.getDefault();
    }
}

