/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class PushDownRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PushDownRefactoring refactoring;

    public PushDownRefactoringPlugin(PushDownRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            JavaClass sourceType = this.refactoring.getSourceType();
            Problem result = PushDownRefactoringPlugin.isElementAvail((Element)sourceType);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (!CheckUtils.isElementInOpenProject((Element)sourceType)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            if (sourceType instanceof UnresolvedClass) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.fireProgressListenerStep();
            if (this.refactoring.collectSubtypes().length == 0) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)PushDownRefactoringPlugin.class, (String)"ERR_PushDOwn_NoSubtype"));
                return problem;
            }
            this.fireProgressListenerStep();
            if (!PushDownRefactoringPlugin.hasMembers(sourceType)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembers"));
                return problem;
            }
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        if (this.refactoring.getMembers().length == 0) {
            return new Problem(true, NbBundle.getMessage((Class)PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembersSelected"));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        PushDownRefactoring.MemberInfo[] members = this.refactoring.getMembers();
        ArrayList<NamedElement> featuresToMove = new ArrayList<NamedElement>();
        JavaClass[] subtypes = this.refactoring.collectSubtypes();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].member instanceof Feature) {
                featuresToMove.add(members[i].member);
            }
            for (int j = 0; j < subtypes.length; ++j) {
                boolean enabled = true;
                Iterator it = subtypes[j].getFeatures().iterator();
                while (it.hasNext()) {
                    Feature f = (Feature)it.next();
                    if (!CheckUtils.membersEqual((NamedElement)f, members[i].member)) continue;
                    enabled = false;
                    break;
                }
                refactoringElements.add(this.refactoring, new CopyMemberElement(members[i].member, subtypes[j], 0, enabled));
                UndoWatcher.watch(((JMManager)JMManager.getManager()).getDataObject(subtypes[j].getResource()));
            }
            refactoringElements.add(this.refactoring, new RemoveOriginalElement(members[i].member, members[i].makeAbstract));
        }
        PushDownRefactoringPlugin.collectRelaxModifierElements(this.refactoring, refactoringElements, this.refactoring.getSourceType(), featuresToMove);
        return null;
    }

    private static boolean hasMembers(JavaClass sourceType, JavaClass[] supertypes) {
        boolean result = PushDownRefactoringPlugin.hasMembers(sourceType);
        for (int i = 0; i < supertypes.length - 1 && !result; ++i) {
            result = PushDownRefactoringPlugin.hasMembers(supertypes[i]);
        }
        return result;
    }

    private static boolean hasMembers(JavaClass type) {
        Iterator it = type.getFeatures().iterator();
        while (it.hasNext()) {
            Feature feature = (Feature)it.next();
            if (!(feature instanceof Field) && !(feature instanceof Method) && !(feature instanceof JavaClass)) continue;
            return true;
        }
        return false;
    }

    static void collectRelaxModifierElements(AbstractRefactoring refactoring, RefactoringElementsBag refactoringElements, JavaClass jc, List members) {
        Feature f;
        HashSet accessedMembers = new HashSet();
        HashSet<Feature> membersToCheck = new HashSet<Feature>();
        HashSet membersToMove = new HashSet();
        Iterator iter = members.iterator();
        while (iter.hasNext()) {
            membersToMove.add(iter.next());
        }
        iter = jc.getFeatures().iterator();
        while (iter.hasNext()) {
            f = (Feature)iter.next();
            int mods = f.getModifiers();
            if (!Modifier.isPrivate(mods) && (Modifier.isProtected(mods) || Modifier.isPublic(mods))) continue;
            membersToCheck.add(f);
        }
        iter = membersToMove.iterator();
        while (iter.hasNext()) {
            PushDownRefactoringPlugin.traverseAccessedMembers((Element)((Feature)iter.next()), accessedMembers, membersToCheck);
        }
        iter = jc.getFeatures().iterator();
        while (iter.hasNext()) {
            f = (Feature)iter.next();
            if (!accessedMembers.contains(f) || membersToMove.contains(f)) continue;
            refactoringElements.add(refactoring, new RelaxAccessModifier(f));
        }
    }

    static void traverseAccessedMembers(Element element, Set accessedMembers, Set membersToCheck) {
        NamedElement nelem;
        if ((element instanceof MethodInvocation || element instanceof VariableAccess || element instanceof TypeReference) && membersToCheck.contains(nelem = ((ElementReference)element).getElement())) {
            accessedMembers.add(nelem);
        }
        Iterator it = element.getChildren().iterator();
        while (it.hasNext()) {
            PushDownRefactoringPlugin.traverseAccessedMembers((Element)it.next(), accessedMembers, membersToCheck);
        }
    }

    private static class RelaxAccessModifier
    extends SimpleRefactoringElementImpl {
        private final String text;
        private final Feature feature;

        RelaxAccessModifier(Feature feature) {
            this.feature = feature;
            boolean isPrivate = Modifier.isPrivate(feature.getModifiers());
            this.text = new MessageFormat(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"TXT_PushDown_RelaxAccessModifier")).format(new Object[]{isPrivate ? NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"LBL_PushDown_private") : NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"LBL_PushDown_package_private"), NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"LBL_PushDown_protected")});
        }

        public void performChange() {
            this.feature.setModifiers(this.feature.getModifiers() & 0xFFFFFFFD | 4);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.feature.getResource());
        }

        public Element getJavaElement() {
            return this.feature;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.feature);
        }
    }

    private static class CopyMemberElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToCopy;
        private final JavaClass target;
        private final int newModifiers;
        private final String text;

        CopyMemberElement(NamedElement elementToCopy, JavaClass target, int newModifiers, boolean enabled) {
            this.elementToCopy = elementToCopy;
            this.target = target;
            this.newModifiers = newModifiers;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)"TXT_PushDown_Member", (Object)UIUtilities.getDisplayText(elementToCopy), (Object)UIUtilities.getDisplayText((NamedElement)target));
            this.setEnabled(enabled);
        }

        public void performChange() {
            Element newElement;
            JavaModelPackage targetExtent = (JavaModelPackage)this.target.refImmediatePackage();
            if (this.elementToCopy instanceof Feature) {
                JavaClass elementParent = (JavaClass)((Feature)this.elementToCopy).getDeclaringClass();
                newElement = ((MetadataElement)this.elementToCopy).duplicate(targetExtent);
                this.target.getContents().add(newElement);
                if (this.newModifiers != 0) {
                    ((Feature)newElement).setModifiers(this.newModifiers);
                }
            } else {
                JavaClass elementParent = (JavaClass)this.elementToCopy.refImmediateComposite();
                newElement = ((MetadataElement)this.elementToCopy).duplicate(targetExtent);
                this.target.getInterfaceNames().add(newElement);
            }
            ((MetadataElement)newElement).fixImports((Element)this.target, (Element)this.elementToCopy);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToCopy.getResource());
        }

        public Element getJavaElement() {
            return this.target;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToCopy);
        }
    }

    private static class RemoveOriginalElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToRemove;
        private final String text;
        private final boolean makeItAbstract;

        RemoveOriginalElement(NamedElement elementToRemove, boolean makeItAbstract) {
            this.elementToRemove = elementToRemove;
            this.makeItAbstract = makeItAbstract;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin = PushDownRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PushDownRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PushDownRefactoringPlugin), (String)(makeItAbstract ? "TXT_PushDown_Abstract" : "TXT_PushDown_Remove"), (Object)UIUtilities.getDisplayText(elementToRemove));
        }

        public void performChange() {
            if (this.makeItAbstract) {
                Method m = (Method)this.elementToRemove;
                m.setModifiers(m.getModifiers() | 0x400);
                m.setBodyText(null);
            } else {
                this.elementToRemove.refDelete();
            }
        }

        public String getText() {
            return this.text;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToRemove);
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToRemove.getResource());
        }

        public Element getJavaElement() {
            return (Element)this.elementToRemove.refImmediateComposite();
        }

        public String getDisplayText() {
            return this.text;
        }
    }
}

