/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.Constants;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.ModuleMBean;

public class ServerInfo
extends ModuleMBean
implements Constants {
    String PORT = "Port";
    String DOMAIN = "Domain";
    String port = null;
    String username = null;
    String password = null;
    String domain = null;

    public ServerInfo(MBeanServerConnection in_conn) {
        super(in_conn);
        this.runtimeObjName = this.createRuntimeObjectName();
    }

    private ObjectName createRuntimeObjectName() {
        ObjectName runtimeName = null;
        try {
            runtimeName = new ObjectName("com.sun.appserv:j2eeType=J2EEServer,name=server,category=runtime");
        }
        catch (Exception ex) {
            return null;
        }
        return runtimeName;
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList attList = null;
        try {
            attList = this.conn.getAttributes(this.runtimeObjName, attributes);
            AttributeList jsrList = this.createAddAttributes();
            attList.addAll(jsrList);
        }
        catch (Exception ex) {
            return attList;
        }
        return attList;
    }

    public MBeanInfo getMBeanInfo() {
        MBeanInfo updatedInfo = null;
        try {
            MBeanInfo currentInfo = this.conn.getMBeanInfo(this.runtimeObjName);
            MBeanAttributeInfo[] currentAttrInfo = currentInfo.getAttributes();
            int additionalSize = ADDITIONAL_SERVER_INFO.length;
            int size = JSR_SERVER_INFO.length + additionalSize;
            MBeanAttributeInfo[] updatedAttrInfo = new MBeanAttributeInfo[size];
            HashSet<String> reqdAttrs = new HashSet<String>(Arrays.asList(JSR_SERVER_INFO));
            int j = 0;
            for (int i = 0; i < currentAttrInfo.length; ++i) {
                if (!reqdAttrs.contains(currentAttrInfo[i].getName())) continue;
                updatedAttrInfo[j] = currentAttrInfo[i];
                ++j;
            }
            updatedAttrInfo[j] = new MBeanAttributeInfo(this.PORT, "int", "Server's port number", true, false, false);
            updatedAttrInfo[j + 1] = new MBeanAttributeInfo(this.DOMAIN, "char", "Server's domain", true, false, false);
            updatedInfo = new MBeanInfo(currentInfo.getClassName(), currentInfo.getDescription(), updatedAttrInfo, currentInfo.getConstructors(), null, currentInfo.getNotifications());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return updatedInfo;
    }

    public void setAttribute(Attribute attribute) throws RemoteException, InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        String attrName = attribute.getName();
        HashSet<String> appList = new HashSet<String>(Arrays.asList(JSR_SERVER_INFO));
        if (appList.contains(attrName)) {
            this.conn.setAttribute(this.runtimeObjName, attribute);
        }
    }

    private AttributeList createAddAttributes() {
        AttributeList atList = new AttributeList();
        atList.add(new Attribute(this.PORT, this.getPort()));
        atList.add(new Attribute(this.DOMAIN, this.getDomain()));
        return atList;
    }

    public void setAttributes(String in_port, String in_userName, String in_password, String in_domain) {
        this.port = in_port;
        this.username = in_userName;
        this.password = in_password;
        this.domain = in_domain;
    }

    public String getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHiddenPassword() {
        String modPassword = "";
        for (int i = 0; i < this.password.length(); ++i) {
            char c = '*';
            modPassword = modPassword + c;
        }
        return modPassword;
    }

    public String getDomain() {
        return this.domain;
    }

    public boolean isRestartRequired() {
        boolean restartReq = false;
        String val = this.getRuntimeAttributeValue("restartRequired");
        if (val != null) {
            restartReq = Boolean.valueOf(val);
        }
        return restartReq;
    }

    public String getRuntimeAttributeValue(String attributeName) {
        return super.getAttribute(this.runtimeObjName, attributeName);
    }
}

