/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.appsrvapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

public class PortDetector {
    public static byte[] TEST_QUERY = new byte[]{22, 3, 0, 0, 83, 1, 0, 0, 79, 3, 0, 63, 71, -41, -9, -70, 44, -18, -22, -78, 96, 126, -13, 0, -3, -126, 123, -71, -43, -106, -56, 119, -101, -26, -60, -37, 60, 61, -37, 111, -17, 16, 110, 0, 0, 40, 0, 22, 0, 19, 0, 10, 0, 102, 0, 5, 0, 4, 0, 101, 0, 100, 0, 99, 0, 98, 0, 97, 0, 96, 0, 21, 0, 18, 0, 9, 0, 20, 0, 17, 0, 8, 0, 6, 0, 3, 1, 0, 71, 69, 84, 32, 47, 32, 72, 84, 84, 80, 47, 49, 46, 48, 10, 10};

    public static boolean isSecurePortGlassFish(String host, int port) throws ConnectException {
        boolean isSecure = false;
        int i = 0;
        try {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(5000);
            OutputStream os = socket.getOutputStream();
            os.write("GET / HTTP/1.1\n".getBytes());
            os.write(("host: " + host + "\n").getBytes());
            os.write("\n".getBytes());
            InputStream is = socket.getInputStream();
            BufferedReader bis = new BufferedReader(new InputStreamReader(is));
            while (bis.readLine() != null && ++i <= 5) {
            }
            if (i == 1) {
                isSecure = true;
            }
        }
        catch (ConnectException ex) {
            throw ex;
        }
        catch (SocketTimeoutException ex) {
            ConnectException ce = new ConnectException();
            ce.initCause(ex);
            throw ce;
        }
        catch (SocketException ex) {
            if (ex.getMessage().indexOf("broken pipe") != -1) {
                isSecure = true;
            }
        }
        catch (IOException ex) {
            if (ex.getMessage().indexOf("end of file") != -1) {
                isSecure = true;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            ConnectException ce = new ConnectException();
            ce.initCause(ex);
            throw ce;
        }
        return isSecure;
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket;
        block11: {
            socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(hostname, port), 4000);
            }
            catch (SocketException ex) {
                String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block11;
                String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", socksNonProxyHosts + localhost);
                ConnectException ce = new ConnectException();
                ce.initCause(ex);
                throw ce;
            }
        }
        OutputStream ostream = socket.getOutputStream();
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        for (int count = 0; count < 20; ++count) {
            try {
                if (istream.available() > 0) break;
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        byte[] input = new byte[istream.available()];
        istream.read(input);
        socket.close();
        String response = new String(input).toLowerCase();
        boolean isSecure = true;
        if (response.length() == 0) {
            throw new ConnectException();
        }
        if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        return isSecure;
    }
}

