/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public final class BrokenProjectSupport {
    private final EarProject project;
    private final Set<ChangeListener> listeners;
    private final FileChangeListener artifactListener;
    private final Collection<FileObject> watchedArtifacts = new HashSet<FileObject>();

    BrokenProjectSupport(EarProject project) {
        this.project = project;
        this.listeners = new HashSet<ChangeListener>(1);
        this.artifactListener = new ArtifactListener();
    }

    public boolean hasBrokenArtifacts() {
        boolean brokenArtifacts = false;
        List<VisualClassPathItem> vcpis = this.project.getProjectProperties().getJarContentAdditional();
        for (VisualClassPathItem vcpi : vcpis) {
            AntArtifact aa;
            FileObject script;
            Object obj = vcpi.getObject();
            if (!(obj instanceof AntArtifact) || (script = (aa = (AntArtifact)obj).getScriptFile()) != null && script.isValid()) continue;
            brokenArtifacts = true;
            break;
        }
        return brokenArtifacts;
    }

    public void watchAntArtifact(AntArtifact artifact) {
        FileObject artFile = artifact.getScriptFile();
        this.watchedArtifacts.add(artFile);
        artFile.addFileChangeListener(this.artifactListener);
    }

    public void cleanUp() {
        for (FileObject artFile : this.watchedArtifacts) {
            artFile.removeFileChangeListener(this.artifactListener);
        }
        this.watchedArtifacts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void adjustReferences() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                for (VisualClassPathItem vcpi : BrokenProjectSupport.this.project.getProjectProperties().getJarContentAdditional()) {
                    String raw;
                    if (!(vcpi.getObject() instanceof AntArtifact) || !(raw = vcpi.getRaw()).matches("^\\$\\{reference\\..*\\}")) continue;
                    String currEvaluated = BrokenProjectSupport.this.project.evaluator().evaluate(raw);
                    FileObject currEvaluatedFO = BrokenProjectSupport.this.project.getAntProjectHelper().resolveFileObject(currEvaluated);
                    if (currEvaluatedFO != null) continue;
                    String referenceKey = raw.substring(2, raw.length() - 1);
                    BrokenProjectSupport.this.adjustReference(vcpi, referenceKey);
                }
            }
        });
    }

    private void adjustReference(VisualClassPathItem vcpi, String referenceKey) {
        EditableProperties prjProps = this.project.getAntProjectHelper().getProperties("nbproject/project.properties");
        String referenceValue = prjProps.getProperty(referenceKey);
        if (referenceValue.matches("^\\$\\{project\\..*\\}.+")) {
            String prjReference = referenceValue.substring(0, referenceValue.indexOf(125, 2) + 1);
            String relPath = vcpi.getEvaluated();
            prjProps.setProperty(referenceKey, prjReference + '/' + relPath);
        }
        this.project.getAntProjectHelper().putProperties("nbproject/project.properties", prjProps);
        try {
            ProjectManager.getDefault().saveProject((Project)this.project);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
        }
    }

    private class ArtifactListener
    extends FileChangeAdapter {
        private ArtifactListener() {
        }

        public void fileDeleted(FileEvent fe) {
            BrokenProjectSupport.this.fireChangeEvent();
        }

        public void fileRenamed(FileRenameEvent fe) {
            BrokenProjectSupport.this.fireChangeEvent();
        }
    }
}

