/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.j2ee.earproject.ui.FoldersListSettings;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.j2ee.earproject.ui.wizards.CompleteEarProjectWizardIterator;
import org.netbeans.modules.j2ee.earproject.ui.wizards.J2eeVersionWarningPanel;
import org.netbeans.modules.j2ee.earproject.ui.wizards.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends JPanel
implements PropertyChangeListener {
    private final PanelConfigureProject panel;
    private final DefaultComboBoxModel serversModel = new DefaultComboBoxModel();
    private J2eeVersionWarningPanel warningPanel;
    private boolean valid;
    private JCheckBox createCarCheckBox;
    private JCheckBox createEjbCheckBox;
    private JCheckBox createWARCheckBox;
    private JComboBox j2eeSpecComboBox;
    private JLabel j2eeSpecLabel;
    private JTextField jTextFieldCarName;
    private JTextField jTextFieldEjbModuleName;
    private JTextField jTextFieldWebAppName;
    private JLabel mainClassLabel;
    private JTextField mainClassTextField;
    private JButton manageServersButton;
    private JPanel serverAndVersionPanel;
    private JComboBox serverInstanceComboBox;
    private JLabel serverInstanceLabel;
    private JCheckBox setAsMainCheckBox;
    private JPanel warningPlaceHolderPanel;

    public PanelOptionsVisual(PanelConfigureProject panel, boolean importStyle) {
        panel.getProjectTypeFlag();
        this.initComponents();
        this.panel = panel;
        this.setJ2eeVersionWarningPanel();
        this.initServers(FoldersListSettings.getDefault().getLastUsedServer());
        if (this.j2eeSpecComboBox.getModel().getSize() > 0) {
            this.j2eeSpecComboBox.setSelectedIndex(0);
        }
        if (importStyle) {
            this.createEjbCheckBox.setSelected(!importStyle);
            this.createWARCheckBox.setSelected(!importStyle);
            this.createCarCheckBox.setSelected(!importStyle);
            this.createEjbCheckBox.setVisible(!importStyle);
            this.createWARCheckBox.setVisible(!importStyle);
            this.createCarCheckBox.setVisible(!importStyle);
            this.jTextFieldEjbModuleName.setVisible(!importStyle);
            this.jTextFieldWebAppName.setVisible(!importStyle);
            this.jTextFieldCarName.setVisible(!importStyle);
            this.mainClassLabel.setVisible(!importStyle);
            this.mainClassTextField.setVisible(!importStyle);
        } else {
            DocumentListener subProjectNameListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    PanelOptionsVisual.this.projectNameChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    PanelOptionsVisual.this.projectNameChanged();
                }

                public void changedUpdate(DocumentEvent e) {
                    PanelOptionsVisual.this.projectNameChanged();
                }
            };
            this.jTextFieldEjbModuleName.getDocument().addDocumentListener(subProjectNameListener);
            this.jTextFieldWebAppName.getDocument().addDocumentListener(subProjectNameListener);
            this.jTextFieldCarName.getDocument().addDocumentListener(subProjectNameListener);
            this.mainClassTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    PanelOptionsVisual.this.mainClassChanged();
                }

                public void removeUpdate(DocumentEvent e) {
                    PanelOptionsVisual.this.mainClassChanged();
                }

                public void changedUpdate(DocumentEvent e) {
                    PanelOptionsVisual.this.mainClassChanged();
                }
            });
        }
    }

    private void initComponents() {
        this.setAsMainCheckBox = new JCheckBox();
        this.createEjbCheckBox = new JCheckBox();
        this.jTextFieldEjbModuleName = new JTextField();
        this.createWARCheckBox = new JCheckBox();
        this.jTextFieldWebAppName = new JTextField();
        this.warningPlaceHolderPanel = new JPanel();
        this.createCarCheckBox = new JCheckBox();
        this.jTextFieldCarName = new JTextField();
        this.mainClassLabel = new JLabel();
        this.mainClassTextField = new JTextField();
        this.serverAndVersionPanel = new JPanel();
        this.serverInstanceLabel = new JLabel();
        this.serverInstanceComboBox = new JComboBox();
        this.manageServersButton = new JButton();
        this.j2eeSpecLabel = new JLabel();
        this.j2eeSpecComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCN_ManageServers"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCD_ManageServers"));
        this.setAsMainCheckBox.setMnemonic(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBoxMnemonic").charAt(0));
        this.setAsMainCheckBox.setSelected(true);
        this.setAsMainCheckBox.setText(NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_SetAsMain_CheckBox"));
        this.setAsMainCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.setAsMainCheckBox, gridBagConstraints);
        this.setAsMainCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NWP1_SetAsMain_A11YDesc"));
        this.createEjbCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createEjbCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_NEAP_CreateEjbModule"));
        this.createEjbCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.createEjbCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.createEjbCheckBox_action(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 11);
        this.add((Component)this.createEjbCheckBox, gridBagConstraints);
        this.createEjbCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_CreateEJBModule"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.jTextFieldEjbModuleName, gridBagConstraints);
        this.jTextFieldEjbModuleName.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ACSN_EjbModuleName"));
        this.jTextFieldEjbModuleName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_EjbModuleName"));
        this.createWARCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.createWARCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_NEAP_CreatWebAppModule"));
        this.createWARCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.createWARCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.createWebAppCheckBox_action(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 11);
        this.add((Component)this.createWARCheckBox, gridBagConstraints);
        this.createWARCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_CreateWebModule"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.jTextFieldWebAppName, gridBagConstraints);
        this.jTextFieldWebAppName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_WebAppName"));
        this.jTextFieldWebAppName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_WebAppName"));
        this.warningPlaceHolderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.warningPlaceHolderPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.createCarCheckBox, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_NEAP_CreateCarModule"));
        this.createCarCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.createCarCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.createCarCheckBox_action(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 11);
        this.add((Component)this.createCarCheckBox, gridBagConstraints);
        this.createCarCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_CreateAppClientModule"));
        this.jTextFieldCarName.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.jTextFieldCarName, gridBagConstraints);
        this.jTextFieldCarName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_AppClientName"));
        this.jTextFieldCarName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_AppClientName"));
        this.mainClassLabel.setLabelFor(this.mainClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.mainClassLabel, (String)NbBundle.getBundle(PanelOptionsVisual.class).getString("LBL_NWP1_MainClass_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 11, 11);
        this.add((Component)this.mainClassLabel, gridBagConstraints);
        this.mainClassTextField.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 11, 5);
        this.add((Component)this.mainClassTextField, gridBagConstraints);
        this.mainClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCN_mainClassTextFiled"));
        this.mainClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelOptionsVisual.class).getString("ASCD_mainClassTextFiled"));
        this.serverAndVersionPanel.setLayout(new GridBagLayout());
        this.serverInstanceLabel.setLabelFor(this.serverInstanceComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverInstanceLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_Server_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 11);
        this.serverAndVersionPanel.add((Component)this.serverInstanceLabel, gridBagConstraints);
        this.serverInstanceComboBox.setModel(this.serversModel);
        this.serverInstanceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.serverInstanceComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 6);
        this.serverAndVersionPanel.add((Component)this.serverInstanceComboBox, gridBagConstraints);
        this.serverInstanceComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_NWP1_Server_ComboBox_A11YDesc"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageServersButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_ManageServers"));
        this.manageServersButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.manageServersButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.serverAndVersionPanel.add((Component)this.manageServersButton, gridBagConstraints);
        this.manageServersButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_ManageButton"));
        this.j2eeSpecLabel.setLabelFor(this.j2eeSpecComboBox);
        Mnemonics.setLocalizedText((JLabel)this.j2eeSpecLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"LBL_NWP1_J2EESpecLevel_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 11, 11);
        this.serverAndVersionPanel.add((Component)this.j2eeSpecLabel, gridBagConstraints);
        this.j2eeSpecComboBox.setPrototypeDisplayValue("MMMMMMMMM");
        this.j2eeSpecComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.j2eeSpecComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 11, 5);
        this.serverAndVersionPanel.add((Component)this.j2eeSpecComboBox, gridBagConstraints);
        this.j2eeSpecComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACS_LBL_NPW1_J2EESpecLevel_A11YDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.serverAndVersionPanel, gridBagConstraints);
    }

    private void manageServersButtonActionPerformed(ActionEvent evt) {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        String lastSelectedServerInstanceID = null;
        if (serverInstanceWrapper != null) {
            lastSelectedServerInstanceID = serverInstanceWrapper.getServerInstanceID();
        }
        ServerManager.showCustomizer(lastSelectedServerInstanceID);
        String lastSelectedJ2eeSpecLevel = (String)this.j2eeSpecComboBox.getSelectedItem();
        this.initServers(lastSelectedServerInstanceID);
        if (lastSelectedJ2eeSpecLevel != null) {
            this.j2eeSpecComboBox.setSelectedItem(lastSelectedJ2eeSpecLevel);
        }
    }

    private void createCarCheckBox_action(ActionEvent evt) {
        this.jTextFieldCarName.setEnabled(this.createCarCheckBox.isSelected());
        this.mainClassTextField.setEnabled(this.createCarCheckBox.isSelected());
        this.panel.fireChangeEvent();
    }

    private void createWebAppCheckBox_action(ActionEvent evt) {
        this.jTextFieldWebAppName.setEnabled(this.createWARCheckBox.isSelected());
        this.panel.fireChangeEvent();
    }

    private void createEjbCheckBox_action(ActionEvent evt) {
        this.jTextFieldEjbModuleName.setEnabled(this.createEjbCheckBox.isSelected());
        this.panel.fireChangeEvent();
    }

    private void serverInstanceComboBoxActionPerformed(ActionEvent evt) {
        String prevSelectedItem = (String)this.j2eeSpecComboBox.getSelectedItem();
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper != null) {
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceWrapper.getServerInstanceID());
            Set supportedVersions = j2eePlatform.getSupportedSpecVersions(J2eeModule.EAR);
            this.j2eeSpecComboBox.removeAllItems();
            if (supportedVersions.contains("1.5")) {
                this.j2eeSpecComboBox.addItem(EarProjectProperties.JAVA_EE_SPEC_50_LABEL);
            }
            if (supportedVersions.contains("1.4")) {
                this.j2eeSpecComboBox.addItem(EarProjectProperties.J2EE_SPEC_14_LABEL);
            }
            if (prevSelectedItem != null) {
                this.j2eeSpecComboBox.setSelectedItem(prevSelectedItem);
            }
            boolean carSupported = j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.CLIENT);
            this.createCarCheckBox.setEnabled(carSupported);
            this.jTextFieldCarName.setEnabled(carSupported && this.createCarCheckBox.isSelected());
            this.mainClassLabel.setEnabled(carSupported);
            this.mainClassTextField.setEnabled(carSupported && this.createCarCheckBox.isSelected());
        } else {
            this.j2eeSpecComboBox.removeAllItems();
        }
        this.panel.fireChangeEvent();
    }

    private void j2eeSpecComboBoxActionPerformed(ActionEvent evt) {
        this.setJ2eeVersionWarningPanel();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("projectName".equals(event.getPropertyName())) {
            String newProjectName = (String)event.getNewValue();
            if (newProjectName.trim().equals("")) {
                return;
            }
            this.jTextFieldEjbModuleName.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_EJBProjectName"), newProjectName));
            this.jTextFieldWebAppName.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_WebAppProjectName"), newProjectName));
            this.jTextFieldCarName.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_AppClientProjectName"), newProjectName));
            newProjectName = CompleteEarProjectWizardIterator.getPackageName(newProjectName);
            if (!Utilities.isJavaIdentifier((String)newProjectName)) {
                newProjectName = NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_PackageNameSuffix", (Object)newProjectName);
            }
            this.mainClassTextField.setText(MessageFormat.format(NbBundle.getMessage(PanelOptionsVisual.class, (String)"TXT_ClassName"), newProjectName));
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String specVer;
        J2eePlatform j2eePlatform;
        ServerInstanceWrapper serverInstanceWrapper;
        String jarName;
        if (this.getSelectedServer() == null) {
            PanelOptionsVisual.setErrorMessage("MSG_NoServer", wizardDescriptor);
            return false;
        }
        if (this.createWARCheckBox.isSelected()) {
            String warName = this.jTextFieldWebAppName.getText();
            if (warName.length() < 1) {
                PanelOptionsVisual.setErrorMessage("MSG_NoWARName", wizardDescriptor);
                return false;
            }
            if (!warName.endsWith("-war")) {
                PanelOptionsVisual.setErrorMessage("MSG_WARNameNotBlueprints", wizardDescriptor);
            }
        }
        if (this.createEjbCheckBox.isSelected()) {
            jarName = this.jTextFieldEjbModuleName.getText();
            if (jarName.length() < 1) {
                PanelOptionsVisual.setErrorMessage("MSG_NoJARName", wizardDescriptor);
                return false;
            }
            if (!jarName.endsWith("-ejb")) {
                PanelOptionsVisual.setErrorMessage("MSG_JARNameNotBlueprints", wizardDescriptor);
            }
        }
        if (this.createCarCheckBox.isSelected()) {
            jarName = this.jTextFieldCarName.getText();
            if (jarName.length() < 1) {
                PanelOptionsVisual.setErrorMessage("MSG_NoCARName", wizardDescriptor);
                return false;
            }
            if (!this.valid) {
                PanelOptionsVisual.setErrorMessage("ERROR_IllegalMainClassName", wizardDescriptor);
                return this.valid;
            }
            if (!jarName.endsWith("-app-client")) {
                PanelOptionsVisual.setErrorMessage("MSG_CARNameNotBlueprints", wizardDescriptor);
            }
        }
        if ((serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem()) != null && !(j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceWrapper.getServerInstanceID())).getSupportedModuleTypes().contains(J2eeModule.CLIENT)) {
            PanelOptionsVisual.setErrorMessage("MSG_CARIsNotSupported", wizardDescriptor);
        }
        if (null == (specVer = this.getSelectedJ2eeSpec()) || specVer.equals("1.3")) {
            PanelOptionsVisual.setErrorMessage("MSG_UnsupportedSpec", wizardDescriptor);
            return false;
        }
        return true;
    }

    private static void setErrorMessage(String errMsgKey, WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)errMsgKey));
    }

    void store(WizardDescriptor d) {
        d.putProperty("setAsMain", (Object)(this.setAsMainCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("serverInstanceID", (Object)this.getSelectedServer());
        d.putProperty("j2eeLevel", (Object)this.getSelectedJ2eeSpec());
        d.putProperty("createWAR", (Object)(this.createWARCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("createJAR", (Object)(this.createEjbCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("createCAR", (Object)(this.createCarCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("warName", (Object)this.jTextFieldWebAppName.getText());
        d.putProperty("jarName", (Object)this.jTextFieldEjbModuleName.getText());
        d.putProperty("carName", (Object)this.jTextFieldCarName.getText());
        d.putProperty("mainClass", (Object)this.mainClassTextField.getText().trim());
        if (this.warningPanel != null && this.warningPanel.getWarningType() != null && this.warningPanel.getDowngradeAllowed()) {
            d.putProperty("setJavaPlatform", (Object)this.warningPanel.getSuggestedJavaPlatformName());
            String j2ee = this.getSelectedJ2eeSpec();
            if (j2ee != null) {
                String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
                FoldersListSettings fls = FoldersListSettings.getDefault();
                String srcLevel = "1.6";
                if ((warningType.equals("warnSetSourceLevel14") || warningType.equals("warnSetJdk14")) && fls.isAgreedSetSourceLevel14()) {
                    srcLevel = "1.4";
                } else if ((warningType.equals("warnSetSourceLevel15") || warningType.equals("warnSetJdk15")) && fls.isAgreedSetSourceLevel15()) {
                    srcLevel = "1.5";
                }
                d.putProperty("setSourceLevel", (Object)srcLevel);
            }
        } else {
            d.putProperty("setSourceLevel", null);
        }
    }

    void read(WizardDescriptor d) {
    }

    private void initServers(String selectedServerInstanceID) {
        this.serversModel.removeAllElements();
        TreeSet<ServerInstanceWrapper> servers = new TreeSet<ServerInstanceWrapper>();
        ServerInstanceWrapper selectedItem = null;
        boolean sjasFound = false;
        for (String serverInstanceID : Deployment.getDefault().getServerInstanceIDs()) {
            String displayName = Deployment.getDefault().getServerInstanceDisplayName(serverInstanceID);
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
            if (displayName == null || j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.EAR)) continue;
            ServerInstanceWrapper serverWrapper = new ServerInstanceWrapper(serverInstanceID, displayName);
            if (selectedItem == null || !sjasFound) {
                if (selectedServerInstanceID != null) {
                    if (selectedServerInstanceID.equals(serverInstanceID)) {
                        selectedItem = serverWrapper;
                    }
                } else {
                    String shortName = Deployment.getDefault().getServerID(serverInstanceID);
                    if ("J2EE".equals(shortName)) {
                        selectedItem = serverWrapper;
                        sjasFound = true;
                    } else if ("JBoss4".equals(shortName)) {
                        selectedItem = serverWrapper;
                    }
                }
            }
            servers.add(serverWrapper);
        }
        for (ServerInstanceWrapper item : servers) {
            this.serversModel.addElement(item);
        }
        if (selectedItem != null) {
            this.serversModel.setSelectedItem(selectedItem);
        } else if (this.serversModel.getSize() > 0) {
            this.serversModel.setSelectedItem(this.serversModel.getElementAt(0));
        }
    }

    private String getSelectedJ2eeSpec() {
        Object item = this.j2eeSpecComboBox.getSelectedItem();
        return item == null ? null : (item.equals(EarProjectProperties.JAVA_EE_SPEC_50_LABEL) ? "1.5" : (item.equals(EarProjectProperties.J2EE_SPEC_14_LABEL) ? "1.4" : "1.3"));
    }

    private String getSelectedServer() {
        ServerInstanceWrapper serverInstanceWrapper = (ServerInstanceWrapper)this.serversModel.getSelectedItem();
        if (serverInstanceWrapper == null) {
            return null;
        }
        return serverInstanceWrapper.getServerInstanceID();
    }

    private void setJ2eeVersionWarningPanel() {
        String j2ee = this.getSelectedJ2eeSpec();
        if (j2ee == null) {
            return;
        }
        String warningType = J2eeVersionWarningPanel.findWarningType(j2ee);
        if (warningType == null && this.warningPanel == null) {
            return;
        }
        if (this.warningPanel == null) {
            this.warningPanel = new J2eeVersionWarningPanel(warningType);
            this.warningPlaceHolderPanel.add((Component)this.warningPanel, "Center");
        }
        this.warningPanel.setWarningType(warningType);
    }

    private void mainClassChanged() {
        boolean valid;
        String mainClassName = this.mainClassTextField.getText().trim();
        StringTokenizer tk = new StringTokenizer(mainClassName, ".");
        boolean bl = valid = tk.countTokens() > 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (token.length() != 0 && Utilities.isJavaIdentifier((String)token)) continue;
            valid = false;
            break;
        }
        this.valid = valid;
        this.panel.fireChangeEvent();
    }

    private void projectNameChanged() {
        this.panel.fireChangeEvent();
    }

    private static class ServerInstanceWrapper
    implements Comparable {
        private final String serverInstanceID;
        private final String displayName;

        ServerInstanceWrapper(String serverInstanceID, String displayName) {
            this.serverInstanceID = serverInstanceID;
            this.displayName = displayName;
        }

        public String getServerInstanceID() {
            return this.serverInstanceID;
        }

        public String toString() {
            return this.displayName;
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

