/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.earproject.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.j2ee.earproject.ui.customizer.LibrariesChooser;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisualClasspathSupport {
    final Project master;
    String j2eePlatform;
    final JTable classpathTable;
    final JButton addJarButton;
    final JButton addLibraryButton;
    final JButton addArtifactButton;
    final JButton editButton;
    final JButton removeButton;
    final JButton upButton;
    final JButton downButton;
    private final ClasspathTableModel classpathModel;
    private final List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private static Collection baseLibrarySet = Collections.EMPTY_LIST;

    public VisualClasspathSupport(Project master, String j2eePlatform, JTable classpathTable, JButton addJarButton, JButton addLibraryButton, JButton addArtifactButton, JButton editButton, JButton removeButton, JButton upButton, JButton downButton) {
        this(master, j2eePlatform, classpathTable, addJarButton, addLibraryButton, addArtifactButton, editButton, removeButton, upButton, downButton, false);
    }

    public VisualClasspathSupport(Project master, String j2eePlatform, JTable classpathTable, JButton addJarButton, JButton addLibraryButton, JButton addArtifactButton, JButton editButton, JButton removeButton, JButton upButton, JButton downButton, boolean singleColumn) {
        this.classpathTable = classpathTable;
        this.classpathTable.setGridColor(this.classpathTable.getBackground());
        this.classpathTable.setRowHeight(this.classpathTable.getRowHeight() + 4);
        this.classpathModel = new ClasspathTableModel(singleColumn);
        this.classpathTable.setModel(this.classpathModel);
        this.classpathTable.setTableHeader(null);
        this.classpathTable.getColumnModel().getColumn(0).setCellRenderer(new LibraryCellRenderer());
        if (!singleColumn) {
            this.classpathTable.getColumnModel().getColumn(1).setCellRenderer(new BooleanCellRenderer(classpathTable));
            this.classpathTable.getColumnModel().getColumn(1).setMaxWidth(25);
        }
        this.classpathTable.setSelectionMode(2);
        this.addJarButton = addJarButton;
        this.addLibraryButton = addLibraryButton;
        this.addArtifactButton = addArtifactButton;
        this.editButton = editButton;
        this.removeButton = removeButton;
        this.upButton = upButton;
        this.downButton = downButton;
        this.master = master;
        this.j2eePlatform = j2eePlatform;
        ClasspathSupportListener csl = new ClasspathSupportListener();
        addJarButton.addActionListener(csl);
        addLibraryButton.addActionListener(csl);
        addArtifactButton.addActionListener(csl);
        editButton.addActionListener(csl);
        removeButton.addActionListener(csl);
        upButton.addActionListener(csl);
        downButton.addActionListener(csl);
        classpathTable.getSelectionModel().addListSelectionListener(csl);
        this.classpathModel.addTableModelListener(csl);
        csl.valueChanged(null);
    }

    public void setVisualClassPathItems(List<VisualClassPathItem> items) {
        this.classpathModel.setItems(items);
    }

    public List<VisualClassPathItem> getVisualClassPathItems() {
        return this.classpathModel.getItems();
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionPerformed() {
        ArrayList<ActionListener> listeners;
        VisualClasspathSupport visualClasspathSupport = this;
        synchronized (visualClasspathSupport) {
            listeners = new ArrayList<ActionListener>(this.actionListeners);
        }
        ActionEvent ae = new ActionEvent(this, 0, null);
        for (ActionListener al : listeners) {
            al.actionPerformed(ae);
        }
    }

    private Collection<Object> getLibraries() {
        HashSet<Object> libs = new HashSet<Object>();
        for (VisualClassPathItem vcpi : this.getVisualClassPathItems()) {
            if (vcpi.getType() != VisualClassPathItem.Type.LIBRARY) continue;
            libs.add(vcpi.getObject());
        }
        return libs;
    }

    private void addLibraries(Library[] libraries) {
        if (libraries.length > 0) {
            ArrayList<Library> newLibList = new ArrayList<Library>(Arrays.asList(libraries));
            this.classpathTable.clearSelection();
            int n0 = this.classpathModel.size();
            for (int i = 0; i < n0; ++i) {
                VisualClassPathItem item = this.classpathModel.get(i);
                if (item.getType() != VisualClassPathItem.Type.LIBRARY || !newLibList.remove(item.getObject())) continue;
                this.classpathTable.addRowSelectionInterval(i, i);
            }
            int n = newLibList.size();
            if (n > 0) {
                for (Library library : newLibList) {
                    VisualClassPathItem item = VisualClassPathItem.createLibrary(library, "WEB-INF/lib");
                    this.classpathModel.add(item);
                }
                this.rowsAdded(n0, n);
            }
        }
    }

    private void addJarFiles(File[] files) {
        int n = files.length;
        if (n > 0) {
            this.classpathTable.clearSelection();
            int n0 = this.classpathModel.size();
            for (int i = 0; i < n; ++i) {
                String pathInEAR = files[i].isDirectory() ? VisualClassPathItem.PATH_IN_EAR_NONE : "WEB-INF/lib";
                this.classpathModel.add(VisualClassPathItem.createJAR(files[i], null, pathInEAR));
            }
            this.rowsAdded(n0, n);
        }
    }

    private void addArtifacts(AntArtifact[] artifacts) {
        int n = artifacts.length;
        if (n > 0) {
            this.classpathTable.clearSelection();
            int n0 = this.classpathModel.size();
            for (int i = 0; i < n; ++i) {
                this.classpathModel.add(VisualClassPathItem.createArtifact(artifacts[i], null, "WEB-INF/lib"));
            }
            this.rowsAdded(n0, n);
        }
    }

    private void rowsAdded(int n0, int n) {
        this.classpathModel.fireTableRowsInserted(n0, n0 + n - 1);
        this.classpathTable.addRowSelectionInterval(n0, n0 + n - 1);
        this.fireActionPerformed();
    }

    private void removeSelectedItems() {
        ListSelectionModel sm = this.classpathTable.getSelectionModel();
        if (sm.isSelectionEmpty()) assert (false) : "Remove button should be disabled";
        int index = sm.getMinSelectionIndex();
        ArrayList elements = new ArrayList();
        int n0 = this.classpathModel.size();
        for (int i = n0 - 1; i >= 0; --i) {
            if (!sm.isSelectedIndex(i) || VisualClasspathSupport.isBaseLibraryItem(this.classpathModel.get(i))) continue;
            this.classpathModel.remove(i);
        }
        int n = this.classpathModel.size();
        this.classpathModel.fireTableRowsDeleted(elements.size(), n0 - 1);
        if (index >= n) {
            index = n - 1;
        }
        sm.setSelectionInterval(index, index);
        this.fireActionPerformed();
    }

    private void moveUp() {
        int[] si = this.classpathTable.getSelectedRows();
        if (si == null || si.length == 0 || si[0] == 0) assert (false) : "MoveUp button should be disabled";
        this.classpathTable.clearSelection();
        for (int i = 0; i < si.length; ++i) {
            int index = si[i] - 1;
            this.classpathModel.add(index, this.classpathModel.remove(index + 1));
            this.classpathTable.addRowSelectionInterval(index, index);
        }
        this.fireActionPerformed();
    }

    private void moveDown() {
        int[] si = this.classpathTable.getSelectedRows();
        if (si == null || si.length == 0 || si[si.length - 1] >= this.classpathModel.size() - 1) assert (false) : "MoveUp button should be disabled";
        this.classpathTable.clearSelection();
        for (int i = si.length - 1; i >= 0; --i) {
            int index = si[i] + 1;
            this.classpathModel.add(index, this.classpathModel.remove(index - 1));
            this.classpathTable.addRowSelectionInterval(index, index);
        }
        this.fireActionPerformed();
    }

    private void editLibrary() {
        DefaultListSelectionModel sm = (DefaultListSelectionModel)this.classpathTable.getSelectionModel();
        int index = sm.getMinSelectionIndex();
        if (sm.isSelectionEmpty()) assert (false) : "EditLibrary button should be disabled";
        VisualClassPathItem item = this.classpathModel.get(index);
        if (item.getType() == VisualClassPathItem.Type.LIBRARY) {
            LibrariesCustomizer.showCustomizer((Library)((Library)item.getObject()));
        }
        this.fireActionPerformed();
    }

    static Collection<Library> getLibrarySet(Collection<String> libraryNames) {
        HashSet<Library> librarySet = new HashSet<Library>();
        for (String libName : libraryNames) {
            librarySet.add(LibraryManager.getDefault().getLibrary(libName));
        }
        return librarySet;
    }

    private static boolean isBaseLibraryItem(VisualClassPathItem item) {
        return baseLibrarySet.contains(item.getObject());
    }

    public static String getLibraryString(Library lib) {
        List content = lib.getContent("classpath");
        StringBuilder sb = new StringBuilder();
        Iterator it = content.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(it.next().toString());
        }
        String s = sb.toString();
        return s;
    }

    private static String getBundleResource(String resourceName) {
        return NbBundle.getMessage(VisualClasspathSupport.class, (String)resourceName);
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private final String description;
        private final Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        public String getDescription() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClasspathTableModel
    extends AbstractTableModel {
        int columnCount = 2;
        private List<VisualClassPathItem> cpItems;

        ClasspathTableModel(boolean singleColumn) {
            if (singleColumn) {
                this.columnCount = 1;
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public int getRowCount() {
            return this.cpItems == null ? 0 : this.cpItems.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            VisualClassPathItem item = this.cpItems.get(row);
            if (col == 0) {
                return item;
            }
            return this.isInWar(item);
        }

        public VisualClassPathItem get(int row) {
            return (VisualClassPathItem)this.getValueAt(row, 0);
        }

        public void setItem(int row, VisualClassPathItem item) {
            this.cpItems.set(row, item);
            this.fireTableCellUpdated(row, 0);
            this.fireTableCellUpdated(row, 1);
        }

        public void add(VisualClassPathItem item) {
            this.cpItems.add(item);
        }

        public void add(int index, VisualClassPathItem item) {
            this.cpItems.add(index, item);
        }

        public VisualClassPathItem remove(int index) {
            return this.cpItems.remove(index);
        }

        private Boolean isInWar(VisualClassPathItem item) {
            String pathInWAR = item.getPathInEAR();
            Boolean isInWar = pathInWAR == null || pathInWAR.equals(VisualClassPathItem.PATH_IN_EAR_NONE) ? (VisualClasspathSupport.isBaseLibraryItem(item) || item.getType() == VisualClassPathItem.Type.JAR && ((File)item.getObject()).isDirectory() ? null : Boolean.FALSE) : Boolean.TRUE;
            return isInWar;
        }

        public Class getColumnClass(int c) {
            if (c == 1) {
                return Boolean.class;
            }
            return VisualClassPathItem.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 1) {
                return this.isInWar(VisualClasspathSupport.this.classpathModel.get(row)) instanceof Boolean;
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                this.setItem(row, (VisualClassPathItem)value);
            } else if (value instanceof Boolean) {
                this.cpItems.get(row).setPathInEAR(value == Boolean.TRUE ? "WEB-INF/lib" : VisualClassPathItem.PATH_IN_EAR_NONE);
                this.fireTableCellUpdated(row, col);
            }
        }

        public void setItems(List<VisualClassPathItem> items) {
            this.cpItems = new ArrayList<VisualClassPathItem>(items);
            this.fireTableDataChanged();
        }

        public List<VisualClassPathItem> getItems() {
            return new ArrayList<VisualClassPathItem>(this.cpItems);
        }

        public int size() {
            return this.getRowCount();
        }
    }

    private static class BooleanCellRenderer
    implements TableCellRenderer {
        private final TableCellRenderer booleanRenderer;
        private final TableCellRenderer defaultRenderer;

        public BooleanCellRenderer(JTable table) {
            this.booleanRenderer = table.getDefaultRenderer(Boolean.class);
            this.defaultRenderer = new DefaultTableCellRenderer();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableCellRenderer renderer = value instanceof Boolean ? this.booleanRenderer : this.defaultRenderer;
            return renderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }

    private static class LibraryCellRenderer
    extends DefaultTableCellRenderer {
        private LibraryCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o;
            if (value instanceof VisualClassPathItem) {
                VisualClassPathItem item = (VisualClassPathItem)value;
                this.setIcon(item.getIcon());
                this.setEnabled(!VisualClasspathSupport.isBaseLibraryItem(item));
                String toolTipText = item.getToolTipText();
                this.setToolTipText(toolTipText);
                o = item.toString();
            } else {
                o = value;
            }
            return super.getTableCellRendererComponent(table, o, isSelected, false, row, column);
        }
    }

    private class ClasspathSupportListener
    implements ActionListener,
    ListSelectionListener,
    TableModelListener {
        private ClasspathSupportListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == VisualClasspathSupport.this.addJarButton) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(2);
                chooser.setMultiSelectionEnabled(true);
                chooser.setDialogTitle(VisualClasspathSupport.getBundleResource("LBL_AddJar_DialogTitle"));
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter(new SimpleFileFilter(VisualClasspathSupport.getBundleResource("LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"}));
                int option = chooser.showOpenDialog(null);
                if (option == 0) {
                    File[] files = chooser.getSelectedFiles();
                    VisualClasspathSupport.this.addJarFiles(files);
                }
            } else if (source == VisualClasspathSupport.this.addLibraryButton) {
                final LibrariesChooser panel = new LibrariesChooser(VisualClasspathSupport.this.getLibraries(), VisualClasspathSupport.this.j2eePlatform);
                final JButton btnAddLibrary = new JButton(VisualClasspathSupport.getBundleResource("LBL_AddLibrary"));
                Object[] options = new Object[]{btnAddLibrary, DialogDescriptor.CANCEL_OPTION};
                DialogDescriptor desc = new DialogDescriptor((Object)panel, VisualClasspathSupport.getBundleResource("LBL_CustomizeCompile_Classpath_AddLibrary"), true, options, options[0], 0, null, null);
                Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
                panel.addListSelectionListener(new ListSelectionListener(){

                    public void valueChanged(ListSelectionEvent e) {
                        btnAddLibrary.setEnabled(panel.isValidSelection());
                    }
                });
                btnAddLibrary.setEnabled(panel.isValidSelection());
                dlg.setVisible(true);
                if (desc.getValue() == options[0]) {
                    VisualClasspathSupport.this.addLibraries(panel.getSelectedLibraries());
                }
                dlg.dispose();
            } else if (source == VisualClasspathSupport.this.addArtifactButton) {
                AntArtifact[] artifacts = AntArtifactChooser.showDialog(VisualClasspathSupport.this.master, new String[]{"j2ee_ear_archive", "j2ee_ear_archive", "jar"});
                if (artifacts != null) {
                    VisualClasspathSupport.this.addArtifacts(artifacts);
                }
            } else if (source == VisualClasspathSupport.this.removeButton) {
                VisualClasspathSupport.this.removeSelectedItems();
            } else if (source == VisualClasspathSupport.this.upButton) {
                VisualClasspathSupport.this.moveUp();
            } else if (source == VisualClasspathSupport.this.downButton) {
                VisualClasspathSupport.this.moveDown();
            } else if (source == VisualClasspathSupport.this.editButton) {
                VisualClasspathSupport.this.editLibrary();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            boolean remove;
            int[] si = VisualClasspathSupport.this.classpathTable.getSelectedRows();
            boolean edit = false;
            if (si != null && si.length > 0) {
                for (int i = 0; i < si.length; ++i) {
                    int index = si[i];
                    VisualClassPathItem item = VisualClasspathSupport.this.classpathModel.get(index);
                    if (item.getType() == VisualClassPathItem.Type.LIBRARY || VisualClasspathSupport.isBaseLibraryItem(item)) continue;
                    edit = true;
                    break;
                }
            }
            boolean bl = remove = si != null && si.length > 0;
            if (remove) {
                for (int i = 0; i < si.length; ++i) {
                    int index = si[i];
                    assert (index < VisualClasspathSupport.this.classpathModel.size()) : "The selected indices " + Arrays.asList(Utilities.toObjectArray((Object)si)) + " at " + i + " must fit into size of classpathModel" + VisualClasspathSupport.access$1100(VisualClasspathSupport.this).size();
                    VisualClassPathItem item = VisualClasspathSupport.this.classpathModel.get(index);
                    if (item.canDelete() && !VisualClasspathSupport.isBaseLibraryItem(item)) continue;
                    remove = false;
                    break;
                }
            }
            boolean up = si != null && si.length > 0 && si[0] != 0;
            boolean down = si != null && si.length > 0 && si[si.length - 1] != VisualClasspathSupport.this.classpathModel.size() - 1;
            VisualClasspathSupport.this.editButton.setEnabled(edit);
            VisualClasspathSupport.this.removeButton.setEnabled(remove);
            VisualClasspathSupport.this.upButton.setEnabled(up);
            VisualClasspathSupport.this.downButton.setEnabled(down);
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getColumn() == 1) {
                VisualClassPathItem item = VisualClasspathSupport.this.classpathModel.get(e.getFirstRow());
                if (VisualClasspathSupport.this.classpathModel.getValueAt(e.getFirstRow(), 1) == Boolean.TRUE) {
                    item.setPathInEAR("WEB-INF/lib");
                } else {
                    item.setPathInEAR(VisualClassPathItem.PATH_IN_EAR_NONE);
                }
                VisualClasspathSupport.this.fireActionPerformed();
            }
        }
    }
}

