/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.wizard;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.util.TomcatInstallUtil;
import org.netbeans.modules.tomcat5.wizard.InstallPanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class AddInstanceIterator
implements WizardDescriptor.InstantiatingIterator {
    public static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    private static final String[] CONTENT_DATA = new String[]{NbBundle.getMessage(AddInstanceIterator.class, (String)"LBL_InstanceProperties")};
    private WizardDescriptor wizard;
    private InstallPanel panel;
    private final int tomcatVersion;

    public AddInstanceIterator(int aTomcatVersion) {
        this.tomcatVersion = aTomcatVersion;
    }

    public void removeChangeListener(ChangeListener l) {
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void previousPanel() {
        throw new NoSuchElementException();
    }

    public void nextPanel() {
        throw new NoSuchElementException();
    }

    public String name() {
        return null;
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> result = new HashSet<InstanceProperties>();
        String displayName = this.getDisplayName();
        String url = this.panel.getVisual().getUrl();
        String username = this.panel.getVisual().getUsername();
        String password = this.panel.getVisual().getPassword();
        try {
            InstanceProperties ip = InstanceProperties.createInstanceProperties((String)url, (String)username, (String)password, (String)displayName);
            Properties prop = this.panel.getVisual().getProperties();
            Enumeration<?> en = prop.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                ip.setProperty(key, prop.getProperty(key));
            }
            ip.setProperty("runningCheckTimeout", Integer.toString(2000));
            result.add(ip);
            this.checkStartupScript(this.panel.getVisual().getHomeDir());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().log(4096, ex.getMessage());
        }
        return result;
    }

    public boolean hasPrevious() {
        return false;
    }

    public boolean hasNext() {
        return false;
    }

    public WizardDescriptor.Panel current() {
        if (this.panel == null) {
            this.panel = new InstallPanel(this.tomcatVersion);
        }
        this.setContentData((JComponent)this.panel.getComponent());
        this.setContentSelectedIndex((JComponent)this.panel.getComponent());
        return this.panel;
    }

    private void setContentData(JComponent component) {
        if (component.getClientProperty(PROP_CONTENT_DATA) == null) {
            component.putClientProperty(PROP_CONTENT_DATA, CONTENT_DATA);
        }
    }

    private void setContentSelectedIndex(JComponent component) {
        if (component.getClientProperty(PROP_CONTENT_SELECTED_INDEX) == null) {
            component.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        }
    }

    private String getDisplayName() {
        return (String)this.wizard.getProperty(PROP_DISPLAY_NAME);
    }

    private void checkStartupScript(File homeDir) {
        String CATALINA = Utilities.isWindows() ? "catalina.bat" : "catalina.sh";
        boolean catalinaOK = new File(homeDir, "bin/" + CATALINA).exists();
        String SETCLASSPATH = Utilities.isWindows() ? "setclasspath.bat" : "setclasspath.sh";
        boolean setclasspathOK = new File(homeDir, "bin/" + SETCLASSPATH).exists();
        if (!catalinaOK || !setclasspathOK) {
            String msg = null;
            msg = !catalinaOK && !setclasspathOK ? NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_scripts", (Object)CATALINA, (Object)SETCLASSPATH) : NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_no_startup_script", (Object)(!catalinaOK ? CATALINA : SETCLASSPATH));
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd).equals(NotifyDescriptor.YES_OPTION)) {
                try {
                    File bundledHome = TomcatInstallUtil.getBundledHome();
                    if (bundledHome != null) {
                        if (!catalinaOK) {
                            FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)new File(bundledHome, "bin/" + CATALINA)), (FileObject)FileUtil.toFileObject((File)new File(homeDir, "bin")), (String)CATALINA.substring(0, CATALINA.indexOf(".")));
                        }
                        if (!setclasspathOK) {
                            FileUtil.copyFile((FileObject)FileUtil.toFileObject((File)new File(bundledHome, "bin/" + SETCLASSPATH)), (FileObject)FileUtil.toFileObject((File)new File(homeDir, "bin")), (String)SETCLASSPATH.substring(0, SETCLASSPATH.indexOf(".")));
                        }
                    }
                }
                catch (IOException e) {
                    msg = NbBundle.getMessage(AddInstanceIterator.class, (String)"MSG_startup_scripts_copy_failed");
                    nd = new NotifyDescriptor.Message((Object)msg, 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        }
    }
}

