/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;
import org.openide.ErrorManager;

public class TomcatManagerConfig {
    private File serverXml;
    private long timestamp;
    private boolean hasLogger;
    private String loggerClassName;
    private String loggerDir;
    private String loggerPrefix;
    private String loggerSuffix;
    private boolean loggerTimestamp;

    public TomcatManagerConfig(File serverXml) {
        this.serverXml = serverXml;
        this.refresh();
    }

    public void refresh() {
        long newTimestamp = this.serverXml.lastModified();
        if (newTimestamp > this.timestamp) {
            this.timestamp = newTimestamp;
            Host host = this.getHostElement();
            if (host != null && host.isLogger()) {
                this.hasLogger = true;
                this.loggerClassName = host.getAttributeValue("Logger", "className");
                this.loggerDir = host.getAttributeValue("Logger", "directory");
                this.loggerPrefix = host.getAttributeValue("Logger", "prefix");
                this.loggerSuffix = host.getAttributeValue("Logger", "suffix");
                String timestamp = host.getAttributeValue("Logger", "timestamp");
                this.loggerTimestamp = Boolean.valueOf(timestamp);
            } else {
                Engine engine = this.getEngineElement();
                if (engine != null && engine.isLogger()) {
                    this.hasLogger = true;
                    this.loggerClassName = engine.getAttributeValue("Logger", "className");
                    this.loggerDir = engine.getAttributeValue("Logger", "directory");
                    this.loggerPrefix = engine.getAttributeValue("Logger", "prefix");
                    this.loggerSuffix = engine.getAttributeValue("Logger", "suffix");
                    String timestamp = engine.getAttributeValue("Logger", "timestamp");
                    this.loggerTimestamp = Boolean.valueOf(timestamp);
                } else {
                    this.hasLogger = false;
                }
            }
        }
    }

    public String serverXmlPath() {
        return this.serverXml.getAbsolutePath();
    }

    public Server getServerElement() {
        try {
            return Server.createGraph(this.serverXml);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        catch (RuntimeException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return null;
    }

    public Engine getEngineElement() {
        Server server = this.getServerElement();
        if (server == null) {
            return null;
        }
        Service[] service = server.getService();
        if (service.length > 0) {
            return service[0].getEngine();
        }
        return null;
    }

    public Host getHostElement() {
        Host[] host;
        Engine engine = this.getEngineElement();
        if (engine != null && (host = engine.getHost()).length > 0) {
            return host[0];
        }
        return null;
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public String loggerClassName() {
        return this.loggerClassName;
    }

    public String loggerDir() {
        return this.loggerDir;
    }

    public String loggerPrefix() {
        return this.loggerPrefix;
    }

    public String loggerSuffix() {
        return this.loggerSuffix;
    }

    public boolean loggerTimestamp() {
        return this.loggerTimestamp;
    }
}

