/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeConditionalSection;
import org.netbeans.tax.TreeException;

public class TreeConditionalSectionCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = -396968653847909885L;
    private JRadioButton ignoreRadioButton;
    private JScrollPane ignoredContentScrollPane;
    private ButtonGroup includeButtonGroup;
    private JTextArea ignoredContentTextArea;
    private JRadioButton includeRadioButton;
    private JPanel fillPanel;

    public TreeConditionalSectionCustomizer() {
        this.initComponents();
        this.initAccessibility();
    }

    protected final TreeConditionalSection getConditionalSection() {
        return (TreeConditionalSection)this.getTreeObject();
    }

    protected final void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("include")) {
            this.updateIncludeIgnoreComponent();
        } else if (pche.getPropertyName().equals("ignoredContent")) {
            this.updateIgnoredContentComponent();
        }
    }

    protected void updateIncludeIgnoreComponent() {
        this.includeRadioButton.setSelected(this.getConditionalSection().isInclude());
        this.ignoreRadioButton.setSelected(!this.getConditionalSection().isInclude());
        this.ignoredContentScrollPane.setVisible(!this.getConditionalSection().isInclude());
        this.fillPanel.setVisible(this.getConditionalSection().isInclude());
    }

    protected void updateConditionalSectionInclude() {
        try {
            this.getConditionalSection().setInclude(this.includeRadioButton.isSelected());
        }
        catch (TreeException exc) {
            this.updateIncludeIgnoreComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected void updateIgnoredContentComponent() {
        this.ignoredContentTextArea.setText(TreeConditionalSectionCustomizer.null2text(this.getConditionalSection().getIgnoredContent()));
    }

    protected void updateConditionalSectionIgnoredContent() {
        try {
            this.getConditionalSection().setIgnoredContent(TreeConditionalSectionCustomizer.text2null(this.ignoredContentTextArea.getText()));
        }
        catch (TreeException exc) {
            this.updateIgnoredContentComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected void initComponentValues() {
        this.updateIncludeIgnoreComponent();
        this.updateIgnoredContentComponent();
    }

    protected void updateReadOnlyStatus(boolean editable) {
        this.includeRadioButton.setEnabled(editable);
        this.ignoreRadioButton.setEnabled(editable);
        this.ignoredContentTextArea.setEditable(editable);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeConditionalSectionCustomizer"));
        this.ignoredContentTextArea.getAccessibleContext().setAccessibleName(Util.THIS.getString("ACSN_ignoredContentPane"));
        this.includeRadioButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_includeRadioButton"));
        this.ignoreRadioButton.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_ignoreRadioButton"));
    }

    private void initComponents() {
        this.includeButtonGroup = new ButtonGroup();
        this.includeRadioButton = new JRadioButton();
        this.ignoreRadioButton = new JRadioButton();
        this.ignoredContentScrollPane = new JScrollPane();
        this.ignoredContentTextArea = new JTextArea();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 100));
        this.includeRadioButton.setSelected(true);
        this.includeRadioButton.setText(Util.THIS.getString("PROP_condSection_include"));
        this.includeButtonGroup.add(this.includeRadioButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.includeRadioButton, gridBagConstraints);
        this.ignoreRadioButton.setText(Util.THIS.getString("PROP_condSection_ignore"));
        this.includeButtonGroup.add(this.ignoreRadioButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.ignoreRadioButton, gridBagConstraints);
        this.ignoredContentScrollPane.setPreferredSize(new Dimension(350, 200));
        this.ignoredContentScrollPane.setViewportView(this.ignoredContentTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.ignoredContentScrollPane, gridBagConstraints);
        this.fillPanel.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillPanel, gridBagConstraints);
    }
}

