/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.framework;

import com.sun.tools.ws.util.xml.PrettyPrintingXmlWriter;
import com.sun.xml.ws.util.NamespaceSupport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WriterContext {
    private PrettyPrintingXmlWriter _writer;
    private NamespaceSupport _nsSupport;
    private String _targetNamespaceURI;
    private int _newPrefixCount;
    private List _pendingNamespaceDeclarations;

    public WriterContext(OutputStream os) throws IOException {
        this._writer = new PrettyPrintingXmlWriter(os);
        this._nsSupport = new NamespaceSupport();
        this._newPrefixCount = 2;
    }

    public void flush() throws IOException {
        this._writer.flush();
    }

    public void close() throws IOException {
        this._writer.close();
    }

    public void push() {
        if (this._pendingNamespaceDeclarations != null) {
            throw new IllegalStateException("prefix declarations are pending");
        }
        this._nsSupport.pushContext();
    }

    public void pop() {
        this._nsSupport.popContext();
        this._pendingNamespaceDeclarations = null;
    }

    public String getNamespaceURI(String prefix) {
        return this._nsSupport.getURI(prefix);
    }

    public Iterator getPrefixes() {
        return this._nsSupport.getPrefixes();
    }

    public String getDefaultNamespaceURI() {
        return this.getNamespaceURI("");
    }

    public void declarePrefix(String prefix, String uri) {
        this._nsSupport.declarePrefix(prefix, uri);
        if (this._pendingNamespaceDeclarations == null) {
            this._pendingNamespaceDeclarations = new ArrayList();
        }
        this._pendingNamespaceDeclarations.add(new String[]{prefix, uri});
    }

    public String getPrefixFor(String uri) {
        if (this.getDefaultNamespaceURI() != null && this.getDefaultNamespaceURI().equals(uri) || uri.equals("")) {
            return "";
        }
        return this._nsSupport.getPrefix(uri);
    }

    public String findNewPrefix(String base) {
        return base + Integer.toString(this._newPrefixCount++);
    }

    public String getTargetNamespaceURI() {
        return this._targetNamespaceURI;
    }

    public void setTargetNamespaceURI(String uri) {
        this._targetNamespaceURI = uri;
    }

    public void writeStartTag(QName name) throws IOException {
        this._writer.start(this.getQNameString(name));
    }

    public void writeEndTag(QName name) throws IOException {
        this._writer.end(this.getQNameString(name));
    }

    public void writeAttribute(String name, String value) throws IOException {
        if (value != null) {
            this._writer.attribute(name, value);
        }
    }

    public void writeAttribute(String name, QName value) throws IOException {
        if (value != null) {
            this._writer.attribute(name, this.getQNameString(value));
        }
    }

    public void writeAttribute(String name, boolean value) throws IOException {
        this.writeAttribute(name, value ? "true" : "false");
    }

    public void writeAttribute(String name, Boolean value) throws IOException {
        if (value != null) {
            this.writeAttribute(name, (boolean)value);
        }
    }

    public void writeAttribute(String name, int value) throws IOException {
        this.writeAttribute(name, Integer.toString(value));
    }

    public void writeAttribute(String name, Object value, Map valueToXmlMap) throws IOException {
        String actualValue = (String)valueToXmlMap.get(value);
        this.writeAttribute(name, actualValue);
    }

    public void writeNamespaceDeclaration(String prefix, String uri) throws IOException {
        this._writer.attribute(this.getNamespaceDeclarationAttributeName(prefix), uri);
    }

    public void writeAllPendingNamespaceDeclarations() throws IOException {
        if (this._pendingNamespaceDeclarations != null) {
            for (String[] pair : this._pendingNamespaceDeclarations) {
                this.writeNamespaceDeclaration(pair[0], pair[1]);
            }
        }
        this._pendingNamespaceDeclarations = null;
    }

    private String getNamespaceDeclarationAttributeName(String prefix) {
        if (prefix.equals("")) {
            return "xmlns";
        }
        return "xmlns:" + prefix;
    }

    public void writeTag(QName name, String value) throws IOException {
        this._writer.leaf(this.getQNameString(name), value);
    }

    public String getQNameString(QName name) {
        String nsURI = name.getNamespaceURI();
        String prefix = this.getPrefixFor(nsURI);
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (prefix.equals("")) {
            return name.getLocalPart();
        }
        return prefix + ":" + name.getLocalPart();
    }

    public String getQNameStringWithTargetNamespaceCheck(QName name) {
        if (name.getNamespaceURI().equals(this._targetNamespaceURI)) {
            return name.getLocalPart();
        }
        return this.getQNameString(name);
    }

    public void writeChars(String chars) throws IOException {
        this._writer.chars(chars);
    }
}

