/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsdl.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.netbeans.modules.websvc.wsdl.config.api.J2eeMappingFile;
import org.netbeans.modules.websvc.wsdl.config.api.Modelfile;
import org.netbeans.modules.websvc.wsdl.config.api.RootInterface;
import org.netbeans.modules.websvc.wsdl.config.api.Service;
import org.netbeans.modules.websvc.wsdl.config.api.Wsdl;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.xml.sax.SAXParseException;

public class ConfigurationProxy
implements Configuration {
    private Configuration configuration;
    private String version;
    private List listeners;
    public boolean writing = false;
    private OutputProvider outputProvider;
    private SAXParseException error;
    private int ddStatus;

    public ConfigurationProxy(Configuration configuration) {
        this.init(configuration, "1.1");
    }

    private void init(Configuration configuration, String version) {
        this.configuration = configuration;
        this.version = version;
        this.listeners = new ArrayList();
    }

    public void setOriginal(Configuration configuration) {
        if (this.configuration != configuration) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                PropertyChangeListener pcl = (PropertyChangeListener)this.listeners.get(i);
                if (this.configuration != null) {
                    this.configuration.removePropertyChangeListener(pcl);
                }
                if (configuration == null) continue;
                configuration.addPropertyChangeListener(pcl);
            }
            this.configuration = configuration;
        }
    }

    public Configuration getOriginal() {
        return this.configuration;
    }

    public void setProxyVersion(String value) {
        if (this.version == null && value != null || !this.version.equals(value)) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "cfg_version", this.version, value);
            this.version = value;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(evt);
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public SAXParseException getError() {
        return this.error;
    }

    public void setError(SAXParseException error) {
        this.error = error;
    }

    public int getStatus() {
        return this.ddStatus;
    }

    public void setStatus(int value) {
        if (this.ddStatus != value) {
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "cfg_status", new Integer(this.ddStatus), new Integer(value));
            this.ddStatus = value;
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((PropertyChangeListener)this.listeners.get(i)).propertyChange(evt);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.configuration != null) {
            this.configuration.addPropertyChangeListener(pcl);
        }
        this.listeners.add(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.configuration != null) {
            this.configuration.removePropertyChangeListener(pcl);
        }
        this.listeners.remove(pcl);
    }

    public J2eeMappingFile getJ2eeMappingFile() {
        return this.configuration == null ? null : this.configuration.getJ2eeMappingFile();
    }

    public Modelfile getModelfile() {
        return this.configuration == null ? null : this.configuration.getModelfile();
    }

    public Service getService() {
        return this.configuration == null ? null : this.configuration.getService();
    }

    public Wsdl getWsdl() {
        return this.configuration == null ? null : this.configuration.getWsdl();
    }

    public J2eeMappingFile newJ2eeMappingFile() {
        return this.configuration == null ? null : this.configuration.newJ2eeMappingFile();
    }

    public Modelfile newModelfile() {
        return this.configuration == null ? null : this.configuration.newModelfile();
    }

    public Service newService() {
        return this.configuration == null ? null : this.configuration.newService();
    }

    public Wsdl newWsdl() {
        return this.configuration == null ? null : this.configuration.newWsdl();
    }

    public void setJ2eeMappingFile(J2eeMappingFile value) {
        if (this.configuration != null) {
            this.configuration.setJ2eeMappingFile(value);
        }
    }

    public void setModelfile(Modelfile value) {
        if (this.configuration != null) {
            this.configuration.setModelfile(value);
        }
    }

    public void setService(Service value) {
        if (this.configuration != null) {
            this.configuration.setService(value);
        }
    }

    public void setWsdl(Wsdl value) {
        if (this.configuration != null) {
            this.configuration.setWsdl(value);
        }
    }

    public Object getValue(String name) {
        return this.configuration == null ? null : this.configuration.getValue(name);
    }

    public void merge(RootInterface bean, int mode) {
        if (this.configuration != null) {
            if (bean instanceof ConfigurationProxy) {
                this.configuration.merge(((ConfigurationProxy)bean).getOriginal(), mode);
            } else {
                this.configuration.merge(bean, mode);
            }
        }
    }

    public void write(OutputStream os) throws IOException {
        if (this.configuration != null) {
            this.writing = true;
            this.configuration.write(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileObject fo) throws IOException {
        if (this.configuration != null) {
            try {
                FileLock lock = fo.lock();
                try {
                    OutputStream os = fo.getOutputStream(lock);
                    try {
                        this.writing = true;
                        this.write(os);
                    }
                    finally {
                        os.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            catch (FileAlreadyLockedException ex) {
                DataObject dobj = DataObject.find((FileObject)fo);
                if (dobj != null && dobj instanceof OutputProvider) {
                    ((OutputProvider)dobj).write(this);
                }
                throw ex;
            }
        }
    }

    public Object clone() {
        ConfigurationProxy proxy = null;
        if (this.configuration == null) {
            proxy = new ConfigurationProxy(null);
        } else {
            Configuration clonedConfiguration = (Configuration)this.configuration.clone();
            proxy = new ConfigurationProxy(clonedConfiguration);
            ((org.netbeans.modules.websvc.wsdl.config.impl.Configuration)clonedConfiguration)._setSchemaLocation("http://java.sun.com/xml/ns/jax-rpc/ri/config");
        }
        proxy.setError(this.error);
        proxy.setStatus(this.ddStatus);
        return proxy;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void setWriting(boolean writing) {
        this.writing = writing;
    }

    public void setOutputProvider(OutputProvider iop) {
        this.outputProvider = iop;
    }

    public static interface OutputProvider {
        public void write(Configuration var1) throws IOException;

        public FileObject getTarget();
    }
}

