/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class JMIUtils {
    private static MDRepository repository = JavaModel.getJavaRepository();
    private BaseDocument doc;
    private FileObject fileObject;

    public static synchronized JMIUtils get(BaseDocument doc) {
        JMIUtils utils = (JMIUtils)doc.getProperty(JMIUtils.class);
        if (utils == null) {
            utils = new JMIUtils(doc);
            doc.putProperty(JMIUtils.class, (Object)utils);
        }
        return utils;
    }

    private JMIUtils(BaseDocument doc) {
        FileObject fo;
        ClassPath sourceCP;
        this.doc = doc;
        DataObject dob = NbEditorUtilities.getDataObject((Document)doc);
        if (dob != null && (sourceCP = ClassPath.getClassPath((FileObject)(fo = dob.getPrimaryFile()), (String)"classpath/source")) != null) {
            this.fileObject = sourceCP.findOwnerRoot(fo);
        }
    }

    public void beginTrans(boolean write) {
        repository.beginTrans(write);
        if (this.fileObject != null) {
            try {
                JavaModel.setClassPath((FileObject)this.fileObject);
            }
            catch (RuntimeException e) {
                repository.endTrans(write);
                throw e;
            }
            catch (Error e) {
                repository.endTrans(write);
                throw e;
            }
        }
    }

    public void endTrans(boolean fail) {
        repository.endTrans(fail);
    }
}

