/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.lang.reflect.Method;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;

public class WebProxySetter {
    private final Integer MANUAL_SET_PROXY = new Integer(2);
    private final String PROXY_HOST = "http.proxyHost";
    private final String PROXY_PORT = "http.proxyPort";
    private static WebProxySetter defaultInstance = new WebProxySetter();
    private Object settingsInstance;
    private Method mGetUseProxy;
    private Method mSetUseProxy;
    private Method mGetProxyHost;
    private Method mSetProxyHost;
    private Method mGetProxyPort;
    private Method mSetProxyPort;

    private WebProxySetter() {
        try {
            ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clazz = l.loadClass("org.netbeans.core.IDESettings");
            this.settingsInstance = SharedClassObject.findObject(clazz, (boolean)true);
            this.mGetUseProxy = clazz.getMethod("getProxyType", null);
            this.mSetUseProxy = clazz.getMethod("setProxyType", Integer.TYPE);
            this.mGetProxyHost = clazz.getMethod("getUserProxyHost", null);
            this.mSetProxyHost = clazz.getMethod("setUserProxyHost", String.class);
            this.mGetProxyPort = clazz.getMethod("getUserProxyPort", null);
            this.mSetProxyPort = clazz.getMethod("setUserProxyPort", String.class);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public static WebProxySetter getInstance() {
        return defaultInstance;
    }

    public String getProxyHost() {
        try {
            return (String)this.mGetProxyHost.invoke(this.settingsInstance, new Object[0]);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return System.getProperty("http.proxyHost");
        }
    }

    public String getProxyPort() {
        try {
            return (String)this.mGetProxyPort.invoke(this.settingsInstance, new Object[0]);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return System.getProperty("http.proxyPort");
        }
    }

    public int getProxyType() {
        try {
            return (Integer)this.mGetUseProxy.invoke(this.settingsInstance, new Object[0]);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return 1;
        }
    }

    public void setProxyConfiguration(int proxyType, String host, String port) {
        try {
            this.mSetUseProxy.invoke(this.settingsInstance, new Integer(proxyType));
            this.mSetProxyHost.invoke(this.settingsInstance, host);
            this.mSetProxyPort.invoke(this.settingsInstance, port);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        if (proxyType == 0) {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        } else {
            System.setProperty("http.proxyHost", host);
            System.setProperty("http.proxyPort", port);
        }
    }
}

