/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.util.Map;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.xml.text.indent.XMLIndentEngine;
import org.netbeans.modules.xml.text.syntax.AbstractBaseOptions;
import org.netbeans.modules.xml.text.syntax.XMLKit;

public class XMLOptions
extends AbstractBaseOptions {
    private static final long serialVersionUID = 2347735706857337892L;
    public static final String COMPLETION_AUTO_POPUP_PROP = "completionAutoPopup";
    public static final String COMPLETION_AUTO_POPUP_DELAY_PROP = "completionAutoPopupDelay";
    public static final String COMPLETION_INSTANT_SUBSTITUTION_PROP = "completionInstantSubstitution";
    static final String[] XML_PROP_NAMES = new String[]{"completionAutoPopup", "completionAutoPopupDelay", "completionInstantSubstitution"};
    private static final String[][] TRANSLATE_COLORS = new String[][]{{"xml-string", "xml-value"}, {"xml-symbol", "xml-operator"}, {"xml-keyword", "xml-doctype"}, {"xml-plain", "xml-text"}};

    public XMLOptions() {
        super(XMLKit.class, "xml");
    }

    protected Class getDefaultIndentEngineClass() {
        return XMLIndentEngine.class;
    }

    public boolean getCompletionAutoPopup() {
        return this.getSettingBoolean("completion-auto-popup");
    }

    public void setCompletionAutoPopup(boolean v) {
        this.setSettingBoolean("completion-auto-popup", v, COMPLETION_AUTO_POPUP_PROP);
    }

    public int getCompletionAutoPopupDelay() {
        return this.getSettingInteger("completion-auto-popup-delay");
    }

    public void setCompletionAutoPopupDelay(int delay) {
        if (delay < 0) {
            NbEditorUtilities.invalidArgument((String)"MSG_NegativeValue");
            return;
        }
        this.setSettingInteger("completion-auto-popup-delay", delay, COMPLETION_AUTO_POPUP_DELAY_PROP);
    }

    public boolean getCompletionInstantSubstitution() {
        return this.getSettingBoolean("completion-instant-substitution");
    }

    public void setCompletionInstantSubstitution(boolean v) {
        this.setSettingBoolean("completion-instant-substitution", v, COMPLETION_INSTANT_SUBSTITUTION_PROP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getColoringMap() {
        Map colors = super.getColoringMap();
        XMLOptions xMLOptions = this;
        synchronized (xMLOptions) {
            for (int i = 0; i < TRANSLATE_COLORS.length; ++i) {
                String oldKey = TRANSLATE_COLORS[i][0];
                Object color = colors.get(oldKey);
                if (color == null) continue;
                colors.remove(oldKey);
                String newKey = TRANSLATE_COLORS[i][1];
                colors.put(newKey, color);
            }
            return colors;
        }
    }
}

