/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.xml.text.completion.XMLCompletionResultItemPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

class XMLResultItem
implements CompletionQuery.ResultItem,
CompletionItem {
    private static final int XML_ITEMS_SORT_PRIORITY = 20;
    public String displayText;
    private String replacementText;
    public Icon icon;
    public Color foreground = Color.black;
    public Color background = Color.white;
    public Color selectionForeground = Color.black;
    public Color selectionBackground = new Color(204, 204, 255);
    private static JLabel rubberStamp = new JLabel();
    private XMLCompletionResultItemPaintComponent component;
    private boolean shift = false;
    static int substituteOffset;

    public XMLResultItem(String replacementText) {
        this(replacementText, null);
    }

    public XMLResultItem(String replacementText, String displayText) {
        this.replacementText = replacementText;
        this.displayText = displayText != null ? displayText : replacementText;
    }

    public XMLResultItem(String displayText, Icon icon, Color foreground, Color background, Color selectionForeground, Color selectionBackground) {
        this.displayText = displayText;
        this.icon = icon;
        this.foreground = foreground;
        this.background = background;
        this.selectionForeground = selectionForeground;
        this.selectionBackground = selectionBackground;
    }

    public String getReplacementText(int modifiers) {
        return this.displayText;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceText(JTextComponent component, String text, int offset, int len) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        doc.atomicLock();
        try {
            String currentText = doc.getText(offset, doc.getLength() - offset < text.length() ? doc.getLength() - offset : text.length());
            if (!text.equals(currentText)) {
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
            } else {
                int newCaretPos = component.getCaret().getDot() + text.length() - len;
                component.setCaretPosition(newCaretPos < doc.getLength() ? newCaretPos : doc.getLength());
            }
        }
        catch (BadLocationException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            doc.atomicUnlock();
        }
        return true;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return this.replaceText(c, this.getReplacementText(0).substring(0, subLen), offset, len);
    }

    public final boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        int modifier = shift ? 1 : 0;
        return this.substituteText(c, offset, len, modifier);
    }

    public boolean substituteText(JTextComponent c, int offset, int len, int modifiers) {
        return this.replaceText(c, this.getReplacementText(modifiers), offset, len);
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        if (this.getIcon() != null) {
            rubberStamp.setIcon(this.getIcon());
        }
        rubberStamp.setText(this.displayText);
        if (isSelected) {
            rubberStamp.setBackground(this.selectionBackground);
            rubberStamp.setForeground(this.selectionForeground);
        } else {
            rubberStamp.setBackground(this.background);
            rubberStamp.setForeground(this.foreground);
        }
        return rubberStamp;
    }

    public final String getItemText() {
        return this.replacementText;
    }

    public String toString() {
        return this.getItemText();
    }

    Color getPaintColor() {
        return Color.BLUE;
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public void defaultAction(JTextComponent component) {
        int substOffset = this.getSubstituteOffset();
        if (substOffset == -1) {
            substOffset = component.getCaretPosition();
        }
        if (!this.shift) {
            Completion.get().hideAll();
        }
        this.substituteText(component, substOffset, component.getCaretPosition() - substOffset, this.shift);
    }

    public int getSubstituteOffset() {
        return substituteOffset;
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public Component getPaintComponent(boolean isSelected) {
        XMLCompletionResultItemPaintComponent.StringPaintComponent component = new XMLCompletionResultItemPaintComponent.StringPaintComponent(this.getPaintColor());
        component.setSelected(isSelected);
        component.setString(this.getItemText());
        return component;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public int getSortPriority() {
        return 20;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((XMLCompletionResultItemPaintComponent)renderComponent).paintComponent(g);
    }

    static {
        rubberStamp.setOpaque(true);
        substituteOffset = -1;
    }
}

