/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.j2ee.common.JMIGenerationUtil;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.MethodCollectorFactory;
import org.netbeans.modules.j2ee.common.ui.nodes.MethodCustomizer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class WSUtils {
    public static Method addWsOperation(JavaClass javaClass) {
        return WSUtils.addWsOperation(javaClass, NbBundle.getMessage(WSUtils.class, (String)"TXT_DefaultOperationName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Method addWsOperation(JavaClass javaClass, String operationName) {
        Method m = null;
        if (javaClass == null) return m;
        if (!javaClass.isValid()) return m;
        JMIUtils.beginJmiTransaction();
        try {
            m = JMIUtils.createMethod(javaClass);
            m.setModifiers(1);
            m.setName(operationName);
            MultipartId tr = ((JavaModelPackage)javaClass.refImmediatePackage()).getMultipartId().createMultipartId("String", null, null);
            m.setTypeName((TypeReference)tr);
        }
        catch (JmiException e) {
            ErrorManager.getDefault().log(1, e.toString());
            ErrorManager.getDefault().log(1, e.getElementInError().toString());
            ErrorManager.getDefault().log(1, e.getObjectInError().toString());
        }
        finally {
            JMIUtils.endJmiTransaction();
        }
        if (m == null) {
            return null;
        }
        MethodCustomizer mc = MethodCollectorFactory.operationCollector(m);
        final NotifyDescriptor nd = new NotifyDescriptor((Object)mc, NbBundle.getMessage(WSUtils.class, (String)"TTL_AddOperation"), 2, -1, null, null);
        mc.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Object newvalue;
                if (evt.getPropertyName().equals("ok_enabled") && (newvalue = evt.getNewValue()) != null && newvalue instanceof Boolean) {
                    nd.setValid(((Boolean)newvalue).booleanValue());
                }
            }
        });
        Object rv = DialogDisplayer.getDefault().notify(nd);
        mc.isOK();
        if (rv == NotifyDescriptor.OK_OPTION) {
            boolean rollback = true;
            JMIUtils.beginJmiTransaction(true);
            try {
                m.setJavadocText(NbBundle.getMessage(WSUtils.class, (String)"TXT_WSOperation"));
                String body = NbBundle.getMessage(WSUtils.class, (String)"TXT_VoidOperation");
                Type returnType = m.getType();
                boolean voidType = true;
                if (!(returnType instanceof PrimitiveType) || !((PrimitiveType)returnType).getKind().equals(PrimitiveTypeKindEnum.VOID)) {
                    voidType = false;
                    String retString = WSUtils.getImplicitValue(m.getType());
                    if (retString != null) {
                        body = body + "return " + retString + ";";
                    }
                }
                if (javaClass == null) return m;
                javaClass.getContents().add(m);
                JMIUtils.fixImports(javaClass);
                m.setBodyText(body);
                m.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)javaClass, "javax.jws.WebMethod", new ArrayList()));
                if (voidType && m.getExceptionNames().size() == 0) {
                    m.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)javaClass, "javax.jws.Oneway", new ArrayList()));
                }
                List parameters = m.getParameters();
                for (int i = 0; i < parameters.size(); ++i) {
                    Parameter param = (Parameter)parameters.get(i);
                    String paramName = param.getName();
                    ArrayList<AttributeValue> attrValues = new ArrayList<AttributeValue>();
                    attrValues.add(JMIGenerationUtil.createAttributeValue((Element)javaClass, "name", paramName));
                    param.getAnnotations().add(JMIGenerationUtil.createAnnotation((Element)javaClass, "javax.jws.WebParam", attrValues));
                }
                rollback = false;
                return m;
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return m;
            }
            finally {
                JMIUtils.endJmiTransaction(rollback);
            }
        } else {
            m.refDelete();
            return null;
        }
    }

    private static String getImplicitValue(Type t) {
        String ret = "return ";
        if (t instanceof PrimitiveType) {
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.BOOLEAN)) {
                return "false";
            }
            if (((PrimitiveType)t).getKind().equals(PrimitiveTypeKindEnum.CHAR)) {
                return "''";
            }
            return "0";
        }
        if (t instanceof JavaClass) {
            return "null";
        }
        if (t instanceof Array) {
            return "new " + t.getName() + " { }";
        }
        return null;
    }
}

