/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class JMIGenerationUtil {
    private static final String CLASS_TEMPLATE = "Templates/Classes/Class.java";
    private static final String INTERFACE_TEMPLATE = "Templates/Classes/Interface.java";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaClass createEntityClass(FileObject targetFolder, String targetName) throws IOException {
        DataObject jcDob = JMIGenerationUtil.createClassFromTemplate(CLASS_TEMPLATE, targetFolder, targetName);
        JavaClass javaClass = null;
        JavaModel.getJavaRepository().beginTrans(true);
        boolean rollback = true;
        try {
            javaClass = JMIGenerationUtil.getJavaClassFromDataObject(jcDob);
            String templateJavaDoc = javaClass.getJavadocText();
            javaClass.setJavadocText(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_Class", (Object)targetName) + templateJavaDoc);
            JMIGenerationUtil.ensurePublicConstructor(javaClass);
            rollback = false;
        }
        finally {
            JavaModel.getJavaRepository().endTrans(rollback);
        }
        return javaClass;
    }

    public static JavaClass createClass(FileObject targetFolder, String targetName) throws IOException {
        DataObject dobj = JMIGenerationUtil.createClassFromTemplate(CLASS_TEMPLATE, targetFolder, targetName);
        return JMIGenerationUtil.getJavaClassFromDataObject(dobj);
    }

    public static JavaClass createInterface(FileObject targetFolder, String targetName) throws IOException {
        DataObject dobj = JMIGenerationUtil.createClassFromTemplate(INTERFACE_TEMPLATE, targetFolder, targetName);
        return JMIGenerationUtil.getJavaClassFromDataObject(dobj);
    }

    private static DataObject createClassFromTemplate(String template, FileObject targetFolder, String targetName) throws IOException {
        if (null == targetFolder || null == targetName || "".equals(targetName.trim())) {
            throw new IllegalArgumentException("Target folder and target name must be given.");
        }
        FileSystem dfs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = dfs.findResource(template);
        DataObject dob = DataObject.find((FileObject)fo);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        return dob.createFromTemplate(dataFolder, targetName);
    }

    public static Annotation createAnnotation(Element element, String annotationClassName, List attributeValues) {
        JavaClass annotationClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(annotationClassName);
        return JMIGenerationUtil.getJavaModelPackage(element).getAnnotation().createAnnotation(JavaModelUtil.resolveImportsForClass((Element)element, (JavaClass)annotationClass), attributeValues);
    }

    public static AttributeValue createAttributeValue(Element element, String name, String value) {
        return JMIGenerationUtil.getJavaModelPackage(element).getAttributeValue().createAttributeValue(name, (InitialValue)JMIGenerationUtil.getJavaModelPackage(element).getStringLiteral().createStringLiteral(value));
    }

    public static AttributeValue createAttributeValue(Element element, String name, boolean value) {
        return JMIGenerationUtil.getJavaModelPackage(element).getAttributeValue().createAttributeValue(name, (InitialValue)JMIGenerationUtil.getJavaModelPackage(element).getBooleanLiteral().createBooleanLiteral(value));
    }

    public static AttributeValue createAttributeValue(Element element, String name, List arrayItems) {
        return JMIGenerationUtil.getJavaModelPackage(element).getAttributeValue().createAttributeValue(name, (InitialValue)JMIGenerationUtil.getJavaModelPackage(element).getArrayInitialization().createArrayInitialization(arrayItems));
    }

    public static AttributeValue createAttributeValue(Element element, String name, String type, String variable) {
        JavaClass typeClass = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(type);
        String typeSimpleName = JavaModelUtil.resolveImportsForType((Element)element, (Type)typeClass).getName();
        return JMIGenerationUtil.getJavaModelPackage(element).getAttributeValue().createAttributeValue(name, (InitialValue)JMIGenerationUtil.getJavaModelPackage(element).getVariableAccess().createVariableAccess(typeSimpleName + (variable == null ? null : "." + variable), null, false));
    }

    public static Field createField(Element element, String name, int modifiers, String type) {
        return JMIGenerationUtil.getJavaModelPackage(element).getField().createField(name, null, modifiers, null, null, false, JMIGenerationUtil.getTypeReference(element, type), 0, null, null);
    }

    public static Field createFieldArray(Element element, String name, int modifiers, String type) {
        return JMIGenerationUtil.getJavaModelPackage(element).getField().createField(name, null, modifiers, null, null, false, JMIGenerationUtil.getArrayTypeReference(element, type), 0, null, null);
    }

    public static Method createMethod(Element element, String name, int modifiers, String type) {
        return JMIGenerationUtil.getJavaModelPackage(element).getMethod().createMethod(name, null, modifiers, null, null, null, null, null, null, null, JMIGenerationUtil.getTypeReference(element, type), 0);
    }

    public static Method createMethodArray(Element element, String name, int modifiers, String type) {
        return JMIGenerationUtil.getJavaModelPackage(element).getMethod().createMethod(name, null, modifiers, null, null, null, null, null, null, null, JMIGenerationUtil.getArrayTypeReference(element, type), 0);
    }

    public static Method createGetterMethod(String fieldName, String capitalizedFieldName, String fieldType, JavaClass javaClass) {
        Method getter = JMIGenerationUtil.createMethod((Element)javaClass, "get" + capitalizedFieldName, 1, fieldType);
        getter.setBodyText("return this." + fieldName + ";");
        getter.setJavadocText(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_Getter", (Object)fieldName, (Object)javaClass.getSimpleName()));
        return getter;
    }

    public static Method createSetterMethod(String fieldName, String capitalizedFieldName, String fieldType, JavaClass javaClass) {
        Method setter = JMIGenerationUtil.createMethod((Element)javaClass, "set" + capitalizedFieldName, 1, "void");
        Parameter idParameter = JMIGenerationUtil.createParameter((Element)javaClass, fieldName, fieldType);
        setter.getParameters().add(idParameter);
        setter.setBodyText(JMIGenerationUtil.getAssignmentLineForField(fieldName));
        setter.setJavadocText(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_Setter", (Object)fieldName, (Object)javaClass.getSimpleName()));
        return setter;
    }

    private static String getAssignmentLineForField(String fieldName) {
        return "this." + fieldName + " = " + fieldName + ";";
    }

    public static Method createEntityEqualsMethod(JavaClass javaClass, List idFields) {
        Method equals = JMIGenerationUtil.createMethod((Element)javaClass, "equals", 1, "boolean");
        Parameter objectParameter = JMIGenerationUtil.createParameter((Element)javaClass, "object", "java.lang.Object");
        equals.getParameters().add(objectParameter);
        String javaClassName = javaClass.getSimpleName();
        StringBuilder equalsMethodBody = new StringBuilder("// TODO: Warning - this method won't work in the case the id fields are not set\n");
        equalsMethodBody.append("if (!(object instanceof ");
        equalsMethodBody.append(javaClassName + ")) {\nreturn false;\n}\n");
        equalsMethodBody.append(javaClassName + " other = (" + javaClassName + ")object;\n");
        for (Field nextField : idFields) {
            equalsMethodBody.append(JMIGenerationUtil.getEqualsLineForField(nextField.getName(), nextField.getType()));
        }
        equalsMethodBody.append("return true;\n");
        equals.setBodyText(equalsMethodBody.toString());
        equals.setJavadocText(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_Equals", (Object)javaClassName));
        Annotation overrideAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, "java.lang.Override", Collections.EMPTY_LIST);
        equals.getAnnotations().add(overrideAnnotation);
        return equals;
    }

    private static String getEqualsLineForField(String fieldName, Type resolvedType) {
        if (resolvedType instanceof PrimitiveType) {
            return "if (this." + fieldName + " != other." + fieldName + ") return false;\n";
        }
        return "if (this." + fieldName + " != other." + fieldName + " && (this." + fieldName + " == null || !this." + fieldName + ".equals(other." + fieldName + "))) return false;\n";
    }

    public static Method createHashCodeMethod(JavaClass javaClass, List fields) {
        Method hashCode = JMIGenerationUtil.createMethod((Element)javaClass, "hashCode", 1, "int");
        StringBuilder hashCodeMethodBody = new StringBuilder("int hash = 0;\n");
        for (Field nextField : fields) {
            hashCodeMethodBody.append(JMIGenerationUtil.getHashCodeLineForField(nextField.getName(), nextField.getType()));
        }
        hashCodeMethodBody.append("return hash;");
        hashCode.setBodyText(hashCodeMethodBody.toString());
        hashCode.setJavadocText(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_HashCode"));
        Annotation overrideAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, "java.lang.Override", Collections.EMPTY_LIST);
        hashCode.getAnnotations().add(overrideAnnotation);
        return hashCode;
    }

    private static String getHashCodeLineForField(String fieldName, Type resolvedType) {
        if (resolvedType instanceof PrimitiveType) {
            if (resolvedType.getName().equals("boolean")) {
                return "hash += (" + fieldName + " ? 1 : 0);\n";
            }
            return "hash += (int)" + fieldName + ";\n";
        }
        return "hash += (this." + fieldName + " != null ? this." + fieldName + ".hashCode() : 0);\n";
    }

    public static Method createToStringMethod(JavaClass javaClass, List fields) {
        Method toString = JMIGenerationUtil.createMethod((Element)javaClass, "toString", 1, "java.lang.String");
        StringBuilder toStringMethodBody = new StringBuilder("return \"" + javaClass.getName() + "[");
        int fieldsCount = fields.size();
        for (int i = 0; i < fieldsCount; ++i) {
            String nextFieldName = ((Field)fields.get(i)).getName();
            toStringMethodBody.append(nextFieldName + "=\" + " + nextFieldName + " + \"");
            toStringMethodBody.append(i < fieldsCount - 1 ? ", " : "]\";");
        }
        toString.setBodyText(toStringMethodBody.toString());
        toString.setJavadocText(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_ToString"));
        Annotation overrideAnnotation = JMIGenerationUtil.createAnnotation((Element)javaClass, "java.lang.Override", Collections.EMPTY_LIST);
        toString.getAnnotations().add(overrideAnnotation);
        return toString;
    }

    public static Constructor createConstructor(JavaClass javaClass, int modifiers) {
        return JMIGenerationUtil.getJavaModelPackage((Element)javaClass).getConstructor().createConstructor(javaClass.getSimpleName(), null, modifiers, null, null, null, null, null, null, null);
    }

    public static Constructor createConstructor(JavaClass javaClass, List fields) {
        Constructor constructor = JMIGenerationUtil.createConstructor(javaClass, 1);
        StringBuilder constructorBody = new StringBuilder();
        String javaClassName = javaClass.getSimpleName();
        StringBuilder constructorJavaDoc = new StringBuilder(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_Constructor", (Object)javaClassName));
        List params = constructor.getParameters();
        for (Field nextField : fields) {
            String fieldName = nextField.getName();
            Parameter fieldParameter = JMIGenerationUtil.createParameter((Element)javaClass, fieldName, nextField.getType().getName());
            params.add(fieldParameter);
            constructorBody.append(JMIGenerationUtil.getAssignmentLineForField(fieldName) + "\n");
            constructorJavaDoc.append(NbBundle.getMessage(JMIGenerationUtil.class, (String)"MSG_Javadoc_ConstructorParam", (Object)fieldName, (Object)javaClassName));
        }
        constructor.setBodyText(constructorBody.toString());
        constructor.setJavadocText(constructorJavaDoc.toString());
        return constructor;
    }

    public static void ensurePublicConstructor(JavaClass javaClass) {
        Constructor existing = javaClass.getConstructor(Collections.EMPTY_LIST, false);
        if (null == existing) {
            Constructor constructor = JMIGenerationUtil.createConstructor(javaClass, 1);
            javaClass.getFeatures().add(constructor);
        } else if (existing.getModifiers() != 1) {
            existing.setModifiers(1);
        }
    }

    public static Parameter createParameter(Element element, String name, String type) {
        return JMIGenerationUtil.getJavaModelPackage(element).getParameter().createParameter(name, null, false, JMIGenerationUtil.getTypeReference(element, type), 0, false);
    }

    public static Parameter createParameterArray(Element element, String name, String type) {
        return JMIGenerationUtil.getJavaModelPackage(element).getParameter().createParameter(name, null, false, JMIGenerationUtil.getArrayTypeReference(element, type), 0, false);
    }

    public static StringLiteral createStringLiteral(Element element, String value) {
        return JMIGenerationUtil.getJavaModelPackage(element).getStringLiteral().createStringLiteral(value);
    }

    public static void setAttribute(Annotation annotation, String name, String value) {
        for (AttributeValue attributeValue : annotation.getAttributeValues()) {
            if (!attributeValue.getDefinition().getName().equals(name)) continue;
            StringLiteral stringLiteral = JMIGenerationUtil.createStringLiteral((Element)annotation, value);
            attributeValue.setValue((InitialValue)stringLiteral);
            return;
        }
    }

    public static TypeReference createImport(Element element, String name) {
        return JMIGenerationUtil.getTypeReference(element, name);
    }

    public static void addInterface(JavaClass clazz, String interfaceName) {
        int lastDot = interfaceName.lastIndexOf(46);
        String simpleInterfaceName = lastDot > 0 ? interfaceName.substring(lastDot + 1) : interfaceName;
        List names = clazz.getInterfaceNames();
        for (MultipartId name : names) {
            if (!interfaceName.equals(name.getName()) && !simpleInterfaceName.equals(name.getName())) continue;
            return;
        }
        JMIGenerationUtil.createImport((Element)clazz, interfaceName);
        names.add(JMIGenerationUtil.getJavaModelPackage((Element)clazz).getMultipartId().createMultipartId(simpleInterfaceName, null, null));
    }

    private static TypeReference getTypeReference(Element element, String name) {
        Type resolvedType = JavaModel.getDefaultExtent().getType().resolve(name);
        if (resolvedType instanceof PrimitiveType) {
            return JMIGenerationUtil.getJavaModelPackage(element).getMultipartId().createMultipartId(name, null, null);
        }
        return JavaModelUtil.resolveImportsForType((Element)element, (Type)resolvedType);
    }

    private static TypeReference getArrayTypeReference(Element element, String name) {
        Type resolvedType = JavaModel.getDefaultExtent().getType().resolve(name);
        MultipartId itemType = JMIGenerationUtil.getJavaModelPackage(element).getMultipartId().createMultipartId(name, null, null);
        return JMIGenerationUtil.getJavaModelPackage(element).getArrayReference().createArrayReference(null, itemType, 1);
    }

    private static JavaModelPackage getJavaModelPackage(Element element) {
        return element != null ? (JavaModelPackage)element.refImmediatePackage() : JavaModel.getDefaultExtent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaClass getJavaClassFromDataObject(DataObject dobj) {
        if (null == dobj) {
            throw new NullPointerException("DataObject must be given.");
        }
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            Resource res = JavaModel.getResource((FileObject)dobj.getPrimaryFile());
            if (res != null) {
                JavaModel.setClassPath((Resource)res);
                List classes = res.getClassifiers();
                if (classes.size() == 1) {
                    JavaClass javaClass = (JavaClass)classes.get(0);
                    return javaClass;
                }
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans(false);
        }
        return null;
    }
}

