/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.scanning;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.JavaEnum;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.InvalidClassFormatException;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AnnotationTypeClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaEnumImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.scanning.FObjectInfo;
import org.netbeans.modules.javacore.scanning.FileInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class ClassUpdater {
    private Map fileObjectToClassFile;
    private Map nameToResource;
    private Map resourceToSuperCodes;
    private Map unmodifiedResources;
    private Map resourceToClasses;
    private ResourceClassImpl resProxy;
    private JavaClassClassImpl clsProxy;
    private JavaEnumClassImpl enumProxy;
    private AnnotationTypeClassImpl annoProxy;
    private ClassIndex classIndex;
    private ResourceImpl updatedResource;
    private long indexTimestamp;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassUpdater(JavaModelPackage mofModel) {
        this.clsProxy = (JavaClassClassImpl)mofModel.getJavaClass();
        this.enumProxy = (JavaEnumClassImpl)mofModel.getJavaEnum();
        this.resProxy = (ResourceClassImpl)mofModel.getResource();
        this.annoProxy = (AnnotationTypeClassImpl)mofModel.getAnnotationType();
        this.classIndex = ClassIndex.getIndex(mofModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateIndex(ResourceImpl resource, FileObject fobj) {
        JavaMetamodel.getDefaultRepository().beginTrans(false);
        try {
            JavaModelPackage pck = (JavaModelPackage)resource.refOutermostPackage();
            HashMap<String, FObjectInfo> cls = new HashMap<String, FObjectInfo>();
            String fname = fobj.getNameExt();
            String prefix = fobj.getName().concat("$");
            String ext = fobj.getExt();
            FileObject[] children = fobj.getParent().getChildren();
            cls.put(fname, new FObjectInfo(fobj));
            for (int i = 0; i < children.length; ++i) {
                FileObject ch = children[i];
                if (!ext.equals(ch.getExt()) || !ch.getName().startsWith(prefix)) continue;
                cls.put(ch.getNameExt(), new FObjectInfo(ch));
            }
            ClassUpdater instance = new ClassUpdater(pck);
            instance.updatedResource = resource;
            instance.updateResources(Collections.EMPTY_MAP, cls, true);
        }
        finally {
            JavaMetamodel.getDefaultRepository().endTrans();
        }
    }

    public Collection updateResources(Map sources, Map classes) {
        return this.updateResources(sources, classes, false);
    }

    public Collection updateResources(Map sources, Map classes, boolean directUpdate) {
        this.indexTimestamp = this.classIndex.getTimestamp();
        this.unmodifiedResources = new HashMap();
        this.fileObjectToClassFile = new HashMap();
        this.nameToResource = new HashMap();
        this.resourceToClasses = new HashMap();
        this.resourceToSuperCodes = new HashMap();
        Iterator iter = classes.entrySet().iterator();
        while (iter.hasNext()) {
            Set superCodes;
            FileInfo file;
            ClassFile clsFile;
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            int index = name.indexOf(36);
            String resName = index > -1 ? name.substring(0, index) + ".class" : name;
            String srcName = resName.substring(0, resName.length() - ".class".length()) + ".java";
            if (sources.containsKey(srcName) || (clsFile = this.getClassFile(file = (FileInfo)entry.getValue())) == null || this.isAnonymous(clsFile) || (superCodes = this.getSuperCodes(resName, classes)) == null) continue;
            this.addFileToMap(resName, clsFile);
            this.addSuperCodes(superCodes, clsFile);
        }
        iter = this.resourceToSuperCodes.entrySet().iterator();
        int x = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Set codes = (Set)entry.getValue();
            int size = codes.size();
            int[] hc = new int[size];
            Iterator iter2 = codes.iterator();
            for (int y = 0; y < size; ++y) {
                hc[y] = (Integer)iter2.next();
            }
            ResourceImpl resource = (ResourceImpl)((Object)entry.getKey());
            this.classIndex.setIdentifiers(resource, hc);
            ++x;
        }
        iter = this.nameToResource.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String resName = (String)entry.getKey();
            ResourceImpl res = (ResourceImpl)((Object)entry.getValue());
            this.updateClasses(resName, res, !directUpdate && !res.isInitialized());
        }
        ArrayList resources = new ArrayList(this.resourceToSuperCodes.keySet());
        resources.addAll(this.unmodifiedResources.values());
        return resources;
    }

    public void addSuperCodes(Set codes, ClassFile classFile) {
        ClassName superName = classFile.getSuperClass();
        if (superName != null) {
            codes.add(this.nameToHashCode(superName));
        }
        Iterator iter = classFile.getInterfaces().iterator();
        while (iter.hasNext()) {
            codes.add(this.nameToHashCode((ClassName)iter.next()));
        }
    }

    private Set getSuperCodes(String name, Map classes) {
        if (this.unmodifiedResources.containsKey(name)) {
            return null;
        }
        Resource res = (Resource)this.nameToResource.get(name);
        if (res == null) {
            FileInfo file = (FileInfo)classes.get(name);
            if (file == null) {
                this.unmodifiedResources.put(name, null);
                JMManager.getLog().log("ClassUpdater, cannot find file object: " + name);
                return null;
            }
            if (this.updatedResource != null) {
                if (!$assertionsDisabled && !this.updatedResource.getName().endsWith(name)) {
                    throw new AssertionError((Object)(this.updatedResource.getName() + " " + name));
                }
                res = this.updatedResource;
            } else {
                res = this.resProxy.resolveResource(file.getPath(), true, false);
            }
            long timestamp = file.lastModified();
            if (res.getTimestamp() != timestamp || this.indexTimestamp < timestamp) {
                res.setTimestamp(timestamp);
                this.nameToResource.put(name, res);
                HashSet set = new HashSet();
                this.resourceToSuperCodes.put(res, set);
                return set;
            }
            this.unmodifiedResources.put(name, res);
            return null;
        }
        return (Set)this.resourceToSuperCodes.get(res);
    }

    public String getSimpleName(ClassName clsName) {
        String name = clsName.getSimpleName();
        int index = name.lastIndexOf(46);
        if (index > -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public Integer nameToHashCode(ClassName clsName) {
        return new Integer(this.getSimpleName(clsName).hashCode());
    }

    public boolean isAnonymous(ClassFile clsFile) {
        String name = clsFile.getName().getSimpleName();
        int index = name.lastIndexOf(46) + 1;
        if (name.length() == index) {
            JMManager.getLog().log("ClassUpdater, class name ends with a dot: " + name);
        }
        return index > 0 && name.length() > index && Character.isDigit(name.charAt(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassFile getClassFile(FileInfo file) {
        ClassFile clsFile = (ClassFile)this.fileObjectToClassFile.get(file);
        if (clsFile == null) {
            try {
                BufferedInputStream stream = new BufferedInputStream(file.getInputStream());
                try {
                    clsFile = new ClassFile((InputStream)stream, false);
                    this.fileObjectToClassFile.put(file, clsFile);
                }
                finally {
                    ((InputStream)stream).close();
                }
            }
            catch (InvalidClassFormatException ex) {
                ErrorManager errmgr = ErrorManager.getDefault();
                errmgr.log(1, "invalid class file format: " + file.getPath());
            }
            catch (IOException ex) {
                ErrorManager errmgr = ErrorManager.getDefault();
                errmgr.annotate((Throwable)ex, 4096, file.getName(), null, null, null);
                errmgr.notify(1, (Throwable)ex);
            }
        }
        return clsFile;
    }

    public void addFileToMap(String resName, ClassFile clsFile) {
        HashMap<String, ClassFile> map = (HashMap<String, ClassFile>)this.resourceToClasses.get(resName);
        if (map == null) {
            map = new HashMap<String, ClassFile>();
            this.resourceToClasses.put(resName, map);
        }
        map.put(clsFile.getName().getSimpleName(), clsFile);
    }

    public void updateClasses(String resName, ResourceImpl resource, boolean removeFeatures) {
        Map map = (Map)this.resourceToClasses.get(resName);
        List javaClasses = resource.getNakedClassifiers();
        if (javaClasses.size() > 0 && !this.newClassesNeeded(resource, map, removeFeatures)) {
            map.clear();
            return;
        }
        HashMap result = new HashMap();
        Iterator classIt = javaClasses.iterator();
        while (classIt.hasNext()) {
            RefObject oldJcls = (RefObject)classIt.next();
            classIt.remove();
            oldJcls.refDelete();
        }
        while (map.size() > 0) {
            Map.Entry entry = map.entrySet().iterator().next();
            ClassFile clsFile = (ClassFile)entry.getValue();
            this.createJavaClass(resource, javaClasses, clsFile, map, result);
        }
    }

    private boolean newClassesNeeded(ResourceImpl resource, Map classesMap, boolean removeFeatures) {
        List javaClasses = resource.getNakedClassifiers();
        HashMap<String, JavaClassImpl> nameToClass = new HashMap<String, JavaClassImpl>();
        Iterator<Object> iter = javaClasses.iterator();
        while (iter.hasNext()) {
            JavaClassImpl jc = (JavaClassImpl)((Object)iter.next());
            if (!this.isInIndex(jc, resource)) {
                return true;
            }
            nameToClass.put(jc.getName(), jc);
            this.collectInnerClasses(nameToClass, resource, jc);
        }
        if (classesMap.size() != nameToClass.size()) {
            return true;
        }
        iter = classesMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            ClassFile clsFile = (ClassFile)entry.getValue();
            ClassName clsName = clsFile.getName();
            String fullName = clsName.getExternalName();
            JavaClassImpl jc = (JavaClassImpl)((Object)nameToClass.get(fullName));
            if (jc == null) {
                return true;
            }
            int access = clsFile.getAccess() & 0xFFFFFFDF;
            if (access != jc.getSourceModifiers()) {
                return true;
            }
            int declType = jc instanceof JavaEnum ? 1 : (jc instanceof AnnotationType ? 2 : 0);
            boolean isEnum = clsFile.isEnum();
            boolean isAnnotation = clsFile.isAnnotation();
            if (!(declType == 1 && !isEnum || declType != 1 && isEnum || declType == 2 && !isAnnotation) && (declType == 2 || !isAnnotation)) continue;
            return true;
        }
        if (removeFeatures) {
            iter = nameToClass.values().iterator();
            while (iter.hasNext()) {
                ClassUpdater.removePersisted((JavaClassImpl)((Object)iter.next()));
            }
        }
        return false;
    }

    private boolean isInIndex(JavaClassImpl jc, Resource res) {
        Iterator innerListIt = this.classIndex.getClassesByFqn(jc.getName()).iterator();
        while (innerListIt.hasNext()) {
            JavaClassImpl innerJcls = (JavaClassImpl)((Object)innerListIt.next());
            if (!res.equals(innerJcls.getResource())) continue;
            return true;
        }
        return false;
    }

    private void collectInnerClasses(Map nameToClass, Resource res, JavaClassImpl jc) {
        Iterator innerListIt = this.classIndex.getClassesByFQNPrefix(jc.getName().concat(".")).iterator();
        while (innerListIt.hasNext()) {
            JavaClassImpl innerJcls = (JavaClassImpl)((Object)innerListIt.next());
            if (!res.equals(innerJcls.getResource())) continue;
            nameToClass.put(innerJcls.getName(), innerJcls);
            this.collectInnerClasses(nameToClass, res, innerJcls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removePersisted(JavaClassImpl jcls) {
        boolean changes = jcls.disableChanges;
        jcls.disableChanges = true;
        try {
            List ec;
            int i;
            int size;
            List fs = jcls.getPersistentContents();
            if (!fs.isEmpty()) {
                size = fs.size();
                ClassMember[] features = fs.toArray(new ClassMember[size]);
                for (i = 0; i < size; ++i) {
                    ClassMember f = features[i];
                    fs.remove(f);
                    if (f instanceof JavaClassImpl) continue;
                    f.refDelete();
                }
            }
            if (!(fs = jcls.getPersistentTypeParameters()).isEmpty()) {
                size = fs.size();
                RefObject[] paramTypes = fs.toArray(new RefObject[size]);
                for (i = 0; i < size; ++i) {
                    RefObject tp = paramTypes[i];
                    fs.remove(tp);
                    tp.refDelete();
                }
            }
            if (!(fs = jcls.getPersistentAnnotations()).isEmpty()) {
                size = fs.size();
                RefObject[] annos = fs.toArray(new RefObject[size]);
                for (i = 0; i < size; ++i) {
                    RefObject anno = annos[i];
                    fs.remove(anno);
                    anno.refDelete();
                }
            }
            if (jcls instanceof JavaEnumImpl && !(ec = ((JavaEnumImpl)jcls).getPersistentConstants()).isEmpty()) {
                int cSize = ec.size();
                EnumConstant[] constants = ec.toArray(new EnumConstant[cSize]);
                for (int i2 = 0; i2 < cSize; ++i2) {
                    EnumConstant c = constants[i2];
                    ec.remove(c);
                    c.refDelete();
                }
            }
            jcls.setPersisted(false);
        }
        finally {
            jcls.disableChanges = changes;
        }
    }

    private JavaClassImpl createJavaClass(ResourceImpl resource, Collection resClassifiers, ClassFile clsFile, Map map, Map createdClasses) {
        String outerName;
        ClassName clsName = clsFile.getName();
        String fullName = clsName.getExternalName();
        String simpleName = clsName.getSimpleName();
        int index = simpleName.lastIndexOf(46);
        JavaClassImpl outer = null;
        if (index > -1 && (outer = (JavaClassImpl)((Object)createdClasses.get(outerName = simpleName.substring(0, index)))) == null) {
            ClassFile outerClassFile = (ClassFile)map.get(outerName);
            if (outerClassFile == null) {
                map.remove(simpleName);
                return null;
            }
            outer = this.createJavaClass(resource, resClassifiers, outerClassFile, map, createdClasses);
        }
        String pkgName = clsName.getPackage();
        resource._setPackageName(pkgName);
        int access = clsFile.getAccess() & 0xFFFFFFDF | (clsFile.isDeprecated() ? Integer.MIN_VALUE : 0);
        JavaClassImpl jc = clsFile.isAnnotation() ? this.annoProxy.create(fullName, access, false) : (clsFile.isEnum() ? this.enumProxy.create(fullName, access, false) : this.clsProxy.create(fullName, access, null, null, false));
        if (outer != null) {
            if (outer.isPersisted()) {
                outer.getPersistentContents().add(jc);
            } else {
                jc.setParentClass(outer);
            }
        } else {
            resClassifiers.add(jc);
        }
        createdClasses.put(simpleName, jc);
        map.remove(simpleName);
        return jc;
    }

    static {
        $assertionsDisabled = !ClassUpdater.class.desiredAssertionStatus();
    }
}

