/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.internalapi;

import java.io.IOException;
import javax.swing.text.StyledDocument;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.FileGuardedResolver;
import org.netbeans.modules.javacore.internalapi.GuardedResolver;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;

public final class GuardedQuery {
    private static GuardedResolver fileResolver = null;
    private static GuardedResolver documentResolver = null;

    private GuardedQuery() {
    }

    public static boolean isSectionGuarded(Resource res, PositionBounds pos) {
        ResourceImpl resource = (ResourceImpl)res;
        DataObject dobj = JavaMetamodel.getManager().getDataObject(resource);
        EditorCookie editor = (EditorCookie)dobj.getCookie(EditorCookie.class);
        StyledDocument doc = null;
        if (editor != null && (doc = editor.getDocument()) == null && resource.getParser().isFromDocument()) {
            try {
                doc = editor.openDocument();
            }
            catch (IOException ex) {
                throw (RuntimeException)ErrorManager.getDefault().annotate((Throwable)new RuntimeException(), (Throwable)ex);
            }
        }
        if (doc != null) {
            return GuardedQuery.getDocumentGuardedResolver().isSectionGuarded(resource, pos);
        }
        return GuardedQuery.getFileGuardedResolver().isSectionGuarded(resource, pos);
    }

    private static GuardedResolver getDocumentGuardedResolver() {
        if (documentResolver == null) {
            return GuardedQuery.getFileGuardedResolver();
        }
        return documentResolver;
    }

    private static GuardedResolver getFileGuardedResolver() {
        return FileGuardedResolver.getDefault();
    }

    public static void setDocumentGuardedResolver(GuardedResolver resolver) {
        documentResolver = resolver;
    }
}

