/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.util.AbstractSequentialList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LazyImmutableList
extends AbstractSequentialList {
    private LazyIterator internal;
    private boolean complete = false;
    private final Object[] array;
    private int nextIndex = 0;

    public LazyImmutableList(LazyIterator internalIterator) {
        this.internal = internalIterator;
        this.array = new Object[internalIterator.maxEstimatedSize()];
    }

    public int size() {
        while (this.internal != null) {
            this.nextItem();
        }
        return this.nextIndex;
    }

    public ListIterator listIterator(int index) {
        return new LazyImmutableIterator(index);
    }

    public int maxEstimatedSize() {
        return this.internal == null ? this.nextIndex : this.internal.maxEstimatedSize();
    }

    private void nextItem() {
        if (this.internal != null && this.internal.hasNext()) {
            this.array[this.nextIndex] = this.internal.next();
            ++this.nextIndex;
        } else {
            this.internal = null;
        }
    }

    public static abstract class LazyIterator
    implements Iterator {
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract int maxEstimatedSize();
    }

    private class LazyImmutableIterator
    implements ListIterator {
        private int currentIndex;

        public LazyImmutableIterator(int index) {
            this.currentIndex = index;
        }

        public boolean hasNext() {
            while (LazyImmutableList.this.nextIndex <= this.currentIndex && LazyImmutableList.this.internal != null) {
                LazyImmutableList.this.nextItem();
            }
            return LazyImmutableList.this.nextIndex > this.currentIndex;
        }

        public int previousIndex() {
            return this.currentIndex - 1;
        }

        public Object previous() {
            if (this.hasPrevious()) {
                --this.currentIndex;
                return LazyImmutableList.this.array[this.currentIndex];
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this.currentIndex > 0;
        }

        public Object next() {
            if (this.hasNext()) {
                ++this.currentIndex;
                return LazyImmutableList.this.array[this.currentIndex - 1];
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.currentIndex;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

