/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefBaseObject;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.util.TransactionMutex;
import org.netbeans.modules.javacore.ClassIndex;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.RepositoryUpdater;
import org.netbeans.modules.javacore.Util;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.classpath.FilterClassPathImplementation;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AttributeImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.AttributeValueImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.BehavioralFeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.EnumConstantImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FieldImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceClassImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class ExclusiveMutex
extends TransactionMutex {
    private static final boolean DEBUG = false;
    private boolean changes = false;
    private boolean fail = false;
    private Thread thread = null;
    private int counter = 0;
    private int modCount = 1;
    private boolean isSafeTrans = false;
    private Set newObjects = new HashSet();
    private Set changedRscSet = new HashSet();
    private Set changedExternalSet = new HashSet();
    private Set undoElementsSet = new HashSet();
    private Set upToDateElements = new HashSet();
    private Set invalidClasses = new HashSet();
    private List initBodyQueue;
    private Map parserCache;
    private Set needParsing = new HashSet();
    private Set needDelete = new HashSet();
    private Set needParsingRW = new HashSet();
    private Set needTSUpdate = new HashSet();
    private Set priorityThreads = null;
    private ClassPath classPath = null;
    private List searchScope = null;
    private volatile boolean isSwingWaiting = false;
    private JMManager manager = (JMManager)JMManager.getManager();
    private boolean modificationsDisabled = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExclusiveMutex(Object p1, Object p2, Object p3) {
        super(p1, p2, p3);
    }

    public boolean isSwingWaiting() {
        return this.isSwingWaiting;
    }

    public int getModCount() {
        return this.modCount;
    }

    public boolean isSafeTrans() {
        return this.isSafeTrans;
    }

    void setSafeTrans(boolean safeTrans) {
        this.isSafeTrans = safeTrans;
    }

    public synchronized void addPriorityThread() {
        if (this.priorityThreads == null) {
            this.priorityThreads = new HashSet();
        }
        this.priorityThreads.add(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enter(boolean writeAccess) {
        Thread thread = Thread.currentThread();
        if (!($assertionsDisabled || this.counter > 0 && this.thread == thread || JMManager.getDocumentLocksCounter() == null || JMManager.getDocumentLocksCounter().get() == null)) {
            throw new AssertionError((Object)"Document was locked before starting the MDR transaction.");
        }
        if (this.thread != thread) {
            boolean isPriorityThread;
            if (SwingUtilities.isEventDispatchThread()) {
                this.addPriorityThread();
            }
            boolean bl = isPriorityThread = this.priorityThreads != null && this.priorityThreads.remove(thread);
            while (this.counter != 0 || this.isSwingWaiting && !isPriorityThread) {
                try {
                    this.isSwingWaiting |= isPriorityThread;
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
            this.thread = thread;
            if (isPriorityThread) {
                if (this.priorityThreads != null && this.priorityThreads.isEmpty()) {
                    this.priorityThreads = null;
                }
                this.isSwingWaiting = this.priorityThreads != null;
            }
            ++this.modCount;
            if (this.modCount == 0) {
                this.modCount = 1;
            }
            if (JMManager.TRANS_DEBUG) {
                Thread.dumpStack();
            }
        }
        ++this.counter;
        if (writeAccess && !this.changes) {
            this.changes = true;
            this.start();
        }
        if (this.counter == 1) {
            boolean success = false;
            try {
                this.parseIfNeeded(writeAccess);
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        if (this.changes && this.counter == 1) {
                            this.end(true);
                            this.notifyElements();
                            ClassIndex.rollback();
                        }
                    }
                    catch (RuntimeException x) {
                        ErrorManager.getDefault().notify(1, (Throwable)x);
                    }
                    finally {
                        this.finalizeTrans();
                    }
                }
            }
            this.clearClassPath();
            this.clearParserCache();
        }
    }

    private void clearClassPath() {
        this.classPath = null;
        this.searchScope = null;
    }

    private void clearParserCache() {
        this.parserCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseIfNeeded(boolean writeAccess) {
        FileObject fobj;
        FileObject fo;
        FileObject[] fos;
        boolean isEmpty;
        Set set = this.needDelete;
        synchronized (set) {
            isEmpty = this.needDelete.isEmpty();
        }
        if (!isEmpty) {
            set = this.needDelete;
            synchronized (set) {
                fos = this.needDelete.toArray(new FileObject[this.needDelete.size()]);
                this.needDelete.clear();
            }
            for (int i = 0; i < fos.length; ++i) {
                fo = fos[i];
                FileObject cpRoot = Util.getCPRoot(fo);
                if (cpRoot == null) {
                    return;
                }
                JavaModelPackage modelPckg = this.manager.resolveJavaExtent(cpRoot);
                if (modelPckg == null) {
                    return;
                }
                ResourceImpl resource = (ResourceImpl)((ResourceClassImpl)modelPckg.getResource()).resolveResource(this.manager.getResourceName(fo), false, false);
                if (resource == null) continue;
                resource.refDelete();
            }
        }
        Set i = this.needParsingRW;
        synchronized (i) {
            isEmpty = this.needParsingRW.isEmpty();
        }
        if (!isEmpty) {
            i = this.needParsingRW;
            synchronized (i) {
                fos = this.needParsingRW.toArray(new FileObject[this.needParsingRW.size()]);
                this.needParsingRW.clear();
            }
            for (int i2 = 0; i2 < fos.length; ++i2) {
                fobj = fos[i2];
                if (!fobj.isValid()) continue;
                JavaModel.setClassPath(fobj);
                RepositoryUpdater.getDefault().createOrUpdateResource(fobj);
                this.needParsing.remove(fobj);
            }
        }
        if (writeAccess) {
            Set i2 = this.needParsing;
            synchronized (i2) {
                isEmpty = this.needParsing.isEmpty();
            }
            if (!isEmpty) {
                i2 = this.needParsing;
                synchronized (i2) {
                    fos = this.needParsing.toArray(new FileObject[this.needParsing.size()]);
                    this.needParsing.clear();
                }
                for (int i3 = 0; i3 < fos.length; ++i3) {
                    fobj = fos[i3];
                    if (!fobj.isValid()) continue;
                    JavaModel.setClassPath(fobj);
                    ResourceImpl res = (ResourceImpl)((JMManager)JavaMetamodel.getManager()).getResource(fobj, false);
                    if (res == null) continue;
                    res.updateFromFileObject(fobj, true);
                }
            }
        }
        Set i3 = this.needTSUpdate;
        synchronized (i3) {
            isEmpty = this.needTSUpdate.isEmpty();
        }
        if (!isEmpty) {
            i3 = this.needTSUpdate;
            synchronized (i3) {
                fos = this.needTSUpdate.toArray(new FileObject[this.needTSUpdate.size()]);
                this.needTSUpdate.clear();
            }
            for (int i4 = 0; i4 < fos.length; ++i4) {
                fo = fos[i4];
                if (!fo.isValid()) continue;
                RepositoryUpdater.updateTimeStamp(fo);
            }
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModified(FileObject fo) {
        Set set = this.needParsing;
        synchronized (set) {
            this.needParsing.add(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeleted(FileObject fo) {
        Set set = this.needDelete;
        synchronized (set) {
            this.needDelete.add(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addModifiedRW(FileObject fo) {
        Set set = this.needParsingRW;
        synchronized (set) {
            Set set2 = this.needParsing;
            synchronized (set2) {
                this.needParsingRW.add(fo);
                this.needParsing.remove(fo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUpdateTS(FileObject fo) {
        Set set = this.needTSUpdate;
        synchronized (set) {
            this.needTSUpdate.add(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean leave(boolean fail) {
        if (!$assertionsDisabled && this.thread != Thread.currentThread()) {
            throw new AssertionError((Object)"Cannot end transaction from a different thread!");
        }
        if (fail) {
            JMManager.getLog().notify(1, (Throwable)new Exception("rollback!!!"));
        }
        boolean result = false;
        try {
            if (this.changes) {
                this.fail |= fail;
            } else if (fail) {
                throw new RuntimeException("Cannot fail in read mode.");
            }
            if (this.counter == 1) {
                result = true;
                if (this.changes) {
                    if (this.fail) {
                        this.end(true);
                        this.notifyElements();
                        ClassIndex.rollback();
                    } else {
                        this.notifyElements();
                        this.end(false);
                        ClassIndex.commit();
                    }
                }
            }
        }
        catch (RuntimeException x) {
            ErrorManager.getDefault().notify(1, (Throwable)x);
            this.fail = true;
            try {
                this.end(true);
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            try {
                this.notifyElements();
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            try {
                ClassIndex.rollback();
            }
            catch (RuntimeException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        finally {
            this.finalizeTrans();
        }
        return result;
    }

    private void finalizeTrans() {
        if (this.counter > 0) {
            --this.counter;
            if (this.counter == 0) {
                this.modificationsDisabled = false;
                this.isSafeTrans = false;
                this.thread = null;
                this.fail = false;
                this.changes = false;
                this.clearClassPath();
                this.clearParserCache();
                ((Object)((Object)this)).notifyAll();
            }
        } else {
            throw new RuntimeException("Error: leave() without enter().");
        }
    }

    void setClassPath(List cp, boolean preferSources) {
        this.classPath = FilterClassPathImplementation.createClassPath(cp, preferSources);
    }

    public void setSearchScope(List cp) {
        this.searchScope = cp;
    }

    List getSearchScope() {
        return this.searchScope;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public synchronized Map getParserCache() {
        if (this.parserCache == null) {
            this.parserCache = new HashMap();
        }
        return this.parserCache;
    }

    public void invalidateAtCommit(Element element) {
        this.invalidClasses.add(element);
    }

    public boolean pendingChanges() {
        return this.changes;
    }

    public boolean willFail() {
        return this.fail;
    }

    public void registerChange(ResourceImpl resource) {
        this.changedRscSet.add(resource);
    }

    public void registerPersisted(SemiPersistentElement element) {
        this.upToDateElements.add(element._getMofId());
    }

    public void unregisterChange(ResourceImpl resource) {
        this.changedRscSet.remove((Object)resource);
    }

    public void registerExtChange(ExternalChange change) {
        this.changedExternalSet.add(change);
    }

    public void registerUndoElement(ExternalChange change) {
        this.undoElementsSet.add(change);
    }

    public void addNew(Element h) {
        this.newObjects.add(h);
    }

    public void removeNew(Element h) {
        this.newObjects.remove(h);
    }

    public void addBFeatureToInitQueue(Object bf) {
        this.initBodyQueue.add(bf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyElements() {
        Iterator it;
        if (!this.upToDateElements.isEmpty()) {
            it = this.upToDateElements.iterator();
            while (it.hasNext()) {
                RefBaseObject element = ((NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository()).getByMofId((MOFID)it.next());
                if (element == null) continue;
                ((SemiPersistentElement)element).clearPersist(this.fail);
            }
            if (!this.fail) {
                this.upToDateElements.clear();
            }
        }
        if (!(this.modificationsDisabled || this.changedRscSet.isEmpty() && this.changedExternalSet.isEmpty() && this.undoElementsSet.isEmpty())) {
            JavaMetamodel.getUndoManager().transactionStarted();
        }
        try {
            if (!this.modificationsDisabled && !this.fail) {
                it = this.undoElementsSet.iterator();
                while (it.hasNext()) {
                    JavaMetamodel.getUndoManager().addItem((ExternalChange)it.next());
                }
            }
            this.initBodyQueue = new ArrayList();
            if (!(!this.fail && this.modificationsDisabled || this.changedRscSet.isEmpty())) {
                JMManager.initIndentation();
                Iterator resIt = this.changedRscSet.iterator();
                while (resIt.hasNext()) {
                    ResourceImpl resource = (ResourceImpl)((Object)resIt.next());
                    if (this.fail) {
                        resource.rollbackChanges();
                        continue;
                    }
                    resource.commitChanges();
                    if (this.newObjects.isEmpty()) continue;
                    throw new RuntimeException("Some objects were not added to a resource or deleted before commit.");
                }
            }
            if (!this.fail) {
                ResourceImpl resource;
                it = this.invalidClasses.iterator();
                while (it.hasNext()) {
                    Element el = (Element)it.next();
                    if (el.isValid()) {
                        el.refDelete();
                    }
                    it.remove();
                }
                Iterator resIt = this.changedRscSet.iterator();
                while (resIt.hasNext()) {
                    resource = (ResourceImpl)((Object)resIt.next());
                    resource.parseResource();
                }
                resIt = this.changedRscSet.iterator();
                while (resIt.hasNext()) {
                    resource = (ResourceImpl)((Object)resIt.next());
                    resource.commitConfirmed();
                    FileObject fo = ((JMManager)JavaMetamodel.getManager()).getFileObject(resource);
                    Set set = this.needParsing;
                    synchronized (set) {
                        this.needParsing.remove(fo);
                    }
                    set = this.needParsing;
                    synchronized (set) {
                        this.needParsingRW.remove(fo);
                    }
                }
            }
            while (!this.initBodyQueue.isEmpty()) {
                Object bf = this.initBodyQueue.remove(0);
                if (bf instanceof BehavioralFeatureImpl) {
                    ((BehavioralFeatureImpl)((Object)bf)).initBody();
                    continue;
                }
                if (bf instanceof FieldImpl) {
                    ((FieldImpl)((Object)bf)).initInitValue();
                    continue;
                }
                if (bf instanceof EnumConstantImpl) {
                    ((EnumConstantImpl)((Object)bf)).initInitValue();
                    continue;
                }
                if (bf instanceof AttributeImpl) {
                    ((AttributeImpl)((Object)bf)).initDefaultValue();
                    continue;
                }
                ((AttributeValueImpl)((Object)bf)).initInitValue();
            }
            this.initBodyQueue = null;
            if (!this.fail && !this.modificationsDisabled) {
                it = this.changedExternalSet.iterator();
                while (it.hasNext()) {
                    ExternalChange change = (ExternalChange)it.next();
                    JavaMetamodel.getUndoManager().addItem(change);
                    change.performExternalChange();
                }
            }
        }
        finally {
            if (!(this.modificationsDisabled || this.changedRscSet.isEmpty() && this.changedExternalSet.isEmpty() && this.undoElementsSet.isEmpty())) {
                JavaMetamodel.getUndoManager().transactionEnded(this.fail);
            }
            this.changedExternalSet.clear();
            this.undoElementsSet.clear();
            this.changedRscSet.clear();
            this.newObjects.clear();
        }
    }

    public void disableModifications() {
        this.modificationsDisabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isModified(FileObject fileObject) {
        Set set = this.needParsing;
        synchronized (set) {
            return this.needParsing.contains(fileObject);
        }
    }

    static {
        $assertionsDisabled = !ExclusiveMutex.class.desiredAssertionStatus();
    }
}

