/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.List;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.RelationshipAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataJoinColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataPrimaryKeyJoinColumn;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.mappings.OneToOneMapping;

public abstract class ObjectAccessor
extends RelationshipAccessor {
    protected ObjectAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        this.setIsOptional(true);
        this.setFetchType("EAGER");
    }

    protected OneToOneMapping initOneToOneMapping() {
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsPrivateOwned(false);
        mapping.setIsOptional(this.isOptional());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        boolean usesIndirection = this.m_project.enableLazyForOneToOne() ? this.usesIndirection() : false;
        mapping.setUsesIndirection(usesIndirection);
        this.setAccessorMethods(mapping);
        this.processCascadeTypes(mapping);
        return mapping;
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping) {
        if (this.isOneToOnePrimaryKeyRelationship()) {
            this.processOneToOnePrimaryKeyRelationship(mapping);
        } else {
            this.processOneToOneForeignKeyRelationship(mapping);
        }
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping mapping) {
        String defaultPKFieldName = this.getReferenceDescriptor().getPrimaryKeyFieldName();
        String defaultFKFieldName = this.getUpperCaseAttributeName() + "_" + defaultPKFieldName;
        List<MetadataJoinColumn> joinColumns = this.processJoinColumns();
        for (MetadataJoinColumn joinColumn : joinColumns) {
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, defaultPKFieldName, "metadata_default_pk_column"));
            pkField.setTableName(this.getReferenceDescriptor().getPrimaryTableName());
            DatabaseField fkField = joinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, defaultFKFieldName, "metadata_default_fk_column"));
            if (fkField.getTableName().equals("")) {
                fkField.setTableName(this.m_descriptor.getPrimaryTableName());
            }
            mapping.addForeignKeyField(fkField, pkField);
            if (!fkField.isReadOnly()) continue;
            mapping.setIsReadOnly(true);
        }
    }

    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping mapping) {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        List<MetadataPrimaryKeyJoinColumn> primaryKeyJoinColumns = this.processPrimaryKeyJoinColumns(this.getPrimaryKeyJoinColumns(referenceDescriptor.getPrimaryTableName(), this.m_descriptor.getPrimaryTableName()));
        for (MetadataPrimaryKeyJoinColumn primaryKeyJoinColumn : primaryKeyJoinColumns) {
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            pkField.setName(this.getName(pkField, referenceDescriptor.getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            fkField.setName(this.getName(fkField, this.m_descriptor.getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            mapping.addForeignKeyField(fkField, pkField);
            mapping.setIsReadOnly(true);
        }
    }
}

