/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.servlet;

import com.sun.xml.ws.server.DocInfo;
import com.sun.xml.ws.server.RuntimeEndpointInfo;
import com.sun.xml.ws.server.ServerRtException;
import com.sun.xml.ws.transport.http.servlet.RuntimeEndpointInfoParser;
import com.sun.xml.ws.transport.http.servlet.ServletDocInfo;
import com.sun.xml.ws.transport.http.servlet.WSServletException;
import com.sun.xml.ws.transport.http.servlet.WebServiceContextImpl;
import com.sun.xml.ws.util.localization.LocalizableMessageFactory;
import com.sun.xml.ws.util.localization.Localizer;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSServletContextListener
implements ServletContextAttributeListener,
ServletContextListener {
    private Localizer localizer = new Localizer();
    private LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.sun.xml.ws.resources.wsservlet");
    private ServletContext context;
    private ClassLoader classLoader;
    private static final String JAXWS_RI_RUNTIME = "/WEB-INF/sun-jaxws.xml";
    public static final String JAXWS_WSDL_DIR = "/WEB-INF/wsdl";
    public static final String JAXWS_WSDL_DD_DIR = "WEB-INF/wsdl";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.server.http");

    public void attributeAdded(ServletContextAttributeEvent event) {
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
    }

    public void contextDestroyed(ServletContextEvent event) {
        this.context = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.localizer.localize(this.messageFactory.getMessage("listener.info.destroy", new Object[0])));
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(this.localizer.localize(this.messageFactory.getMessage("listener.info.initialize", new Object[0])));
        }
        this.context = event.getServletContext();
        this.classLoader = Thread.currentThread().getContextClassLoader();
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        try {
            RuntimeEndpointInfoParser parser = new RuntimeEndpointInfoParser(this.classLoader);
            InputStream is = this.context.getResourceAsStream(JAXWS_RI_RUNTIME);
            List<RuntimeEndpointInfo> endpoints = parser.parse(is);
            this.context.setAttribute("com.sun.xml.ws.server.http.info", endpoints);
            this.createWebServiceContext(endpoints);
            this.createModelAndMetadata(endpoints);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, this.localizer.localize(this.messageFactory.getMessage("listener.parsingFailed", e.toString())), e);
            this.context.removeAttribute("com.sun.xml.ws.server.http.info");
            throw new WSServletException("listener.parsingFailed", new Object[]{e});
        }
    }

    private static void collectDocs(ServletContext context, String dirPath, Map<String, DocInfo> docs) throws MalformedURLException {
        Set paths = context.getResourcePaths(dirPath);
        if (paths != null) {
            for (String docPath : paths) {
                if (docPath.endsWith("/")) {
                    WSServletContextListener.collectDocs(context, docPath, docs);
                    continue;
                }
                docs.put(context.getResource(docPath).toString(), new ServletDocInfo(context, docPath));
            }
        }
    }

    private void createWebServiceContext(List<RuntimeEndpointInfo> endpoints) {
        for (RuntimeEndpointInfo endpoint : endpoints) {
            WebServiceContextImpl wsContext = new WebServiceContextImpl();
            endpoint.setWebServiceContext(wsContext);
        }
    }

    private void createModelAndMetadata(List<RuntimeEndpointInfo> endpoints) throws Exception {
        URL catalogUrl = null;
        try {
            catalogUrl = this.context.getResource("/WEB-INF/jax-ws-catalog.xml");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        EntityResolver entityResolver = XmlUtil.createEntityResolver(catalogUrl);
        for (RuntimeEndpointInfo endpoint : endpoints) {
            Map<String, DocInfo> docs = new HashMap<String, DocInfo>();
            WSServletContextListener.collectDocs(this.context, JAXWS_WSDL_DIR, docs);
            logger.fine("Endpoint metadata=" + docs);
            String wsdlFile = endpoint.getWSDLFileName();
            if (wsdlFile != null) {
                try {
                    wsdlFile = "/" + wsdlFile;
                    URL wsdlUrl = this.context.getResource(wsdlFile);
                    if (wsdlUrl == null) {
                        throw new ServerRtException("cannot.load.wsdl", wsdlFile);
                    }
                    endpoint.setWsdlInfo(wsdlUrl, entityResolver);
                }
                catch (MalformedURLException e) {
                    throw new ServerRtException("cannot.load.wsdl", wsdlFile);
                }
            }
            endpoint.init();
            if (endpoint.needWSDLGeneration()) {
                endpoint.generateWSDL();
            } else {
                DocInfo wsdlDoc;
                endpoint.setMetadata(docs);
                if (endpoint.getWsdlUrl() != null && (wsdlDoc = (docs = endpoint.getDocMetadata()).get(endpoint.getWsdlUrl().toString())) != null) {
                    wsdlDoc.setQueryString("wsdl");
                }
                RuntimeEndpointInfo.fillDocInfo(endpoint);
            }
            RuntimeEndpointInfo.publishWSDLDocs(endpoint);
        }
    }
}

