/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.j2ee.xml;

import com.sun.xml.rpc.processor.modeler.j2ee.xml.Factory;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BaseType
implements Serializable {
    protected Factory factory;
    protected Element xmlElement;
    protected Attr xmlAttr;
    protected SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public void updateElementValue(byte value) {
        this.updateElementValue(new Byte(value).toString());
    }

    public void updateElementValue(double value) {
        this.updateElementValue(new Double(value).toString());
    }

    public void updateElementValue(float value) {
        this.updateElementValue(new Float(value).toString());
    }

    public void updateElementValue(int value) {
        this.updateElementValue(new Integer(value).toString());
    }

    public void updateElementValue(long value) {
        this.updateElementValue(new Long(value).toString());
    }

    public void updateElementValue(short value) {
        this.updateElementValue(new Short(value).toString());
    }

    public void updateElementValue(boolean value) {
        this.updateElementValue(new Boolean(value).toString());
    }

    protected void setFactory(Factory factory) {
        this.factory = factory;
    }

    public String getElementName() {
        return this.xmlElement.getLocalName();
    }

    public String getElementValue() {
        if (this.xmlAttr != null) {
            return this.xmlAttr.getValue();
        }
        String value = this.xmlElement.getNodeValue();
        if (value != null) {
            return value;
        }
        NodeList nList = this.xmlElement.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            if (nList.item(i) instanceof Text) {
                return ((Text)nList.item(i)).getData();
            }
            ++i;
        }
        return null;
    }

    public byte getElementByteValue(String elementName) {
        return new Byte(this.getElementValue(elementName));
    }

    public double getElementDoubleValue(String elementName) {
        return new Double(this.getElementValue(elementName));
    }

    public float getElementFloatValue(String elementName) {
        return new Float(this.getElementValue(elementName)).floatValue();
    }

    public int getElementIntegerValue(String elementName) {
        return new Integer(this.getElementValue(elementName));
    }

    public int sizeOfElement(String name) {
        NodeList nodes = this.xmlElement.getChildNodes();
        int len = 0;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getLocalName().equals(name)) {
                ++len;
            }
            ++i;
        }
        return len;
    }

    public long getElementLongValue(String elementName) {
        return new Long(this.getElementValue(elementName));
    }

    public short getElementShortValue(String elementName) {
        return new Short(this.getElementValue(elementName));
    }

    public void updateElementValue(String value) {
        Node textNode = this.xmlElement.getFirstChild();
        if (textNode == null) {
            this.factory.createText(this.xmlElement, value);
        } else {
            textNode.setNodeValue(value);
        }
    }

    public boolean getElementBooleanValue(String elementName) {
        return new Boolean(this.getElementValue(elementName));
    }

    public boolean removeElement(String elementName) {
        NodeList nodes = this.xmlElement.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getLocalName().equals(elementName)) {
                try {
                    this.xmlElement.removeChild(node);
                    return true;
                }
                catch (DOMException ex) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    public void setElementValue(String elementName, byte value) {
        this.setElementValue(elementName, new Byte(value).toString());
    }

    public void setElementValue(String elementName, double value) {
        this.setElementValue(elementName, new Double(value).toString());
    }

    public void setElementValue(String elementName, float value) {
        this.setElementValue(elementName, new Float(value).toString());
    }

    public void setElementValue(String elementName, int value) {
        this.setElementValue(elementName, new Integer(value).toString());
    }

    public void setElementValue(String elementName, long value) {
        this.setElementValue(elementName, new Long(value).toString());
    }

    public void setElementValue(String elementName, short value) {
        this.setElementValue(elementName, new Short(value).toString());
    }

    public void setElementValue(String elementName, boolean value) {
        this.setElementValue(elementName, new Boolean(value).toString());
    }

    public void updateElementValue(Date value) {
        this.updateElementValue(this.simpleDateFormat.format(value));
    }

    public Attr getXMLAttribute() {
        return this.xmlAttr;
    }

    protected void setXMLAttribute(Attr xmlAttr) {
        this.xmlAttr = xmlAttr;
    }

    public Element getXMLElement() {
        return this.xmlElement;
    }

    protected void setXMLElement(Element element) {
        this.xmlElement = element;
    }

    public void setElementValue(String elementName, BaseType baseType) {
        Element childXml = baseType.getXMLElement();
        this.xmlElement.appendChild(childXml);
    }

    public String getElementValue(String elementName) {
        NodeList nList = this.xmlElement.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            Node child;
            Element anElement;
            Node node = nList.item(i);
            if (node.getNodeType() == 1 && (anElement = (Element)node).getLocalName().equals(elementName) && (child = anElement.getFirstChild()) instanceof Text) {
                return ((Text)child).getData();
            }
            ++i;
        }
        return null;
    }

    public String getElementValue(String property, int index) {
        NodeList nodes = this.xmlElement.getChildNodes();
        int idx = 0;
        int i = 0;
        while (i < nodes.getLength()) {
            String localName;
            Node node = nodes.item(i);
            if (node instanceof Element && (localName = node.getLocalName()) != null && localName.equals(property) && ++idx == index) {
                Element element = (Element)node;
                Node child = element.getFirstChild();
                if (child instanceof Text) {
                    return ((Text)child).getData();
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public void setElementValue(String elementName, String elementValue) {
        NodeList nodes = this.xmlElement.getElementsByTagName(elementName);
        if (nodes.getLength() == 0) {
            Element elementNode = this.factory.createXMLElementAndText(elementName, elementValue);
            this.xmlElement.appendChild(elementNode);
        } else {
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                String item = node.getNodeName().trim();
                if (item.equals(elementName)) {
                    Node textNode = node.getFirstChild();
                    if (!(textNode instanceof Text)) break;
                    ((Text)textNode).setNodeValue(elementValue);
                    break;
                }
                ++i;
            }
        }
    }

    public Date getElementDateValue(String elementName) {
        try {
            String result = this.getElementValue(elementName);
            if (result != null) {
                return this.simpleDateFormat.parse(result);
            }
        }
        catch (ParseException ex) {
            System.out.println("getElementDateValue exception.." + ex);
        }
        return null;
    }

    public void setElementValue(String elementName, Date value) {
        this.setElementValue(elementName, this.simpleDateFormat.format(value));
    }

    public BaseType getElementValue(String property, String className) {
        NodeList nList = this.xmlElement.getChildNodes();
        int i = 0;
        while (i < nList.getLength()) {
            Node node = nList.item(i);
            if (node instanceof Element && node.getLocalName().equals(property)) {
                return this.factory.newInstance((Element)node, className);
            }
            ++i;
        }
        return null;
    }

    public Object getElementValue(String property, String className, int index) {
        NodeList nList = this.xmlElement.getChildNodes();
        int count = 0;
        int i = 0;
        while (i < nList.getLength()) {
            Node node = nList.item(i);
            if (node instanceof Element && node.getLocalName().equals(property)) {
                if (count == index) {
                    return this.factory.newInstance((Element)node, className);
                }
                ++count;
            }
            ++i;
        }
        return null;
    }
}

