/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.filter.Filter;
import org.netbeans.modules.tasklist.core.filter.FilterRepository;
import org.netbeans.modules.tasklist.core.filter.FilteredTopComponent;
import org.netbeans.modules.tasklist.core.filter.FiltersPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class FilterAction
extends CallableSystemAction {
    private static final long serialVersionUID = 1L;

    protected final boolean asynchronous() {
        return false;
    }

    public final void performAction() {
        TopComponent tc = WindowManager.getDefault().getRegistry().getActivated();
        if (!(tc instanceof FilteredTopComponent)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        final FilteredTopComponent view = (FilteredTopComponent)tc;
        JPanel parentPanel = new JPanel();
        parentPanel.setLayout(new BorderLayout());
        parentPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FilterAction.class, (String)"ACSD_Filter"));
        final FiltersPanel panel = new FiltersPanel(view);
        parentPanel.add((Component)panel, "Center");
        DialogDescriptor d = new DialogDescriptor((Object)parentPanel, NbBundle.getMessage((Class)FilterAction.class, (String)"TITLE_filter"));
        d.setModal(this.isModal());
        final JButton ok = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)ok, (String)NbBundle.getMessage((Class)FilterAction.class, (String)"OK"));
        ok.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FilterAction.class, (String)"BTN_OK_Hint"));
        final JButton cancel = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)cancel, (String)NbBundle.getMessage((Class)FilterAction.class, (String)"Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FilterAction.class, (String)"BTN_Cancel_Hint"));
        final JButton apply = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)apply, (String)NbBundle.getMessage((Class)FilterAction.class, (String)"BTN_Preview"));
        apply.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)FilterAction.class, (String)"BTN_Preview_Hint"));
        panel.addPropertyChangeListener("value-valid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ok.setEnabled(panel.isValueValid());
                apply.setEnabled(panel.isValueValid());
            }
        });
        d.setOptions((Object[])new JButton[]{ok, cancel, apply});
        d.setMessageType(-1);
        d.setButtonListener(new ActionListener(){
            private FilterRepository repositoryBackup = null;
            private Filter activeFilterBackup = null;

            public void actionPerformed(ActionEvent e) {
                Object src = e.getSource();
                if (src == ok) {
                    panel.updateFilters();
                    view.setFilter(view.getFilters().getActive());
                } else if (src == cancel) {
                    if (this.repositoryBackup != null) {
                        view.getFilters().assign(this.repositoryBackup);
                        view.setFilter(this.activeFilterBackup);
                    }
                } else if (src == apply) {
                    if (this.repositoryBackup == null) {
                        this.repositoryBackup = (FilterRepository)view.getFilters().clone();
                        this.activeFilterBackup = view.getFilter();
                    }
                    panel.updateFilters();
                    view.setFilter(view.getFilters().getActive());
                }
            }
        });
        d.setClosingOptions(new Object[]{ok, cancel});
        Dialog dlg = DialogDisplayer.getDefault().createDialog(d);
        dlg.pack();
        dlg.setVisible(true);
    }

    public final void performAction(SystemAction action) {
        this.performAction();
    }

    protected Component createSubpanel() {
        return null;
    }

    protected Filter createFilter(TaskListView tlv) {
        return tlv.createFilter();
    }

    public String getName() {
        return NbBundle.getMessage((Class)FilterAction.class, (String)"Filter");
    }

    protected String iconResource() {
        return "org/netbeans/modules/tasklist/core/filter/filter.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean isModal() {
        return false;
    }
}

