/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Mutex;

public class NodeListModel
extends AbstractListModel
implements ComboBoxModel {
    static final long serialVersionUID = -1926931095895356820L;
    private transient Listener listener;
    private transient VisualizerNode parent = VisualizerNode.EMPTY;
    private transient Object selectedObject = VisualizerNode.EMPTY;
    private transient int size;
    private int depth = 1;
    private Map childrenCount;

    public NodeListModel() {
        this.clearChildrenCount();
    }

    public NodeListModel(Node root) {
        this();
        this.setNode(root);
    }

    public void setNode(final Node root) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                VisualizerNode v = VisualizerNode.getVisualizer(null, root);
                if (v == NodeListModel.this.parent) {
                    return;
                }
                NodeListModel.this.removeAll();
                NodeListModel.this.parent.removeNodeModel(NodeListModel.this.listener());
                NodeListModel.this.parent = v;
                NodeListModel.this.selectedObject = v;
                NodeListModel.this.clearChildrenCount();
                NodeListModel.this.addAll();
                NodeListModel.this.parent.addNodeModel(NodeListModel.this.listener());
            }
        });
    }

    public void setDepth(int depth) {
        if (depth != this.depth) {
            this.depth = depth;
            this.clearChildrenCount();
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    NodeListModel.this.removeAll();
                    NodeListModel.this.addAll();
                }
            });
        }
    }

    public int getDepth() {
        return this.depth;
    }

    private Listener listener() {
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
        return this.listener;
    }

    public int getSize() {
        int s = this.findSize(this.parent, -1, this.depth);
        return s;
    }

    public Object getElementAt(int i) {
        return this.findElementAt(this.parent, i, -1, this.depth);
    }

    public int getIndex(Object o) {
        this.getSize();
        Info i = (Info)this.childrenCount.get(o);
        return i == null ? -1 : i.index;
    }

    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != anObject) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public Object getSelectedItem() {
        return this.selectedObject;
    }

    private void clearChildrenCount() {
        this.childrenCount = new HashMap(17);
    }

    private int findSize(VisualizerNode vis, int index, int depth) {
        Info info = (Info)this.childrenCount.get(vis);
        if (info != null) {
            return info.childrenCount;
        }
        int size = 0;
        info = new Info();
        info.depth = depth;
        info.index = index;
        if (depth-- > 0) {
            Iterator it = vis.getChildren().iterator();
            while (it.hasNext()) {
                VisualizerNode v = (VisualizerNode)it.next();
                ++size;
                size += this.findSize(v, index + size, depth);
            }
        }
        info.childrenCount = size;
        this.childrenCount.put(vis, info);
        return size;
    }

    private VisualizerNode findElementAt(VisualizerNode vis, int indx, int realIndx, int depth) {
        if (--depth == 0) {
            return (VisualizerNode)vis.getChildAt(indx);
        }
        Iterator it = vis.getChildren().iterator();
        while (it.hasNext()) {
            int s;
            VisualizerNode v = (VisualizerNode)it.next();
            if (indx-- == 0) {
                return v;
            }
            if (indx < (s = this.findSize(v, ++realIndx, depth))) {
                return this.findElementAt(v, indx, realIndx, depth);
            }
            indx -= s;
            realIndx += s;
        }
        return vis;
    }

    static int findVisualizerDepth(ListModel m, VisualizerNode o) {
        if (m instanceof NodeListModel) {
            NodeListModel n = (NodeListModel)m;
            Info i = (Info)n.childrenCount.get(o);
            if (i != null) {
                return n.depth - i.depth - 1;
            }
        }
        return 0;
    }

    final void addAll() {
        this.size = this.getSize();
        if (this.size > 0) {
            this.fireIntervalAdded(this, 0, this.size - 1);
        }
    }

    final void removeAll() {
        if (this.size > 0) {
            this.fireIntervalRemoved(this, 0, this.size - 1);
        }
    }

    final void changeAll() {
        this.size = this.getSize();
        if (this.size > 0) {
            this.fireContentsChanged(this, 0, this.size - 1);
        }
        this.clearChildrenCount();
    }

    final void added(VisualizerEvent.Added ev) {
        VisualizerNode v = ev.getVisualizer();
        int[] indices = ev.getArray();
        if (this.cachedDepth(v) <= 0 || indices.length == 0) {
            return;
        }
        this.clearChildrenCount();
        this.size = this.getSize();
        int seg = this.parent == v ? 0 : this.getIndex(v);
        this.fireIntervalAdded(this, indices[0] + seg, indices[indices.length - 1] + seg);
    }

    final void removed(VisualizerEvent.Removed ev) {
        VisualizerNode v = ev.getVisualizer();
        int[] indices = ev.getArray();
        if (this.cachedDepth(v) <= 0 || indices.length == 0) {
            return;
        }
        this.clearChildrenCount();
        int seg = this.parent == v ? 0 : this.getIndex(v);
        this.fireIntervalRemoved(this, indices[0] + seg, indices[indices.length - 1] + seg);
    }

    final void update(VisualizerNode v) {
        this.getSize();
        Info i = (Info)this.childrenCount.get(v);
        if (i != null) {
            this.fireContentsChanged(this, i.index, i.index);
        }
    }

    private int cachedDepth(VisualizerNode v) {
        this.getSize();
        Info i = (Info)this.childrenCount.get(v);
        if (i != null) {
            return i.depth;
        }
        return -1;
    }

    private static final class Info {
        public int childrenCount;
        public int depth;
        public int index;

        Info() {
        }

        public String toString() {
            return "Info[childrenCount=" + this.childrenCount + ", depth=" + this.depth + ", index=" + this.index;
        }
    }

    private static final class Listener
    implements NodeModel {
        private Reference model;

        public Listener(NodeListModel m) {
            this.model = new WeakReference<NodeListModel>(m);
        }

        private NodeListModel get(VisualizerEvent ev) {
            NodeListModel m = (NodeListModel)this.model.get();
            if (m == null && ev != null) {
                ev.getVisualizer().removeNodeModel(this);
                return null;
            }
            return m;
        }

        public void added(VisualizerEvent.Added ev) {
            NodeListModel m = this.get(ev);
            if (m == null) {
                return;
            }
            m.added(ev);
        }

        public void removed(VisualizerEvent.Removed ev) {
            NodeListModel m = this.get(ev);
            if (m == null) {
                return;
            }
            m.removed(ev);
        }

        public void reordered(VisualizerEvent.Reordered ev) {
            NodeListModel m = this.get(ev);
            if (m == null) {
                return;
            }
            m.changeAll();
        }

        public void update(VisualizerNode v) {
            NodeListModel m = this.get(null);
            if (m == null) {
                return;
            }
            m.update(v);
        }

        public void structuralChange(VisualizerNode v) {
            NodeListModel m = this.get(null);
            if (m == null) {
                return;
            }
            m.changeAll();
        }
    }
}

