/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.util.DataComboBoxModel;
import org.netbeans.modules.db.util.DataComboBoxSupport;
import org.openide.util.NbBundle;

public final class DatabaseExplorerInternalUIs {
    static /* synthetic */ Class class$org$netbeans$modules$db$util$DatabaseExplorerInternalUIs;

    private DatabaseExplorerInternalUIs() {
    }

    public static void connect(JComboBox comboBox, JDBCDriverManager driverManager) {
        DatabaseExplorerInternalUIs.connect(comboBox, driverManager, null);
    }

    public static void connect(JComboBox comboBox, JDBCDriverManager driverManager, String driverClass) {
        DataComboBoxSupport.connect(comboBox, new DriverDataComboBoxModel(driverManager, driverClass), driverClass == null);
    }

    private static final class DriverComparator
    implements Comparator {
        private DriverComparator() {
        }

        public boolean equals(Object that) {
            return that instanceof DriverComparator;
        }

        public int compare(Object driver1, Object driver2) {
            if (driver1 == null) {
                return driver2 == null ? 0 : -1;
            }
            if (driver2 == null) {
                return 1;
            }
            String dispName1 = ((JDBCDriver)driver1).getDisplayName();
            String dispName2 = ((JDBCDriver)driver2).getDisplayName();
            if (dispName1 == null) {
                return dispName2 == null ? 0 : -1;
            }
            return dispName2 == null ? 1 : dispName1.compareToIgnoreCase(dispName2);
        }
    }

    private static final class DriverComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final JDBCDriverManager driverManager;
        private final List driverList;
        private Object selectedItem;

        public DriverComboBoxModel(JDBCDriverManager driverManager, String driverClass) {
            this.driverManager = driverManager;
            this.driverList = new ArrayList();
            JDBCDriver[] drivers = driverClass != null ? driverManager.getDrivers(driverClass) : driverManager.getDrivers();
            for (int i = 0; i < drivers.length; ++i) {
                if (!JDBCDriverSupport.isAvailable(drivers[i])) continue;
                this.driverList.add(drivers[i]);
            }
            Collections.sort(this.driverList, new DriverComparator());
        }

        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
        }

        public Object getElementAt(int index) {
            return this.driverList.get(index);
        }

        public int getSize() {
            return this.driverList.size();
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void addSelectedDriver(JDBCDriver dbconn) {
            this.selectedItem = dbconn;
            this.driverList.add(dbconn);
            Collections.sort(this.driverList, new DriverComparator());
            this.fireContentsChanged(this, 0, this.driverList.size());
        }
    }

    private static final class DriverDataComboBoxModel
    implements DataComboBoxModel {
        private final JDBCDriverManager driverManager;
        private final DriverComboBoxModel comboBoxModel;

        public DriverDataComboBoxModel(JDBCDriverManager driverManager, String driverClass) {
            this.driverManager = driverManager;
            this.comboBoxModel = new DriverComboBoxModel(driverManager, driverClass);
        }

        public String getItemTooltipText(Object item) {
            return ((JDBCDriver)item).toString();
        }

        public String getItemDisplayName(Object item) {
            return ((JDBCDriver)item).getDisplayName();
        }

        public void newItemActionPerformed() {
            HashSet<JDBCDriver> oldDrivers = new HashSet<JDBCDriver>(Arrays.asList(this.driverManager.getDrivers()));
            this.driverManager.showAddDriverDialog();
            JDBCDriver[] newDrivers = this.driverManager.getDrivers();
            if (newDrivers.length == oldDrivers.size()) {
                return;
            }
            for (int i = 0; i < newDrivers.length; ++i) {
                if (oldDrivers.contains(newDrivers[i])) continue;
                this.comboBoxModel.addSelectedDriver(newDrivers[i]);
                break;
            }
        }

        public String getNewItemDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$db$util$DatabaseExplorerInternalUIs == null ? (class$org$netbeans$modules$db$util$DatabaseExplorerInternalUIs = DatabaseExplorerInternalUIs.class$("org.netbeans.modules.db.util.DatabaseExplorerInternalUIs")) : class$org$netbeans$modules$db$util$DatabaseExplorerInternalUIs), (String)"LBL_NewDriver");
        }

        public ComboBoxModel getListModel() {
            return this.comboBoxModel;
        }
    }
}

