/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.InputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.ddl.impl.CreateIndex;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.util.CommandBuffer;
import org.netbeans.lib.ddl.util.PListReader;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;
import org.netbeans.modules.db.explorer.dlg.DataModel;
import org.netbeans.modules.db.explorer.dlg.TypeElement;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.util.TextFieldValidator;
import org.netbeans.modules.db.util.ValidableTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CreateTableDialog {
    boolean result = false;
    Dialog dialog = null;
    JTextField dbnamefield;
    JTextField dbownerfield;
    JTable table;
    JComboBox ownercombo;
    JButton addbtn;
    JButton delbtn;
    Specification spec;
    private Vector ttab;
    private static Map dlgtab = null;
    private static final String filename = "org/netbeans/modules/db/resources/CreateTableDialog.plist";
    private ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");

    public static final Map getProperties() {
        if (dlgtab == null) {
            try {
                ClassLoader cl = CreateTableDialog.class.getClassLoader();
                InputStream stream = cl.getResourceAsStream(filename);
                if (stream == null) {
                    String message = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_UnableToOpenStream"), filename);
                    throw new Exception(message);
                }
                PListReader reader = new PListReader(stream);
                dlgtab = reader.getData();
                stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                dlgtab = null;
            }
        }
        return dlgtab;
    }

    public CreateTableDialog(Specification spe, DatabaseNodeInfo nfo) throws SQLException {
        this.spec = spe;
        try {
            JPanel pane = new JPanel();
            pane.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints constr = new GridBagConstraints();
            pane.setLayout(layout);
            pane.setMinimumSize(new Dimension(200, 100));
            JLabel label = new JLabel(this.bundle.getString("CreateTableName"));
            label.setDisplayedMnemonic(this.bundle.getString("CreateTableName_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableNameA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            constr.gridx = 0;
            constr.gridy = 0;
            layout.setConstraints(label, constr);
            pane.add(label);
            constr.fill = 2;
            constr.weightx = 1.0;
            constr.weighty = 0.0;
            constr.gridx = 1;
            constr.gridy = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            this.dbnamefield = new JTextField(this.bundle.getString("CreateTableUntitledName"), 10);
            this.dbnamefield.setToolTipText(this.bundle.getString("ACS_CreateTableNameTextFieldA11yDesc"));
            this.dbnamefield.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_CreateTableNameTextFieldA11yName"));
            label.setLabelFor(this.dbnamefield);
            layout.setConstraints(this.dbnamefield, constr);
            pane.add(this.dbnamefield);
            label = new JLabel(this.bundle.getString("CreateTableOwner"));
            label.setDisplayedMnemonic(this.bundle.getString("CreateTableOwner_Mnemonic").charAt(0));
            label.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableOwnerA11yDesc"));
            constr.anchor = 17;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.fill = 0;
            constr.insets = new Insets(2, 10, 2, 2);
            constr.gridx = 2;
            constr.gridy = 0;
            layout.setConstraints(label, constr);
            pane.add(label);
            Vector<String> users = new Vector<String>();
            String schema = nfo.getDriverSpecification().getSchema();
            if (schema != null && schema.length() > 0) {
                users.add(schema);
            } else {
                users.add(" ");
            }
            constr.fill = 2;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.gridx = 3;
            constr.gridy = 0;
            constr.insets = new Insets(2, 2, 2, 2);
            this.ownercombo = new JComboBox(users);
            this.ownercombo.setSelectedIndex(0);
            this.ownercombo.setRenderer(new ListCellRendererImpl());
            this.ownercombo.setToolTipText(this.bundle.getString("ACS_CreateTableOwnerComboBoxA11yDesc"));
            this.ownercombo.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_CreateTableOwnerComboBoxA11yName"));
            label.setLabelFor(this.ownercombo);
            layout.setConstraints(this.ownercombo, constr);
            pane.add(this.ownercombo);
            constr.fill = 1;
            constr.weightx = 1.0;
            constr.weighty = 1.0;
            constr.gridx = 0;
            constr.gridy = 1;
            constr.gridwidth = 4;
            constr.gridheight = 3;
            constr.insets = new Insets(2, 2, 2, 2);
            this.table = new DataTable(new DataModel());
            this.table.setAutoResizeMode(0);
            this.table.setToolTipText(this.bundle.getString("ACS_CreateTableColumnTableA11yDesc"));
            this.table.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_CreateTableColumnTableA11yName"));
            this.table.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableColumnTableA11yDesc"));
            JScrollPane scrollpane = new JScrollPane(this.table);
            scrollpane.setBorder(new BevelBorder(1));
            layout.setConstraints(scrollpane, constr);
            pane.add(scrollpane);
            Map tmap = this.spec.getTypeMap();
            this.ttab = new Vector(tmap.size());
            Iterator iter = tmap.keySet().iterator();
            while (iter.hasNext()) {
                String iterkey = (String)iter.next();
                String iterval = (String)tmap.get(iterkey);
                this.ttab.add(new TypeElement(iterkey, iterval));
            }
            final JComboBox combo = new JComboBox(this.ttab);
            combo.setSelectedIndex(0);
            this.table.setDefaultEditor(String.class, new DataCellEditor(new JTextField()));
            this.table.getColumn("type").setCellEditor(new ComboBoxEditor(combo));
            this.table.getColumn("size").setCellEditor(new DataCellEditor(new ValidableTextField(new TextFieldValidator.integer())));
            this.table.getColumn("scale").setCellEditor(new DataCellEditor(new ValidableTextField(new TextFieldValidator.integer())));
            this.table.setRowHeight(combo.getPreferredSize().height);
            constr.fill = 2;
            constr.anchor = 11;
            constr.weightx = 0.0;
            constr.weighty = 0.0;
            constr.gridx = 4;
            constr.gridy = 1;
            constr.insets = new Insets(2, 8, 2, 2);
            JPanel btnpane = new JPanel();
            GridLayout btnlay = new GridLayout(2, 1, 0, 5);
            btnpane.setLayout(btnlay);
            layout.setConstraints(btnpane, constr);
            pane.add(btnpane);
            this.addbtn = new JButton(this.bundle.getString("CreateTableAddButtonTitle"));
            this.addbtn.setMnemonic(this.bundle.getString("CreateTableAddButtonTitle_Mnemonic").charAt(0));
            this.addbtn.setToolTipText(this.bundle.getString("ACS_CreateTableAddButtonTitleA11yDesc"));
            btnpane.add(this.addbtn);
            this.addbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (CreateTableDialog.this.table.getCellEditor() != null) {
                        CreateTableDialog.this.table.getCellEditor().stopCellEditing();
                    }
                    DataModel model = (DataModel)CreateTableDialog.this.table.getModel();
                    ColumnItem item = new ColumnItem();
                    item.setProperty("type", CreateTableDialog.this.ttab.elementAt(0));
                    model.addRow(item);
                }
            });
            this.delbtn = new JButton(this.bundle.getString("CreateTableRemoveButtonTitle"));
            this.delbtn.setMnemonic(this.bundle.getString("CreateTableRemoveButtonTitle_Mnemonic").charAt(0));
            this.delbtn.setToolTipText(this.bundle.getString("ACS_CreateTableRemoveButtonTitleA11yDesc"));
            btnpane.add(this.delbtn);
            this.delbtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    int idx;
                    if (CreateTableDialog.this.table.getCellEditor() != null) {
                        CreateTableDialog.this.table.getCellEditor().stopCellEditing();
                    }
                    if ((idx = CreateTableDialog.this.table.getSelectedRow()) != -1) {
                        ((DataModel)CreateTableDialog.this.table.getModel()).removeRow(idx);
                    }
                }
            });
            ActionListener listener = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    final ActionEvent evt = event;
                    if (CreateTableDialog.this.table.getCellEditor() != null) {
                        CreateTableDialog.this.table.getCellEditor().stopCellEditing();
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            if (evt.getSource() == DialogDescriptor.OK_OPTION) {
                                (this).CreateTableDialog.this.result = CreateTableDialog.this.validate();
                                CommandBuffer cbuff = new CommandBuffer();
                                Vector<CreateIndex> idxCommands = new Vector<CreateIndex>();
                                if ((this).CreateTableDialog.this.result) {
                                    try {
                                        String tablename = CreateTableDialog.this.getTableName();
                                        DataModel dataModel = (DataModel)(this).CreateTableDialog.this.table.getModel();
                                        Vector data = dataModel.getData();
                                        CreateTable cmd = (this).CreateTableDialog.this.spec.createCommandCreateTable(tablename);
                                        cmd.setObjectOwner(((String)(this).CreateTableDialog.this.ownercombo.getSelectedItem()).trim());
                                        org.netbeans.lib.ddl.impl.TableColumn cmdcol = null;
                                        CreateIndex xcmd = null;
                                        Enumeration enu = data.elements();
                                        while (enu.hasMoreElements()) {
                                            ColumnItem enuele = (ColumnItem)enu.nextElement();
                                            String name = enuele.getName();
                                            cmdcol = enuele.isPrimaryKey() && !dataModel.isTablePrimaryKey() ? cmd.createPrimaryKeyColumn(name) : (enuele.isUnique() && !enuele.isPrimaryKey() ? cmd.createUniqueColumn(name) : cmd.createColumn(name));
                                            combo.setSelectedItem(combo.getSelectedItem());
                                            cmdcol.setColumnType(Specification.getType(enuele.getType().getType()));
                                            cmdcol.setColumnSize(enuele.getSize());
                                            cmdcol.setDecimalSize(enuele.getScale());
                                            cmdcol.setNullAllowed(enuele.allowsNull());
                                            String defval = enuele.getDefaultValue();
                                            if (defval != null && defval.length() > 0) {
                                                cmdcol.setDefaultValue(defval);
                                            }
                                            if (enuele.hasCheckConstraint()) {
                                                cmd.createCheckConstraint(name, enuele.getCheckConstraint());
                                            }
                                            if (!enuele.isIndexed() || enuele.isPrimaryKey() || enuele.isUnique()) continue;
                                            xcmd = (this).CreateTableDialog.this.spec.createCommandCreateIndex(tablename);
                                            xcmd.setIndexName(tablename + "_" + name + "_idx");
                                            xcmd.setIndexType(new String());
                                            xcmd.setObjectOwner((String)(this).CreateTableDialog.this.ownercombo.getSelectedItem());
                                            xcmd.specifyColumn(name);
                                            idxCommands.add(xcmd);
                                        }
                                        if (dataModel.isTablePrimaryKey()) {
                                            cmdcol = cmd.createPrimaryKeyConstraint(tablename);
                                            cmdcol.setTableConstraintColumns(dataModel.getTablePrimaryKeys());
                                            cmdcol.setColumnType(0);
                                            cmdcol.setColumnSize(0);
                                            cmdcol.setDecimalSize(0);
                                            cmdcol.setNullAllowed(true);
                                        }
                                        cbuff.add(cmd);
                                        for (int i = 0; i < idxCommands.size(); ++i) {
                                            cbuff.add((CreateIndex)idxCommands.elementAt(i));
                                        }
                                        cbuff.execute();
                                        if (!cbuff.wasException()) {
                                            (this).CreateTableDialog.this.dialog.setVisible(false);
                                            (this).CreateTableDialog.this.dialog.dispose();
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    String msg = CreateTableDialog.this.bundle.getString("EXC_InsufficientCreateTableInfo");
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                                }
                            }
                        }
                    }, 0);
                }
            };
            pane.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_CreateTableDialogA11yDesc"));
            this.addbtn.doClick();
            DialogDescriptor descriptor = new DialogDescriptor((Object)pane, this.bundle.getString("CreateTableDialogTitle"), true, listener);
            Object[] closingOptions = new Object[]{DialogDescriptor.CANCEL_OPTION};
            descriptor.setClosingOptions(closingOptions);
            this.dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            this.dialog.setResizable(true);
        }
        catch (MissingResourceException ex) {
            ex.printStackTrace();
        }
    }

    public boolean run() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
        }
        return this.result;
    }

    public String getTableName() {
        return this.dbnamefield.getText();
    }

    private boolean validate() {
        String tname = this.getTableName();
        if (tname == null || tname.length() < 1) {
            return false;
        }
        Vector cols = ((DataModel)this.table.getModel()).getData();
        Enumeration colse = cols.elements();
        while (colse.hasMoreElements()) {
            if (((ColumnItem)colse.nextElement()).validate()) continue;
            return false;
        }
        return true;
    }

    private static final class ListCellRendererImpl
    extends DefaultListCellRenderer {
        private ListCellRendererImpl() {
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (Utilities.isWindows()) {
                size.width += 4;
            }
            return size;
        }
    }

    class ComboBoxEditor
    extends DefaultCellEditor {
        public ComboBoxEditor(final JComboBox jComboBox) {
            super(jComboBox);
            jComboBox.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    SwingUtilities.invokeLater(new PopupInvoker(jComboBox));
                }

                public void focusLost(FocusEvent e) {
                }
            });
        }
    }

    class PopupInvoker
    implements Runnable {
        private JComboBox jComboBox;

        public PopupInvoker(JComboBox aJComboBox) {
            this.jComboBox = aJComboBox;
        }

        public void run() {
            try {
                this.jComboBox.showPopup();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    class DataCellEditor
    extends DefaultCellEditor {
        static final long serialVersionUID = 3855371868128838794L;

        public DataCellEditor(JTextField x) {
            super(x);
            this.setClickCountToStart(1);
        }
    }

    class FocusInvoker
    implements Runnable {
        private JTextField xxx;

        public FocusInvoker(JTextField fld) {
            this.xxx = fld;
        }

        public void run() {
            this.xxx.selectAll();
        }
    }

    class DataTable
    extends JTable {
        static final long serialVersionUID = 1222037401669064863L;

        public DataTable(TableModel model) {
            super(model);
            this.setSurrendersFocusOnKeystroke(true);
            TableColumnModel cmodel = this.getColumnModel();
            int ccount = model.getColumnCount();
            int width = 0;
            for (int i = 0; i < ccount; ++i) {
                TableColumn col = cmodel.getColumn(i);
                Map cmap = ColumnItem.getColumnProperty(i);
                col.setIdentifier(cmap.get("name"));
                String columnName = CreateTableDialog.this.bundle.getString("CreateTable_" + i);
                int columnWidth = new Double(this.getFontMetrics(this.getFont()).getStringBounds(columnName, this.getGraphics()).getWidth()).intValue() + 20;
                if (cmap.containsKey("width")) {
                    if ((Integer)cmap.get("width") < columnWidth) {
                        col.setPreferredWidth(columnWidth);
                    } else {
                        col.setPreferredWidth((Integer)cmap.get("width"));
                    }
                    int n = col.getPreferredWidth();
                }
                if (cmap.containsKey("minwidth")) {
                    if ((Integer)cmap.get("minwidth") < columnWidth) {
                        col.setMinWidth(columnWidth);
                    } else {
                        col.setMinWidth((Integer)cmap.get("minwidth"));
                    }
                }
                if (i >= 7) continue;
                width += col.getPreferredWidth();
            }
            width = Math.min(Math.max(width, 380), Toolkit.getDefaultToolkit().getScreenSize().width - 100);
            this.setPreferredScrollableViewportSize(new Dimension(width, 150));
        }
    }
}

