/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FilteredNode;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.UserCancelException;

public class SelectorUtils {
    public static final FilteredNode.NodeFilter BUNDLES_FILTER = new FilteredNode.NodeFilter(){

        public boolean acceptNode(Node n) {
            DataObject dataObject = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SelectorUtils.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (dataObject == null) {
                return false;
            }
            return dataObject instanceof DataFolder && SelectorUtils.isVisible(dataObject) || dataObject instanceof PropertiesDataObject;
        }
    };
    public static final FilteredNode.NodeFilter ALL_FILTER = new FilteredNode.NodeFilter(){

        public boolean acceptNode(Node n) {
            return true;
        }
    };
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesDataObject;

    private static boolean isVisible(DataObject dobj) {
        return dobj.getPrimaryFile() == null || VisibilityQuery.getDefault().isVisible(dobj.getPrimaryFile());
    }

    public static DataObject selectBundle(Project prj, FileObject file) {
        try {
            Node root = SelectorUtils.bundlesNode(prj, file, true);
            Node[] selectedNodes = NodeOperation.getDefault().select(Util.getString("CTL_SelectPropDO_Dialog_Title"), Util.getString("CTL_SelectPropDO_Dialog_RootTitle"), root, new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes == null || nodes.length != 1) {
                        return false;
                    }
                    DataObject dataObject = (DataObject)nodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = SelectorUtils.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
                    if (dataObject == null) {
                        return false;
                    }
                    return dataObject.getClass().equals(class$org$netbeans$modules$properties$PropertiesDataObject == null ? (class$org$netbeans$modules$properties$PropertiesDataObject = SelectorUtils.class$("org.netbeans.modules.properties.PropertiesDataObject")) : class$org$netbeans$modules$properties$PropertiesDataObject);
                }
            });
            return (DataObject)selectedNodes[0].getCookie(DataObject.class);
        }
        catch (UserCancelException uce) {
            return null;
        }
    }

    public static Node bundlesNode(Project prj, FileObject file, boolean includeFiles) {
        LinkedList nodes = new LinkedList();
        ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/execute");
        if (cp != null) {
            nodes.addAll(SelectorUtils.getRootNodes(prj, SelectorUtils.getRoots(cp), BUNDLES_FILTER, includeFiles));
        }
        return SelectorUtils.createRootFor(nodes, prj);
    }

    private static List getRoots(ClassPath cp) {
        ArrayList<FileObject> l = new ArrayList<FileObject>(cp.entries().size());
        Iterator eit = cp.entries().iterator();
        while (eit.hasNext()) {
            ClassPath.Entry e = (ClassPath.Entry)eit.next();
            URL url = e.getURL();
            SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)url);
            FileObject[] fos = r.getRoots();
            if (fos.length > 0) {
                for (int i = 0; i < fos.length; ++i) {
                    l.add(fos[i]);
                }
                continue;
            }
            if (e.getRoot() == null) continue;
            l.add(e.getRoot());
        }
        return l;
    }

    private static List getRootNodes(Project prj, List roots, FilteredNode.NodeFilter filter, boolean includeFiles) {
        ArrayList<FilteredNode> nodes = new ArrayList<FilteredNode>(roots.size());
        Iterator it = roots.iterator();
        while (it.hasNext()) {
            try {
                FileObject rfo = (FileObject)it.next();
                if (!includeFiles && FileUtil.toFile((FileObject)rfo) == null) continue;
                Project owner = FileOwnerQuery.getOwner((FileObject)rfo);
                Node origNode = DataObject.find((FileObject)rfo).getNodeDelegate();
                FilteredNode node = new FilteredNode(origNode, filter, SelectorUtils.getDisplayName(rfo, owner, prj != owner));
                nodes.add(node);
            }
            catch (DataObjectNotFoundException ex) {}
        }
        return nodes;
    }

    private static String getDisplayName(FileObject fo, Project owner, boolean incPrjName) {
        if (owner != null) {
            String n;
            SourceGroup grp = SelectorUtils.getSourceGroup(fo, owner);
            String string = n = grp != null ? grp.getDisplayName() : FileUtil.getFileDisplayName((FileObject)fo);
            if (incPrjName) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)owner);
                n = n + " [" + pi.getDisplayName() + "]";
            }
            return n;
        }
        return FileUtil.getFileDisplayName((FileObject)fo);
    }

    private static SourceGroup getSourceGroup(FileObject file, Project prj) {
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] srcgrps = src.getSourceGroups("java");
        for (int i = 0; i < srcgrps.length; ++i) {
            if (file != srcgrps[i].getRootFolder()) continue;
            return srcgrps[i];
        }
        return null;
    }

    public static Node sourcesNode(Project prj, FilteredNode.NodeFilter filter) {
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] srcgrps = src.getSourceGroups("java");
        ArrayList<FilteredNode> nodes = new ArrayList<FilteredNode>();
        for (int i = 0; i < srcgrps.length; ++i) {
            try {
                FileObject rfo = srcgrps[i].getRootFolder();
                FilteredNode node = new FilteredNode(DataObject.find((FileObject)rfo).getNodeDelegate(), filter);
                node.setDisplayName(srcgrps[i].getDisplayName());
                nodes.add(node);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        return SelectorUtils.createRootFor(nodes, prj);
    }

    private static Node createRootFor(List nodes, Project prj) {
        Children.Array ch = new Children.Array();
        Node[] nodesArray = new Node[nodes.size()];
        nodes.toArray(nodesArray);
        ch.add(nodesArray);
        AbstractNode ret = new AbstractNode((Children)ch);
        ret.setDisplayName(ProjectUtils.getInformation((Project)prj).getDisplayName());
        return ret;
    }

    public static DataObject instantiateTemplate(Project project, FileObject refFile, DataObject template) throws IOException {
        ObjectNameInputPanel panel = new ObjectNameInputPanel();
        Node repositoryNode = SelectorUtils.bundlesNode(project, refFile, false);
        DataFolder dataFolder = (DataFolder)NodeOperation.getDefault().select(I18nUtil.getBundle().getString("CTL_Template_Dialog_Title"), I18nUtil.getBundle().getString("CTL_Template_Dialog_RootTitle"), repositoryNode, new NodeAcceptor(){

            public boolean acceptNodes(Node[] nodes) {
                if (nodes == null || nodes.length != 1) {
                    return false;
                }
                DataFolder cookie = (DataFolder)nodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = SelectorUtils.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                return cookie != null && cookie.getPrimaryFile().canWrite();
            }
        }, (Component)panel)[0].getCookie(DataFolder.class);
        String name = panel.getText();
        DataObject newObject = name.equals("") ? template.createFromTemplate(dataFolder) : template.createFromTemplate(dataFolder, name);
        try {
            return newObject;
        }
        catch (ClassCastException cce) {
            throw new UserCancelException();
        }
    }

    private static class ObjectNameInputPanel
    extends JPanel {
        static final long serialVersionUID = 1980214734060402958L;
        JTextField text;

        public ObjectNameInputPanel() {
            BorderLayout layout = new BorderLayout();
            layout.setVgap(5);
            layout.setHgap(5);
            this.setLayout(layout);
            String labelText = I18nUtil.getBundle().getString("LBL_TemplateName");
            JLabel label = new JLabel(labelText.replace('&', ' '));
            this.text = new JTextField();
            this.text.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_TEXT_ObjectNameInputPanel"));
            label.setDisplayedMnemonic(labelText.charAt(labelText.indexOf(38) + 1));
            label.setLabelFor(this.text);
            this.add("West", label);
            this.add("Center", this.text);
        }

        public void requestFocus() {
            this.text.requestFocus();
        }

        public String getText() {
            return this.text.getText();
        }

        public void setText(String s) {
            this.setText(s);
        }
    }
}

