/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.FindPerformer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesTableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class PropertiesOpen
extends CloneableOpenSupport
implements OpenCookie,
CloseCookie {
    PropertiesDataObject propDataObject;
    PropertyChangeListener modifL;
    protected transient UndoRedo.Manager undoRedoManager;
    transient Object atomicUndoRedoFlag;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$actions$FindAction;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesOpen$PropertiesCloneableTopComponent;

    public PropertiesOpen(PropertiesDataObject propDataObject) {
        super((CloneableOpenSupport.Env)new Environment(propDataObject));
        this.propDataObject = propDataObject;
        this.modifL = new ModifiedListener();
        this.propDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.modifL, (Object)((Object)this.propDataObject)));
    }

    protected boolean canClose() {
        Node.Cookie saveCookie = this.propDataObject.getCookie(SaveCookie.class);
        if (saveCookie == null) {
            return true;
        }
        this.stopEditing();
        if (!this.shouldAskSave()) {
            return true;
        }
        String title = NbBundle.getMessage((Class)PropertiesOpen.class, (String)"CTL_Question");
        String question = NbBundle.getMessage((Class)PropertiesOpen.class, (String)"MSG_SaveFile", (Object)this.propDataObject.getName());
        String optionSave = NbBundle.getMessage((Class)PropertiesOpen.class, (String)"CTL_Save");
        String optionDiscard = NbBundle.getMessage((Class)PropertiesOpen.class, (String)"CTL_Discard");
        DialogDescriptor descr = new DialogDescriptor((Object)question, title, true, new Object[]{optionSave, optionDiscard, NotifyDescriptor.CANCEL_OPTION}, (Object)optionSave, 0, null, (ActionListener)null);
        descr.setMessageType(3);
        Object answer = DialogDisplayer.getDefault().notify((NotifyDescriptor)descr);
        if (answer == optionSave) {
            try {
                ((SaveCookie)saveCookie).save();
                this.propDataObject.updateModificationStatus();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return false;
            }
        }
        this.propDataObject.updateModificationStatus();
        return answer == optionSave || answer == optionDiscard;
    }

    private void stopEditing() {
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            if (!(o instanceof PropertiesCloneableTopComponent)) continue;
            BundleEditPanel bep = (BundleEditPanel)((PropertiesCloneableTopComponent)((Object)o)).getComponent(0);
            bep.stopEditing();
        }
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        return new PropertiesCloneableTopComponent(this.propDataObject);
    }

    protected String messageOpening() {
        return NbBundle.getMessage((Class)PropertiesOpen.class, (String)"LBL_ObjectOpen", (Object)this.propDataObject.getName(), (Object)this.propDataObject.getPrimaryFile().toString());
    }

    protected String messageOpened() {
        return NbBundle.getMessage((Class)PropertiesOpen.class, (String)"LBL_ObjectOpened");
    }

    public synchronized boolean hasOpenedTableComponent() {
        return !this.allEditors.isEmpty();
    }

    public UndoRedo getUndoRedo() {
        if (this.undoRedoManager != null) {
            return this.undoRedoManager;
        }
        return new CompoundUndoRedoManager(this.propDataObject);
    }

    private synchronized void closeDocuments() {
        this.closeEntry((PropertiesFileEntry)this.propDataObject.getPrimaryEntry());
        Iterator it = this.propDataObject.secondaryEntries().iterator();
        while (it.hasNext()) {
            this.closeEntry((PropertiesFileEntry)((Object)it.next()));
        }
    }

    private void closeEntry(PropertiesFileEntry entry) {
        PropertiesEditorSupport editorSupport = entry.getPropertiesEditor();
        if (editorSupport.hasOpenedEditorComponent()) {
            return;
        }
        editorSupport.forceNotifyClosed();
        if (entry.getFile().isValid() && !entry.getFile().isVirtual()) {
            entry.getHandler().autoParse();
        }
    }

    private boolean shouldAskSave() {
        PropertiesFileEntry entry = (PropertiesFileEntry)this.propDataObject.getPrimaryEntry();
        SaveCookie savec = (SaveCookie)entry.getCookie(SaveCookie.class);
        if (savec != null && !entry.getPropertiesEditor().hasOpenedEditorComponent()) {
            return true;
        }
        Iterator it = this.propDataObject.secondaryEntries().iterator();
        while (it.hasNext()) {
            entry = (PropertiesFileEntry)((Object)it.next());
            savec = (SaveCookie)entry.getCookie(class$org$openide$cookies$SaveCookie == null ? PropertiesOpen.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
            if (savec == null || entry.getPropertiesEditor().hasOpenedEditorComponent()) continue;
            return true;
        }
        return false;
    }

    private static class CompoundUndoRedoManager
    implements UndoRedo {
        private WeakSet managers = new WeakSet(5);

        public CompoundUndoRedoManager(PropertiesDataObject obj) {
            this.init(obj);
        }

        private void init(PropertiesDataObject obj) {
            this.managers.add((Object)((PropertiesFileEntry)obj.getPrimaryEntry()).getPropertiesEditor().getUndoRedoManager());
            Iterator it = obj.secondaryEntries().iterator();
            while (it.hasNext()) {
                this.managers.add((Object)((PropertiesFileEntry)((Object)it.next())).getPropertiesEditor().getUndoRedoManager());
            }
        }

        public synchronized void reset(PropertiesDataObject obj) {
            this.managers.clear();
            this.init(obj);
        }

        private UndoRedo getNextUndo() {
            PropertiesEditorSupport.UndoRedoStampFlagManager chosenManager = null;
            long time = 0L;
            Iterator it = this.managers.iterator();
            while (it.hasNext()) {
                PropertiesEditorSupport.UndoRedoStampFlagManager manager = (PropertiesEditorSupport.UndoRedoStampFlagManager)((Object)it.next());
                long timeManager = manager.getTimeStampOfEditToBeUndone();
                if (timeManager <= time) continue;
                time = timeManager;
                chosenManager = manager;
            }
            return chosenManager;
        }

        private UndoRedo getNextRedo() {
            PropertiesEditorSupport.UndoRedoStampFlagManager chosenManager = null;
            long time = 0L;
            Iterator it = this.managers.iterator();
            while (it.hasNext()) {
                PropertiesEditorSupport.UndoRedoStampFlagManager manager = (PropertiesEditorSupport.UndoRedoStampFlagManager)((Object)it.next());
                long timeManager = manager.getTimeStampOfEditToBeRedone();
                if (timeManager <= time) continue;
                time = timeManager;
                chosenManager = manager;
            }
            return chosenManager;
        }

        public synchronized boolean canUndo() {
            Iterator it = this.managers.iterator();
            while (it.hasNext()) {
                if (!((UndoRedo)it.next()).canUndo()) continue;
                return true;
            }
            return false;
        }

        public synchronized boolean canRedo() {
            Iterator it = this.managers.iterator();
            while (it.hasNext()) {
                if (!((UndoRedo)it.next()).canRedo()) continue;
                return true;
            }
            return false;
        }

        public synchronized void undo() throws CannotUndoException {
            PropertiesEditorSupport.UndoRedoStampFlagManager chosenManager = (PropertiesEditorSupport.UndoRedoStampFlagManager)this.getNextUndo();
            if (chosenManager == null) {
                throw new CannotUndoException();
            }
            Object atomicFlag = chosenManager.getAtomicFlagOfEditToBeUndone();
            if (atomicFlag == null) {
                chosenManager.undo();
            } else {
                boolean undone;
                do {
                    undone = false;
                    Iterator it = this.managers.iterator();
                    while (it.hasNext()) {
                        PropertiesEditorSupport.UndoRedoStampFlagManager manager = (PropertiesEditorSupport.UndoRedoStampFlagManager)((Object)it.next());
                        if (!atomicFlag.equals(manager.getAtomicFlagOfEditToBeUndone())) continue;
                        manager.undo();
                        undone = true;
                    }
                } while (undone);
            }
        }

        public synchronized void redo() throws CannotRedoException {
            PropertiesEditorSupport.UndoRedoStampFlagManager chosenManager = (PropertiesEditorSupport.UndoRedoStampFlagManager)this.getNextRedo();
            if (chosenManager == null) {
                throw new CannotRedoException();
            }
            Object atomicFlag = chosenManager.getAtomicFlagOfEditToBeRedone();
            if (atomicFlag == null) {
                chosenManager.redo();
            } else {
                boolean redone;
                do {
                    redone = false;
                    Iterator it = this.managers.iterator();
                    while (it.hasNext()) {
                        PropertiesEditorSupport.UndoRedoStampFlagManager manager = (PropertiesEditorSupport.UndoRedoStampFlagManager)((Object)it.next());
                        if (!atomicFlag.equals(manager.getAtomicFlagOfEditToBeRedone())) continue;
                        manager.redo();
                        redone = true;
                    }
                } while (redone);
            }
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public synchronized String getUndoPresentationName() {
            UndoRedo chosenManager = this.getNextUndo();
            if (chosenManager == null) {
                return "Undo";
            }
            return chosenManager.getUndoPresentationName();
        }

        public synchronized String getRedoPresentationName() {
            UndoRedo chosenManager = this.getNextRedo();
            if (chosenManager == null) {
                return "Redo";
            }
            return chosenManager.getRedoPresentationName();
        }
    }

    public static class PropertiesCloneableTopComponent
    extends CloneableTopComponent {
        private PropertiesDataObject propDataObject;
        private transient PropertyChangeListener dataObjectListener;
        static final long serialVersionUID = 2836248291419024296L;
        static final /* synthetic */ boolean $assertionsDisabled;

        public PropertiesCloneableTopComponent() {
        }

        public PropertiesCloneableTopComponent(PropertiesDataObject propDataObject) {
            this.propDataObject = propDataObject;
            this.initialize();
        }

        public void open() {
            if (this.discard()) {
                return;
            }
            super.open();
        }

        public void requestActive() {
            super.requestActive();
            this.getComponent(0).requestFocusInWindow();
        }

        public boolean canClose() {
            ((BundleEditPanel)this.getComponent(0)).stopEditing();
            return super.canClose();
        }

        private void initialize() {
            this.initComponents();
            this.setupActions();
            this.setActivatedNodes(new Node[]{this.propDataObject.getNodeDelegate()});
            this.dataObjectListener = new NameUpdater();
            this.propDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.dataObjectListener, (Object)((Object)this.propDataObject)));
            this.updateName();
        }

        private void setupActions() {
            JTable bundleTable = ((BundleEditPanel)this.getComponent(0)).getTable();
            CallbackSystemAction findAction = (CallbackSystemAction)SystemAction.get((Class)(class$org$openide$actions$FindAction == null ? (class$org$openide$actions$FindAction = PropertiesOpen.class$("org.openide.actions.FindAction")) : class$org$openide$actions$FindAction));
            FindPerformer action = FindPerformer.getFindPerformer(bundleTable);
            this.getActionMap().put(findAction.getActionMapKey(), action);
        }

        private void updateName() {
            if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                throw new AssertionError();
            }
            String name = this.propDataObject.getName();
            String displayName = this.displayName();
            String htmlDisplayName = this.htmlDisplayName();
            String toolTip = this.messageToolTip();
            Enumeration en = this.getReference().getComponents();
            while (en.hasMoreElements()) {
                TopComponent tc = (TopComponent)en.nextElement();
                tc.setName(name);
                tc.setDisplayName(displayName);
                tc.setHtmlDisplayName(htmlDisplayName);
                tc.setToolTipText(toolTip);
            }
        }

        private void updateDisplayName() {
            if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                throw new AssertionError();
            }
            String displayName = this.displayName();
            String htmlDisplayName = this.htmlDisplayName();
            Enumeration en = this.getReference().getComponents();
            while (en.hasMoreElements()) {
                TopComponent tc = (TopComponent)en.nextElement();
                tc.setDisplayName(displayName);
                tc.setHtmlDisplayName(htmlDisplayName);
            }
        }

        private String addModifiedInfo(String name) {
            boolean modified = this.propDataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PropertiesOpen.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) != null;
            int version = modified ? 1 : 3;
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$properties$PropertiesOpen$PropertiesCloneableTopComponent == null ? (class$org$netbeans$modules$properties$PropertiesOpen$PropertiesCloneableTopComponent = PropertiesOpen.class$("org.netbeans.modules.properties.PropertiesOpen$PropertiesCloneableTopComponent")) : class$org$netbeans$modules$properties$PropertiesOpen$PropertiesCloneableTopComponent), (String)"LBL_EditorName", (Object)new Integer(version), (Object)name);
        }

        private String displayName() {
            String nameBase = this.propDataObject.getNodeDelegate().getDisplayName();
            return this.addModifiedInfo(nameBase);
        }

        private String htmlDisplayName() {
            Node node = this.propDataObject.getNodeDelegate();
            String displayName = node.getHtmlDisplayName();
            if (displayName != null) {
                if (!displayName.startsWith("<html>")) {
                    displayName = "<html>" + displayName;
                }
            } else {
                displayName = node.getDisplayName();
            }
            return this.addModifiedInfo(displayName);
        }

        private String messageToolTip() {
            FileObject fo = this.propDataObject.getPrimaryFile();
            return FileUtil.getFileDisplayName((FileObject)fo);
        }

        protected boolean closeLast() {
            if (!this.propDataObject.getOpenSupport().canClose()) {
                return false;
            }
            this.propDataObject.getOpenSupport().closeDocuments();
            return true;
        }

        protected CloneableTopComponent createClonedObject() {
            return new PropertiesCloneableTopComponent(this.propDataObject);
        }

        public Image getIcon() {
            return Utilities.loadImage((String)"org/netbeans/modules/properties/propertiesEditorMode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.modifying");
        }

        protected String preferredID() {
            return this.getName();
        }

        public int getPersistenceType() {
            return 1;
        }

        public UndoRedo getUndoRedo() {
            return this.propDataObject.getOpenSupport().getUndoRedo();
        }

        private void initComponents() {
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridwidth = 0;
            BundleEditPanel panel = new BundleEditPanel(this.propDataObject, new PropertiesTableModel(this.propDataObject.getBundleStructure()));
            gridbag.setConstraints(panel, c);
            this.add(panel);
        }

        private boolean discard() {
            return this.propDataObject == null;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeObject((Object)this.propDataObject);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.propDataObject = (PropertiesDataObject)((Object)in.readObject());
            this.initialize();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$properties$PropertiesOpen == null ? (class$org$netbeans$modules$properties$PropertiesOpen = PropertiesOpen.class$("org.netbeans.modules.properties.PropertiesOpen")) : class$org$netbeans$modules$properties$PropertiesOpen).desiredAssertionStatus();
        }

        final class NameUpdater
        implements PropertyChangeListener,
        FileStatusListener,
        Runnable {
            private static final int NO_ACTION = 0;
            private static final int ACTION_UPDATE_NAME = 1;
            private static final int ACTION_UPDATE_DISPLAY_NAME = 2;
            private FileStatusListener weakL;
            private FileSystem previous;
            private final int action;
            static final /* synthetic */ boolean $assertionsDisabled;

            NameUpdater() {
                this(0);
                this.updateStatusListener();
            }

            NameUpdater(int action) {
                this.action = action;
            }

            private void updateStatusListener() {
                if (this.previous != null) {
                    this.previous.removeFileStatusListener(this.weakL);
                }
                try {
                    this.previous = PropertiesCloneableTopComponent.this.propDataObject.getPrimaryFile().getFileSystem();
                    if (this.weakL == null) {
                        this.weakL = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)this.previous);
                    }
                    this.previous.addFileStatusListener(this.weakL);
                }
                catch (FileStateInvalidException ex) {
                    this.previous = null;
                }
            }

            public void annotationChanged(FileStatusEvent ev) {
                if (!ev.isNameChange()) {
                    return;
                }
                boolean thisChanged = false;
                Iterator it = PropertiesCloneableTopComponent.this.propDataObject.files().iterator();
                while (it.hasNext()) {
                    FileObject fo = (FileObject)it.next();
                    if (!ev.hasChanged(fo)) continue;
                    thisChanged = true;
                    break;
                }
                if (thisChanged) {
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(2));
                }
            }

            public void propertyChange(PropertyChangeEvent e) {
                if (!PropertiesCloneableTopComponent.this.propDataObject.isValid()) {
                    return;
                }
                String property = e.getPropertyName();
                if (property == null) {
                    return;
                }
                if (property.equals("name")) {
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(1));
                } else if (property.equals("primaryFile")) {
                    this.updateStatusListener();
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(1));
                } else if (property.equals("cookie") || property.equals("files")) {
                    Mutex.EVENT.writeAccess((Runnable)new NameUpdater(2));
                }
            }

            public void run() {
                if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
                    throw new AssertionError();
                }
                if (this.action == 1) {
                    PropertiesCloneableTopComponent.this.updateName();
                } else if (this.action == 2) {
                    PropertiesCloneableTopComponent.this.updateDisplayName();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$properties$PropertiesOpen == null ? (class$org$netbeans$modules$properties$PropertiesOpen = PropertiesOpen.class$("org.netbeans.modules.properties.PropertiesOpen")) : class$org$netbeans$modules$properties$PropertiesOpen).desiredAssertionStatus();
            }
        }
    }

    public class PropertiesOpenAt
    implements OpenCookie {
        private PropertiesFileEntry entry;
        private String key;

        PropertiesOpenAt(PropertiesFileEntry entry, String key) {
            this.entry = entry;
            this.key = key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void open() {
            final PropertiesCloneableTopComponent editor = (PropertiesCloneableTopComponent)PropertiesOpen.super.openCloneableTopComponent();
            editor.requestActive();
            BundleStructure bs = PropertiesOpen.this.propDataObject.getBundleStructure();
            int entryIndex = bs.getEntryIndexByFileName(this.entry.getFile().getName());
            int rowIndex = bs.getKeyIndexByName(this.key);
            if (entryIndex != -1 && rowIndex != -1) {
                final int row = rowIndex;
                final int column = entryIndex + 1;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Rectangle cellRect;
                        JTable table = ((BundleEditPanel)editor.getComponent(0)).getTable();
                        if (table.getAutoscrolls() && (cellRect = table.getCellRect(row, column, false)) != null) {
                            table.scrollRectToVisible(cellRect);
                        }
                        table.getColumnModel().getSelectionModel().setSelectionInterval(row, column);
                        table.getSelectionModel().setSelectionInterval(row, column);
                        table.editCellAt(row, column);
                    }
                });
            }
        }
    }

    private final class ModifiedListener
    implements SaveCookie,
    PropertyChangeListener {
        private ModifiedListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource().equals((Object)PropertiesOpen.this.propDataObject)) {
                ((CompoundUndoRedoManager)PropertiesOpen.this.getUndoRedo()).reset(PropertiesOpen.this.propDataObject);
            }
            if (evt.getSource() == PropertiesOpen.this.propDataObject && "modified".equals(evt.getPropertyName())) {
                if (((Boolean)evt.getNewValue()).booleanValue()) {
                    this.addSaveCookie();
                } else {
                    this.removeSaveCookie();
                }
            }
        }

        public void save() throws IOException {
            PropertiesOpen.this.stopEditing();
            this.saveDocument();
        }

        public void saveDocument() throws IOException {
            PropertiesFileEntry pfe = (PropertiesFileEntry)PropertiesOpen.this.propDataObject.getPrimaryEntry();
            SaveCookie save = (SaveCookie)pfe.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PropertiesOpen.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie);
            if (save != null) {
                save.save();
            }
            Iterator it = PropertiesOpen.this.propDataObject.secondaryEntries().iterator();
            while (it.hasNext()) {
                save = (SaveCookie)((PropertiesFileEntry)((Object)it.next())).getCookie(class$org$openide$cookies$SaveCookie == null ? PropertiesOpen.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
                if (save == null) continue;
                save.save();
            }
        }

        private void addSaveCookie() {
            if (PropertiesOpen.this.propDataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PropertiesOpen.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == null) {
                PropertiesOpen.this.propDataObject.getCookieSet0().add((Node.Cookie)this);
            }
        }

        private void removeSaveCookie() {
            if (PropertiesOpen.this.propDataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? (class$org$openide$cookies$SaveCookie = PropertiesOpen.class$("org.openide.cookies.SaveCookie")) : class$org$openide$cookies$SaveCookie) == this) {
                PropertiesOpen.this.propDataObject.getCookieSet0().remove((Node.Cookie)this);
            }
        }
    }

    private static class Environment
    implements CloneableOpenSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -1934890789745432531L;
        private DataObject dataObject;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;

        public Environment(PropertiesDataObject dataObject) {
            this.dataObject = dataObject;
            dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)dataObject)));
            dataObject.addVetoableChangeListener(WeakListeners.vetoableChange((VetoableChangeListener)this, (Object)((Object)dataObject)));
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.prop().addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.prop().removePropertyChangeListener(l);
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
            this.veto().addVetoableChangeListener(l);
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
            this.veto().removeVetoableChangeListener(l);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.dataObject.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = PropertiesOpen.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
        }

        public boolean isValid() {
            return this.dataObject.isValid();
        }

        public boolean isModified() {
            return this.dataObject.isModified();
        }

        public void markModified() throws IOException {
            this.dataObject.setModified(true);
        }

        public void unmarkModified() {
            this.dataObject.setModified(false);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("modified".equals(evt.getPropertyName())) {
                if (this.dataObject.isModified()) {
                    this.dataObject.addVetoableChangeListener((VetoableChangeListener)this);
                } else {
                    this.dataObject.removeVetoableChangeListener((VetoableChangeListener)this);
                }
            } else if ("valid".equals(evt.getPropertyName())) {
                if (Boolean.FALSE.equals(evt.getOldValue())) {
                    return;
                }
                PropertiesOpen support = (PropertiesOpen)this.findCloneableOpenSupport();
                if (support != null) {
                    this.unmarkModified();
                    support.close(false);
                }
            } else {
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            this.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }

        private void firePropertyChange(String name, Object oldValue, Object newValue) {
            this.prop().firePropertyChange(name, oldValue, newValue);
        }

        private void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
            this.veto().fireVetoableChange(name, oldValue, newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            if (this.propSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.propSupp == null) {
                        this.propSupp = new PropertyChangeSupport(this);
                    }
                }
            }
            return this.propSupp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            if (this.vetoSupp == null) {
                Environment environment = this;
                synchronized (environment) {
                    if (this.vetoSupp == null) {
                        this.vetoSupp = new VetoableChangeSupport(this);
                    }
                }
            }
            return this.vetoSupp;
        }
    }
}

