/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.ui;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.spi.ui.RefactoringAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.RefactoringPanel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public abstract class AbstractRefactoringAction
extends NodeAction
implements RefactoringAction,
Runnable {
    private Node[] activatedNodes;
    private int caretPosition;
    private int startSelectionPosition;
    private int endSelectionPosition;
    private static DelegateTextAction delegate = new DelegateTextAction();
    private boolean invokedExternally = false;

    public AbstractRefactoringAction(String name, Icon icon) {
        this.setName(name);
        this.setIcon(icon);
    }

    public final String getName() {
        return (String)this.getValue("Name");
    }

    protected void setName(String name) {
        this.putValue("Name", name);
    }

    protected void setMnemonic(char m) {
        this.putValue("MnemonicKey", new Integer(m));
    }

    public final void performAction(final Node[] n) {
        Runnable r = new Runnable(){

            public void run() {
                AbstractRefactoringAction.this.processContext(n, delegate.getTextComponent());
                AbstractRefactoringAction.this.run();
            }
        };
        JavaMetamodel.getManager().invokeAfterScanFinished(r, AbstractRefactoringAction.trim(this.getName()));
    }

    public void actionPerformed(ActionEvent ev) {
        if (ev == RefactoringActionsFactory.DEFAULT_EVENT) {
            this.invokedExternally = true;
        }
        AbstractRefactoringAction.super.actionPerformed(ev);
        if (ev == RefactoringActionsFactory.DEFAULT_EVENT) {
            this.invokedExternally = false;
        }
    }

    private static String trim(String arg) {
        arg = Utilities.replaceString((String)arg, (String)"&", (String)"");
        return Utilities.replaceString((String)arg, (String)"...", (String)"");
    }

    protected abstract boolean enabled(Node[] var1);

    protected abstract RefactoringUI createRefactoringUI(Node[] var1, Element var2);

    protected RefactoringUI createRefactoringUI(Element selectedElement, int startOffset, int endOffset) {
        return this.createRefactoringUI(this.activatedNodes, selectedElement);
    }

    public final void processContext(Node[] activatedNodes, JTextComponent textComponent) {
        this.activatedNodes = activatedNodes;
        this.setCaretPosition(textComponent);
        boolean e = this.enabled(activatedNodes);
        this.setEnabled(e);
    }

    private void setCaretPosition(JTextComponent textComponent) {
        JEditorPane pane;
        TopComponent activetc;
        EditorCookie ec;
        this.caretPosition = -1;
        if (this.activatedNodes == null || textComponent == null || this.invokedExternally) {
            return;
        }
        DataObject dobj = (DataObject)this.activatedNodes[0].getCookie(DataObject.class);
        if (dobj != null && (ec = (EditorCookie)dobj.getCookie(EditorCookie.class)) != null && (activetc = TopComponent.getRegistry().getActivated()) instanceof CloneableEditorSupport.Pane && textComponent.equals(pane = ((CloneableEditorSupport.Pane)activetc).getEditorPane())) {
            this.caretPosition = textComponent.getCaretPosition();
            this.startSelectionPosition = textComponent.getSelectionStart();
            this.endSelectionPosition = textComponent.getSelectionEnd();
            if (this.startSelectionPosition != this.endSelectionPosition && this.endSelectionPosition == this.caretPosition) {
                --this.caretPosition;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Element selectedElement = null;
        MDRepository rep = JavaModel.getJavaRepository();
        RefactoringUI ui = null;
        rep.beginTrans(true);
        try {
            if (this.caretPosition != -1) {
                DataObject dobj = (DataObject)this.activatedNodes[0].getCookie(DataObject.class);
                while (dobj instanceof DataShadow) {
                    dobj = ((DataShadow)dobj).getOriginal();
                }
                FileObject fo = dobj.getPrimaryFile();
                JavaModel.setClassPath((FileObject)fo);
                selectedElement = JavaMetamodel.getManager().getElementByOffset(fo, this.caretPosition);
                if (selectedElement != null && this.startSelectionPosition != this.endSelectionPosition) {
                    ui = this.createRefactoringUI(selectedElement, this.startSelectionPosition, this.endSelectionPosition);
                }
            }
            if (ui == null) {
                ui = this.createRefactoringUI(this.activatedNodes, selectedElement);
            }
        }
        finally {
            rep.endTrans();
        }
        TopComponent activetc = TopComponent.getRegistry().getActivated();
        if (activetc instanceof CloneableEditorSupport.Pane) {
            new RefactoringPanel(ui, activetc);
        } else {
            new RefactoringPanel(ui);
        }
    }

    public boolean enable(Node[] a) {
        return this.enabled(a);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if ("enabled".equals(name)) {
            if (newValue != null) {
                super.firePropertyChange(name, oldValue, newValue);
            }
        } else {
            super.firePropertyChange(name, oldValue, newValue);
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private static final class DelegateTextAction
    extends TextAction {
        public DelegateTextAction() {
            super("");
        }

        public void actionPerformed(ActionEvent a) {
        }

        public JTextComponent getTextComponent() {
            return this.getFocusedComponent();
        }
    }
}

