/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.LocalVariable;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class UseSuperTypeRefactoringPlugin
extends JavaRefactoringPlugin {
    private final UseSuperTypeRefactoring refactoring;
    private final RenameRefactoring renameRefactoring = null;
    private final Logger log = Logger.getLogger("org.netbeans.modules.refactoring.plugins");
    private ErrorManager errMngr = ErrorManager.getDefault();
    private static final float ONE_DOT_FIVE = 1.5f;

    public UseSuperTypeRefactoringPlugin(UseSuperTypeRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Collection subClassUsages;
        JavaClass superType = this.refactoring.getTargetSuperType();
        String superTypeName = superType.getName();
        JavaClass subClass = (JavaClass)this.refactoring.getTypeElement();
        this.fireProgressListenerStart(3, 1);
        try {
            subClassUsages = subClass.getReferences();
        }
        finally {
            this.fireProgressListenerStop();
        }
        Iterator iterator = subClassUsages.iterator();
        this.fireProgressListenerStart(3, subClassUsages.size());
        try {
            while (iterator.hasNext()) {
                boolean accessible;
                Element surroundingComposite;
                ElementReference referringElement = (ElementReference)iterator.next();
                Element subTypeReferrer = (Element)referringElement.refImmediateComposite();
                boolean isValidElement = false;
                if (subTypeReferrer instanceof Method) {
                    FileObject referringFileObject;
                    String srcLevelStr;
                    Method methodWithSubType = (Method)subTypeReferrer;
                    TypeReference retTypeRef = methodWithSubType.getTypeName();
                    boolean isReturnTypeSubClass = retTypeRef.getElement().equals(subClass);
                    if (isReturnTypeSubClass && Float.parseFloat(srcLevelStr = SourceLevelQuery.getSourceLevel((FileObject)(referringFileObject = JavaModel.getFileObject((Resource)subTypeReferrer.getResource())))) >= 1.5f) {
                        Collection overriddenMethods = JavaModelUtil.getOverriddenMethods((Method)methodWithSubType);
                        Iterator ovrmIterator = overriddenMethods.iterator();
                        boolean compatibleRetType = true;
                        while (ovrmIterator.hasNext() && compatibleRetType) {
                            Method superMethod = (Method)ovrmIterator.next();
                            JavaClass returnType = (JavaClass)superMethod.getType();
                            compatibleRetType = CheckUtils.isSubTypeOf(superType, returnType);
                        }
                        isValidElement = compatibleRetType;
                    }
                } else if (subTypeReferrer instanceof Variable) {
                    isValidElement = this.checkValidInvocations(superType, ((Variable)subTypeReferrer).getReferences());
                } else if (subTypeReferrer instanceof LocalVarDeclaration) {
                    List localVarList = ((LocalVarDeclaration)subTypeReferrer).getVariables();
                    Iterator locVarIterator = localVarList.iterator();
                    boolean validLocVarUsage = true;
                    while (locVarIterator.hasNext() && validLocVarUsage) {
                        LocalVariable locVar = (LocalVariable)locVarIterator.next();
                        validLocVarUsage = this.checkValidInvocations(superType, locVar.getReferences());
                    }
                    isValidElement = validLocVarUsage;
                }
                if (!isValidElement) {
                    this.fireProgressListenerStep();
                    continue;
                }
                for (surroundingComposite = subTypeReferrer; surroundingComposite != null && !(surroundingComposite instanceof JavaClass) && !surroundingComposite.equals(surroundingComposite.refImmediateComposite()); surroundingComposite = (Element)surroundingComposite.refImmediateComposite()) {
                }
                if (surroundingComposite != null && !(accessible = CheckUtils.isAccessible((ClassDefinition)this.refactoring.getTargetSuperType(), (JavaClass)surroundingComposite))) {
                    String errorMsg = NbBundle.getMessage((Class)UseSuperTypeRefactoringPlugin.class, (String)"TXT_UseSuperTypeProblem", (Object)this.refactoring.getTargetSuperType().getSimpleName(), (Object)surroundingComposite);
                    Problem problem = new Problem(false, errorMsg);
                    return problem;
                }
                refactoringElements.add(this.refactoring, new UseSuperTypeElement(subTypeReferrer, superType));
                this.fireProgressListenerStep();
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    public Problem preCheck() {
        Element subType = this.refactoring.getTypeElement();
        if (!(subType instanceof JavaClass)) {
            String errMsg = NbBundle.getMessage((Class)UseSuperTypeRefactoringPlugin.class, (String)"ERR_UseSuperType_InvalidElement");
            return new Problem(true, errMsg);
        }
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.refactoring.getTargetSuperType() == null) {
            return new Problem(true, NbBundle.getMessage((Class)UseSuperTypeRefactoringPlugin.class, (String)"ERR_UseSuperTypeNoSuperType"));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    private Problem checkSuperTypeVisibility(Resource resource) {
        JavaModelPackage pkg = (JavaModelPackage)resource.refImmediatePackage();
        return null;
    }

    private boolean checkValidInvocations(JavaClass superType, Collection variableUsages) {
        boolean safeInvocationsOnSuper = true;
        Iterator varReferences = variableUsages.iterator();
        while (varReferences.hasNext()) {
            ElementReference varReferrer = (ElementReference)varReferences.next();
            Element varReferrerComposite = (Element)varReferrer.refImmediateComposite();
            if (!(varReferrerComposite instanceof MethodInvocation)) continue;
            Method method = (Method)((MethodInvocation)varReferrerComposite).getElement();
            List params = method.getParameters();
            ArrayList<Type> paramTypes = new ArrayList<Type>(params.size());
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                paramTypes.add(((Parameter)iter.next()).getType());
            }
            if (superType.getMethod(method.getName(), paramTypes, true) != null) continue;
            safeInvocationsOnSuper = false;
            break;
        }
        return safeInvocationsOnSuper;
    }

    private class UseSuperTypeElement
    extends SimpleRefactoringElementImpl {
        private final Element targetElement;
        private final JavaClass targetType;
        private String text;

        public UseSuperTypeElement(Element sourceElement, JavaClass targetType) {
            this.targetElement = sourceElement;
            this.targetType = targetType;
            if (sourceElement instanceof Variable) {
                this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin = UseSuperTypeRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.UseSuperTypeRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin), (String)"TXT_UseSuperTypeVariable", (Object)((Variable)sourceElement).getName(), (Object)targetType.getSimpleName());
            } else if (sourceElement instanceof Method) {
                this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin = UseSuperTypeRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.UseSuperTypeRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin), (String)"TXT_UseSuperTypeReturnType", (Object)((Method)sourceElement).getName(), (Object)targetType.getSimpleName());
            } else if (sourceElement instanceof LocalVarDeclaration) {
                String variableNames = this.getLocalVariables((LocalVarDeclaration)sourceElement);
                this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin = UseSuperTypeRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.UseSuperTypeRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$UseSuperTypeRefactoringPlugin), (String)"TXT_UseSuperTypeLocalVar", (Object)variableNames, (Object)targetType.getSimpleName());
            }
        }

        public void performChange() {
            if (this.targetElement instanceof Method) {
                MultipartId typeRef = JavaModelUtil.resolveImportsForClass((Element)((Element)this.targetElement.refImmediateComposite()), (JavaClass)this.targetType);
                Method method = (Method)this.targetElement;
                method.setTypeName((TypeReference)typeRef);
            } else if (this.targetElement instanceof Variable) {
                Variable param = (Variable)this.targetElement;
                MultipartId typeRef = JavaModelUtil.resolveImportsForClass((Element)((Element)this.targetElement.refImmediateComposite()), (JavaClass)this.targetType);
                param.setTypeName((TypeReference)typeRef);
            } else if (this.targetElement instanceof LocalVarDeclaration) {
                LocalVarDeclaration localVar = (LocalVarDeclaration)this.targetElement;
                MultipartId typeRef = JavaModelUtil.resolveImportsForClass((Element)((Element)this.targetElement.refImmediateComposite()), (JavaClass)this.targetType);
                localVar.setTypeName((TypeReference)typeRef);
            } else {
                ErrorManager.getDefault().log(16, "UseSupertype cannot associateany specific type with " + this.targetElement);
            }
        }

        public String getText() {
            return this.text;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition(this.targetElement);
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.targetElement.getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)this.targetElement);
        }

        public String getDisplayText() {
            return this.getText();
        }

        private String getLocalVariables(LocalVarDeclaration sourceElement) {
            Iterator declaredVarIterator = sourceElement.getVariables().iterator();
            int numVars = 0;
            StringBuffer localVarBuffer = new StringBuffer();
            while (declaredVarIterator.hasNext() && numVars < 2) {
                localVarBuffer.append(((NamedElement)declaredVarIterator.next()).getName());
                if (declaredVarIterator.hasNext() && ++numVars < 2) {
                    localVarBuffer.append(", ");
                    continue;
                }
                if (numVars != 2 || !declaredVarIterator.hasNext()) continue;
                localVarBuffer.append("...");
            }
            String variableNames = localVarBuffer.toString();
            return variableNames;
        }
    }
}

