/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.ConstructorInvocation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.ExpressionStatement;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.Operator;
import org.netbeans.jmi.javamodel.OperatorEnum;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimaryExpression;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.ThisExpressionClass;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.jmi.javamodel.VariableAccessClass;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.WhereUsedElement;
import org.netbeans.modules.refactoring.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InnerToOuterRefactoringPlugin
extends JavaRefactoringPlugin {
    private final InnerToOuterRefactoring refactoring;
    private Collection outerReferences;
    private Collection multipartIds;

    InnerToOuterRefactoringPlugin(InnerToOuterRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            JavaClass sourceType = this.refactoring.getSourceType();
            if (sourceType == null) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
                return problem;
            }
            Problem result = InnerToOuterRefactoringPlugin.isElementAvail((Element)sourceType);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (!CheckUtils.isElementInOpenProject((Element)sourceType)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            if (sourceType instanceof UnresolvedClass) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.refactoring.setClassName(sourceType.getSimpleName());
            this.fireProgressListenerStep();
            RefObject declCls = (RefObject)sourceType.refImmediateComposite();
            if (!(declCls instanceof JavaClass) || !InnerToOuterRefactoringPlugin.isNotLocal(declCls)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
                return problem;
            }
            this.fireProgressListenerStep();
            if (Modifier.isStatic(sourceType.getModifiers())) {
                this.fireProgressListenerStep();
            } else {
                HashSet featureSet = new HashSet();
                HashSet innerFeatures = new HashSet();
                this.getFeatureSet((JavaClass)declCls, featureSet, new HashSet());
                this.getFeatureSet(sourceType, innerFeatures, new HashSet());
                featureSet.remove(sourceType);
                this.fireProgressListenerStep();
                this.multipartIds = new ArrayList();
                Collection outerReferences = this.traverseForOuterReferences((Element)sourceType, new ArrayList(), this.multipartIds, featureSet, innerFeatures, (JavaClass)declCls);
                if (!outerReferences.isEmpty()) {
                    this.outerReferences = outerReferences;
                    this.refactoring.setReferenceName(InnerToOuterRefactoringPlugin.firstLower(((JavaClass)declCls).getSimpleName()));
                }
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        String fieldName;
        Problem result = null;
        JavaClass sourceType = this.refactoring.getSourceType();
        String newName = this.refactoring.getClassName();
        if (!Utilities.isJavaIdentifier((String)newName)) {
            result = InnerToOuterRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_InvalidIdentifier", (Object)newName));
            return result;
        }
        Element composite = this.getFutureParent();
        if (composite instanceof Resource) {
            Resource resource = (Resource)composite;
            FileObject primFile = JavaModel.getFileObject((Resource)resource);
            FileObject folder = primFile.getParent();
            FileObject[] children = folder.getChildren();
            for (int x = 0; x < children.length; ++x) {
                if (children[x] == primFile || children[x].isVirtual() || !children[x].getName().equals(newName) || !"java".equals(children[x].getExt())) continue;
                result = InnerToOuterRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_ClassClash", (Object)newName, (Object)resource.getPackageName()));
                return result;
            }
        } else if (((JavaClass)composite).getInnerClass(newName, false) != null) {
            return InnerToOuterRefactoringPlugin.createProblem(null, true, NbBundle.getMessage((Class)InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_ClassNameClash", (Object)newName));
        }
        if ((fieldName = this.refactoring.getReferenceName()) != null) {
            if (!Utilities.isJavaIdentifier((String)fieldName)) {
                result = InnerToOuterRefactoringPlugin.createProblem(result, true, NbBundle.getMessage((Class)RenameRefactoring.class, (String)"ERR_InvalidIdentifier", (Object)fieldName));
                return result;
            }
            if (sourceType.getField(fieldName, false) != null) {
                return InnerToOuterRefactoringPlugin.createProblem(null, true, NbBundle.getMessage((Class)InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_FieldNameClash", (Object)fieldName));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem checkParameters() {
        Problem result = null;
        this.fireProgressListenerStart(2, 3);
        try {
            String fieldName = this.refactoring.getReferenceName();
            if (fieldName != null && this.refactoring.getSourceType().getField(fieldName, true) != null) {
                result = InnerToOuterRefactoringPlugin.createProblem(result, false, NbBundle.getMessage((Class)InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_FieldHidden", (Object)fieldName));
            }
            this.fireProgressListenerStep();
            if (this.refactoring.getReferenceName() == null && this.outerReferences != null) {
                result = InnerToOuterRefactoringPlugin.createProblem(result, false, NbBundle.getMessage((Class)InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_OuterUsed"));
            }
            this.fireProgressListenerStep();
            Element futureParent = this.getFutureParent();
            if (futureParent instanceof JavaClass && ((JavaClass)futureParent).getInnerClass(this.refactoring.getClassName(), true) != null) {
                result = InnerToOuterRefactoringPlugin.createProblem(result, false, NbBundle.getMessage((Class)InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_InnerHidden", (Object)this.refactoring.getClassName()));
            }
            Problem problem = result;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (!this.refactoring.getClassName().equals(this.refactoring.getSourceType().getSimpleName())) {
            refactoringElements.add(this.refactoring, new RenameClassElement());
        }
        if (this.refactoring.getReferenceName() != null) {
            refactoringElements.add(this.refactoring, new AddReferenceElement());
            if (this.outerReferences != null) {
                refactoringElements.addAll(this.refactoring, this.outerReferences);
            }
            Iterator it = this.refactoring.getSourceType().getSubClasses().iterator();
            while (it.hasNext()) {
                JavaClass cls = (JavaClass)it.next();
                Object[] contents = cls.getContents().toArray();
                boolean constructorVisited = false;
                for (int i = 0; i < contents.length; ++i) {
                    Object firstStatement;
                    if (!(contents[i] instanceof Constructor)) continue;
                    constructorVisited = true;
                    Iterator stmts = ((Constructor)contents[i]).getBody().getStatements().iterator();
                    Object v0 = firstStatement = stmts.hasNext() ? stmts.next() : null;
                    if (firstStatement instanceof ConstructorInvocation) {
                        ConstructorInvocation ci = firstStatement;
                        if (!ci.isHasSuper()) continue;
                        refactoringElements.add(this.refactoring, new AddInvocationArgumentElement(ci));
                        continue;
                    }
                    refactoringElements.add(this.refactoring, new AddConstructorInvocationElement((Constructor)contents[i]));
                }
                if (constructorVisited) continue;
                refactoringElements.add(this.refactoring, new AddConstructorElement(cls));
            }
        }
        JavaClass origOuter = (JavaClass)this.refactoring.getSourceType().refImmediateComposite();
        Element parent = this.getFutureParent();
        if (parent instanceof JavaClass) {
            refactoringElements.add(this.refactoring, new MoveInnerToOuterElement((JavaClass)parent));
        } else {
            refactoringElements.add(this.refactoring, new MoveInnerToTopElement(this.refactoring.getSourceType(), this.refactoring.getClassName()));
        }
        if (this.multipartIds != null) {
            refactoringElements.addAll(this.refactoring, this.multipartIds);
        }
        ElementReference[] classReferences = this.refactoring.getSourceType().getReferences().toArray(new ElementReference[0]);
        for (int i = 0; i < classReferences.length; ++i) {
            refactoringElements.add(this.refactoring, new ChangeClassReferenceElement(classReferences[i], origOuter));
        }
        return null;
    }

    private static boolean isNotLocal(RefObject cls) {
        while (cls instanceof JavaClass) {
            cls = (RefObject)cls.refImmediateComposite();
        }
        return cls instanceof Resource;
    }

    private static String firstLower(String text) {
        return text.substring(0, 1).toLowerCase() + text.substring(1);
    }

    private static ClassDefinition getDeclaringClass(Element element) {
        Feature result = JavaModelUtil.getDeclaringFeature((Element)element);
        if (!(result instanceof ClassDefinition)) {
            return result.getDeclaringClass();
        }
        return (ClassDefinition)result;
    }

    private static ClassDefinition getOuter(ClassDefinition classDefinition) {
        Element composite;
        for (composite = (Element)classDefinition.refImmediateComposite(); composite != null && !(composite instanceof ClassDefinition); composite = (Element)composite.refImmediateComposite()) {
        }
        return (ClassDefinition)composite;
    }

    private Collection traverseForOuterReferences(Element element, Collection refactElements, Collection multipartIds, Set featureSet, Set innerFeatures, JavaClass outer) {
        PrimaryExpression parentClass = null;
        boolean check = true;
        if (element instanceof MethodInvocation) {
            parentClass = ((MethodInvocation)element).getParentClass();
        } else if (element instanceof NewClassExpression) {
            parentClass = ((NewClassExpression)element).getEnclosingClass();
        } else if (element instanceof VariableAccess) {
            parentClass = ((VariableAccess)element).getParentClass();
        } else {
            MultipartId mpi;
            NamedElement e;
            if (element instanceof MultipartId && (e = (mpi = (MultipartId)element).getElement()) instanceof JavaClass && featureSet.contains(e = InnerToOuterRefactoringPlugin.unwrap((JavaClass)e)) && !innerFeatures.contains(e)) {
                multipartIds.add(new UpdateMultipartIdElement((MultipartId)element));
            }
            check = false;
        }
        if (check) {
            NamedElement e = ((ElementReference)element).getElement();
            if (e instanceof Constructor) {
                e = (NamedElement)e.refImmediateComposite();
            }
            if (featureSet.contains(e)) {
                MultipartId className;
                Feature feature = (Feature)e;
                ChangeElementReferenceElement re = null;
                if (parentClass == null) {
                    if (!innerFeatures.contains(feature)) {
                        re = new ChangeElementReferenceElement(element);
                    }
                } else if (parentClass instanceof ThisExpression && (className = ((ThisExpression)parentClass).getClassName()) != null && outer.equals(InnerToOuterRefactoringPlugin.unwrap((JavaClass)className.getElement()))) {
                    re = new ChangeElementReferenceElement(element);
                }
                if (re != null) {
                    refactElements.add(re);
                    if (Modifier.isPrivate(feature.getModifiers())) {
                        refactElements.add(new RelaxAccessRightsElement(feature));
                    }
                }
            }
        }
        Iterator it = element.getChildren().iterator();
        while (it.hasNext()) {
            this.traverseForOuterReferences((Element)it.next(), refactElements, multipartIds, featureSet, innerFeatures, outer);
        }
        return refactElements;
    }

    private void getFeatureSet(JavaClass cls, Set features, Set visited) {
        if (cls == null) {
            return;
        }
        if (visited.add(cls = InnerToOuterRefactoringPlugin.unwrap(cls))) {
            features.addAll(cls.getFeatures());
        }
        this.getFeatureSet(cls.getSuperClass(), features, visited);
        Iterator it = cls.getInterfaces().iterator();
        while (it.hasNext()) {
            this.getFeatureSet((JavaClass)it.next(), features, visited);
        }
    }

    private static JavaClass unwrap(JavaClass cls) {
        while (cls instanceof ParameterizedType) {
            cls = ((ParameterizedType)cls).getDefinition();
        }
        return cls;
    }

    private Element getFutureParent() {
        return (Element)((RefObject)this.refactoring.getSourceType().refImmediateComposite()).refImmediateComposite();
    }

    private PrimaryExpression createConstrInvocArgument(ClassDefinition declCls) {
        JavaClass sourceOuter = (JavaClass)this.refactoring.getSourceType().refImmediateComposite();
        while (declCls != null && !declCls.isSubTypeOf((ClassDefinition)sourceOuter)) {
            declCls = InnerToOuterRefactoringPlugin.getOuter(declCls);
        }
        return ((JavaModelPackage)declCls.refImmediatePackage()).getThisExpression().createThisExpression(declCls != null && declCls instanceof JavaClass ? JavaModelUtil.resolveImportsForClass((Element)declCls, (JavaClass)((JavaClass)declCls)) : null);
    }

    private ConstructorInvocation createConstrInvoc(ClassDefinition javaClass) {
        return ((JavaModelPackage)javaClass.refImmediatePackage()).getConstructorInvocation().createConstructorInvocation(null, Collections.singletonList(this.createConstrInvocArgument(javaClass)), true, null);
    }

    private class AddReferenceElement
    extends SimpleRefactoringElementImpl {
        private final String text;
        private final JavaClass parent;

        AddReferenceElement() {
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin = InnerToOuterRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.InnerToOuterRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin), (String)"TXT_InnerToOuter_AddReference", (Object)InnerToOuterRefactoringPlugin.this.refactoring.getReferenceName());
            this.parent = (JavaClass)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().refImmediateComposite();
        }

        public void performChange() {
            JavaClass cls = InnerToOuterRefactoringPlugin.this.refactoring.getSourceType();
            String paramName = InnerToOuterRefactoringPlugin.this.refactoring.getReferenceName();
            JavaModelPackage jmp = (JavaModelPackage)cls.refImmediatePackage();
            MultipartId typeName = JavaModelUtil.resolveImportsForClass((Element)cls, (JavaClass)this.parent);
            Field field = jmp.getField().createField(paramName, null, 18, null, null, true, (TypeReference)typeName, 0, null, null);
            cls.getContents().add(0, field);
            Object[] contents = cls.getContents().toArray(new ClassMember[0]);
            int constructorIndex = -1;
            Parameter param = jmp.getParameter().createParameter(paramName, null, false, (TypeReference)typeName.duplicate(), 0, false);
            ExpressionStatement assignment = jmp.getExpressionStatement().createExpressionStatement((Expression)jmp.getAssignment().createAssignment((PrimaryExpression)jmp.getVariableAccess().createVariableAccess(paramName, (PrimaryExpression)jmp.getThisExpression().createThisExpression(), false), (Operator)OperatorEnum.ASSIGN, (Expression)jmp.getVariableAccess().createVariableAccess(paramName, null, false)));
            boolean constructorVisited = false;
            JavaClass superType = cls.getSuperClass();
            boolean superIsInner = superType.refImmediateComposite() instanceof JavaClass && !Modifier.isStatic(this.parent.getModifiers());
            for (int i = 0; i < contents.length; ++i) {
                if (contents[i] instanceof Constructor) {
                    Object firstStatement;
                    constructorVisited = true;
                    Constructor constr = (Constructor)contents[i];
                    constr.getParameters().add(0, this.duplicateIfNecessary((Element)param));
                    Iterator it = constr.getBody().getStatements().iterator();
                    Object v0 = firstStatement = it.hasNext() ? it.next() : null;
                    if (firstStatement instanceof ConstructorInvocation && ((ConstructorInvocation)firstStatement).getParentClass() == null) {
                        ConstructorInvocation ci = firstStatement;
                        if (ci.isHasSuper()) {
                            if (superIsInner) {
                                ci.setParentClass((PrimaryExpression)jmp.getVariableAccess().createVariableAccess(paramName, null, false));
                            }
                            constr.getBody().getStatements().add(1, this.duplicateIfNecessary((Element)assignment));
                            continue;
                        }
                        ci.getParameters().add(0, jmp.getVariableAccess().createVariableAccess(paramName, null, false));
                        continue;
                    }
                    constr.getBody().getStatements().add(0, this.duplicateIfNecessary((Element)assignment));
                    if (!superIsInner) continue;
                    constr.getBody().getStatements().add(0, jmp.getConstructorInvocation().createConstructorInvocation(null, null, true, (PrimaryExpression)jmp.getVariableAccess().createVariableAccess(paramName, null, false)));
                    continue;
                }
                if (param != null || constructorIndex != -1 || contents[i] instanceof Field || contents[i] instanceof FieldGroup) continue;
                constructorIndex = i;
            }
            if (!constructorVisited) {
                Constructor constr = jmp.getConstructor().createConstructor(null, null, 1, null, null, jmp.getStatementBlock().createStatementBlock(Collections.singletonList(assignment)), null, null, Collections.singletonList(param), null);
                cls.getContents().add(constructorIndex < 0 ? 0 : constructorIndex, constr);
            }
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType());
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType());
        }

        private Element duplicateIfNecessary(Element element) {
            if (element.refImmediateComposite() != null) {
                element = element.duplicate();
            }
            return element;
        }
    }

    private class RenameClassElement
    extends SimpleRefactoringElementImpl {
        private final String text;

        RenameClassElement() {
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin = InnerToOuterRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.InnerToOuterRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin), (String)"TXT_InnerToOuter_Rename", (Object)InnerToOuterRefactoringPlugin.this.refactoring.getClassName());
        }

        public void performChange() {
            InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().setSimpleName(InnerToOuterRefactoringPlugin.this.refactoring.getClassName());
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType());
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType());
        }
    }

    private static class MoveInnerToTopElement
    extends SimpleRefactoringElementImpl {
        private final String text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin = InnerToOuterRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.InnerToOuterRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin), (String)"TXT_InnerToOuter_MoveToTop");
        private final JavaClass sourceType;
        private final String className;
        private FileObject newClsFO;

        MoveInnerToTopElement(JavaClass sourceType, String className) {
            this.sourceType = sourceType;
            this.className = className;
        }

        public void performChange() {
            ExternalChange ec = new ExternalChange(){
                private FileSystem fs;
                private String folderName;

                public void performExternalChange() {
                    try {
                        FileObject folderFO;
                        FileObject tempFO = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Classes/Empty.java");
                        if (this.fs == null) {
                            FileObject sourceFO = JavaModel.getFileObject((Resource)MoveInnerToTopElement.this.sourceType.getResource());
                            folderFO = sourceFO.getParent();
                            this.folderName = folderFO.getPath();
                            this.fs = folderFO.getFileSystem();
                        } else {
                            folderFO = this.fs.findResource(this.folderName);
                        }
                        DataFolder folder = (DataFolder)DataObject.find((FileObject)folderFO);
                        DataObject template = DataObject.find((FileObject)tempFO);
                        DataObject newClsDO = template.createFromTemplate(folder, MoveInnerToTopElement.this.className);
                        MoveInnerToTopElement.this.newClsFO = newClsDO.getPrimaryFile();
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }

                public void undoExternalChange() {
                    try {
                        DataObject newClsDO = DataObject.find((FileObject)MoveInnerToTopElement.this.newClsFO);
                        newClsDO.delete();
                    }
                    catch (DataObjectNotFoundException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    MoveInnerToTopElement.this.newClsFO = null;
                }
            };
            ec.performExternalChange();
            String packageName = this.sourceType.getResource().getPackageName();
            Resource clsResource = JavaModel.getResource((FileObject)this.newClsFO);
            if (packageName != null && packageName.length() > 0) {
                clsResource.setPackageName(packageName);
            }
            ((Element)this.sourceType.refImmediateComposite()).replaceChild((Element)this.sourceType, null);
            this.sourceType.setModifiers(this.sourceType.getModifiers() & 0xFFFFFFF5);
            clsResource.getClassifiers().add(this.sourceType);
            ((MetadataElement)this.sourceType).fixImports((Element)this.sourceType, (Element)this.sourceType);
            JavaMetamodel.getManager().registerUndoElement(ec);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.sourceType.getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)this.sourceType);
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.sourceType);
        }
    }

    private class MoveInnerToOuterElement
    extends SimpleRefactoringElementImpl {
        private final String text;
        private final JavaClass parent;

        MoveInnerToOuterElement(JavaClass parent) {
            this.parent = parent;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin = InnerToOuterRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.InnerToOuterRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin), (String)"TXT_InnerToOuter_MoveToOuter", (Object)UIUtilities.getDisplayText((NamedElement)parent));
        }

        public void performChange() {
            JavaClass cls = InnerToOuterRefactoringPlugin.this.refactoring.getSourceType();
            ((Element)cls.refImmediateComposite()).replaceChild((Element)cls, null);
            this.parent.getContents().add(cls);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType());
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType());
        }
    }

    private class AddConstructorElement
    extends SimpleRefactoringElementImpl {
        private final String text;
        private final JavaClass parent;

        AddConstructorElement(JavaClass parent) {
            this.parent = parent;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin = InnerToOuterRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.InnerToOuterRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin), (String)"TXT_InnerToOuter_AddConstructor");
        }

        public void performChange() {
            JavaModelPackage jmp = (JavaModelPackage)this.parent.refImmediatePackage();
            Constructor constructor = jmp.getConstructor().createConstructor(null, null, 1, null, null, jmp.getStatementBlock().createStatementBlock(Collections.singletonList(InnerToOuterRefactoringPlugin.this.createConstrInvoc((ClassDefinition)this.parent))), null, null, null, null);
            int constructorIndex = -1;
            Object[] contents = this.parent.getContents().toArray();
            for (int i = 0; i < contents.length; ++i) {
                if (constructorIndex != -1 || contents[i] instanceof Field || contents[i] instanceof FieldGroup) continue;
                constructorIndex = i;
                break;
            }
            this.parent.getContents().add(constructorIndex < 0 ? 0 : constructorIndex, constructor);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.parent.getResource());
        }

        public Element getJavaElement() {
            return this.parent;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.parent);
        }
    }

    private class AddConstructorInvocationElement
    extends SimpleRefactoringElementImpl {
        private final String text;
        private final Constructor constr;

        AddConstructorInvocationElement(Constructor constr) {
            this.constr = constr;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin = InnerToOuterRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.InnerToOuterRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin), (String)"TXT_InnerToOuter_AddConstructorInvocation");
        }

        public void performChange() {
            this.constr.getBody().getStatements().add(0, InnerToOuterRefactoringPlugin.this.createConstrInvoc(this.constr.getDeclaringClass()));
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.constr.getResource());
        }

        public Element getJavaElement() {
            return this.constr;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.constr);
        }
    }

    private class RelaxAccessRightsElement
    extends SimpleRefactoringElementImpl {
        private final String text;
        private final Feature feature;

        RelaxAccessRightsElement(Feature feature) {
            this.feature = feature;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin = InnerToOuterRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.InnerToOuterRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$InnerToOuterRefactoringPlugin), (String)"TXT_InnerToOuter_RelaxAccessRights");
        }

        public void performChange() {
            this.feature.setModifiers(this.feature.getModifiers() & 0xFFFFFFFD);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.feature.getResource());
        }

        public Element getJavaElement() {
            return this.feature;
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.feature);
        }
    }

    private class ChangeClassReferenceElement
    extends WhereUsedElement {
        private final JavaClass origOuter;

        ChangeClassReferenceElement(ElementReference elementReference, JavaClass origOuter) {
            super((RefObject)JavaModelUtil.getDeclaringFeature((Element)elementReference), (Element)elementReference);
            this.origOuter = origOuter;
        }

        public void performChange() {
            Element composite = (Element)this.feature.refImmediateComposite();
            if (composite instanceof Import) {
                composite.refDelete();
            } else {
                if (composite instanceof NewClassExpression && ((NewClassExpression)composite).getClassName().equals(this.feature) && InnerToOuterRefactoringPlugin.this.refactoring.getReferenceName() != null) {
                    NewClassExpression nce = (NewClassExpression)composite;
                    PrimaryExpression enclosing = nce.getEnclosingClass();
                    if (enclosing != null) {
                        nce.setEnclosingClass(null);
                        nce.getParameters().add(0, enclosing);
                    } else {
                        JavaModelPackage jmp = (JavaModelPackage)this.feature.refImmediatePackage();
                        boolean needOuter = false;
                        ClassDefinition outer = JavaModelUtil.getDeclaringFeature((Element)nce).getDeclaringClass();
                        while (outer != null && !this.isAcceptableClass(outer)) {
                            needOuter = true;
                            outer = InnerToOuterRefactoringPlugin.getOuter(outer);
                        }
                        VariableAccessClass vac = jmp.getVariableAccess();
                        ThisExpressionClass tec = jmp.getThisExpression();
                        if (InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().equals(outer)) {
                            ThisExpression te = tec.createThisExpression(needOuter ? jmp.getMultipartId().createMultipartId(InnerToOuterRefactoringPlugin.this.refactoring.getClassName(), null, null) : null);
                            nce.getParameters().add(0, vac.createVariableAccess(InnerToOuterRefactoringPlugin.this.refactoring.getReferenceName(), (PrimaryExpression)te, false));
                        } else {
                            nce.getParameters().add(0, tec.createThisExpression(needOuter && outer instanceof JavaClass ? JavaModelUtil.resolveImportsForClass((Element)nce, (JavaClass)((JavaClass)outer)) : null));
                        }
                    }
                }
                composite.replaceChild(this.feature, (Element)JavaModelUtil.resolveImportsForClass((Element)composite, (JavaClass)InnerToOuterRefactoringPlugin.this.refactoring.getSourceType()));
            }
        }

        private boolean isAcceptableClass(ClassDefinition cls) {
            return InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().equals(cls) || cls.isSubTypeOf((ClassDefinition)this.origOuter);
        }
    }

    private class ChangeElementReferenceElement
    extends WhereUsedElement {
        ChangeElementReferenceElement(Element elementReference) {
            super((RefObject)JavaModelUtil.getDeclaringFeature((Element)elementReference), elementReference);
        }

        public void performChange() {
            JavaModelPackage jmp = (JavaModelPackage)this.feature.refImmediatePackage();
            VariableAccessClass vac = jmp.getVariableAccess();
            ClassDefinition cd = InnerToOuterRefactoringPlugin.getDeclaringClass(this.feature);
            ThisExpression te = jmp.getThisExpression().createThisExpression(InnerToOuterRefactoringPlugin.this.refactoring.getSourceType().equals(cd) ? null : jmp.getMultipartId().createMultipartId(InnerToOuterRefactoringPlugin.this.refactoring.getClassName(), null, null));
            VariableAccess va = vac.createVariableAccess(InnerToOuterRefactoringPlugin.this.refactoring.getReferenceName(), (PrimaryExpression)te, false);
            if (this.feature instanceof MethodInvocation) {
                ((MethodInvocation)this.feature).setParentClass((PrimaryExpression)va);
            } else if (this.feature instanceof NewClassExpression) {
                ((NewClassExpression)this.feature).setEnclosingClass((PrimaryExpression)va);
            } else {
                ((VariableAccess)this.feature).setParentClass((PrimaryExpression)va);
            }
        }
    }

    private class UpdateMultipartIdElement
    extends WhereUsedElement {
        UpdateMultipartIdElement(MultipartId mpi) {
            super((RefObject)JavaModelUtil.getDeclaringFeature((Element)mpi), (Element)mpi);
        }

        public void performChange() {
            Element parent = (Element)this.feature.refImmediateComposite();
            parent.replaceChild(this.feature, (Element)JavaModelUtil.resolveImportsForClass((Element)this.feature, (JavaClass)((JavaClass)((MultipartId)this.feature).getElement())));
        }
    }

    private class AddInvocationArgumentElement
    extends WhereUsedElement {
        AddInvocationArgumentElement(ConstructorInvocation ci) {
            super((RefObject)JavaModelUtil.getDeclaringFeature((Element)ci), (Element)ci);
        }

        public void performChange() {
            JavaModelPackage jmp = (JavaModelPackage)this.feature.refImmediatePackage();
            ConstructorInvocation ci = (ConstructorInvocation)this.feature;
            PrimaryExpression pe = ci.getParentClass();
            if (pe != null) {
                ci.setParentClass(null);
            } else {
                pe = InnerToOuterRefactoringPlugin.this.createConstrInvocArgument(InnerToOuterRefactoringPlugin.getDeclaringClass(this.feature));
            }
            ci.getParameters().add(0, pe);
        }
    }
}

