/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.client;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.websvc.jaxws.client.JAXWSClientSupportAccessor;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportProvider;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class JAXWSClientSupport {
    public static final String WSCLIENTUPTODATE_CLASSPATH = "wsclientuptodate.classpath";
    private JAXWSClientSupportImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesClientSupportProvider.class));

    private JAXWSClientSupport(JAXWSClientSupportImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static JAXWSClientSupport getJaxWsClientSupport(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to JAXWSClientSupport.getJAXWSClientSupport(FileObject)");
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            WebServicesClientSupportProvider impl = (WebServicesClientSupportProvider)it.next();
            JAXWSClientSupport wscs = impl.findJAXWSClientSupport(f);
            if (wscs == null) continue;
            return wscs;
        }
        return null;
    }

    public String addServiceClient(String serviceName, String wsdlUrl, String packageName, boolean isJsr109) {
        return this.impl.addServiceClient(serviceName, wsdlUrl, packageName, isJsr109);
    }

    public void removeServiceClient(String serviceName) {
        this.impl.removeServiceClient(serviceName);
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        return this.impl.getWsdlFolder(create);
    }

    public FileObject getLocalWsdlFolderForClient(String clientName, boolean createFolder) {
        return this.impl.getLocalWsdlFolderForClient(clientName, createFolder);
    }

    public FileObject getBindingsFolderForClient(String clientName, boolean createFolder) {
        return this.impl.getBindingsFolderForClient(clientName, createFolder);
    }

    public URL getCatalog() {
        return this.impl.getCatalog();
    }

    public List getServiceClients() {
        return this.impl.getServiceClients();
    }

    public String getServiceRefName(Node clientNode) {
        return this.impl.getServiceRefName(clientNode);
    }

    static {
        JAXWSClientSupportAccessor.DEFAULT = new JAXWSClientSupportAccessor(){

            public JAXWSClientSupport createJAXWSClientSupport(JAXWSClientSupportImpl spiWebServicesClientSupport) {
                return new JAXWSClientSupport(spiWebServicesClientSupport);
            }

            public JAXWSClientSupportImpl getJAXWSClientSupportImpl(JAXWSClientSupport wscs) {
                return wscs == null ? null : wscs.impl;
            }
        };
    }
}

