/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.ui.customizer;

import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.openide.util.NbBundle;

public class J2eePlatformUiSupport {
    private static final String JAVA_EE_5_DISPLAY_NAME = NbBundle.getMessage(J2eePlatformUiSupport.class, (String)"JAVA_EE_5_displayName");
    private static final String J2EE_1_4_DISPLAY_NAME = NbBundle.getMessage(J2eePlatformUiSupport.class, (String)"J2EE_1_4_displayName");
    private static final String J2EE_1_3_DISPLAY_NAME = NbBundle.getMessage(J2eePlatformUiSupport.class, (String)"J2EE_1_3_displayName");

    private J2eePlatformUiSupport() {
    }

    public static ComboBoxModel createPlatformComboBoxModel(String serverInstanceId) {
        return new J2eePlatformComboBoxModel(serverInstanceId);
    }

    public static String getServerInstanceID(Object j2eePlatformModelObject) {
        if (j2eePlatformModelObject == null) {
            return null;
        }
        J2eePlatform j2eePlatform = ((J2eePlatformAdapter)j2eePlatformModelObject).getJ2eePlatform();
        String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
        for (int i = 0; i < serverInstanceIDs.length; ++i) {
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
            if (platform == null || !platform.getDisplayName().equals(j2eePlatform.getDisplayName())) continue;
            return serverInstanceIDs[i];
        }
        return null;
    }

    public static ComboBoxModel createSpecVersionComboBoxModel(String j2eeSpecVersion) {
        return new J2eeSpecVersionComboBoxModel(j2eeSpecVersion);
    }

    public static String getSpecVersion(Object j2eeSpecVersionModelObject) {
        return ((J2eePlatformComboBoxItem)j2eeSpecVersionModelObject).getCode();
    }

    public static boolean getJ2eePlatformAndSpecVersionMatch(Object j2eePlatformModelObject, Object j2eeSpecVersionModelObject) {
        if (!(j2eePlatformModelObject instanceof J2eePlatformAdapter) || !(j2eeSpecVersionModelObject instanceof String)) {
            return false;
        }
        J2eePlatform j2eePlatform = ((J2eePlatformAdapter)j2eePlatformModelObject).getJ2eePlatform();
        String specVersion = (String)j2eeSpecVersionModelObject;
        return j2eePlatform.getSupportedSpecVersions(J2eeModule.EJB).contains(specVersion);
    }

    private static final class J2eePlatformAdapter
    implements Comparable {
        private J2eePlatform platform;

        public J2eePlatformAdapter(J2eePlatform platform) {
            this.platform = platform;
        }

        public J2eePlatform getJ2eePlatform() {
            return this.platform;
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public int compareTo(Object o) {
            J2eePlatformAdapter oa = (J2eePlatformAdapter)o;
            return this.toString().compareTo(oa.toString());
        }
    }

    private static final class J2eePlatformComboBoxItem {
        private String code;
        private String displayName;

        public J2eePlatformComboBoxItem(String code, String displayName) {
            this.code = code;
            this.displayName = displayName;
        }

        public J2eePlatformComboBoxItem(String code) {
            this(code, J2eePlatformComboBoxItem.findDisplayName(code));
        }

        private static String findDisplayName(String code) {
            if (code.equals("1.5")) {
                return JAVA_EE_5_DISPLAY_NAME;
            }
            if (code.equals("1.4")) {
                return J2EE_1_4_DISPLAY_NAME;
            }
            if (code.equals("1.3")) {
                return J2EE_1_3_DISPLAY_NAME;
            }
            return code;
        }

        public String getCode() {
            return this.code;
        }

        public String toString() {
            return this.displayName;
        }
    }

    private static final class J2eeSpecVersionComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private J2eePlatformComboBoxItem[] j2eeSpecVersions;
        private J2eePlatformComboBoxItem initialJ2eeSpecVersion;
        private J2eePlatformComboBoxItem selectedJ2eeSpecVersion;

        public J2eeSpecVersionComboBoxModel(String j2eeSpecVersion) {
            this.initialJ2eeSpecVersion = new J2eePlatformComboBoxItem(j2eeSpecVersion);
            ArrayList<J2eePlatformComboBoxItem> orderedListItems = new ArrayList<J2eePlatformComboBoxItem>();
            orderedListItems.add(new J2eePlatformComboBoxItem("1.5"));
            orderedListItems.add(new J2eePlatformComboBoxItem("1.4"));
            if (!this.initialJ2eeSpecVersion.getCode().equals("1.5") && !this.initialJ2eeSpecVersion.getCode().equals("1.4")) {
                orderedListItems.add(0, new J2eePlatformComboBoxItem("1.3"));
            }
            this.j2eeSpecVersions = orderedListItems.toArray(new J2eePlatformComboBoxItem[orderedListItems.size()]);
            this.selectedJ2eeSpecVersion = this.initialJ2eeSpecVersion;
        }

        public Object getElementAt(int index) {
            return this.j2eeSpecVersions[index];
        }

        public int getSize() {
            return this.j2eeSpecVersions.length;
        }

        public Object getSelectedItem() {
            return this.selectedJ2eeSpecVersion;
        }

        public void setSelectedItem(Object obj) {
            this.selectedJ2eeSpecVersion = (J2eePlatformComboBoxItem)obj;
        }
    }

    private static final class J2eePlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private J2eePlatformAdapter[] j2eePlatforms;
        private String initialJ2eePlatform;
        private J2eePlatformAdapter selectedJ2eePlatform;

        public J2eePlatformComboBoxModel(String serverInstanceID) {
            this.initialJ2eePlatform = serverInstanceID;
            this.getJ2eePlatforms();
        }

        public Object getElementAt(int index) {
            return this.getJ2eePlatforms()[index];
        }

        public int getSize() {
            return this.getJ2eePlatforms().length;
        }

        public Object getSelectedItem() {
            return this.selectedJ2eePlatform;
        }

        public void setSelectedItem(Object obj) {
            this.selectedJ2eePlatform = (J2eePlatformAdapter)obj;
        }

        private synchronized J2eePlatformAdapter[] getJ2eePlatforms() {
            if (this.j2eePlatforms == null) {
                String[] serverInstanceIDs = Deployment.getDefault().getServerInstanceIDs();
                TreeSet<J2eePlatformAdapter> orderedNames = new TreeSet<J2eePlatformAdapter>();
                boolean activeFound = false;
                for (int i = 0; i < serverInstanceIDs.length; ++i) {
                    J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceIDs[i]);
                    if (j2eePlatform == null || !j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.EJB)) continue;
                    J2eePlatformAdapter adapter = new J2eePlatformAdapter(j2eePlatform);
                    orderedNames.add(adapter);
                    if (this.selectedJ2eePlatform != null || activeFound || this.initialJ2eePlatform == null || !serverInstanceIDs[i].equals(this.initialJ2eePlatform)) continue;
                    this.selectedJ2eePlatform = adapter;
                    activeFound = true;
                }
                this.j2eePlatforms = orderedNames.toArray(new J2eePlatformAdapter[orderedNames.size()]);
            }
            return this.j2eePlatforms;
        }
    }
}

