/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;

public class FlowLayoutSupport
extends AbstractLayoutSupport {
    public Class getSupportedClass() {
        return FlowLayout.class;
    }

    public int getNewIndex(Container container, Container containerDelegate, Component component, int index, Point posInCont, Point posInComp) {
        if (!(containerDelegate.getLayout() instanceof FlowLayout)) {
            return -1;
        }
        int vgap = ((FlowLayout)containerDelegate.getLayout()).getVgap();
        Component[] components = containerDelegate.getComponents();
        int[] rowStarts = new int[components.length + 1];
        int[] rowTops = new int[components.length + 1];
        for (int i = 0; i < rowStarts.length; ++i) {
            rowStarts[i] = -1;
        }
        int lastX = Integer.MAX_VALUE;
        int rowHeight = -vgap;
        int r = 0;
        int i = 0;
        if (components.length > 1 || component.getParent() != containerDelegate) {
            for (int j = 0; j < components.length; ++j) {
                int posX;
                Component comp = components[j];
                if (comp == component) {
                    comp = components[j == 0 ? 1 : j - 1];
                }
                if ((posX = comp.getBounds().x) < lastX) {
                    rowStarts[r] = j;
                    rowTops[r] = rowHeight + vgap;
                    int n = r;
                    rowTops[n] = rowTops[n] + (r > 0 ? rowTops[r - 1] : containerDelegate.getInsets().top);
                    ++r;
                    rowHeight = 0;
                }
                rowHeight = Math.max(rowHeight, comp.getSize().height);
                lastX = posX;
            }
            if (r > 0) {
                rowTops[r] = rowTops[r - 1] + rowHeight + vgap;
            }
            r = 0;
            while (rowStarts[i] >= 0) {
                if (posInCont.y < rowTops[i]) {
                    r = i - 1;
                    break;
                }
                ++i;
            }
            if (rowStarts[i] < 0) {
                if (posInCont.y >= rowTops[i]) {
                    return components.length;
                }
                r = i - 1;
            }
            int m = r <= 0 ? 0 : rowStarts[r];
            int n = rowStarts[r + 1];
            if (n > components.length || n < 0) {
                n = components.length;
            }
            for (i = m; i < n; ++i) {
                Component comp = components[i];
                if (comp == component) {
                    comp = components[i == 0 ? 1 : i - 1];
                }
                Rectangle bounds = comp.getBounds();
                int centerX = bounds.x + bounds.width / 2;
                if (posInCont.x < centerX) break;
            }
            i = i < n ? i : n;
        }
        return i;
    }

    public boolean paintDragFeedback(Container container, Container containerDelegate, Component component, LayoutConstraints newConstraints, int newIndex, Graphics g) {
        if (!(containerDelegate.getLayout() instanceof FlowLayout)) {
            return false;
        }
        Component[] components = containerDelegate.getComponents();
        int alignment = ((FlowLayout)containerDelegate.getLayout()).getAlignment();
        int hgap = ((FlowLayout)containerDelegate.getLayout()).getHgap();
        int draggedIndex = -1;
        if (component.getParent() == containerDelegate) {
            for (int i = 0; i < components.length; ++i) {
                if (component != components[i]) continue;
                draggedIndex = i;
            }
        }
        int x = 0;
        int y1 = 0;
        int y2 = 0;
        if (newIndex <= 0 || components.length == 1 && draggedIndex != -1) {
            if (components.length == 0 || components.length == 1 && draggedIndex != -1) {
                x = alignment == 2 ? containerDelegate.getSize().width : (alignment == 0 ? 0 : containerDelegate.getSize().width / 2 - 5);
                y1 = 0;
                y2 = component != null ? component.getHeight() : 20;
            } else {
                Rectangle b = components[draggedIndex == 0 ? 1 : 0].getBounds();
                x = b.x;
                y1 = b.y;
                y2 = b.y + (component != null ? component.getHeight() : b.height);
            }
        } else if (newIndex >= components.length || newIndex == components.length - 1 && newIndex == draggedIndex) {
            int last = components.length - 1;
            Rectangle b = components[last == draggedIndex ? last - 1 : last].getBounds();
            x = b.x + b.width;
            y1 = b.y;
            y2 = b.y + (component != null ? component.getHeight() : b.height);
        } else {
            Rectangle b = components[newIndex == draggedIndex ? newIndex + 1 : newIndex].getBounds();
            x = b.x;
            y1 = b.y;
            y2 = b.y + (component != null ? component.getHeight() : b.height);
        }
        g.drawRect(x - 10 - hgap / 2, y1, 20, y2 - y1);
        return true;
    }
}

