/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.favorites;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.favorites.Favorites;
import org.netbeans.modules.favorites.Tab;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public final class Actions {
    private static File currentDir = null;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$View;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$Select;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$Remove;
    static /* synthetic */ Class class$org$netbeans$modules$favorites$Actions$Add;

    private Actions() {
    }

    public static Action view() {
        return View.getDefault();
    }

    public static Action add() {
        return Add.getDefault();
    }

    public static Action addOnFavoritesNode() {
        return AddOnFavoritesNode.getDefault();
    }

    public static Action remove() {
        return Remove.getDefault();
    }

    public static Action select() {
        return Select.getDefault();
    }

    public static class AddOnFavoritesNode
    extends Add {
        static final long serialVersionUID = -6471284573153172312L;
        private static final AddOnFavoritesNode ADD_ON_FAVORITES_NODE = new AddOnFavoritesNode();

        public static Action getDefault() {
            return ADD_ON_FAVORITES_NODE;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_AddOnFavoritesNode");
        }
    }

    public static class Add
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final Add ADD;
        static final /* synthetic */ boolean $assertionsDisabled;

        public static Action getDefault() {
            return ADD;
        }

        private Add() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        public boolean enable(Node[] arr) {
            if (arr == null || arr.length == 0) {
                return false;
            }
            if (arr.length == 1 && arr[0] instanceof Favorites) {
                return true;
            }
            for (int i = 0; i < arr.length; ++i) {
                DataObject dataObject = (DataObject)arr[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject == null) {
                    return false;
                }
                FileObject fo = dataObject.getPrimaryFile();
                if (fo != null) {
                    if (this.isInFavorites(fo)) {
                        return false;
                    }
                    File file = FileUtil.toFile((FileObject)fo);
                    if (file != null && file.getParent() == null) {
                        return false;
                    }
                }
                try {
                    if (!dataObject.getPrimaryFile().getFileSystem().isDefault()) continue;
                    return false;
                }
                catch (FileStateInvalidException fsie) {
                    return false;
                }
            }
            return true;
        }

        private boolean isInFavorites(FileObject fo) {
            DataFolder f = Favorites.getFolder();
            DataObject[] arr = f.getChildren();
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof DataShadow) || !fo.equals(((DataShadow)arr[i]).getOriginal().getPrimaryFile())) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_Add");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$favorites$Actions$Add == null ? (class$org$netbeans$modules$favorites$Actions$Add = Actions.class$("org.netbeans.modules.favorites.Actions$Add")) : class$org$netbeans$modules$favorites$Actions$Add);
        }

        protected void performAction(Node[] activatedNodes) {
            DataFolder f = Favorites.getFolder();
            DataObject[] arr = f.getChildren();
            ArrayList listAdd = new ArrayList();
            DataObject createdDO = null;
            Node[] toShadows = activatedNodes;
            try {
                if (activatedNodes.length == 1 && activatedNodes[0] instanceof Favorites) {
                    FileObject fo = Add.chooseFileObject();
                    if (fo == null) {
                        return;
                    }
                    toShadows = new Node[]{DataObject.find((FileObject)fo).getNodeDelegate()};
                }
                createdDO = Add.createShadows(f, toShadows, listAdd);
                Add.reorderAfterAddition(f, arr, listAdd);
                this.selectAfterAddition(createdDO);
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        private static FileObject chooseFileObject() {
            int option;
            FileObject retVal = null;
            File chooserSelection = null;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(2);
            chooser.setDialogTitle(NbBundle.getBundle((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions)).getString("CTL_DialogTitle"));
            chooser.setApproveButtonText(NbBundle.getBundle((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions)).getString("CTL_ApproveButtonText"));
            if (currentDir != null) {
                chooser.setCurrentDirectory(currentDir);
            }
            if ((option = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                chooserSelection = chooser.getSelectedFile();
                File selectedFile = FileUtil.normalizeFile((File)chooserSelection);
                if (!selectedFile.exists() && selectedFile.getParentFile() != null && selectedFile.getParentFile().exists() && selectedFile.getName().equals(selectedFile.getParentFile().getName())) {
                    selectedFile = selectedFile.getParentFile();
                }
                if (!selectedFile.exists()) {
                    String message = NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ERR_FileDoesNotExist", (Object)selectedFile.getPath());
                    String title = NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ERR_FileDoesNotExistDlgTitle");
                    DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)message, title, -1, 1, new Object[]{NotifyDescriptor.CLOSED_OPTION}, NotifyDescriptor.OK_OPTION));
                } else {
                    retVal = FileUtil.toFileObject((File)selectedFile);
                    if (!$assertionsDisabled && retVal == null) {
                        throw new AssertionError();
                    }
                }
            }
            currentDir = chooser.getCurrentDirectory();
            return retVal;
        }

        private void selectAfterAddition(DataObject createdDO) {
            final Tab projectsTab = Tab.findDefault();
            projectsTab.open();
            projectsTab.requestActive();
            if (createdDO != null) {
                Node n = Favorites.getNode();
                Node[] nodes = projectsTab.getExplorerManager().getRootContext().getChildren().getNodes(true);
                final Node[] toSelect = new Node[1];
                boolean setSelected = false;
                for (int i = 0; i < nodes.length; ++i) {
                    if (!createdDO.getName().equals(nodes[i].getName())) continue;
                    toSelect[0] = nodes[i];
                    setSelected = true;
                    break;
                }
                if (setSelected) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                projectsTab.getExplorerManager().setExploredContextAndSelection(toSelect[0], toSelect);
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        }

        private static DataObject createShadows(DataFolder favourities, Node[] activatedNodes, List listAdd) {
            DataShadow createdDO = null;
            for (int i = 0; i < activatedNodes.length; ++i) {
                DataObject obj = (DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (obj == null) continue;
                try {
                    if (createdDO == null) {
                        createdDO = obj.createShadow(favourities);
                        listAdd.add(createdDO);
                        continue;
                    }
                    listAdd.add(obj.createShadow(favourities));
                    continue;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            return createdDO;
        }

        private static void reorderAfterAddition(DataFolder favourities, DataObject[] children, List listAdd) {
            ArrayList<Object> listDest = new ArrayList<Object>();
            if (listAdd.size() > 0) {
                int i;
                Object root = null;
                for (i = 0; i < children.length; ++i) {
                    FileObject fo = children[i].getPrimaryFile();
                    if (!"Favorites/Root.instance".equals(fo.getPath())) continue;
                    root = children[i];
                }
                if (root != null) {
                    for (i = 0; i < children.length; ++i) {
                        if (root.equals(children[i])) continue;
                        listDest.add(children[i]);
                    }
                    listDest.addAll(listAdd);
                    listDest.add(root);
                } else {
                    for (i = 0; i < children.length; ++i) {
                        listDest.add(children[i]);
                    }
                    listDest.addAll(listAdd);
                }
                DataObject[] newOrder = listDest.toArray(new DataObject[listDest.size()]);
                try {
                    favourities.setOrder(newOrder);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions).desiredAssertionStatus();
            ADD = new Add();
        }
    }

    private static class Remove
    extends NodeAction {
        static final long serialVersionUID = -6471281373153172312L;
        private static final Remove REMOVE = new Remove();

        private Remove() {
        }

        public static Action getDefault() {
            return REMOVE;
        }

        public boolean enable(Node[] arr) {
            if (arr == null || arr.length == 0) {
                return false;
            }
            for (int i = 0; i < arr.length; ++i) {
                DataObject shad = (DataObject)arr[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (shad != null && shad.getFolder() == Favorites.getFolder()) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_Remove");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$favorites$Actions$Remove == null ? (class$org$netbeans$modules$favorites$Actions$Remove = Actions.class$("org.netbeans.modules.favorites.Actions$Remove")) : class$org$netbeans$modules$favorites$Actions$Remove);
        }

        protected void performAction(Node[] arr) {
            for (int i = 0; i < arr.length; ++i) {
                DataObject shad = (DataObject)arr[i].getCookie(class$org$openide$loaders$DataObject == null ? Actions.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (shad == null || shad.getFolder() != Favorites.getFolder()) continue;
                try {
                    shad.delete();
                    continue;
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class Select
    extends NodeAction {
        private static final Select SELECT = new Select();

        public static Action getDefault() {
            return SELECT;
        }

        private Select() {
            this.putValue("noIconInMenu", Boolean.TRUE);
        }

        protected void performAction(Node[] activatedNodes) {
            Tab proj = Tab.findDefault();
            proj.open();
            proj.requestActive();
            proj.doSelectNode((DataObject)activatedNodes[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = Actions.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject));
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length == 1;
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions$Select == null ? (class$org$netbeans$modules$favorites$Actions$Select = Actions.class$("org.netbeans.modules.favorites.Actions$Select")) : class$org$netbeans$modules$favorites$Actions$Select), (String)"ACT_Select_Main_Menu");
        }

        public JMenuItem getPopupPresenter() {
            JMenuItem mi = super.getPopupPresenter();
            mi.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions$Select == null ? (class$org$netbeans$modules$favorites$Actions$Select = Actions.class$("org.netbeans.modules.favorites.Actions$Select")) : class$org$netbeans$modules$favorites$Actions$Select), (String)"ACT_Select"));
            return mi;
        }

        protected String iconResource() {
            return "org/netbeans/modules/favorites/resources/actionSelect.gif";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        protected boolean asynchronous() {
            return false;
        }
    }

    private static class View
    extends AbstractAction
    implements HelpCtx.Provider {
        private static final View VIEW = new View();

        public View() {
            this.putValue("Name", NbBundle.getMessage((Class)(class$org$netbeans$modules$favorites$Actions == null ? (class$org$netbeans$modules$favorites$Actions = Actions.class$("org.netbeans.modules.favorites.Actions")) : class$org$netbeans$modules$favorites$Actions), (String)"ACT_View"));
            Image image = Utilities.loadImage((String)"org/netbeans/modules/favorites/resources/actionView.gif");
            this.putValue("SmallIcon", image != null ? new ImageIcon(image) : null);
        }

        public static Action getDefault() {
            return VIEW;
        }

        public void actionPerformed(ActionEvent evt) {
            Tab projectsTab = Tab.findDefault();
            projectsTab.open();
            projectsTab.requestActive();
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$favorites$Actions$View == null ? (class$org$netbeans$modules$favorites$Actions$View = Actions.class$("org.netbeans.modules.favorites.Actions$View")) : class$org$netbeans$modules$favorites$Actions$View);
        }
    }
}

